/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_STANDARD_STATS_H
#define LIBNOMORE_STANDARD_STATS_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <iosfwd>
#include <statistics/statistics_object.h>

namespace NS_NOMORE {

class Graph;
struct HeadNodeColored;
struct BodyNodeColored;
struct BodyNodeColoredChoicePoint;
struct HeadNodeColoredChoicePoint;
//! This abstract class gathers some important statistic values like choice points or assignments.
/*!
 *  This way this class can gather information about the executed
 *  operators (number of executions and names).
 */
class StandardStatistics : public StatisticsObject {
public:
  //! Constructs the stats instance.
  StandardStatistics(event::ChannelManager& m);
  
  //! Register with the event handles.
  void registerWith(event::ChannelManager& m);

  //! Prints the result of the information-gathering.
  void print(std::ostream& os) const;

  //! event handler for HeadNodeColored events.
  void handle(const HeadNodeColored& e);

  //! event handler for BodyNodeColored events.
  void handle(const BodyNodeColored& e);

  //! event handler for BodyNodeColoredChoicePoint events
  void handle(const BodyNodeColoredChoicePoint& e);

  //! event handler for HeadNodeColoredChoicePoint events
  void handle(const HeadNodeColoredChoicePoint& e);

protected:
  long headCps_;
  long bodyCps_;
  long headChoices_;
  long bodyChoices_;
  long headAssignments_;
  long bodyAssignments_;
  long headChoiceRecolors_;
  long bodyChoiceRecolors_;

  long laHeadCps_;
  long laBodyCps_;
  long laHeadChoices_;
  long laBodyChoices_;
  long laHeadAssignments_;
  long laBodyAssignments_;
  long laHeadChoiceRecolors_;
  long laBodyChoiceRecolors_;

  long heuHeadCps_;
  long heuBodyCps_;
  long heuHeadChoices_;
  long heuBodyChoices_;
  long heuHeadAssignments_;
  long heuBodyAssignments_;
  long heuHeadChoiceRecolors_;
  long heuBodyChoiceRecolors_;
};

}

#endif
