/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_TIMING_STATISTICS_H
#define NOMORE_TIMING_STATISTICS_H

#include <statistics/statistics_object.h>
#include <statistics/rdtsc_timer.h>

namespace NS_NOMORE {

class Graph;
struct LookaheadExecution;
struct HeuristicExecution;
struct GraphConstructionFinished;

//! Interface for gathering statistic information about the current mode (lookahead, heuristics or normal mode).
class TimingStatistics : public StatisticsObject {
public:
  TimingStatistics(event::ChannelManager& m);

  //! Destroys the object
  virtual ~TimingStatistics();

  //! Register with the event handles.
  void registerWith(event::ChannelManager& m);

  //! Prints the result of the information-gathering.
  void print(std::ostream& os) const;
  
  //! event handler for LookaheadExecution events
  void handle(const LookaheadExecution& e);

  //! event handler for HeuristicExecution events
  void handle(const HeuristicExecution& e);

  //! event handler for GraphConstructionFinished events
  void handle(const GraphConstructionFinished& e);

private:
  uint64 startGraphConstruction_;
  uint64 endGraphConstruction_;
  uint64 graphConstruction_;

  uint64 startPropagation_;
  uint64 endPropagation_;
  uint64 propagation_;

  uint64 startLookahead_;
  uint64 endLookahead_;
  uint64 lookahead_;

  uint64 startHeuristic_;
  uint64 endHeuristic_;
  uint64 heuristic_;

  uint64 startExecution_;
  uint64 endExecution_;
  uint64 execution_;
};

}

#endif
