/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_STATS_H
#define NOMORE_STATS_H

#include <iosfwd>
#include <vector>
#include <time.h>
#include <statistics/statistics_object.h>
#include <operator_decorator_factory.h>

namespace NS_NOMORE {

//! Statistics object for gathering statistic information.
  class Statistics : public OperatorDecoratorFactory {
public:
  //! Constructs a new object
  Statistics();

  //! Destroys the object
  virtual ~Statistics();

  //! Prints the result of the information-gathering
  void print(std::ostream& os) const;

  //! Starts the internal timer.
  void startTimer();
  
  //! Stops the internal timer.
  void stopTimer();

  //! Adds a new statistic object like OperatorCalls. 
  void add(StatisticsObject* stats);

  //! Sets the object decorator for the statistics.
  void setDecorator(OperatorDecoratorFactory* dec);

  Operator* decorate(Operator* op);

private:
  //! Prints the time elapsed between calls to startTimer and stopTimer
  void printTimer(std::ostream& os) const;
  
  Statistics(const Statistics&);
  Statistics& operator=(const Statistics&);

  std::vector<StatisticsObject*> statistics_;
  OperatorDecoratorFactory *decorator_;
  
  //! Seconds.
  unsigned long sec_;

  //! Milliseconds.
  unsigned long msec_;

  //! Timer.
  clock_t timer_;
};

}

#endif
