/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/hybrid_lookahead.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <constraint.h>
#include <heuristic.h>

namespace NS_NOMORE {

///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(HybridLookahead*) {
  return "HLA";
}

template <>
Lookahead* createLookaheadOp(Graph& g, HybridLookahead*) {
  return new HybridLookahead(g);
}
///////////////////////////////////////////////////////////////////////////////
  
  
HybridLookahead::HybridLookahead(Graph& grp, Operator& op, const Constraint& con, Heuristic& heu) 
  : Lookahead(grp, op, con)
  , currentNode_(0)
  , currentValue_(0) {
  setHeuristic(heu);
  grp.checkTightness();
}

HybridLookahead::HybridLookahead(Graph& grp) 
  : Lookahead(grp)
  , currentNode_(0)
  , currentValue_(0)
  , heuristic_(0) {
  grp.checkTightness();
}

const char* HybridLookahead::getName() const {
  return NS_NOMORE::getName<HybridLookahead>(0);
}

void HybridLookahead::execute() {
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  overlayList_.resize(getGraph().countNodes());
  NS_NOMORE::lookahead(*this);

  em.getChannelFor(event::Event<HeadNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).disconnect(*this);  
  em.getChannelFor(event::Event<BodyNodeColored>()).disconnect(*this);
  
  overlayList_.clear();
}

void HybridLookahead::handle(const HeadNodeColored& e) {
  if(e.node_->countOneSuccesors() != 0)
    ++currentValue_;

  if(e.node_->getColor() == Color::minus && getConstraint().supersedes(*currentNode_, *e.node_)) {
    overlayList_.add(*e.node_, Color::minus);
  }
}

void HybridLookahead::handle(const HeadNodeColoredChoicePoint& e) {
  if(e.node_->countOneSuccesors() != 0)
    ++currentValue_;
}

void HybridLookahead::handle(const BodyNodeColored& e) {
  if (HasColor(Color::plus | Color::weak_plus)(e.node_)
    && getConstraint().supersedes(*currentNode_, *e.node_)) {
    overlayList_.add(*e.node_, Color::plus);
    overlayList_.add(*e.node_, Color::weak_plus);
  }
}

void HybridLookahead::storeHeuristic() {
  if (heuristic_) {
    heuristic_->addHeuristicValue(currentNode_, (HybridLAHeuristicBase::HeuristicValueType)(currentValue_ * getGraph().getTightnessFactor(currentNode_)));
  }
}

bool HybridLookahead::lookahead(Node* n) {
  if(overlayList_.hasOverlay(*n))
    return false;
  
  currentNode_ = n;
  currentValue_ = 0;
  
  
  if (checkColor(*currentNode_, currentNode_->preferredChoicePointColor())) {
    storeHeuristic();    
    return false;
  }
  else {
    // conflict found
    color(*currentNode_, currentNode_->alternativeChoicePointColor());    
    // reset the overlay map (all nodes must be re-checked)
    overlayList_.clear();
    return true;
  }
}

void HybridLookahead::setHeuristic(Heuristic& h) {
  heuristic_ = dynamic_cast<HybridLAHeuristicBase*>(&h);
}

}
