/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <statistics/invocation_decorator.h>
namespace NS_NOMORE {

InvocationDecorator::InvocationDecorator(Operator* op, Observer* o) 
  : Operator()
  , operator_(op) 
  , o_(o) {
}

InvocationDecorator::~InvocationDecorator() {  
  delete operator_;
}

Operator* InvocationDecorator::extractOperator(const std::string& name) {
  return operator_->extractOperator(name);
}


ColorOpResult InvocationDecorator::operator()() {
  o_->onOperatorStarted(operator_->getName());
  return (*operator_)();
}

bool InvocationDecorator::validate(const OpSet& ops) const {
  return operator_->validate(ops);
}

void InvocationDecorator::reset() {
  operator_->reset();
}

const char* InvocationDecorator::getName() const {
  return operator_->getName();
}
  
}
