/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#include <statistics/rdtsc_timer.h>

#if defined (_WIN32)
#include <windows.h>
#else
#include <unistd.h>
inline void Sleep(unsigned long millis) {
  if (millis < 1000)
    usleep(millis * 1000);
  else
    sleep(millis / 1000);
}
#endif


#if defined (_MSC_VER)
#pragma warning(disable:4035)
#endif

extern "C" uint64 readTimeStampCounter() {

#if defined (_MSC_VER) || defined (__WATCOMC__) 
  __asm rdtsc;
#elif defined(__i386__) || defined(__x86_64__) || defined(__amd64__)
  unsigned long hi;
  unsigned long low;
  asm("rdtsc; movl %%edx,%0; movl %%eax,%1"
          : "=r" (hi), "=r" (low)
          : /* No input */
          : "%edx", "%eax");
  uint64 temp(hi);
  return (temp << 32) + low;
#elif defined(__powerpc__)
  unsigned long long int result=0;
  unsigned long int upper, lower,tmp;
  __asm__ volatile(
                "loop:                  \n"
                "\tmftbu   %0           \n"
                "\tmftb    %1           \n"
                "\tmftbu   %2           \n"
                "\tcmpw    %2,%0        \n"
                "\tbne     loop         \n"
		: "=r"(upper),"=r"(lower),"=r"(tmp)
		);
  result = upper;
  result = result<<32;
  result = result|lower;
  return result;
#else
#error  "Unknown architecture or compiler"
#endif
}

extern "C" unsigned long measureCpuSpeed(unsigned duration, unsigned iters) {
  unsigned long res = 0;
  for (unsigned i = 0; i < iters; ++i) {
    uint64 ticks1 = readTimeStampCounter();
    Sleep(duration);
    uint64 ticks2 = readTimeStampCounter();
    res += static_cast<unsigned long>( (ticks2 - ticks1) / (duration * 1000) );
    
  }
  return res / iters;
}

unsigned long TscTimer::cpuSpeed_s = 0;

void TscTimer::reset() {
  startTicks_ = endTicks_ = 0;
}

uint64 TscTimer::result() const {
  return endTicks_ - startTicks_;
}


#include <sstream>
#include <iomanip>
std::string TscTimer::resultAsTimeString() const {
  if (cpuSpeed_s == 0) {
    return "time not available - call setCpuSpeed first";
  }
  uint64 res = result();
  
  const unsigned long ticksPerSec = cpuSpeed_s * 1000000;
  const unsigned long milli = 1000;
  const unsigned long ticksPerMilli = ticksPerSec / milli;
  const unsigned long micro = 1000 * milli;
  const unsigned long ticksPerMicro = ticksPerSec / micro;


  unsigned long secs = static_cast<unsigned long>( res / ticksPerSec );
  unsigned long msecs = (res - ticksPerSec * secs) / ( ticksPerMilli );
  unsigned long microSecs = (res - (ticksPerSec * secs) - (ticksPerMilli * msecs)) / ( ticksPerMicro );
  if (microSecs >= 1000) {
    microSecs -= 1000;
    ++msecs;
  }
  if (msecs >= 1000) {
    msecs -= 1000;
    ++secs;
  }
  
  std::ostringstream ostr;
  ostr << secs << "." << std::setw(3) << std::setfill('0') << msecs;
  if (microSecs != 0) {
    ostr << "," << std::setw(3) << std::setfill('0') << microSecs;
  }
  return ostr.str();
  
}

void TscTimer::setCpuSpeed(unsigned speedInMhz) {
  cpuSpeed_s = speedInMhz;
}

void TscTimer::measureCpuSpeed(unsigned mTime, unsigned iterations) {
  setCpuSpeed( ::measureCpuSpeed(mTime, iterations) );
}
