#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <operators/post_operator.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class TestPostOperator : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(TestPostOperator);
  CPPUNIT_TEST(testNodes1);
  CPPUNIT_TEST(testNodes2);
  CPPUNIT_TEST(testNodes3);
  CPPUNIT_TEST(testNodesException);
	CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {    
    grp = new Graph;
    head1 = grp->insertHeadNode(1);
    head2 = grp->insertHeadNode(2);
    body1 = grp->insertBodyNode();
    body2 = grp->insertBodyNode();
    n = new PostOperator(*grp);
  }

  void tearDown() {
    delete grp;
    delete n;
  }

  void testNodes1() {
    //CPPUNIT_ASSERT_EQUAL( true, (*n)() );
    grp->totalize();
    CPPUNIT_ASSERT_EQUAL( Color::minus, head1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, head2->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, body1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, body2->getColor() );
  }

  void testNodes2() {
    grp->color(*head1, Color::plus);
    grp->color(*body2, Color::plus);
    //CPPUNIT_ASSERT_EQUAL( true, (*n)() );
    grp->totalize();
    CPPUNIT_ASSERT_EQUAL( Color::plus, head1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, head2->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, body1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::plus, body2->getColor() );
  }

  void testNodes3() {
    grp->color(*head1, Color::plus);
    grp->color(*head2, Color::minus);
    grp->color(*body1, Color::minus);
    grp->color(*body2, Color::plus);
    //CPPUNIT_ASSERT_EQUAL( false, (*n)() );
    grp->totalize();
    CPPUNIT_ASSERT_EQUAL( Color::plus, head1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, head2->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::minus, body1->getColor() );
    CPPUNIT_ASSERT_EQUAL( Color::plus, body2->getColor() );
  }

  void testNodesException() {
    grp->color(*head1, Color::weak_plus);
    //CPPUNIT_ASSERT_THROW( (*n)(), NS_NOMORE::ColorError );
    CPPUNIT_ASSERT_EQUAL( ColorOperation::failed, grp->totalize() );
  }

private:
  HeadNode* head1;
  HeadNode* head2;
  BodyNode* body1;
  BodyNode* body2;
  Graph* grp;
  PostOperator* n;
};

CPPUNIT_TEST_SUITE_REGISTRATION(TestPostOperator);

}	// end namespace NS_NOMORE_TESTS
