/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_LEX_ORDERING_HEURISTIC_H
#define LIBNOMORE_LEX_ORDERING_HEURISTIC_H
#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <string>
#include <utility>

#include <static_heuristic.h>

namespace NS_NOMORE {

//! Heuristic strategy that values nodes based on their lexicographical ordering.
/*! 
 *  This class is useful for testing. Using this strategy a body b1 is "better" 
 *  than a body b2 
 *  -# iff the positive part represented as an ordered string of atom names 
 *     of b1 precedes the positive part of b2
 *  -# or if the positive parts of b1 and b2 are equal iff the negative part 
 *     represented as an ordered string of atom names of b1 precedes the 
 *     negative part of b2.
 *  A head node h1 is "better" than another head node h2 iff the atom name of 
 *  h1 lexicographically prcedes the atom name of h2.
 *
 *  \note The strategy can be used with body and head nodes. */
class StaticLexOrderingStrat {
public:
  //! The value type definition.
  typedef std::pair<std::string, std::string> ValueType;

  //! The comparator type comparing two value types.
  struct Compare {
    //! Compares two value types which contains of two simple strings.
    /*!
     *  \param v1 The value of the first node. 
     *  \param v2 The value of the second node. */
    bool operator()(const ValueType& v1, const ValueType& v2) const {
      return v1.first < v2.first || (v1.first == v2.first && v1.second < v2.second);
    }
  };

  //! The evaluator for a node.
  struct Evaluate {
    //! Generates the value for a node.
    /*!
     *  \param n The node used to generate the s value. 
     *  \param tf */
    ValueType operator()(Node* n, double tf) const;
  };

  //! The comparator for the value type.  
  typedef Compare ComparatorType;

  //! Evaluator type of the strategie.
  typedef Evaluate EvaluatorType;

  //! The choice creator type used to create a Choice.
  typedef DefaultChoiceCreator ChoiceCreatorType;
};

//! A static heuristic that uses StaticLexOrderingStrat as strategy.
typedef StaticHeuristic<StaticLexOrderingStrat> LexOrdering;

}
#endif
