/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_NARY_BACKTRACKING_SOLVER_H
#define NOMORE_NARY_BACKTRACKING_SOLVER_H

#include <solver.h>
#include <memory>

namespace NS_NOMORE {

//! The n-ary backtracking search similar to the dlv idea.
/*!
 *  This solver uses n-ary backtacking, i.e. it generates a n-ary backtracking 
 *  search space where a choice point is a list of nodes which is tested in 
 *  all color combinations of Color::plus (or Color::weak_plus) and 
 *  Color::minus. */
class NaryBacktrackingSolver : public Solver {
public:
  //! Initializes the solver object.
  /*!
   *  \note This constructor constructs a not yet usable object. To be usable 
   *        one first needs to set operators and a printer. */
  NaryBacktrackingSolver();
  
  //! Initializes the objects within the solver instance.
  /*! 
   *  \param as      Maximal number of answer sets to compute (0 = all answer 
   *                 sets).
   *  \param prop    Propagator for the propagation process.
   *  \param look    Lookahead operator for propagation (0 to indicate no 
   *                 lookahead).
   *  \param choice  Choice operator for selecting branching nodes.
   *  \param printer Printer instance to be used for printing answer sets.
   *
   *  \pre Pointer arguments are either not null or point to objects that 
   *       were allocated using new or 0.
   *
   *  \note The Solver takes over ownership of the objects. */
  NaryBacktrackingSolver(int as, Propagator* prop, Lookahead* look, ChoiceOperator* choice, Printer* printer);

private:
  // instance methods
  bool backtrack(Graph& g);
  bool choose(Graph& g);

  // instance variables
  ChoiceOperator* choiceOp_;
};

}

#endif
