/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_TIMER_H
#define NOMORE_TIMER_H

#if defined(_MSC_VER) || defined(__WATCOMC__)
typedef unsigned __int64 uint64;
#else
typedef unsigned long long uint64;
#endif

#if defined(_WIN32) || defined(_WIN64)
#include <windows.h>
#else 
#include <sys/time.h>
#endif

namespace NS_NOMORE {

#if defined(_WIN32) || defined(_WIN64)

  //! Returns the current micro seconds counter of the system time (windows).
  /*! 
   *  \return Returns the current number of micro seconds since ... */
  inline uint64 readMicroSecCounter() {
    union {
      FILETIME now;
      uint64 asUint;
    } now;
    GetSystemTimeAsFileTime(&now.now);
    return now.asUint / 10;
  }
#else

  //! Returns the current micro seconds counter of the system time (posix).
  /*! 
   *  \return Returns the current number of micro seconds since ... */
  inline uint64 readMicroSecCounter() {
    const int microSec = 1000000;
    struct timeval t;
    gettimeofday(&t, 0);
    return t.tv_sec * microSec + t.tv_usec;
  }
#endif
}

#endif
