/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#pragma warning (disable : 4503)
#define for if (0); else for
#endif
#include <object_factory.h>
#include <heuristic.h>
#include <choice_operator.h>
#include <operators/lookahead.h>
#include <constraint.h>
#include <graph.h>
#include <cassert>
#include <set>
#include <stack>
#include <memory>

#define INCLUDED_IN_OBJECT_FACTORY
#include "detail/exported_classes.h"
#undef INCLUDED_IN_OBJECT_FACTORY


namespace NS_NOMORE { namespace {

template <class V>
std::vector<std::string>& appendKeys(const std::map<std::string, V>& m, 
                                     std::vector<std::string>& out) {
  typename std::map<std::string, V>::const_iterator it = m.begin();
  typename std::map<std::string, V>::const_iterator end = m.end();
  for (; it != end; ++it)
    out.push_back(it->first);
  return out;
}

} // end anonymous namespace
///////////////////////////////////////////////////////////////////////////////
// ObjectFactory::Operators
///////////////////////////////////////////////////////////////////////////////
ObjectFactory::Operators::Operators()
{}

ObjectFactory::Operators::Operators(const Operators& other)
  : detOp_(other.detOp_.release())
  , lookOp_(other.lookOp_.release())
  , choiceOp_(other.choiceOp_.release())
{}
    
ObjectFactory::Operators::~Operators() {
  /* intentionally left blank */
}

///////////////////////////////////////////////////////////////////////////////
// ObjectFactory
///////////////////////////////////////////////////////////////////////////////
ObjectFactory::ObjectFactory() {
}
  
ObjectFactory::~ObjectFactory() {
}

bool ObjectFactory::registerClass(const PropInfo& info) {
  return detOps_.insert(
    PropMap::value_type(info.name, std::make_pair(info.creator, info.description))
  ).second;
}

bool ObjectFactory::registerClass(const LookOpInfo& info) {
  return lookaheadOps_.insert(
    LookOpMap::value_type(info.name, std::make_pair(info.creator, info.description))
  ).second;
}

bool ObjectFactory::registerClass(const ChoiceOpInfo& info) {
  return choiceOps_.insert(
    ChoiceOpMap::value_type(info.name, std::make_pair(info.creator, info.description))
  ).second;
}


bool ObjectFactory::registerClass(const HeuristicInfo& info) {
  return heuristics_.insert(
    HeuristicsMap::value_type(info.name, std::make_pair(info.creator, info.description))
  ).second;
}


void ObjectFactory::registerKnownClasses() {
	propagators_s.registerClasses(*this);
	lookaheadOps_s.registerClasses(*this);
  choiceOps_s.registerClasses(*this);
  heuristics_s.registerClasses(*this);
}


std::auto_ptr<Propagator> ObjectFactory::createPropagator(Graph& g, const std::string& name) const {
  PropMap::const_iterator it = detOps_.find(name);
  if (it != detOps_.end())  
    return std::auto_ptr<Propagator>( it->second.first(g) );
	throw UnknownObject(name, ObjectFactory::PROPAGATOR);
}

std::auto_ptr<Lookahead> ObjectFactory::createLookaheadOperator(Graph& g, const std::string& name) const {
  LookOpMap::const_iterator it = lookaheadOps_.find(name);
	if (it != lookaheadOps_.end()) {
		return std::auto_ptr<Lookahead>( it->second.first(g) );

	}
  throw UnknownObject(name, ObjectFactory::LOOKAHEAD_OP);
}

std::auto_ptr<ChoiceOperator> ObjectFactory::createChoiceOperator(Graph& g, const std::string& name, const std::string& heu) const{
  std::auto_ptr<Heuristic> h(createHeuristic(g, heu));
  ChoiceOpMap::const_iterator it = choiceOps_.find(name);
  if (it != choiceOps_.end())
    return std::auto_ptr<ChoiceOperator>( it->second.first(g, h.release()) );
  throw UnknownObject(name, ObjectFactory::CHOICE_OP);
}

std::auto_ptr<Heuristic> ObjectFactory::createHeuristic(Graph&, const std::string& name) const {
  HeuristicsMap::const_iterator it = heuristics_.find(name);
  if (it != heuristics_.end()) {   
    std::auto_ptr<Heuristic> h( it->second.first() );
    return h;
  }
  throw UnknownObject(name, ObjectFactory::HEURISTIC);
}

ObjectFactory::Operators ObjectFactory::createObjects(Graph& g, const std::string& propName, const std::string& lookName, Propagator::Mode lookPropMode, const std::string& choiceName, const std::string& heuName) const {
  
	Operators o;
	o.detOp_ = createPropagator(g, propName);
	o.choiceOp_ = createChoiceOperator(g, choiceName, heuName);
	setLookahead(g, o, lookName, lookPropMode);
	// !!!! HACK HACK HACK !!!
	o.choiceOp_->getHeuristic().setPropagator(*o.detOp_);
  return o;
}

void ObjectFactory::setLookahead(Graph& g, Operators& o, const std::string& name, Propagator::Mode m) const {
	if (name != "None") {
		o.lookOp_ = createLookaheadOperator(g, name);
		o.lookOp_->setPropagator(*o.detOp_, m);
		o.lookOp_->setConstraint(o.choiceOp_->getConstraint());
		o.lookOp_->setHeuristic(o.choiceOp_->getHeuristic());
	}
}

std::vector<std::string> ObjectFactory::getRegisteredClasses(ObjectType ot) const {
  std::vector<std::string> res;
  if ( (ot & PROPAGATOR) ) {
    appendKeys(detOps_, res);
  }
  if ( (ot & LOOKAHEAD_OP) ) {
    appendKeys(lookaheadOps_, res);
  }
  if ( (ot & CHOICE_OP) ) {
    appendKeys(choiceOps_, res);
  }
  if ( (ot & HEURISTIC) ) {
    appendKeys(heuristics_, res);
  }
  return res;
}

std::string ObjectFactory::getDescription(const std::string& name) const {
  PropMap::const_iterator op = detOps_.find(name);
  if (op != detOps_.end()) {
    return op->second.second;
  }
  
  LookOpMap::const_iterator lop = lookaheadOps_.find(name);
  if (lop != lookaheadOps_.end()) {
    return lop->second.second;
  }
  
  ChoiceOpMap::const_iterator cop = choiceOps_.find(name);
  if (cop != choiceOps_.end()) {
    return cop->second.second;
  }
  
  HeuristicsMap::const_iterator heu = heuristics_.find(name);
  if (heu != heuristics_.end()) {
    return heu->second.second;
  }
  throw UnknownObject(name, ALL_OBJECTS);
}

}

