/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <statistics/standard_statistics.h>
#include <event/channel_manager.h>
#include <ostream>
#include <head_node.h>
#include <body_node.h>

namespace NS_NOMORE {

StandardStatistics::StandardStatistics(event::ChannelManager& m) 
  : StatisticsObject()
  , headCps_(0)
  , bodyCps_(0)
  , headChoices_(0)
  , bodyChoices_(0)
  , headAssignments_(0)
  , bodyAssignments_(0)
  , headChoiceRecolors_(0)
  , bodyChoiceRecolors_(0)

  , laHeadCps_(0)
  , laBodyCps_(0)
  , laHeadChoices_(0)
  , laBodyChoices_(0)
  , laHeadAssignments_(0)
  , laBodyAssignments_(0)
  , laHeadChoiceRecolors_(0)
  , laBodyChoiceRecolors_(0)

  , heuHeadCps_(0)
  , heuBodyCps_(0)
  , heuHeadChoices_(0)
  , heuBodyChoices_(0)
  , heuHeadAssignments_(0)
  , heuBodyAssignments_(0)
  , heuHeadChoiceRecolors_(0)
  , heuBodyChoiceRecolors_(0) {

  registerWith(m);
}

void StandardStatistics::registerWith(event::ChannelManager& m) {
  m.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  m.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  m.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);
}

void StandardStatistics::handle(const HeadNodeColored&) {
  if(StatisticsObject::getCurrentMode() == Mode::normal)
    ++headAssignments_;
  else if(StatisticsObject::getCurrentMode() == Mode::lookahead)
    ++laHeadAssignments_;
  else
    ++heuHeadAssignments_;
}

void StandardStatistics::handle(const BodyNodeColored&) {
  if(StatisticsObject::getCurrentMode() == Mode::normal)
    ++bodyAssignments_;
  else if(StatisticsObject::getCurrentMode() == Mode::lookahead)
    ++laBodyAssignments_;
  else
    ++heuBodyAssignments_;
}

void StandardStatistics::handle(const BodyNodeColoredChoicePoint& e) {
  if(StatisticsObject::getCurrentMode() == Mode::normal) {
    ++bodyAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++bodyCps_;
      ++bodyChoices_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++bodyChoices_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++bodyChoiceRecolors_;
    }
  }
  else if(StatisticsObject::getCurrentMode() == Mode::lookahead) {
    ++laBodyAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++laBodyCps_;
      ++laBodyChoices_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++laBodyCps_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++laBodyChoiceRecolors_;
    }
  }
  else {
    ++heuBodyAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++heuBodyCps_;
      ++heuBodyChoices_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++heuBodyChoices_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++heuBodyChoiceRecolors_;
    }
  }
}

void StandardStatistics::handle(const HeadNodeColoredChoicePoint& e) {
  if(StatisticsObject::getCurrentMode() == Mode::normal) {
    ++headAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++headCps_;
      ++headChoices_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++headChoices_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++headChoiceRecolors_;
    }
  }
  else if(StatisticsObject::getCurrentMode() == Mode::lookahead) {
    ++laHeadAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++laHeadCps_;
      ++laHeadChoices_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++laHeadChoices_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++laHeadChoiceRecolors_;
    }
  }
  else {
    ++heuHeadAssignments_;
    if(e.type_ == ColorOpType::first_choice) {
      ++heuHeadChoices_;
      ++heuHeadCps_;
    }
    if(e.type_ == ColorOpType::next_choice) {
      ++heuHeadChoices_;
    }
    if(e.type_ == ColorOpType::last_choice) {
      ++heuHeadChoiceRecolors_;
    }
  }
}

void StandardStatistics::print(std::ostream& os) const {
  os << "Choice Points: " << headCps_ + bodyCps_ 
     << " (" << headCps_ << " heads, " << bodyCps_ << " bodies)\n";

  os << "Choices: " << headChoices_ + bodyChoices_ 
     << " (" << headChoices_ << " heads, " << bodyChoices_ << " bodies)\n";

  os << "Wrong Choices: " << headChoiceRecolors_ + bodyChoiceRecolors_ 
     << " (" << headChoiceRecolors_ << " heads, " 
     << bodyChoiceRecolors_ << " bodies)\n";

  os << "Assignments: " << headAssignments_ + bodyAssignments_
     << " (" << headAssignments_ << " heads, "
     << bodyAssignments_ << " bodies)\n";

  if(laHeadCps_ + laBodyCps_ > 0) {
    os << "Lookahead summary:\n";

    os << "  Checked nodes: " << laHeadCps_ + laBodyCps_  
       << " (" << laHeadCps_ << " heads, " << laBodyCps_ << " bodies)\n";

    os << "  Assignments: " << laHeadAssignments_ + laBodyAssignments_ 
       << " (" << laHeadAssignments_ << " heads, " 
       << laBodyAssignments_ << " bodies)\n";

    os << "  Forced conflicts: " << laHeadChoiceRecolors_ + laBodyChoiceRecolors_
       << " (" << laHeadChoiceRecolors_ << " heads, " 
       << laBodyChoiceRecolors_ << " bodies)\n";
  }

  if(heuHeadCps_ + heuBodyCps_ > 0) {
    os << "Heuristics summary:\n";

    os << "  Checked nodes: " << heuHeadCps_ + heuBodyCps_  
       << " (" << heuHeadCps_ << " heads, " << heuBodyCps_ << " bodies)\n";

    os << "  Assignments: " << heuHeadAssignments_ + heuBodyAssignments_ 
       << " (" << heuHeadAssignments_ << " heads, " 
       << heuBodyAssignments_ << " bodies)\n";
  }
}

}
