#ifndef GRAPHTEST_H
#define GRAPHTEST_H

#include <cppunit/extensions/HelperMacros.h>
namespace NS_NOMORE {
  class Graph;
}
namespace NS_NOMORE_TESTS {

class GraphTest : public CPPUNIT_NS::TestFixture
{
  CPPUNIT_TEST_SUITE( GraphTest );
  CPPUNIT_TEST( testEmpty );
  CPPUNIT_TEST( testInsertBodyNode );
  CPPUNIT_TEST( testInsertHeadNode );
  CPPUNIT_TEST( testSetColor );
  CPPUNIT_TEST( testRestoreColor );
  CPPUNIT_TEST( testClear );
  CPPUNIT_TEST( testNumbering );

  CPPUNIT_TEST_SUITE_END();
  NS_NOMORE::Graph* graph;
public:
  void setUp();
  void tearDown();

  void testEmpty();

  //! Tests the method Graph::insertBodyNode() and Graph::getBodyNode().
  void testInsertBodyNode();

  //! Tests the method Graph::insertHeadNode() and Graph::getHeadNode().
  void testInsertHeadNode();

  //! Tests the method Graph::setColor().
  void testSetColor();

  //! Tests the method Graph::restoreColor().
  void testRestoreColor();

  //! Tests the method Graph::clear().
  void testClear();

  void testNumbering();
};

} // NS_NOMORE_TESTS

#endif
