/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_NO_UNFOUNDED_CHECK_H_INCLUDED
#define LIBNOMORE_NO_UNFOUNDED_CHECK_H_INCLUDED

#include <operators/default_local_propagator.h>
namespace NS_NOMORE {

//! Propagator implements the full propagation without unfounded set check.
/*!
 *  \note This propagator is only useable if the logic program is tight. Tight
 *        means there are no cyclic structures. There are only trivial 
 *        connected body and head nodes. */
class NoUnfoundedCheck : public DefaultLocalPropagator {
public:
  //! Initializes the propagator using the underlying graph.
  /*!
   *  \param g The graph used to operate on. */
  explicit NoUnfoundedCheck(Graph& g);

  //! Full propagation using forward and backward propagation and in this case no unfounded set check.
  /*!
   *  \pre The current assignment is conflict-free.
   *  \return Returns false on conflict. */
  virtual bool propagateFull();

  //! Returns the name of the propagator.
  /*!
   *  \return The name of the propagator. */
	virtual const char* getName() const;
};

}

#endif
