/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/
#ifndef NOMORE_PRINTER_H
#define NOMORE_PRINTER_H

namespace NS_NOMORE {

class Graph;

//! Base class for answer set printer.
/*! This class declares an interface for printing answer sets.
 *  Concrete subclasses implement this interface to print answer sets in a
 *  specific format to a specific output device. */
class Printer {
public:
  //! Constructs the printer.
  Printer();

  //! Destroys the printer.
  virtual ~Printer();

  //! Prints the answer (depending on the implementation of print()).
  /*!
   *  First records the number of the current answer set then calls print.
   *  \param nr The current number of the answer set to print.
   *  \param grp The totally colored graph.
   *
   *  \pre The graph has been colored totally.
   */
  void operator()(int nr, const Graph& grp) {
    counter_ = nr;
    print(nr, grp);
  }

  //! Returns the number of answer sets printed.
  int getNrOfFoundAS() const;

private:
  // deny usage
  Printer(const Printer&);
  Printer& operator=(const Printer&);

  // instance methods
	/*!
	 * subclass must override this method to print the current answer set in a
   * certain format to some device. */
  virtual void print(int nr, const Graph& g) = 0;

  // instance variables
  int counter_;
};

}

#endif
