/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/
#ifndef NOMORE_STDSET_PRINTER_H
#define NOMORE_STDSET_PRINTER_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
  #pragma warning (disable : 4786)
  #pragma warning (disable : 4503)
#endif

#include <printer.h>

#include <set>
#include <string>

namespace NS_NOMORE {

//! Writes the answer sets to a std::set.
/*!
 *  This printer is useful to check the answer sets for correctness. The
 *  answer sets are stored as set of strings in a std::set. */
class StdSetPrinter : public Printer {
public:
  //! Type defining one answer set.
  typedef std::set<std::string> AnswerSet;

  //! Type defining a set of answer sets.
  typedef std::set<AnswerSet> AllAnswerSets;

  //! Constructs the object.
  StdSetPrinter() {}

  //! Returns the set of all answer sets.
  /*!
   *  \return Returns the set of answer sets set by the method operator(). */
  AllAnswerSets& getAnswerSets() {
    return _answerSets;
  }

private:
  // instance methods
  void print(int nr, const Graph& g);

  // instance variables
  AllAnswerSets _answerSets;
};

}

#endif
