/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_STATISTICS_OBJECT_H
#define NOMORE_STATISTICS_OBJECT_H

#include <iosfwd>

namespace event {
  class ChannelManager;
}

namespace NS_NOMORE {

class Operator;

//! Interface for gathering statistic information about the AS computation process.
class StatisticsObject {
public:
  //! Mode in which the nomore++ system currently is.
  struct Mode {
    enum Value {
      //! The normal propagation is enabled.
      normal,

      //! The lookahead as propagation or heuristic is enabled.
      lookahead,

      //! The heuristic is enabled to compute the next choice point.
      heuristic
    };
  };

  //! Initializes the mode value to normal propagation mode.
  StatisticsObject();

  //! Cleans up the instance.
  virtual ~StatisticsObject();

  //! Prints the gathered results into a given output stream.
  /*! 
   *  \param os The output stream to write the informations to. */
  virtual void print(std::ostream&) const {
  }

  //! Sets the current mode of the computation.
  /*!
   *  \param val The current mode of nomore's computation. */
  static void setCurrentMode(Mode::Value val) {
    currentMode_ = val;
  }

  //! Returns the current mode of the computation.
  /*! 
   *  \return Returns the current computational mode. */
  static Mode::Value getCurrentMode() {
    return currentMode_;
  }

private:
  //! instance methods
  /*! 
   *  Register with the event handles. Concrete subclasses implement this 
   *  method in order to register themselves as event handlers. */
  virtual void registerWith(event::ChannelManager&) {
  }

  // class variables
  static Mode::Value currentMode_;
};

}

#endif
