/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_STATS_H
#define NOMORE_STATS_H

#include <iosfwd>
#include <vector>
#include <time.h>

#include <statistics/statistics_object.h>

namespace NS_NOMORE {

//! Class for gathering several statistics information.
class Statistics {
public:
  //! Initializes the timers.
  Statistics();

  //! Cleans up the statistics.
  virtual ~Statistics();

  //! Prints all result of the information gathering.
  /*! 
   *  Writes all informations gathered in the added statistic objects and 
   *  some timing informations.
   *  \param os The output stream used to write the informations. */
  void print(std::ostream& os) const;

  //! Starts the internal timer.
  void startTimer();
  
  //! Stops the internal timer.
  void stopTimer();

  //! Adds a statistic object which gets more statistic informations.
  /*!
   *  \param stats The statistics object which gathers several informations 
   *               produced during the computation. */
  void add(StatisticsObject* stats);

private:
  // Prints the time elapsed between calls to startTimer() and stopTimer().
  /*! 
   *  \param os The output stream used to write the informations. */
  void printTimer(std::ostream& os) const;

  // deny usage
  Statistics(const Statistics&);
  Statistics& operator=(const Statistics&);

  // instance variables
  std::vector<StatisticsObject*> statistics_;
  unsigned long sec_;
  unsigned long msec_;
  clock_t timer_;
};

}

#endif
