//
//	(C) Copyright Benjamin Kaufmann, 2004-2005. 
//	Permission to copy, use, modify, sell and distribute this software is 
//	granted provided this copyright notice appears in all copies. 
//	This software is provided "as is" without express or implied warranty, 
//	and with no claim as to its suitability for any purpose.
//
#ifndef EVENT_EVENTLIST_H_INCLUDED
#define EVENT_EVENTLIST_H_INCLUDED

namespace event { namespace detail {

template <class H, class T>
struct EventList
{
    typedef H Head;
    typedef T Tail;
};

struct NoEvent {};

}	// end namespace event::detail

/*!
 * \brief The class EventList is a convenience class for specifying list
 * of events.
 *
 */
template
<
    typename T1  = detail::NoEvent, typename T2  = detail::NoEvent, typename T3  = detail::NoEvent,
    typename T4  = detail::NoEvent, typename T5  = detail::NoEvent, typename T6  = detail::NoEvent,
    typename T7  = detail::NoEvent, typename T8  = detail::NoEvent, typename T9  = detail::NoEvent,
    typename T10 = detail::NoEvent, typename T11 = detail::NoEvent, typename T12 = detail::NoEvent,
    typename T13 = detail::NoEvent, typename T14 = detail::NoEvent, typename T15 = detail::NoEvent,
    typename T16 = detail::NoEvent, typename T17 = detail::NoEvent, typename T18 = detail::NoEvent
>
struct EventList
{
private:
    typedef typename EventList
    <
        T2 , T3 , T4 ,
        T5 , T6 , T7 ,
        T8 , T9 , T10,
        T11, T12, T13,
        T14, T15, T16,
        T17, T18
    >
    ::Result TailResult;

public:
    typedef detail::EventList<T1, TailResult> Result;
};

template<>
struct EventList
<
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent,
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent,
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent,
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent,
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent,
	event::detail::NoEvent, event::detail::NoEvent, event::detail::NoEvent
>
{
	typedef event::detail::NoEvent Result;
};

}	// end of namespace event

#endif
