/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_STANDARD_STATS_H
#define LIBNOMORE_STANDARD_STATS_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <iosfwd>

#include <statistics/statistics_object.h>

namespace NS_NOMORE {

class Graph;
struct HeadNodeColored;
struct BodyNodeColored;
struct BodyNodeColoredChoicePoint;
struct HeadNodeColoredChoicePoint;

//! Counts some statistic information for node coloring.
/*!
 *  The following information are gathered using the computation mode and 
 *  several head and body node events:
 *    - number of head/body choice points in normal propagation, lookahead 
 *      and heuristics
 *    - number of head/body choices in normal propagation, lookahead and 
 *      heuristics
 *    - number of head/body assignments in normal propagation, lookahead and 
 *      heuristics
 *    - number of head/body choice recolors in normal propagation, lookahead 
 *      and heuristics */
class StandardStatistics : public StatisticsObject {
public:
  //! Initializes all counters
  /*! 
   *  \param m Channel manager for registering at desired channels. */
  StandardStatistics(event::ChannelManager& m);
  
  //! Prints the counters to a stream.
  /*!
   *  \param os The output stream to write the counter stats to. */
  void print(std::ostream& os) const;

  //! Event handler for HeadNodeColored events.
  /*!
   *  \param e The raised event. */
  void handle(const HeadNodeColored& e);

  //! Event handler for BodyNodeColored events.
  /*!
   *  \param e The raised event. */
  void handle(const BodyNodeColored& e);

  //! Event handler for BodyNodeColoredChoicePoint events.
  /*!
   *  \param e The raised event. */
  void handle(const BodyNodeColoredChoicePoint& e);

  //! Event handler for HeadNodeColoredChoicePoint events.
  /*!
   *  \param e The raised event. */
  void handle(const HeadNodeColoredChoicePoint& e);

private:
  // instance methods
  void registerWith(event::ChannelManager& m);

  // instance variables
  long headCps_;
  long bodyCps_;
  long headChoices_;
  long bodyChoices_;
  long headAssignments_;
  long bodyAssignments_;
  long headChoiceRecolors_;
  long bodyChoiceRecolors_;

  long laHeadCps_;
  long laBodyCps_;
  long laHeadChoices_;
  long laBodyChoices_;
  long laHeadAssignments_;
  long laBodyAssignments_;
  long laHeadChoiceRecolors_;
  long laBodyChoiceRecolors_;

  long heuHeadCps_;
  long heuBodyCps_;
  long heuHeadChoices_;
  long heuBodyChoices_;
  long heuHeadAssignments_;
  long heuBodyAssignments_;
  long heuHeadChoiceRecolors_;
  long heuBodyChoiceRecolors_;

};

}

#endif
