/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/
#ifndef LIBNOMORE_STRONG_COMPONENTS_H
#define LIBNOMORE_STRONG_COMPONENTS_H

/*!
 *  \file strong_components.h
 *
 *  The function identifyStrongComponents assigns a component number to each 
 *  node of a given graph. This component number can be used to provide a 
 *  constant time test of whether two nodes are in the same strong component. */

namespace NS_NOMORE {

class Graph;

//! The number for a trivial component.
/*!
 *  This value is assigned to nodes which are trivially connected. Trivially 
 *  connected means that the node is not circular dependend on itself. The 
 *  value 0 is assigned to nodes that stronly connected component is unknown. */
const int trivialComponent = -1;

//! Assigns every node in the input graph a component number.
/*!
 *  Implements Tarjan's algorithm for finding strong components in the graph g.
 *
 *  \pre  The ids of the graph's nodes are in the range [0..g.countNodes()-1].
 *  \post Each node were assigned a component number in the range 
 *        [-1, nrComponents - 1].
 *  \return The number of non-trivial strong components contained in g.
 *
 *  \see Robert Sedgewick: "Algorithms in C++ - Part 5, page 205ff" */
int identifyStrongComponents(Graph& g);

}

#endif
