/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <nary_backtracking_solver.h>
#include <graph.h>
#include <operator.h>
#include <choice_operator.h>
#include <heuristic.h>
#include <cassert>
namespace NS_NOMORE {

NaryBacktrackingSolver::NaryBacktrackingSolver() 
  : Solver()
  , choiceOp_(0) {  
}  
  
NaryBacktrackingSolver::NaryBacktrackingSolver(int as, Propagator* prop, Lookahead* look, ChoiceOperator* choice, Printer* printer)
  : Solver(as, prop, look, choice, printer)
  , choiceOp_(0) {
}

bool NaryBacktrackingSolver::backtrack(Graph& grp) {
  bool ok = false;
  bool restored = false;
  while ( !ok && (restored = grp.recolorChoicePoint()) == true ) {
    if ( det_->propagateFull() ) {
      ok = true;
      grp.getEventManager().dispatch(HeuristicValuesEvent(HeuristicValuesEvent::restore));
      if ((*choice_)(ColorOpType::next_choice)) {
        // new choice colored
        grp.getEventManager().dispatch(HeuristicValuesEvent(HeuristicValuesEvent::save));
      }
      else {
        assert(!grp.hasConflict() && "error in Nary::Backtrack");
      }
      
    } 
  }
  return restored;
}

bool NaryBacktrackingSolver::choose(Graph& grp) {
  bool res = (*choice_)();
  grp.getEventManager().dispatch(HeuristicValuesEvent(HeuristicValuesEvent::save));
  return res;
}

}
