#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/body_lookahead_heuristic.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class BodyLookaheadHeuristicTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(BodyLookaheadHeuristicTest);
  CPPUNIT_TEST(testNoChoices);
  CPPUNIT_TEST(testNoValue);
  CPPUNIT_TEST(testMixedValues);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph();
    heu = new BodyLookaheadHeuristic();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete graph;
    delete heu;
  }

  void testNoChoices() {    
    CPPUNIT_ASSERT_EQUAL( (Node*)0, heu->selectNode(noConstraint).node() );
  }

  void testNoValue() {
    graph->insertBodyNode();
    graph->insertBodyNode();
    graph->insertBodyNode();
    
    CPPUNIT_ASSERT( 0 == heu->selectNode(noConstraint).node() );
  }

  void testMixedValues() {
    BodyNode* bn[4];
    for (int i = 0; i != 4; ++i)
      bn[i] = graph->insertBodyNode();

    heu->handle(LookaheadExecution(ActivityState::started));
    heu->addHeuristicValue(bn[0], BodyLookahead::HeuristicValueType(1,1));
    heu->addHeuristicValue(bn[2], BodyLookahead::HeuristicValueType(4,3));
    heu->addHeuristicValue(bn[3], BodyLookahead::HeuristicValueType(4,2));
    heu->handle(LookaheadExecution(ActivityState::finished));
    CPPUNIT_ASSERT_EQUAL( static_cast<Node*>(bn[2]), heu->selectNode(noConstraint).node() );
  }

private:
  NoConstraint noConstraint;
  Graph* graph;
  BodyLookaheadHeuristic* heu;

};

CPPUNIT_TEST_SUITE_REGISTRATION(BodyLookaheadHeuristicTest);

} // end namespace NS_NOMORE_TESTS
