#!/usr/bin/env python
#########################################################################
#   Copyright 2011 Torsten Grote
#
#	This program is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.
##########################################################################

import sys
import os
import time
import subprocess
import tempfile

TESTS = [
	['access', 'accessBase.lp',       'streams/accessgen01.str', 'streams/accessgen01.str'],
	['access', 'accessCumulative.lp', 'streams/accessgen01.str', 'streams/accessgen01.str'],
	['access', 'accessReground.lp',   'streams/accessgen01.str', 'streams/accessgen01.str'],
	['access', 'accessVolatile.lp',   'streams/accessgen01.str', 'streams/accessgen01.str'],
	['access', 'accessBase.lp',       'streams/accessgen02.str', 'streams/accessgen02.str'],
	['access', 'accessCumulative.lp', 'streams/accessgen02.str', 'streams/accessgen02.str'],
	['access', 'accessReground.lp',   'streams/accessgen02.str', 'streams/accessgen02.str'],
	['access', 'accessVolatile.lp',   'streams/accessgen02.str', 'streams/accessgen02.str'],
#	['access', 'accessBase.lp',       'streams/accessgen03.str', 'streams/accessgen03.str'],
#	['access', 'accessCumulative.lp', 'streams/accessgen03.str', 'streams/accessgen03.str'],
#	['access', 'accessReground.lp',   'streams/accessgen03.str', 'streams/accessgen03.str'],
#	['access', 'accessVolatile.lp',   'streams/accessgen03.str', 'streams/accessgen03.str'],
#	['access', 'accessBase.lp',       'streams/accessgen04.str', 'streams/accessgen04.str'],
#	['access', 'accessCumulative.lp', 'streams/accessgen04.str', 'streams/accessgen04.str'],
#	['access', 'accessReground.lp',   'streams/accessgen04.str', 'streams/accessgen04.str'],
#	['access', 'accessVolatile.lp',   'streams/accessgen04.str', 'streams/accessgen04.str'],

	['overtaking', 'overtakingBase.lp',      'streams/overtaking1f.str', 'streams/overtaking1fBase.out'],
	['overtaking', 'overtakingCumulative.lp','streams/overtaking1f.str', 'streams/overtaking1fOther.out'],
	['overtaking', 'overtakingReground.lp',  'streams/overtaking1f.str', 'streams/overtaking1fReground.out'],
	['overtaking', 'overtakingVolatile.lp',  'streams/overtaking1f.str', 'streams/overtaking1fOther.out'],
	['overtaking', 'overtakingBase.lp',      'streams/overtaking2f.str', 'streams/overtaking2fBase.out'],
	['overtaking', 'overtakingCumulative.lp','streams/overtaking2f.str', 'streams/overtaking2fOther.out'],
	['overtaking', 'overtakingReground.lp',  'streams/overtaking2f.str', 'streams/overtaking2fReground.out'],
	['overtaking', 'overtakingVolatile.lp',  'streams/overtaking2f.str', 'streams/overtaking2fOther.out'],
	['overtaking', 'overtakingBase.lp',      'streams/overtaking3f.str', 'streams/overtaking3fBase.out'],
	['overtaking', 'overtakingCumulative.lp','streams/overtaking3f.str', 'streams/overtaking3fOther.out'],
	['overtaking', 'overtakingReground.lp',  'streams/overtaking3f.str', 'streams/overtaking3fReground.out'],
	['overtaking', 'overtakingVolatile.lp',  'streams/overtaking3f.str', 'streams/overtaking3fOther.out'],
	['overtaking', 'overtakingBase.lp',      'streams/otgen01.str'],
	['overtaking', 'overtakingCumulative.lp','streams/otgen01.str'],
	['overtaking', 'overtakingReground.lp',  'streams/otgen01.str'],
	['overtaking', 'overtakingVolatile.lp',  'streams/otgen01.str'],
	['overtaking', 'overtakingBase.lp',      'streams/otgen02.str', 'streams/otgen02.str'],
	['overtaking', 'overtakingCumulative.lp','streams/otgen02.str', 'streams/otgen02.str'],
	['overtaking', 'overtakingReground.lp',  'streams/otgen02.str', 'streams/otgen02.str'],
	['overtaking', 'overtakingVolatile.lp',  'streams/otgen02.str', 'streams/otgen02.str'],
	['overtaking', 'overtakingBase.lp',      'streams/otgen03.str', 'streams/otgen03.str'],
	['overtaking', 'overtakingCumulative.lp','streams/otgen03.str', 'streams/otgen03.str'],
	['overtaking', 'overtakingReground.lp',  'streams/otgen03.str', 'streams/otgen03.str'],
	['overtaking', 'overtakingVolatile.lp',  'streams/otgen03.str', 'streams/otgen03.str'],
#	['overtaking', 'overtakingBase.lp',      'streams/otgen04.str', 'streams/otgen04.str'],
#	['overtaking', 'overtakingCumulative.lp','streams/otgen04.str', 'streams/otgen04.str'],
#	['overtaking', 'overtakingReground.lp',  'streams/otgen04.str', 'streams/otgen04.str'],
#	['overtaking', 'overtakingVolatile.lp',  'streams/otgen04.str', 'streams/otgen04.str'],

	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str1',   'streams/200_3x3x3_9.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str2',   'streams/200_3x3x3_9.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str3',   'streams/200_3x3x3_9.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str1',  'streams/200_5x3x5_15.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str2',  'streams/200_5x3x5_15.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str3',  'streams/200_5x3x5_15.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str1',   'streams/200_5x5x15_20.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str2',   'streams/200_5x5x15_20.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str3',   'streams/200_5x5x15_20.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str1',  'streams/200_10x5x20_20.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str2',  'streams/200_10x5x20_20.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str3',  'streams/200_10x5x20_20.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str1',  'streams/200_5x5x10_30.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str2',  'streams/200_5x5x10_30.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str3',  'streams/200_5x5x10_30.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str1',   'streams/600_3x3x3_9.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str2',   'streams/600_3x3x3_9.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str3',   'streams/600_3x3x3_9.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str1',  'streams/600_5x3x5_15.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str2',  'streams/600_5x3x5_15.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str3',  'streams/600_5x3x5_15.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str1',  'streams/600_5x5x15_20.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str2',  'streams/600_5x5x15_20.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str3',  'streams/600_5x5x15_20.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str1',  'streams/600_10x5x20_20.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str2',  'streams/600_10x5x20_20.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str3',  'streams/600_10x5x20_20.str3'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str1',  'streams/600_5x5x10_30.str1'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str2',  'streams/600_5x5x10_30.str2'],
	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str3',  'streams/600_5x5x10_30.str3'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str1',  'streams/1000_3x3x3_9.str1'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str2',  'streams/1000_3x3x3_9.str2'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str3',  'streams/1000_3x3x3_9.str3'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str1', 'streams/1000_5x3x5_15.str1'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str2', 'streams/1000_5x3x5_15.str2'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str3', 'streams/1000_5x3x5_15.str3'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str1',  'streams/1000_5x5x15_20.str1'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str2',  'streams/1000_5x5x15_20.str2'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str3',  'streams/1000_5x5x15_20.str3'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str1',  'streams/1000_10x5x20_20.str1'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str2',  'streams/1000_10x5x20_20.str2'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str3',  'streams/1000_10x5x20_20.str3'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str1',  'streams/1000_5x5x10_30.str1'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str2',  'streams/1000_5x5x10_30.str2'],
#	['jobscheduling', 'jobscheduleB_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str3',  'streams/1000_5x5x10_30.str3'],

	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str1',   'streams/200_3x3x3_9.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str2',   'streams/200_3x3x3_9.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/200_3x3x3_9.str3',   'streams/200_3x3x3_9.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str1',  'streams/200_5x3x5_15.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str2',  'streams/200_5x3x5_15.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/200_5x3x5_15.str3',  'streams/200_5x3x5_15.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str1',   'streams/200_5x5x15_20.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str2',   'streams/200_5x5x15_20.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp',  'streams/200_5x5x15_20.str3',   'streams/200_5x5x15_20.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str1',  'streams/200_10x5x20_20.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str2',  'streams/200_10x5x20_20.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/200_10x5x20_20.str3',  'streams/200_10x5x20_20.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str1',  'streams/200_5x5x10_30.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str2',  'streams/200_5x5x10_30.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/200_5x5x10_30.str3',  'streams/200_5x5x10_30.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str1',   'streams/600_3x3x3_9.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str2',   'streams/600_3x3x3_9.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/600_3x3x3_9.str3',   'streams/600_3x3x3_9.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str1',  'streams/600_5x3x5_15.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str2',  'streams/600_5x3x5_15.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/600_5x3x5_15.str3',  'streams/600_5x3x5_15.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str1',  'streams/600_5x5x15_20.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str2',  'streams/600_5x5x15_20.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/600_5x5x15_20.str3',  'streams/600_5x5x15_20.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str1',  'streams/600_10x5x20_20.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str2',  'streams/600_10x5x20_20.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/600_10x5x20_20.str3',  'streams/600_10x5x20_20.str3'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str1',  'streams/600_5x5x10_30.str1'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str2',  'streams/600_5x5x10_30.str2'],
	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/600_5x5x10_30.str3',  'streams/600_5x5x10_30.str3'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str1',  'streams/1000_3x3x3_9.str1'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str2',  'streams/1000_3x3x3_9.str2'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/3x3x3_9_domain.lp',  'streams/1000_3x3x3_9.str3',  'streams/1000_3x3x3_9.str3'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str1', 'streams/1000_5x3x5_15.str1'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str2', 'streams/1000_5x3x5_15.str2'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x3x5_15_domain.lp', 'streams/1000_5x3x5_15.str3', 'streams/1000_5x3x5_15.str3'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str1',  'streams/1000_5x5x15_20.str1'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str2',  'streams/1000_5x5x15_20.str2'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x15_20_domain.lp', 'streams/1000_5x5x15_20.str3',  'streams/1000_5x5x15_20.str3'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str1',  'streams/1000_10x5x20_20.str1'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str2',  'streams/1000_10x5x20_20.str2'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/10x5x20_20_domain.lp', 'streams/1000_10x5x20_20.str3',  'streams/1000_10x5x20_20.str3'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str1',  'streams/1000_5x5x10_30.str1'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str2',  'streams/1000_5x5x10_30.str2'],
#	['jobscheduling', 'jobscheduleC_unsat.lp', 'streams/5x5x10_30_domain.lp', 'streams/1000_5x5x10_30.str3',  'streams/1000_5x5x10_30.str3'],
		]

NO_COMPARE = [ 'access', 'overtaking', 'jobscheduling' ]

OCLINGO = '../oclingo'
CONTROLLER = '../controller.py'
RUNSCRIPT = sys.path[0] + '/startoclingo.sh'

def main():
	tests = []
	for test in TESTS:
		tests.append(TestCase(test))

	findPrograms()
	print

	for test in tests:
		test_string = test.name + " " + str.rsplit(test.encoding, '/')[-1] + " " +  str.rsplit(test.online, '/')[-1]

		print "Running " + test.uid + " ..."
		
		if not os.path.isfile(sys.path[0] + '/results/' + test.uid):
			runOClingo(test)
			result = runController(test)
			
			if result:
				print "Test " + test_string + " completed sucessfully.\n"
			else:
				print "Error: Test " + test_string + " failed!\n"
				return 1
		else:
			print "Test " + test_string + " skippped. Result already exisists.\n"


	print
	print "**********************************************"
	print "* ALL BENCHMARK RUNS SUCCESSFULLY COMPLETED! *"
	print "**********************************************"

	return 0

class TestCase:
	def __init__(self, case):
		self.name = case[0]
		self.encoding = os.path.join(self.name, case[1])
		if len(case) > 3:
			self.instance = os.path.join(self.name, case[2])
			self.online = os.path.join(self.name, case[3])
		else:
			self.instance = ''
			self.online = os.path.join(self.name, case[2])
		self.check()
		self.uid = self.name + "-" + str.rsplit(self.encoding, '/')[-1].replace('.lp','') + "-" +  str.rsplit(self.online, '/')[-1]

	def check(self):
		if not os.path.isfile(self.encoding):
			raise IOError('File not found: ' + self.encoding)
		if self.instance != '' and not os.path.isfile(self.instance):
			raise IOError('File not found: ' + self.instance)
		if not os.path.isfile(self.online):
			raise IOError('File not found: ' + self.online)


def findPrograms():
	global OCLINGO
	if not os.path.exists(OCLINGO):
		OCLINGO = '../../qtcreator-build/bin/oclingo'
		if not os.path.exists(OCLINGO):
			OCLINGO = '../../build/release/bin/oclingo'
			if not os.path.exists(OCLINGO):
				OCLINGO = '../../build/debug/bin/oclingo'
	try:
		subprocess.call([OCLINGO, '--version'], stdout=open('/dev/null', 'w'), stderr=open('/dev/null', 'w'))
	except OSError, err:
		print "Error: Could not find", OCLINGO, err
		sys.exit(1)
	print "Found oClingo at " + OCLINGO

	global CONTROLLER
	if not os.path.exists(CONTROLLER):
		CONTROLLER = './controller.py'
		if not os.path.exists(CONTROLLER):
			CONTROLLER = 'controller.py'
	try:
		subprocess.call([CONTROLLER, '--version'], stdout=open('/dev/null', 'w'), stderr=open('/dev/null', 'w'))
	except OSError, err:
		print "Error: Could not find", CONTROLLER, err
		sys.exit(1)
	print "Found controller at " + CONTROLLER


def runOClingo(test):
	global OCLINGO
	global RUNSCRIPT
	try:
		subprocess.Popen([RUNSCRIPT, OCLINGO+' '+test.instance+' '+test.encoding+' '+'--imax=1000001'+' '+'--istats=3'+' '+'1', test.uid], stdin=None, stdout=None, stderr=open('/dev/null', 'w')).pid
	except OSError, err:
		print err
		sys.exit(1)
	

def runController(test):
	global CONTROLLER
	try:
		# dirty hack to wait until socket is open
		for n in range(1, 5000):
			tmp = subprocess.call("netstat -tln | grep ':25277 .* LISTEN'", stdout=open('/dev/null', 'w'), stderr=open('/dev/null', 'w'), shell=True)
			if tmp == 0:
				print "Found something listening on port 25277. Starting controller..."
				break;
			else:
				time.sleep(0.3)
		
		subprocess.check_call([CONTROLLER, '-t 0', test.online], stdin=None, stdout=open('/dev/null', 'w'), stderr=None)
		
		return True
	except OSError, err:
		print err
		sys.exit(1)

if __name__ == '__main__':
	if sys.version < '2.6':
		print 'You need at least python 2.6'
		sys.exit(1)

#	try:
	sys.exit(main())
#	except Exception, err:
#		sys.stderr.write('ERROR: %s\n' % str(err))
#		sys.exit(1)

