#! /usr/bin/env python
# -*- coding: utf-8 -*-

#
# Re-launch clingo for Online Job Scheduling
#
# Orkunt Sabuncu
#

import argparse
import sys
import re
import subprocess

STEP_PTRN = re.compile(r'^#step[ ]*(\d+)')
VOLATILE_PTRN = None    # will be initialized with window size
CLOSING_PTRN = re.compile(r'^#endstep')
STATEMENT_PTRN = re.compile(r'^#')
MAX_STEP_PTRN = re.compile(r'^%% Maximum schedule timespan: (\d+)')

parser = argparse.ArgumentParser(description='Re-launch clingo with a stream.')
parser.add_argument('-s', dest='streamfile', help='input stream file')
parser.add_argument('-e', dest='encodingfile', help='logic program encoding file')
parser.add_argument('-i', dest='instancefile', help='instance file')
#parser.add_argument('-t', dest='maxstep', type=int, help='maximum schedule timespan (max_step in encoding)')

args = parser.parse_args()
#print args
#if args.windowsize:
  #VOLATILE_PTRN = re.compile(r'#volatile[ ]*:[ ]*%d' %(args.windowsize))

def callWithFiltering():
  # TODO
  print ''

def callWithoutFiltering():
  inputstream = {}
  insidestep = False
  maxstep = 1 # default if not specified
  stream = open(args.streamfile,'r')
  
  for line in stream:
    #sys.stdout.write('%s' %(line))
    
    o = CLOSING_PTRN.match(line)
    m = MAX_STEP_PTRN.match(line)
    if m:
      maxstep = m.group(1)
    if o:
      # send the input
      insidestep = False
      sys.stdout.write('\n')
      sys.stdout.write('new input: %s\n' %(inputstream[currentstep]))
      #print inputstream[currentstep]
      command = ['clingo','--stats=3','-c','max_step='+str(maxstep)]
      if args.instancefile:
        command.append(args.instancefile)
      command.append(args.encodingfile)
      command.append('-')
      print "Running ",
      print command
      clingo_process = subprocess.Popen(command, stdin=subprocess.PIPE, stdout=subprocess.PIPE)
      clingo_process.stdin.write('currenttime(%d).\n' %(currentstep))
      #for i in xrange(1,currentstep+1):
      for i in inputstream:
        for a in inputstream[i]:
          #sys.stdout.write('%s' %(a))
          clingo_process.stdin.write('%s' %(a))
      sys.stdout.write('Step: %d\n' %(currentstep))
      sys.stdout.write('%s' %(clingo_process.communicate()[0]))
      continue
    
    o = STEP_PTRN.match(line)
    if o:
      currentstep = int(o.group(1))
      insidestep = True
      inputstream[currentstep] = []
      continue
    
    o = STATEMENT_PTRN.match(line)
    if not o and insidestep:
      inputstream[currentstep].append(line)
      continue


def main():
  callWithoutFiltering()

if __name__ == "__main__":
  main()
