/*
 * generated by Xtext 2.9.0
 */
package mgpl.serializer;

import com.google.inject.Inject;
import java.util.Set;
import mgpl.mGPL.And;
import mgpl.mGPL.AnimBlock;
import mgpl.mGPL.ArrayDecl;
import mgpl.mGPL.AssStmt;
import mgpl.mGPL.AttrAss;
import mgpl.mGPL.Complement;
import mgpl.mGPL.Divide;
import mgpl.mGPL.ElementSelect;
import mgpl.mGPL.Equals;
import mgpl.mGPL.EventBlock;
import mgpl.mGPL.ForStmt;
import mgpl.mGPL.IfStmt;
import mgpl.mGPL.Less;
import mgpl.mGPL.LessOrEquals;
import mgpl.mGPL.MGPLPackage;
import mgpl.mGPL.MemberSelect;
import mgpl.mGPL.Minus;
import mgpl.mGPL.Negation;
import mgpl.mGPL.NumberLiteral;
import mgpl.mGPL.ObjDecl;
import mgpl.mGPL.Or;
import mgpl.mGPL.ParamDecl;
import mgpl.mGPL.Plus;
import mgpl.mGPL.Prog;
import mgpl.mGPL.StmtBlock;
import mgpl.mGPL.Times;
import mgpl.mGPL.Touches;
import mgpl.mGPL.Var;
import mgpl.mGPL.VarDecl;
import mgpl.services.MGPLGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class MGPLSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private MGPLGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == MGPLPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case MGPLPackage.AND:
				sequence_ConjExpr(context, (And) semanticObject); 
				return; 
			case MGPLPackage.ANIM_BLOCK:
				sequence_AnimBlock(context, (AnimBlock) semanticObject); 
				return; 
			case MGPLPackage.ARRAY_DECL:
				if (rule == grammarAccess.getObjDeclRule()) {
					sequence_ObjDecl(context, (ArrayDecl) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getDeclRule()
						|| rule == grammarAccess.getAllDeclsRule()) {
					sequence_ObjDecl_VarDecl(context, (ArrayDecl) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getVarDeclRule()) {
					sequence_VarDecl(context, (ArrayDecl) semanticObject); 
					return; 
				}
				else break;
			case MGPLPackage.ASS_STMT:
				sequence_AssStmt(context, (AssStmt) semanticObject); 
				return; 
			case MGPLPackage.ATTR_ASS:
				sequence_AttrAss(context, (AttrAss) semanticObject); 
				return; 
			case MGPLPackage.COMPLEMENT:
				sequence_UnaryExpr(context, (Complement) semanticObject); 
				return; 
			case MGPLPackage.DIVIDE:
				sequence_MultExpr(context, (Divide) semanticObject); 
				return; 
			case MGPLPackage.ELEMENT_SELECT:
				sequence_Var(context, (ElementSelect) semanticObject); 
				return; 
			case MGPLPackage.EQUALS:
				sequence_RelExpr(context, (Equals) semanticObject); 
				return; 
			case MGPLPackage.EVENT_BLOCK:
				sequence_EventBlock(context, (EventBlock) semanticObject); 
				return; 
			case MGPLPackage.FOR_STMT:
				sequence_ForStmt(context, (ForStmt) semanticObject); 
				return; 
			case MGPLPackage.IF_STMT:
				sequence_IfStmt(context, (IfStmt) semanticObject); 
				return; 
			case MGPLPackage.LESS:
				sequence_RelExpr(context, (Less) semanticObject); 
				return; 
			case MGPLPackage.LESS_OR_EQUALS:
				sequence_RelExpr(context, (LessOrEquals) semanticObject); 
				return; 
			case MGPLPackage.MEMBER_SELECT:
				sequence_Var(context, (MemberSelect) semanticObject); 
				return; 
			case MGPLPackage.MINUS:
				sequence_AddExpr(context, (Minus) semanticObject); 
				return; 
			case MGPLPackage.NEGATION:
				sequence_UnaryExpr(context, (Negation) semanticObject); 
				return; 
			case MGPLPackage.NUMBER_LITERAL:
				sequence_PrimExpr(context, (NumberLiteral) semanticObject); 
				return; 
			case MGPLPackage.OBJ_DECL:
				if (action == grammarAccess.getObjDeclAccess().getArrayDeclVariableAction_2_1_0()) {
					sequence_ObjDecl_ArrayDecl_2_1_0(context, (ObjDecl) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getDeclRule()
						|| rule == grammarAccess.getObjDeclRule()
						|| rule == grammarAccess.getAllDeclsRule()) {
					sequence_ObjDecl(context, (ObjDecl) semanticObject); 
					return; 
				}
				else break;
			case MGPLPackage.OR:
				sequence_DisjExpr(context, (Or) semanticObject); 
				return; 
			case MGPLPackage.PARAM_DECL:
				sequence_ParamDecl(context, (ParamDecl) semanticObject); 
				return; 
			case MGPLPackage.PLUS:
				sequence_AddExpr(context, (Plus) semanticObject); 
				return; 
			case MGPLPackage.PROG:
				sequence_Prog(context, (Prog) semanticObject); 
				return; 
			case MGPLPackage.STMT_BLOCK:
				sequence_StmtBlock(context, (StmtBlock) semanticObject); 
				return; 
			case MGPLPackage.TIMES:
				sequence_MultExpr(context, (Times) semanticObject); 
				return; 
			case MGPLPackage.TOUCHES:
				sequence_PrimExpr(context, (Touches) semanticObject); 
				return; 
			case MGPLPackage.VAR:
				sequence_Var(context, (Var) semanticObject); 
				return; 
			case MGPLPackage.VAR_DECL:
				if (action == grammarAccess.getVarDeclAccess().getArrayDeclVariableAction_2_1_0()) {
					sequence_VarDecl_ArrayDecl_2_1_0(context, (VarDecl) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getDeclRule()
						|| rule == grammarAccess.getVarDeclRule()
						|| rule == grammarAccess.getAllDeclsRule()) {
					sequence_VarDecl(context, (VarDecl) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Init returns Minus
	 *     Expr returns Minus
	 *     DisjExpr returns Minus
	 *     DisjExpr.Or_1_0 returns Minus
	 *     ConjExpr returns Minus
	 *     ConjExpr.And_1_0 returns Minus
	 *     RelExpr returns Minus
	 *     RelExpr.Equals_1_0_0_0 returns Minus
	 *     RelExpr.Less_1_0_1_0 returns Minus
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Minus
	 *     AddExpr returns Minus
	 *     AddExpr.Plus_1_0_0_0 returns Minus
	 *     AddExpr.Minus_1_0_1_0 returns Minus
	 *     MultExpr returns Minus
	 *     MultExpr.Divide_1_0_0_0 returns Minus
	 *     MultExpr.Times_1_0_1_0 returns Minus
	 *     UnaryExpr returns Minus
	 *     PrimExpr returns Minus
	 *
	 * Constraint:
	 *     (left=AddExpr_Minus_1_0_1_0 right=MultExpr)
	 */
	protected void sequence_AddExpr(ISerializationContext context, Minus semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.MINUS__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.MINUS__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.MINUS__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.MINUS__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAddExprAccess().getMinusLeftAction_1_0_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getAddExprAccess().getRightMultExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Plus
	 *     Expr returns Plus
	 *     DisjExpr returns Plus
	 *     DisjExpr.Or_1_0 returns Plus
	 *     ConjExpr returns Plus
	 *     ConjExpr.And_1_0 returns Plus
	 *     RelExpr returns Plus
	 *     RelExpr.Equals_1_0_0_0 returns Plus
	 *     RelExpr.Less_1_0_1_0 returns Plus
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Plus
	 *     AddExpr returns Plus
	 *     AddExpr.Plus_1_0_0_0 returns Plus
	 *     AddExpr.Minus_1_0_1_0 returns Plus
	 *     MultExpr returns Plus
	 *     MultExpr.Divide_1_0_0_0 returns Plus
	 *     MultExpr.Times_1_0_1_0 returns Plus
	 *     UnaryExpr returns Plus
	 *     PrimExpr returns Plus
	 *
	 * Constraint:
	 *     (left=AddExpr_Plus_1_0_0_0 right=MultExpr)
	 */
	protected void sequence_AddExpr(ISerializationContext context, Plus semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.PLUS__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.PLUS__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.PLUS__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.PLUS__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAddExprAccess().getPlusLeftAction_1_0_0_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getAddExprAccess().getRightMultExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Block returns AnimBlock
	 *     AnimBlock returns AnimBlock
	 *     AllDecls returns AnimBlock
	 *
	 * Constraint:
	 *     (name=IDF param=ParamDecl stmtBlock=StmtBlock)
	 */
	protected void sequence_AnimBlock(ISerializationContext context, AnimBlock semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ANIM_BLOCK__PARAM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ANIM_BLOCK__PARAM));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.BLOCK__STMT_BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.BLOCK__STMT_BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAnimBlockAccess().getNameIDFTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getAnimBlockAccess().getParamParamDeclParserRuleCall_3_0(), semanticObject.getParam());
		feeder.accept(grammarAccess.getAnimBlockAccess().getStmtBlockStmtBlockParserRuleCall_5_0(), semanticObject.getStmtBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Stmt returns AssStmt
	 *     AssStmt returns AssStmt
	 *
	 * Constraint:
	 *     (variable=Var expression=Expr)
	 */
	protected void sequence_AssStmt(ISerializationContext context, AssStmt semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ASS_STMT__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ASS_STMT__VARIABLE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ASS_STMT__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ASS_STMT__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAssStmtAccess().getVariableVarParserRuleCall_0_0(), semanticObject.getVariable());
		feeder.accept(grammarAccess.getAssStmtAccess().getExpressionExprParserRuleCall_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AttrAss returns AttrAss
	 *
	 * Constraint:
	 *     (name=IDF value=Expr)
	 */
	protected void sequence_AttrAss(ISerializationContext context, AttrAss semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ATTR_ASS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ATTR_ASS__NAME));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ATTR_ASS__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ATTR_ASS__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAttrAssAccess().getNameIDFTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getAttrAssAccess().getValueExprParserRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns And
	 *     Expr returns And
	 *     DisjExpr returns And
	 *     DisjExpr.Or_1_0 returns And
	 *     ConjExpr returns And
	 *     ConjExpr.And_1_0 returns And
	 *     RelExpr returns And
	 *     RelExpr.Equals_1_0_0_0 returns And
	 *     RelExpr.Less_1_0_1_0 returns And
	 *     RelExpr.LessOrEquals_1_0_2_0 returns And
	 *     AddExpr returns And
	 *     AddExpr.Plus_1_0_0_0 returns And
	 *     AddExpr.Minus_1_0_1_0 returns And
	 *     MultExpr returns And
	 *     MultExpr.Divide_1_0_0_0 returns And
	 *     MultExpr.Times_1_0_1_0 returns And
	 *     UnaryExpr returns And
	 *     PrimExpr returns And
	 *
	 * Constraint:
	 *     (left=ConjExpr_And_1_0 right=RelExpr)
	 */
	protected void sequence_ConjExpr(ISerializationContext context, And semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.AND__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.AND__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.AND__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.AND__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConjExprAccess().getAndLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getConjExprAccess().getRightRelExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Or
	 *     Expr returns Or
	 *     DisjExpr returns Or
	 *     DisjExpr.Or_1_0 returns Or
	 *     ConjExpr returns Or
	 *     ConjExpr.And_1_0 returns Or
	 *     RelExpr returns Or
	 *     RelExpr.Equals_1_0_0_0 returns Or
	 *     RelExpr.Less_1_0_1_0 returns Or
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Or
	 *     AddExpr returns Or
	 *     AddExpr.Plus_1_0_0_0 returns Or
	 *     AddExpr.Minus_1_0_1_0 returns Or
	 *     MultExpr returns Or
	 *     MultExpr.Divide_1_0_0_0 returns Or
	 *     MultExpr.Times_1_0_1_0 returns Or
	 *     UnaryExpr returns Or
	 *     PrimExpr returns Or
	 *
	 * Constraint:
	 *     (left=DisjExpr_Or_1_0 right=ConjExpr)
	 */
	protected void sequence_DisjExpr(ISerializationContext context, Or semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.OR__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.OR__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.OR__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.OR__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDisjExprAccess().getOrLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getDisjExprAccess().getRightConjExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Block returns EventBlock
	 *     EventBlock returns EventBlock
	 *
	 * Constraint:
	 *     (keyStroke=KeyStroke stmtBlock=StmtBlock)
	 */
	protected void sequence_EventBlock(ISerializationContext context, EventBlock semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.EVENT_BLOCK__KEY_STROKE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.EVENT_BLOCK__KEY_STROKE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.BLOCK__STMT_BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.BLOCK__STMT_BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEventBlockAccess().getKeyStrokeKeyStrokeParserRuleCall_1_0(), semanticObject.getKeyStroke());
		feeder.accept(grammarAccess.getEventBlockAccess().getStmtBlockStmtBlockParserRuleCall_2_0(), semanticObject.getStmtBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Stmt returns ForStmt
	 *     ForStmt returns ForStmt
	 *
	 * Constraint:
	 *     (init=AssStmt condition=Expr loop=AssStmt stmtBlock=StmtBlock)
	 */
	protected void sequence_ForStmt(ISerializationContext context, ForStmt semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.FOR_STMT__INIT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.FOR_STMT__INIT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.FOR_STMT__CONDITION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.FOR_STMT__CONDITION));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.FOR_STMT__LOOP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.FOR_STMT__LOOP));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.FOR_STMT__STMT_BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.FOR_STMT__STMT_BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getForStmtAccess().getInitAssStmtParserRuleCall_2_0(), semanticObject.getInit());
		feeder.accept(grammarAccess.getForStmtAccess().getConditionExprParserRuleCall_4_0(), semanticObject.getCondition());
		feeder.accept(grammarAccess.getForStmtAccess().getLoopAssStmtParserRuleCall_6_0(), semanticObject.getLoop());
		feeder.accept(grammarAccess.getForStmtAccess().getStmtBlockStmtBlockParserRuleCall_8_0(), semanticObject.getStmtBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Stmt returns IfStmt
	 *     IfStmt returns IfStmt
	 *
	 * Constraint:
	 *     (condition=Expr thenBlock=StmtBlock elseBlock=StmtBlock?)
	 */
	protected void sequence_IfStmt(ISerializationContext context, IfStmt semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Divide
	 *     Expr returns Divide
	 *     DisjExpr returns Divide
	 *     DisjExpr.Or_1_0 returns Divide
	 *     ConjExpr returns Divide
	 *     ConjExpr.And_1_0 returns Divide
	 *     RelExpr returns Divide
	 *     RelExpr.Equals_1_0_0_0 returns Divide
	 *     RelExpr.Less_1_0_1_0 returns Divide
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Divide
	 *     AddExpr returns Divide
	 *     AddExpr.Plus_1_0_0_0 returns Divide
	 *     AddExpr.Minus_1_0_1_0 returns Divide
	 *     MultExpr returns Divide
	 *     MultExpr.Divide_1_0_0_0 returns Divide
	 *     MultExpr.Times_1_0_1_0 returns Divide
	 *     UnaryExpr returns Divide
	 *     PrimExpr returns Divide
	 *
	 * Constraint:
	 *     (left=MultExpr_Divide_1_0_0_0 right=UnaryExpr)
	 */
	protected void sequence_MultExpr(ISerializationContext context, Divide semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.DIVIDE__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.DIVIDE__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.DIVIDE__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.DIVIDE__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMultExprAccess().getDivideLeftAction_1_0_0_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getMultExprAccess().getRightUnaryExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Times
	 *     Expr returns Times
	 *     DisjExpr returns Times
	 *     DisjExpr.Or_1_0 returns Times
	 *     ConjExpr returns Times
	 *     ConjExpr.And_1_0 returns Times
	 *     RelExpr returns Times
	 *     RelExpr.Equals_1_0_0_0 returns Times
	 *     RelExpr.Less_1_0_1_0 returns Times
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Times
	 *     AddExpr returns Times
	 *     AddExpr.Plus_1_0_0_0 returns Times
	 *     AddExpr.Minus_1_0_1_0 returns Times
	 *     MultExpr returns Times
	 *     MultExpr.Divide_1_0_0_0 returns Times
	 *     MultExpr.Times_1_0_1_0 returns Times
	 *     UnaryExpr returns Times
	 *     PrimExpr returns Times
	 *
	 * Constraint:
	 *     (left=MultExpr_Times_1_0_1_0 right=UnaryExpr)
	 */
	protected void sequence_MultExpr(ISerializationContext context, Times semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.TIMES__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.TIMES__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.TIMES__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.TIMES__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMultExprAccess().getTimesLeftAction_1_0_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getMultExprAccess().getRightUnaryExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ObjDecl returns ArrayDecl
	 *
	 * Constraint:
	 *     (variable=ObjDecl_ArrayDecl_2_1_0 length=NUMBER)
	 */
	protected void sequence_ObjDecl(ISerializationContext context, ArrayDecl semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ARRAY_DECL__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ARRAY_DECL__VARIABLE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ARRAY_DECL__LENGTH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ARRAY_DECL__LENGTH));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getObjDeclAccess().getArrayDeclVariableAction_2_1_0(), semanticObject.getVariable());
		feeder.accept(grammarAccess.getObjDeclAccess().getLengthNUMBERTerminalRuleCall_2_1_2_0(), semanticObject.getLength());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ObjDecl.ArrayDecl_2_1_0 returns ObjDecl
	 *
	 * Constraint:
	 *     (type=ObjType name=IDF)
	 */
	protected void sequence_ObjDecl_ArrayDecl_2_1_0(ISerializationContext context, ObjDecl semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.DECL__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.DECL__TYPE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getObjDeclAccess().getTypeObjTypeParserRuleCall_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getObjDeclAccess().getNameIDFTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Decl returns ObjDecl
	 *     ObjDecl returns ObjDecl
	 *     AllDecls returns ObjDecl
	 *
	 * Constraint:
	 *     (type=ObjType name=IDF (attr+=AttrAss attr+=AttrAss*)?)
	 */
	protected void sequence_ObjDecl(ISerializationContext context, ObjDecl semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Decl returns ArrayDecl
	 *     AllDecls returns ArrayDecl
	 *
	 * Constraint:
	 *     ((variable=VarDecl_ArrayDecl_2_1_0 length=NUMBER) | (variable=ObjDecl_ArrayDecl_2_1_0 length=NUMBER))
	 */
	protected void sequence_ObjDecl_VarDecl(ISerializationContext context, ArrayDecl semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ParamDecl returns ParamDecl
	 *     AllDecls returns ParamDecl
	 *
	 * Constraint:
	 *     (type=ObjType name=IDF)
	 */
	protected void sequence_ParamDecl(ISerializationContext context, ParamDecl semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.PARAM_DECL__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.PARAM_DECL__TYPE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getParamDeclAccess().getTypeObjTypeParserRuleCall_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getParamDeclAccess().getNameIDFTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns NumberLiteral
	 *     Expr returns NumberLiteral
	 *     DisjExpr returns NumberLiteral
	 *     DisjExpr.Or_1_0 returns NumberLiteral
	 *     ConjExpr returns NumberLiteral
	 *     ConjExpr.And_1_0 returns NumberLiteral
	 *     RelExpr returns NumberLiteral
	 *     RelExpr.Equals_1_0_0_0 returns NumberLiteral
	 *     RelExpr.Less_1_0_1_0 returns NumberLiteral
	 *     RelExpr.LessOrEquals_1_0_2_0 returns NumberLiteral
	 *     AddExpr returns NumberLiteral
	 *     AddExpr.Plus_1_0_0_0 returns NumberLiteral
	 *     AddExpr.Minus_1_0_1_0 returns NumberLiteral
	 *     MultExpr returns NumberLiteral
	 *     MultExpr.Divide_1_0_0_0 returns NumberLiteral
	 *     MultExpr.Times_1_0_1_0 returns NumberLiteral
	 *     UnaryExpr returns NumberLiteral
	 *     PrimExpr returns NumberLiteral
	 *
	 * Constraint:
	 *     value=NUMBER
	 */
	protected void sequence_PrimExpr(ISerializationContext context, NumberLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.NUMBER_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.NUMBER_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPrimExprAccess().getValueNUMBERTerminalRuleCall_0_1_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Touches
	 *     Expr returns Touches
	 *     DisjExpr returns Touches
	 *     DisjExpr.Or_1_0 returns Touches
	 *     ConjExpr returns Touches
	 *     ConjExpr.And_1_0 returns Touches
	 *     RelExpr returns Touches
	 *     RelExpr.Equals_1_0_0_0 returns Touches
	 *     RelExpr.Less_1_0_1_0 returns Touches
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Touches
	 *     AddExpr returns Touches
	 *     AddExpr.Plus_1_0_0_0 returns Touches
	 *     AddExpr.Minus_1_0_1_0 returns Touches
	 *     MultExpr returns Touches
	 *     MultExpr.Divide_1_0_0_0 returns Touches
	 *     MultExpr.Times_1_0_1_0 returns Touches
	 *     UnaryExpr returns Touches
	 *     PrimExpr returns Touches
	 *
	 * Constraint:
	 *     (left=PrimExpr_Touches_1_1_0 right=Var)
	 */
	protected void sequence_PrimExpr(ISerializationContext context, Touches semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.TOUCHES__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.TOUCHES__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.TOUCHES__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.TOUCHES__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getPrimExprAccess().getTouchesLeftAction_1_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getPrimExprAccess().getRightVarParserRuleCall_1_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Prog returns Prog
	 *     AllDecls returns Prog
	 *
	 * Constraint:
	 *     (name=IDF (attr+=AttrAss attr+=AttrAss*)? declarations+=Decl* init=StmtBlock blocks+=Block*)
	 */
	protected void sequence_Prog(ISerializationContext context, Prog semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Equals
	 *     Expr returns Equals
	 *     DisjExpr returns Equals
	 *     DisjExpr.Or_1_0 returns Equals
	 *     ConjExpr returns Equals
	 *     ConjExpr.And_1_0 returns Equals
	 *     RelExpr returns Equals
	 *     RelExpr.Equals_1_0_0_0 returns Equals
	 *     RelExpr.Less_1_0_1_0 returns Equals
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Equals
	 *     AddExpr returns Equals
	 *     AddExpr.Plus_1_0_0_0 returns Equals
	 *     AddExpr.Minus_1_0_1_0 returns Equals
	 *     MultExpr returns Equals
	 *     MultExpr.Divide_1_0_0_0 returns Equals
	 *     MultExpr.Times_1_0_1_0 returns Equals
	 *     UnaryExpr returns Equals
	 *     PrimExpr returns Equals
	 *
	 * Constraint:
	 *     (left=RelExpr_Equals_1_0_0_0 right=AddExpr)
	 */
	protected void sequence_RelExpr(ISerializationContext context, Equals semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.EQUALS__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.EQUALS__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.EQUALS__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.EQUALS__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRelExprAccess().getEqualsLeftAction_1_0_0_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getRelExprAccess().getRightAddExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Less
	 *     Expr returns Less
	 *     DisjExpr returns Less
	 *     DisjExpr.Or_1_0 returns Less
	 *     ConjExpr returns Less
	 *     ConjExpr.And_1_0 returns Less
	 *     RelExpr returns Less
	 *     RelExpr.Equals_1_0_0_0 returns Less
	 *     RelExpr.Less_1_0_1_0 returns Less
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Less
	 *     AddExpr returns Less
	 *     AddExpr.Plus_1_0_0_0 returns Less
	 *     AddExpr.Minus_1_0_1_0 returns Less
	 *     MultExpr returns Less
	 *     MultExpr.Divide_1_0_0_0 returns Less
	 *     MultExpr.Times_1_0_1_0 returns Less
	 *     UnaryExpr returns Less
	 *     PrimExpr returns Less
	 *
	 * Constraint:
	 *     (left=RelExpr_Less_1_0_1_0 right=AddExpr)
	 */
	protected void sequence_RelExpr(ISerializationContext context, Less semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.LESS__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.LESS__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.LESS__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.LESS__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRelExprAccess().getLessLeftAction_1_0_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getRelExprAccess().getRightAddExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns LessOrEquals
	 *     Expr returns LessOrEquals
	 *     DisjExpr returns LessOrEquals
	 *     DisjExpr.Or_1_0 returns LessOrEquals
	 *     ConjExpr returns LessOrEquals
	 *     ConjExpr.And_1_0 returns LessOrEquals
	 *     RelExpr returns LessOrEquals
	 *     RelExpr.Equals_1_0_0_0 returns LessOrEquals
	 *     RelExpr.Less_1_0_1_0 returns LessOrEquals
	 *     RelExpr.LessOrEquals_1_0_2_0 returns LessOrEquals
	 *     AddExpr returns LessOrEquals
	 *     AddExpr.Plus_1_0_0_0 returns LessOrEquals
	 *     AddExpr.Minus_1_0_1_0 returns LessOrEquals
	 *     MultExpr returns LessOrEquals
	 *     MultExpr.Divide_1_0_0_0 returns LessOrEquals
	 *     MultExpr.Times_1_0_1_0 returns LessOrEquals
	 *     UnaryExpr returns LessOrEquals
	 *     PrimExpr returns LessOrEquals
	 *
	 * Constraint:
	 *     (left=RelExpr_LessOrEquals_1_0_2_0 right=AddExpr)
	 */
	protected void sequence_RelExpr(ISerializationContext context, LessOrEquals semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.LESS_OR_EQUALS__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.LESS_OR_EQUALS__LEFT));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.LESS_OR_EQUALS__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.LESS_OR_EQUALS__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getRelExprAccess().getLessOrEqualsLeftAction_1_0_2_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getRelExprAccess().getRightAddExprParserRuleCall_1_1_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     StmtBlock returns StmtBlock
	 *
	 * Constraint:
	 *     stmts+=Stmt*
	 */
	protected void sequence_StmtBlock(ISerializationContext context, StmtBlock semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Complement
	 *     Expr returns Complement
	 *     DisjExpr returns Complement
	 *     DisjExpr.Or_1_0 returns Complement
	 *     ConjExpr returns Complement
	 *     ConjExpr.And_1_0 returns Complement
	 *     RelExpr returns Complement
	 *     RelExpr.Equals_1_0_0_0 returns Complement
	 *     RelExpr.Less_1_0_1_0 returns Complement
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Complement
	 *     AddExpr returns Complement
	 *     AddExpr.Plus_1_0_0_0 returns Complement
	 *     AddExpr.Minus_1_0_1_0 returns Complement
	 *     MultExpr returns Complement
	 *     MultExpr.Divide_1_0_0_0 returns Complement
	 *     MultExpr.Times_1_0_1_0 returns Complement
	 *     UnaryExpr returns Complement
	 *     PrimExpr returns Complement
	 *
	 * Constraint:
	 *     expr=UnaryExpr
	 */
	protected void sequence_UnaryExpr(ISerializationContext context, Complement semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.COMPLEMENT__EXPR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.COMPLEMENT__EXPR));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUnaryExprAccess().getExprUnaryExprParserRuleCall_0_1_0(), semanticObject.getExpr());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Negation
	 *     Expr returns Negation
	 *     DisjExpr returns Negation
	 *     DisjExpr.Or_1_0 returns Negation
	 *     ConjExpr returns Negation
	 *     ConjExpr.And_1_0 returns Negation
	 *     RelExpr returns Negation
	 *     RelExpr.Equals_1_0_0_0 returns Negation
	 *     RelExpr.Less_1_0_1_0 returns Negation
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Negation
	 *     AddExpr returns Negation
	 *     AddExpr.Plus_1_0_0_0 returns Negation
	 *     AddExpr.Minus_1_0_1_0 returns Negation
	 *     MultExpr returns Negation
	 *     MultExpr.Divide_1_0_0_0 returns Negation
	 *     MultExpr.Times_1_0_1_0 returns Negation
	 *     UnaryExpr returns Negation
	 *     PrimExpr returns Negation
	 *
	 * Constraint:
	 *     expr=UnaryExpr
	 */
	protected void sequence_UnaryExpr(ISerializationContext context, Negation semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.NEGATION__EXPR) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.NEGATION__EXPR));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getUnaryExprAccess().getExprUnaryExprParserRuleCall_0_1_0(), semanticObject.getExpr());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     VarDecl returns ArrayDecl
	 *
	 * Constraint:
	 *     (variable=VarDecl_ArrayDecl_2_1_0 length=NUMBER)
	 */
	protected void sequence_VarDecl(ISerializationContext context, ArrayDecl semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ARRAY_DECL__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ARRAY_DECL__VARIABLE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ARRAY_DECL__LENGTH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ARRAY_DECL__LENGTH));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarDeclAccess().getArrayDeclVariableAction_2_1_0(), semanticObject.getVariable());
		feeder.accept(grammarAccess.getVarDeclAccess().getLengthNUMBERTerminalRuleCall_2_1_2_0(), semanticObject.getLength());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     VarDecl.ArrayDecl_2_1_0 returns VarDecl
	 *
	 * Constraint:
	 *     (type='int' name=IDF)
	 */
	protected void sequence_VarDecl_ArrayDecl_2_1_0(ISerializationContext context, VarDecl semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.DECL__TYPE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.DECL__TYPE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ALL_DECLS__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarDeclAccess().getTypeIntKeyword_0_0(), semanticObject.getType());
		feeder.accept(grammarAccess.getVarDeclAccess().getNameIDFTerminalRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Decl returns VarDecl
	 *     VarDecl returns VarDecl
	 *     AllDecls returns VarDecl
	 *
	 * Constraint:
	 *     (type='int' name=IDF init=Init?)
	 */
	protected void sequence_VarDecl(ISerializationContext context, VarDecl semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Init returns ElementSelect
	 *     Var returns ElementSelect
	 *     Var.MemberSelect_2_0 returns ElementSelect
	 *     Expr returns ElementSelect
	 *     DisjExpr returns ElementSelect
	 *     DisjExpr.Or_1_0 returns ElementSelect
	 *     ConjExpr returns ElementSelect
	 *     ConjExpr.And_1_0 returns ElementSelect
	 *     RelExpr returns ElementSelect
	 *     RelExpr.Equals_1_0_0_0 returns ElementSelect
	 *     RelExpr.Less_1_0_1_0 returns ElementSelect
	 *     RelExpr.LessOrEquals_1_0_2_0 returns ElementSelect
	 *     AddExpr returns ElementSelect
	 *     AddExpr.Plus_1_0_0_0 returns ElementSelect
	 *     AddExpr.Minus_1_0_1_0 returns ElementSelect
	 *     MultExpr returns ElementSelect
	 *     MultExpr.Divide_1_0_0_0 returns ElementSelect
	 *     MultExpr.Times_1_0_1_0 returns ElementSelect
	 *     UnaryExpr returns ElementSelect
	 *     PrimExpr returns ElementSelect
	 *     PrimExpr.Touches_1_1_0 returns ElementSelect
	 *
	 * Constraint:
	 *     (variable=Var_ElementSelect_1_0 index=Expr)
	 */
	protected void sequence_Var(ISerializationContext context, ElementSelect semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.VAR__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.VAR__VARIABLE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.ELEMENT_SELECT__INDEX) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.ELEMENT_SELECT__INDEX));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarAccess().getElementSelectVariableAction_1_0(), semanticObject.getVariable());
		feeder.accept(grammarAccess.getVarAccess().getIndexExprParserRuleCall_1_2_0(), semanticObject.getIndex());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns MemberSelect
	 *     Var returns MemberSelect
	 *     Expr returns MemberSelect
	 *     DisjExpr returns MemberSelect
	 *     DisjExpr.Or_1_0 returns MemberSelect
	 *     ConjExpr returns MemberSelect
	 *     ConjExpr.And_1_0 returns MemberSelect
	 *     RelExpr returns MemberSelect
	 *     RelExpr.Equals_1_0_0_0 returns MemberSelect
	 *     RelExpr.Less_1_0_1_0 returns MemberSelect
	 *     RelExpr.LessOrEquals_1_0_2_0 returns MemberSelect
	 *     AddExpr returns MemberSelect
	 *     AddExpr.Plus_1_0_0_0 returns MemberSelect
	 *     AddExpr.Minus_1_0_1_0 returns MemberSelect
	 *     MultExpr returns MemberSelect
	 *     MultExpr.Divide_1_0_0_0 returns MemberSelect
	 *     MultExpr.Times_1_0_1_0 returns MemberSelect
	 *     UnaryExpr returns MemberSelect
	 *     PrimExpr returns MemberSelect
	 *     PrimExpr.Touches_1_1_0 returns MemberSelect
	 *
	 * Constraint:
	 *     (variable=Var_MemberSelect_2_0 memberName=IDF)
	 */
	protected void sequence_Var(ISerializationContext context, MemberSelect semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.VAR__VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.VAR__VARIABLE));
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.MEMBER_SELECT__MEMBER_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.MEMBER_SELECT__MEMBER_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarAccess().getMemberSelectVariableAction_2_0(), semanticObject.getVariable());
		feeder.accept(grammarAccess.getVarAccess().getMemberNameIDFTerminalRuleCall_2_2_0(), semanticObject.getMemberName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Init returns Var
	 *     Var returns Var
	 *     Var.ElementSelect_1_0 returns Var
	 *     Var.MemberSelect_2_0 returns Var
	 *     Expr returns Var
	 *     DisjExpr returns Var
	 *     DisjExpr.Or_1_0 returns Var
	 *     ConjExpr returns Var
	 *     ConjExpr.And_1_0 returns Var
	 *     RelExpr returns Var
	 *     RelExpr.Equals_1_0_0_0 returns Var
	 *     RelExpr.Less_1_0_1_0 returns Var
	 *     RelExpr.LessOrEquals_1_0_2_0 returns Var
	 *     AddExpr returns Var
	 *     AddExpr.Plus_1_0_0_0 returns Var
	 *     AddExpr.Minus_1_0_1_0 returns Var
	 *     MultExpr returns Var
	 *     MultExpr.Divide_1_0_0_0 returns Var
	 *     MultExpr.Times_1_0_1_0 returns Var
	 *     UnaryExpr returns Var
	 *     PrimExpr returns Var
	 *     PrimExpr.Touches_1_1_0 returns Var
	 *
	 * Constraint:
	 *     id=[AllDecls|IDF]
	 */
	protected void sequence_Var(ISerializationContext context, Var semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, MGPLPackage.Literals.VAR__ID) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MGPLPackage.Literals.VAR__ID));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVarAccess().getIdAllDeclsIDFTerminalRuleCall_0_0_1(), semanticObject.getId());
		feeder.finish();
	}
	
	
}
