/*
 * generated by Xtext 2.9.0
 */
package mgpl.validation

import mgpl.mGPL.AnimBlock
import mgpl.mGPL.AssStmt
import mgpl.mGPL.AttrAss
import mgpl.mGPL.Complement
import mgpl.mGPL.ElementSelect
import mgpl.mGPL.Expr
import mgpl.mGPL.MGPLPackage
import mgpl.mGPL.MemberSelect
import mgpl.mGPL.Negation
import mgpl.mGPL.NumberLiteral
import mgpl.mGPL.ArrayDecl
import mgpl.mGPL.ObjDecl
import mgpl.mGPL.ParamDecl
import mgpl.mGPL.Prog
import mgpl.mGPL.Touches
import mgpl.mGPL.Var
import mgpl.mGPL.VarDecl
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.validation.Check

import static extension mgpl.Common.*

/**
 * This class contains custom validation rules. 
 *
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
class MGPLValidator extends AbstractMGPLValidator {
	
/* 
 * ##### Vordefinierte Hilfsfunktionen & globale Variablen.
 * ##### Verwenden Sie diese wenn möglich. 
 * ##### Verwenden Sie ggf. auch die statischen Funktionen der Datei Common.xtend
 * ##### TODOs für @Check Implementierung hier weiter unten!
 */
 
 	// Verschiedene Instanzabfragen 
	// id.eIsProxy ist wahr wenn der Querverweis nicht hergestellt werden kann
	def isUndeclared(Var it) { id == null || id.eIsProxy } //it.id 
	def isArray(Var it) { id.eContainer instanceof ArrayDecl } //mit it.id gelangen wir VarDecl oder ArrayDecl
	def isGame(Var it) { id instanceof Prog }
	def isVariable(Var it) { id instanceof VarDecl }
	def isObject(Var it) { id instanceof ObjDecl }
	def isAnimation(Var it) { id instanceof AnimBlock }
	def isParameter(Var it) { id instanceof ParamDecl }
	def hasMembers(Var it) { // wird aufgerufen bei einem Var-Ausdruck der Form v.h, ohne Array-Index
		isGame || isObject && !isArray || isParameter //möglich isGame(it) oder it.isGame
	}
	
	// zeigt, ob die Variable als Array benutzt wird
	def usedAsArray(Var it) {
		eContainer instanceof ElementSelect && eContainingFeature == MGPLPackage.Literals.VAR__VARIABLE
		/* aliens[1+3], bullets[i] */
	}
	
	// zeigt, ob Var-Instanz als Objekt verwendet wird
	def usedAsObject(Var it) {
		eContainer instanceof MemberSelect
		/*aliens[i].visible = 0; cur_bullet.visible = 0; */
		   
	}
	// wird auf die Operanden von Touches(einmal für left und einmal für right) aufgerufen
	// zeigt, ob der Operand kein graphisches Objekt ist. (also kein circle, triangle, rectangle)
	def isNoGraphicalObject(Var it) {
		it instanceof MemberSelect
		|| if (it instanceof ElementSelect) !variable.isUndeclared && !variable.isObject && variable.isArray
			else !isUndeclared && (!isObject || isArray) && !isParameter
	}
	
	// Die Methode wird für jeden atomaren Operanden aufgerufen, also zweimal bei binären Operatoren.
	// Wenn ein Attribut animation_Block ist, ist es kein Integer, sonst sind alle anderen Attribute Integers
	def isNoInt(Var it) {
		if (it instanceof MemberSelect) memberName.equals('animation_block')
		else if (it instanceof ElementSelect) !variable.isUndeclared && !variable.isVariable && variable.isArray
		else !isUndeclared && (!isVariable || isArray)
	}
	
	val gameAttributes= #['height', 'width', 'speed', 'x', 'y']
	val circleAttributes=#['animation_block', 'radius', 'visible', 'x', 'y']
	val rectTriangleAttributes=#['animation_block', 'height', 'visible', 'width', 'x', 'y']
	
	// liefert die für das übergebene Objekt erlaubten Attribute
	def allowedAttributes(EObject it) {
		if (it instanceof ObjDecl)
			if (type.equals('circle')) circleAttributes
			else rectTriangleAttributes
		else if (it instanceof ParamDecl)
			if (type.equals('circle')) circleAttributes
			else rectTriangleAttributes
		else if (it instanceof Prog) gameAttributes
	}
	
	// dient zur Konstruktion von Fehlermeldungen mit großgeschriebenen Objektarten
	def objectType(EObject it) {
		if (it instanceof ObjDecl) type.capitalize
		else if (it instanceof ParamDecl) type.capitalize
		else if (it instanceof Prog) 'Game'
	}


/* 
 * ##### Vordefinierte @Check Funktion als Orientierungshilfe.
 */

	
	// prüfen, dass Operanden von touches grafische Objekte sind und von allen anderen Operatoren Integers
	@Check
	def checkExpressionOperands(Expr it) {
		if (it instanceof NumberLiteral || it instanceof Var) return;
		if (it instanceof Touches) {
			if (left.isNoGraphicalObject)
				error('This Operand must evaluate to a Circle, Rectangle, or Triangle',
					MGPLPackage.Literals.TOUCHES__LEFT)
			if (right.isNoGraphicalObject)
				error('This Operand must evaluate to a Circle, Rectangle, or Triangle',
					MGPLPackage.Literals.TOUCHES__RIGHT)
		} else if (it instanceof Negation || it instanceof Complement) {
			val feature=eClass.getEStructuralFeature(MGPLPackage.Literals.NEGATION__EXPR.name)
			val expr=eGet(feature)
			if (expr instanceof Var)
				if (expr.isNoInt)
					error('This Operand must evaluate to an int', feature)
		} else {
			val leftFeature=eClass.getEStructuralFeature(MGPLPackage.Literals.EQUALS__LEFT.name)
			val rightFeature=eClass.getEStructuralFeature(MGPLPackage.Literals.EQUALS__RIGHT.name)
			val left=eGet(leftFeature)
			val right=eGet(rightFeature)
			if (left instanceof Var)
				if (left.isNoInt)
					error('This Operand must evaluate to an int', leftFeature)
			if (right instanceof Var)
				if (right.isNoInt)
					error('This Operand must evaluate to an int', rightFeature)
		}
	}

/* 
 * ##### Ihre Implementierung der @Check Funktion für Aufgabe 2.
 */

	@Check
	def checkVar(Var it) {
		/*TODO*/
		
		// prüfen, dass sämtliche Vorkommen von Variablen- oder Objektnamen deklaiert sind und wie es verwendet wird  (Aufg. 2. Bindungen)
		
	}

	@Check
	def checkAttributeAssignment(AttrAss it) {
		/*TODO*/
		
		// prüfen, dass dieses Attribut für dieses Objekt erlaubt ist (Aufg. 2. Attribute)
		// prüfen, dass dieses Attribut, das einen langen und einen kurzen Namen haben kann, nur einmal in diesem Objekt belegt wird (Aufg. 2. Attribute)
		// prüfen, dass das Grafikobjekt-Attribut animation_block mit dem Namen eines Animation-Handlers belegt wird (Aufg. 2. Bindungen)
		// prüfen, dass der Animation-Handler einen passenden Typ hat (Aufg. 2. Bindungen)
		// prüfen, dass Game-Attribute nur mit konstanten Zahlen belegt werden (Aufg. 2. Attribute)
		// prüfen, dass das Game-Attribut speed mit einem Wert zwischen 0 und 100 belegt wird (Aufg. 2. Attribute)
		
	}

	@Check
	def checkMemberName(MemberSelect it) {
		/*TODO*/
		
		//prüfen, ob ein verwendetes Attribut für das jeweilige Objekt erlaubt ist (Aufg. 2. Bindungen)
		
	}

	@Check
	def checkAnimation_blockAssignment(AssStmt it) {
		/*TODO*/
		
		// prüfen, dass das Attribut animation_block in einer Zuweisungsanweisung mit dem Namen eines Animation-Handlers 
		// belegt wird und dass dieser einen passenden Typ hat  (Aufg. 2. Bindungen)
		// Bsp.: c.animation_block = a[3] ist unzulässig; richtig: c.animation_block = lead_alien_animate
		
	}
	
}
