/**
 * generated by Xtext 2.9.0
 */
package mgpl.generator;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import mgpl.Common;
import mgpl.mGPL.AllDecls;
import mgpl.mGPL.And;
import mgpl.mGPL.AnimBlock;
import mgpl.mGPL.ArrayDecl;
import mgpl.mGPL.AssStmt;
import mgpl.mGPL.AttrAss;
import mgpl.mGPL.Block;
import mgpl.mGPL.Complement;
import mgpl.mGPL.Decl;
import mgpl.mGPL.Divide;
import mgpl.mGPL.ElementSelect;
import mgpl.mGPL.Equals;
import mgpl.mGPL.EventBlock;
import mgpl.mGPL.Expr;
import mgpl.mGPL.ForStmt;
import mgpl.mGPL.IfStmt;
import mgpl.mGPL.Init;
import mgpl.mGPL.Less;
import mgpl.mGPL.LessOrEquals;
import mgpl.mGPL.MGPLPackage;
import mgpl.mGPL.MemberSelect;
import mgpl.mGPL.Minus;
import mgpl.mGPL.Negation;
import mgpl.mGPL.NumberLiteral;
import mgpl.mGPL.ObjDecl;
import mgpl.mGPL.Or;
import mgpl.mGPL.ParamDecl;
import mgpl.mGPL.Plus;
import mgpl.mGPL.Prog;
import mgpl.mGPL.StmtBlock;
import mgpl.mGPL.Times;
import mgpl.mGPL.Touches;
import mgpl.mGPL.Var;
import mgpl.mGPL.VarDecl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
@SuppressWarnings("all")
public class MGPLGenerator extends AbstractGenerator {
  /**
   * ##### Alle EObjekte des AST werden durch-iteriert und für jedes gefilterte eine Compilefunktion aufgerufen,
   * ##### die von MGPL in den entsprechenden Javacodeabschnitt übersetzt.
   * ##### Das Java-Programm ist zum Großenteil als Template vorgegeben.
   * ##### TODOs für offene compile-Funktionen befinden sich hier weiter unten!
   * ##### Suchen Sie am Besten nach TODO mit Strg+F um keines zu vergessen.
   * ##### Orientieren Sie sich beim Implementieren an dem Vorgehen der vorgegebenen compile-Funktionen.
   * ##### Verwenden Sie ggf. auch die statischen Funktionen der Datei Common.xtend
   */
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    EList<EObject> _contents = resource.getContents();
    Iterable<Prog> _filter = Iterables.<Prog>filter(_contents, Prog.class);
    for (final Prog g : _filter) {
      String _name = g.getName();
      String _uncapitalize = Common.uncapitalize(_name);
      String _plus = ("mgpl/" + _uncapitalize);
      String _plus_1 = (_plus + "/Game.java");
      CharSequence _compile = this.compile(g);
      fsa.generateFile(_plus_1, _compile);
    }
  }
  
  protected CharSequence _compile(final Prog it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package mgpl.");
    String _name = it.getName();
    String _uncapitalize = Common.uncapitalize(_name);
    _builder.append(_uncapitalize, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import java.awt.Graphics;");
    _builder.newLine();
    _builder.append("import java.awt.event.KeyEvent;");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("public class Game extends javax.swing.JPanel implements Runnable {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static void main(String[] args) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.awt.EventQueue.invokeLater(new GameWindow());");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static class GameWindow extends javax.swing.JFrame implements Runnable {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("private static final long serialVersionUID = 1L;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public GameWindow() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("add(new Game(this));");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setTitle(\"");
    String _name_1 = it.getName();
    String _capitalize = Common.capitalize(_name_1);
    _builder.append(_capitalize, "\t\t\t");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("setResizable(false);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("pack(); ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setLocationRelativeTo(null); ");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (x != null)");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setLocation(x, getY());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (y != null)");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("setLocation(getX(), y);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setDefaultCloseOperation(EXIT_ON_CLOSE);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("setVisible(true); ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static int height = 500;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static int width = 500;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static int speed = 50;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static Integer x = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static Integer y = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int delay; ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Game(GameWindow window) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setPreferredSize(new java.awt.Dimension(width, height));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("setDoubleBuffered(true); ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("delay = getDelay(speed);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("window.addKeyListener(onEvent);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int getDelay(int speed) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("speed = 100 - speed;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return (int) (0.0899 * (speed * speed) + (speed + 1));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void addNotify() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.addNotify();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("new Thread(this).start();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void run() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("long beforeTime = System.currentTimeMillis();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("while (true) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("for (Object o : objects) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("if (o.animation_block != null)");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.append("o.animation_block.animate(o);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("repaint();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("long sleep = beforeTime + delay - System.currentTimeMillis();");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (sleep <= 0)");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("sleep = 1;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("Thread.sleep(sleep);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("} catch (InterruptedException e) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("System.err.println(\"Interrupted: \" + e.getMessage());");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("beforeTime = System.currentTimeMillis();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public void paintComponent(Graphics g) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("super.paintComponent(g);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (Object o : objects)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("if (b(o.visible))");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("o.draw(g);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("java.awt.Toolkit.getDefaultToolkit().sync();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static abstract\t class Object {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Animation animation_block;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int visible = 1;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int x;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int y;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public abstract void draw(Graphics g); ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public abstract java.awt.Rectangle getBounds();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static class Circle extends Object {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int radius; ");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void draw(Graphics g) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("g.fillOval(x, y, 2 * radius, 2 * radius);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public java.awt.Rectangle getBounds() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new java.awt.Rectangle(x, y, 2 * radius, 2 * radius);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static class Rectangle extends Object {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int height;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int width;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void draw(Graphics g) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("g.fillRect(x, y, width, height);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public java.awt.Rectangle getBounds() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new java.awt.Rectangle(x, y, width, height);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static class Triangle extends Object {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int height;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public int width;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void draw(Graphics g) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("g.fillPolygon(new int[] { x, x + width, x + width / 2 }, new int[] { y, y, y + height }, 3);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public java.awt.Rectangle getBounds() {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return new java.awt.Rectangle(x, y, width, height);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private static abstract class Animation {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("protected abstract void animate(Object object);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private boolean b(int i) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i != 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int i(boolean b) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return b ? 1 : 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int or(int left, int right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(b(left) || b(right));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int and(int left, int right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(b(left) && b(right));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int eq(int left, int right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(left == right);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int lt(int left, int right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(left < right);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int le(int left, int right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(left <= right);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int not(int value) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(!b(value));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private int touches(Object left, Object right) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return i(left.getBounds().intersects(right.getBounds()));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      boolean _eIsSet = it.eIsSet(MGPLPackage.Literals.PROG__ATTR);
      if (_eIsSet) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        {
          EList<AttrAss> _attr = it.getAttr();
          for(final AttrAss a : _attr) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _compile = this.compile(a);
            _builder.append(_compile, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      EList<Decl> _declarations = it.getDeclarations();
      for(final Decl d : _declarations) {
        _builder.append("\t");
        CharSequence _compile_1 = this.compile(d);
        _builder.append(_compile_1, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private Object[] objects = new Object[] { ");
    {
      EList<Decl> _declarations_1 = it.getDeclarations();
      Iterable<ObjDecl> _filter = Iterables.<ObjDecl>filter(_declarations_1, ObjDecl.class);
      boolean _hasElements = false;
      for(final ObjDecl o : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t");
        }
        CharSequence _objectNames = this.objectNames(o);
        _builder.append(_objectNames, "\t");
      }
    }
    _builder.append(" };");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    StmtBlock _init = it.getInit();
    CharSequence _compile_2 = this.compile(_init);
    _builder.append(_compile_2, "\t");
    _builder.newLineIfNotEmpty();
    {
      EList<Block> _blocks = it.getBlocks();
      Iterable<AnimBlock> _filter_1 = Iterables.<AnimBlock>filter(_blocks, AnimBlock.class);
      for(final AnimBlock a_1 : _filter_1) {
        _builder.append("\t");
        CharSequence _compile_3 = this.compile(a_1);
        _builder.append(_compile_3, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.awt.event.KeyListener onEvent = new java.awt.event.KeyAdapter() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("public void keyPressed(KeyEvent e) {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("switch (e.getKeyCode()) {");
    _builder.newLine();
    {
      EList<Block> _blocks_1 = it.getBlocks();
      Iterable<EventBlock> _filter_2 = Iterables.<EventBlock>filter(_blocks_1, EventBlock.class);
      for(final EventBlock e : _filter_2) {
        _builder.append("\t\t\t");
        CharSequence _compile_4 = this.compile(e);
        _builder.append(_compile_4, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _objectNames(final ArrayDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _length = it.getLength();
      ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length, true);
      boolean _hasElements = false;
      for(final Integer i : _doubleDotLessThan) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        Decl _variable = it.getVariable();
        CharSequence _javaIdentifier = this.javaIdentifier(_variable);
        _builder.append(_javaIdentifier, "");
        _builder.append("[");
        _builder.append(i, "");
        _builder.append("]");
      }
    }
    return _builder;
  }
  
  protected CharSequence _objectNames(final ObjDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _javaIdentifier = this.javaIdentifier(it);
    _builder.append(_javaIdentifier, "");
    return _builder;
  }
  
  protected CharSequence _compile(final ArrayDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Decl _variable = it.getVariable();
      if ((_variable instanceof VarDecl)) {
        _builder.append("private ");
        Decl _variable_1 = it.getVariable();
        String _type = _variable_1.getType();
        _builder.append(_type, "");
        _builder.append("[] _");
        Decl _variable_2 = it.getVariable();
        String _name = _variable_2.getName();
        _builder.append(_name, "");
        _builder.append(" = new ");
        Decl _variable_3 = it.getVariable();
        String _type_1 = _variable_3.getType();
        _builder.append(_type_1, "");
        _builder.append("[");
        int _length = it.getLength();
        _builder.append(_length, "");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Decl _variable_4 = it.getVariable();
      if ((_variable_4 instanceof ObjDecl)) {
        _builder.append("private ");
        Decl _variable_5 = it.getVariable();
        String _type_2 = _variable_5.getType();
        String _capitalize = Common.capitalize(_type_2);
        _builder.append(_capitalize, "");
        _builder.append("[] _");
        Decl _variable_6 = it.getVariable();
        String _name_1 = _variable_6.getName();
        _builder.append(_name_1, "");
        _builder.append(" = new ");
        Decl _variable_7 = it.getVariable();
        String _type_3 = _variable_7.getType();
        String _capitalize_1 = Common.capitalize(_type_3);
        _builder.append(_capitalize_1, "");
        _builder.append("[] { ");
        {
          int _length_1 = it.getLength();
          ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _length_1, true);
          boolean _hasElements = false;
          for(final Integer i : _doubleDotLessThan) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(", ", "");
            }
            _builder.append("new ");
            Decl _variable_8 = it.getVariable();
            String _type_4 = _variable_8.getType();
            String _capitalize_2 = Common.capitalize(_type_4);
            _builder.append(_capitalize_2, "");
            _builder.append("()");
          }
        }
        _builder.append(" };");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _compile(final VarDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private ");
    String _type = it.getType();
    _builder.append(_type, "");
    _builder.append(" _");
    String _name = it.getName();
    _builder.append(_name, "");
    {
      boolean _eIsSet = it.eIsSet(MGPLPackage.Literals.VAR_DECL__INIT);
      if (_eIsSet) {
        _builder.append(" = ");
        Init _init = it.getInit();
        CharSequence _compile = this.compile(_init);
        _builder.append(_compile, "");
      }
    }
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _compile(final ObjDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private ");
    String _type = it.getType();
    String _capitalize = Common.capitalize(_type);
    _builder.append(_capitalize, "");
    _builder.append(" _");
    String _name = it.getName();
    _builder.append(_name, "");
    _builder.append(" = new ");
    String _type_1 = it.getType();
    String _capitalize_1 = Common.capitalize(_type_1);
    _builder.append(_capitalize_1, "");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    {
      boolean _eIsSet = it.eIsSet(MGPLPackage.Literals.OBJ_DECL__ATTR);
      if (_eIsSet) {
        _builder.append("\t");
        _builder.append("{");
        _builder.newLine();
        {
          EList<AttrAss> _attr = it.getAttr();
          for(final AttrAss a : _attr) {
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _compile = this.compile(a);
            _builder.append(_compile, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _compile(final AttrAss it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final AnimBlock it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("private void _");
    String _name = it.getName();
    _builder.append(_name, "");
    _builder.append("(Object _");
    ParamDecl _param = it.getParam();
    String _name_1 = _param.getName();
    _builder.append(_name_1, "");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("_");
    String _name_2 = it.getName();
    _builder.append(_name_2, "\t");
    _builder.append("((");
    ParamDecl _param_1 = it.getParam();
    String _type = _param_1.getType();
    String _capitalize = Common.capitalize(_type);
    _builder.append(_capitalize, "\t");
    _builder.append(") _");
    ParamDecl _param_2 = it.getParam();
    String _name_3 = _param_2.getName();
    _builder.append(_name_3, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.append("private void _");
    String _name_4 = it.getName();
    _builder.append(_name_4, "");
    _builder.append("(");
    ParamDecl _param_3 = it.getParam();
    String _type_1 = _param_3.getType();
    String _capitalize_1 = Common.capitalize(_type_1);
    _builder.append(_capitalize_1, "");
    _builder.append(" _");
    ParamDecl _param_4 = it.getParam();
    String _name_5 = _param_4.getName();
    _builder.append(_name_5, "");
    _builder.append(") ");
    StmtBlock _stmtBlock = it.getStmtBlock();
    CharSequence _compile = this.compile(_stmtBlock);
    _builder.append(_compile, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  protected CharSequence _compile(final EventBlock it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("case KeyEvent.");
    String _keyStroke = it.getKeyStroke();
    String _vKCode = this.getVKCode(_keyStroke);
    _builder.append(_vKCode, "");
    _builder.append(": ");
    StmtBlock _stmtBlock = it.getStmtBlock();
    CharSequence _compile = this.compile(_stmtBlock);
    _builder.append(_compile, "");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("break;");
    _builder.newLine();
    return _builder;
  }
  
  public String getVKCode(final String keyStroke) {
    String _switchResult = null;
    switch (keyStroke) {
      case "space":
        _switchResult = "VK_SPACE";
        break;
      case "leftarrow":
        _switchResult = "VK_LEFT";
        break;
      case "rightarrow":
        _switchResult = "VK_RIGHT";
        break;
      case "uparrow":
        _switchResult = "VK_UP";
        break;
      case "downarrow":
        _switchResult = "VK_DOWN";
        break;
    }
    return _switchResult;
  }
  
  protected CharSequence _compile(final StmtBlock it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final IfStmt it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final ForStmt it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  public CharSequence compileBareAssignment(final AssStmt it) {
    StringConcatenation _builder = new StringConcatenation();
    Var _variable = it.getVariable();
    CharSequence _compile = this.compile(_variable);
    _builder.append(_compile, "");
    _builder.append(" = ");
    Expr _expression = it.getExpression();
    CharSequence _compile_1 = this.compile(_expression);
    _builder.append(_compile_1, "");
    return _builder;
  }
  
  protected CharSequence _compile(final AssStmt it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _compileBareAssignment = this.compileBareAssignment(it);
    _builder.append(_compileBareAssignment, "");
    _builder.append(";");
    return _builder;
  }
  
  protected CharSequence _compile(final Var it) {
    StringConcatenation _builder = new StringConcatenation();
    AllDecls _id = it.getId();
    CharSequence _javaIdentifier = this.javaIdentifier(_id);
    _builder.append(_javaIdentifier, "");
    return _builder;
  }
  
  protected CharSequence _compile(final ElementSelect it) {
    StringConcatenation _builder = new StringConcatenation();
    Var _variable = it.getVariable();
    CharSequence _compile = this.compile(_variable);
    _builder.append(_compile, "");
    _builder.append("[");
    Expr _index = it.getIndex();
    CharSequence _compile_1 = this.compile(_index);
    _builder.append(_compile_1, "");
    _builder.append("]");
    return _builder;
  }
  
  protected CharSequence _compile(final MemberSelect it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _javaIdentifier(final Prog it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Game");
    return _builder;
  }
  
  protected CharSequence _javaIdentifier(final Decl it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("_");
    String _name = it.getName();
    _builder.append(_name, "");
    return _builder;
  }
  
  protected CharSequence _javaIdentifier(final AnimBlock it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("new Animation() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("protected void animate(Object object) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("_");
    String _name = it.getName();
    _builder.append(_name, "\t\t");
    _builder.append("(object);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _javaIdentifier(final ParamDecl it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("_");
    String _name = it.getName();
    _builder.append(_name, "");
    return _builder;
  }
  
  protected CharSequence _compile(final Or it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("or(");
    Expr _left = it.getLeft();
    CharSequence _compile = this.compile(_left);
    _builder.append(_compile, "");
    _builder.append(", ");
    Expr _right = it.getRight();
    CharSequence _compile_1 = this.compile(_right);
    _builder.append(_compile_1, "");
    _builder.append(")");
    return _builder;
  }
  
  protected CharSequence _compile(final Equals it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("eq(");
    Expr _left = it.getLeft();
    CharSequence _compile = this.compile(_left);
    _builder.append(_compile, "");
    _builder.append(", ");
    Expr _right = it.getRight();
    CharSequence _compile_1 = this.compile(_right);
    _builder.append(_compile_1, "");
    _builder.append(")");
    return _builder;
  }
  
  protected CharSequence _compile(final And it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final Less it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final LessOrEquals it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final Complement it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final Touches it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final NumberLiteral it) {
    StringConcatenation _builder = new StringConcatenation();
    int _value = it.getValue();
    _builder.append(_value, "");
    return _builder;
  }
  
  protected CharSequence _compile(final Negation it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("-");
    Expr _expr = it.getExpr();
    CharSequence _compile = this.compile(_expr);
    _builder.append(_compile, "");
    return _builder;
  }
  
  protected CharSequence _compile(final Plus it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("(");
    Expr _left = it.getLeft();
    CharSequence _compile = this.compile(_left);
    _builder.append(_compile, "");
    _builder.append(" + ");
    Expr _right = it.getRight();
    CharSequence _compile_1 = this.compile(_right);
    _builder.append(_compile_1, "");
    _builder.append(")");
    return _builder;
  }
  
  protected CharSequence _compile(final Minus it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final Divide it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  /**
   * TODO
   */
  protected CharSequence _compile(final Times it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(" ");
    return _builder;
  }
  
  public CharSequence compile(final EObject it) {
    if (it instanceof ArrayDecl) {
      return _compile((ArrayDecl)it);
    } else if (it instanceof ElementSelect) {
      return _compile((ElementSelect)it);
    } else if (it instanceof MemberSelect) {
      return _compile((MemberSelect)it);
    } else if (it instanceof And) {
      return _compile((And)it);
    } else if (it instanceof Complement) {
      return _compile((Complement)it);
    } else if (it instanceof Divide) {
      return _compile((Divide)it);
    } else if (it instanceof Equals) {
      return _compile((Equals)it);
    } else if (it instanceof Less) {
      return _compile((Less)it);
    } else if (it instanceof LessOrEquals) {
      return _compile((LessOrEquals)it);
    } else if (it instanceof Minus) {
      return _compile((Minus)it);
    } else if (it instanceof Negation) {
      return _compile((Negation)it);
    } else if (it instanceof NumberLiteral) {
      return _compile((NumberLiteral)it);
    } else if (it instanceof ObjDecl) {
      return _compile((ObjDecl)it);
    } else if (it instanceof Or) {
      return _compile((Or)it);
    } else if (it instanceof Plus) {
      return _compile((Plus)it);
    } else if (it instanceof Times) {
      return _compile((Times)it);
    } else if (it instanceof Touches) {
      return _compile((Touches)it);
    } else if (it instanceof Var) {
      return _compile((Var)it);
    } else if (it instanceof VarDecl) {
      return _compile((VarDecl)it);
    } else if (it instanceof AnimBlock) {
      return _compile((AnimBlock)it);
    } else if (it instanceof AssStmt) {
      return _compile((AssStmt)it);
    } else if (it instanceof EventBlock) {
      return _compile((EventBlock)it);
    } else if (it instanceof ForStmt) {
      return _compile((ForStmt)it);
    } else if (it instanceof IfStmt) {
      return _compile((IfStmt)it);
    } else if (it instanceof Prog) {
      return _compile((Prog)it);
    } else if (it instanceof AttrAss) {
      return _compile((AttrAss)it);
    } else if (it instanceof StmtBlock) {
      return _compile((StmtBlock)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence objectNames(final ObjDecl it) {
    if (it instanceof ArrayDecl) {
      return _objectNames((ArrayDecl)it);
    } else if (it != null) {
      return _objectNames(it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
  
  public CharSequence javaIdentifier(final AllDecls it) {
    if (it instanceof AnimBlock) {
      return _javaIdentifier((AnimBlock)it);
    } else if (it instanceof Decl) {
      return _javaIdentifier((Decl)it);
    } else if (it instanceof ParamDecl) {
      return _javaIdentifier((ParamDecl)it);
    } else if (it instanceof Prog) {
      return _javaIdentifier((Prog)it);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
