/**
 * generated by Xtext 2.9.0
 */
package mgpl.validation;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import mgpl.Common;
import mgpl.mGPL.AllDecls;
import mgpl.mGPL.AnimBlock;
import mgpl.mGPL.ArrayDecl;
import mgpl.mGPL.AssStmt;
import mgpl.mGPL.AttrAss;
import mgpl.mGPL.Complement;
import mgpl.mGPL.ElementSelect;
import mgpl.mGPL.Expr;
import mgpl.mGPL.MGPLPackage;
import mgpl.mGPL.MemberSelect;
import mgpl.mGPL.Negation;
import mgpl.mGPL.NumberLiteral;
import mgpl.mGPL.ObjDecl;
import mgpl.mGPL.ParamDecl;
import mgpl.mGPL.Prog;
import mgpl.mGPL.Touches;
import mgpl.mGPL.Var;
import mgpl.mGPL.VarDecl;
import mgpl.validation.AbstractMGPLValidator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class MGPLValidator extends AbstractMGPLValidator {
  /**
   * ##### Vordefinierte Hilfsfunktionen & globale Variablen.
   * ##### Verwenden Sie diese wenn möglich.
   * ##### Verwenden Sie ggf. auch die statischen Funktionen der Datei Common.xtend
   * ##### TODOs für @Check Implementierung hier weiter unten!
   */
  public boolean isUndeclared(final Var it) {
    boolean _or = false;
    AllDecls _id = it.getId();
    boolean _equals = Objects.equal(_id, null);
    if (_equals) {
      _or = true;
    } else {
      AllDecls _id_1 = it.getId();
      boolean _eIsProxy = _id_1.eIsProxy();
      _or = _eIsProxy;
    }
    return _or;
  }
  
  public boolean isArray(final Var it) {
    AllDecls _id = it.getId();
    EObject _eContainer = _id.eContainer();
    return (_eContainer instanceof ArrayDecl);
  }
  
  public boolean isGame(final Var it) {
    AllDecls _id = it.getId();
    return (_id instanceof Prog);
  }
  
  public boolean isVariable(final Var it) {
    AllDecls _id = it.getId();
    return (_id instanceof VarDecl);
  }
  
  public boolean isObject(final Var it) {
    AllDecls _id = it.getId();
    return (_id instanceof ObjDecl);
  }
  
  public boolean isAnimation(final Var it) {
    AllDecls _id = it.getId();
    return (_id instanceof AnimBlock);
  }
  
  public boolean isParameter(final Var it) {
    AllDecls _id = it.getId();
    return (_id instanceof ParamDecl);
  }
  
  public boolean hasMembers(final Var it) {
    boolean _or = false;
    boolean _or_1 = false;
    boolean _isGame = this.isGame(it);
    if (_isGame) {
      _or_1 = true;
    } else {
      boolean _and = false;
      boolean _isObject = this.isObject(it);
      if (!_isObject) {
        _and = false;
      } else {
        boolean _isArray = this.isArray(it);
        boolean _not = (!_isArray);
        _and = _not;
      }
      _or_1 = _and;
    }
    if (_or_1) {
      _or = true;
    } else {
      boolean _isParameter = this.isParameter(it);
      _or = _isParameter;
    }
    return _or;
  }
  
  public boolean usedAsArray(final Var it) {
    boolean _and = false;
    EObject _eContainer = it.eContainer();
    if (!(_eContainer instanceof ElementSelect)) {
      _and = false;
    } else {
      EStructuralFeature _eContainingFeature = it.eContainingFeature();
      boolean _equals = Objects.equal(_eContainingFeature, MGPLPackage.Literals.VAR__VARIABLE);
      _and = _equals;
    }
    return _and;
  }
  
  public boolean usedAsObject(final Var it) {
    EObject _eContainer = it.eContainer();
    return (_eContainer instanceof MemberSelect);
  }
  
  public boolean isNoGraphicalObject(final Var it) {
    boolean _or = false;
    if ((it instanceof MemberSelect)) {
      _or = true;
    } else {
      boolean _xifexpression = false;
      if ((it instanceof ElementSelect)) {
        boolean _and = false;
        boolean _and_1 = false;
        Var _variable = ((ElementSelect)it).getVariable();
        boolean _isUndeclared = this.isUndeclared(_variable);
        boolean _not = (!_isUndeclared);
        if (!_not) {
          _and_1 = false;
        } else {
          Var _variable_1 = ((ElementSelect)it).getVariable();
          boolean _isObject = this.isObject(_variable_1);
          boolean _not_1 = (!_isObject);
          _and_1 = _not_1;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Var _variable_2 = ((ElementSelect)it).getVariable();
          boolean _isArray = this.isArray(_variable_2);
          _and = _isArray;
        }
        _xifexpression = _and;
      } else {
        boolean _and_2 = false;
        boolean _and_3 = false;
        boolean _isUndeclared_1 = this.isUndeclared(it);
        boolean _not_2 = (!_isUndeclared_1);
        if (!_not_2) {
          _and_3 = false;
        } else {
          boolean _or_1 = false;
          boolean _isObject_1 = this.isObject(it);
          boolean _not_3 = (!_isObject_1);
          if (_not_3) {
            _or_1 = true;
          } else {
            boolean _isArray_1 = this.isArray(it);
            _or_1 = _isArray_1;
          }
          _and_3 = _or_1;
        }
        if (!_and_3) {
          _and_2 = false;
        } else {
          boolean _isParameter = this.isParameter(it);
          boolean _not_4 = (!_isParameter);
          _and_2 = _not_4;
        }
        _xifexpression = _and_2;
      }
      _or = _xifexpression;
    }
    return _or;
  }
  
  public boolean isNoInt(final Var it) {
    boolean _xifexpression = false;
    if ((it instanceof MemberSelect)) {
      String _memberName = ((MemberSelect)it).getMemberName();
      _xifexpression = _memberName.equals("animation_block");
    } else {
      boolean _xifexpression_1 = false;
      if ((it instanceof ElementSelect)) {
        boolean _and = false;
        boolean _and_1 = false;
        Var _variable = ((ElementSelect)it).getVariable();
        boolean _isUndeclared = this.isUndeclared(_variable);
        boolean _not = (!_isUndeclared);
        if (!_not) {
          _and_1 = false;
        } else {
          Var _variable_1 = ((ElementSelect)it).getVariable();
          boolean _isVariable = this.isVariable(_variable_1);
          boolean _not_1 = (!_isVariable);
          _and_1 = _not_1;
        }
        if (!_and_1) {
          _and = false;
        } else {
          Var _variable_2 = ((ElementSelect)it).getVariable();
          boolean _isArray = this.isArray(_variable_2);
          _and = _isArray;
        }
        _xifexpression_1 = _and;
      } else {
        boolean _and_2 = false;
        boolean _isUndeclared_1 = this.isUndeclared(it);
        boolean _not_2 = (!_isUndeclared_1);
        if (!_not_2) {
          _and_2 = false;
        } else {
          boolean _or = false;
          boolean _isVariable_1 = this.isVariable(it);
          boolean _not_3 = (!_isVariable_1);
          if (_not_3) {
            _or = true;
          } else {
            boolean _isArray_1 = this.isArray(it);
            _or = _isArray_1;
          }
          _and_2 = _or;
        }
        _xifexpression_1 = _and_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  private final List<String> gameAttributes = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("height", "width", "speed", "x", "y"));
  
  private final List<String> circleAttributes = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("animation_block", "radius", "visible", "x", "y"));
  
  private final List<String> rectTriangleAttributes = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("animation_block", "height", "visible", "width", "x", "y"));
  
  public List<String> allowedAttributes(final EObject it) {
    List<String> _xifexpression = null;
    if ((it instanceof ObjDecl)) {
      List<String> _xifexpression_1 = null;
      String _type = ((ObjDecl)it).getType();
      boolean _equals = _type.equals("circle");
      if (_equals) {
        _xifexpression_1 = this.circleAttributes;
      } else {
        _xifexpression_1 = this.rectTriangleAttributes;
      }
      _xifexpression = _xifexpression_1;
    } else {
      List<String> _xifexpression_2 = null;
      if ((it instanceof ParamDecl)) {
        List<String> _xifexpression_3 = null;
        String _type_1 = ((ParamDecl)it).getType();
        boolean _equals_1 = _type_1.equals("circle");
        if (_equals_1) {
          _xifexpression_3 = this.circleAttributes;
        } else {
          _xifexpression_3 = this.rectTriangleAttributes;
        }
        _xifexpression_2 = _xifexpression_3;
      } else {
        List<String> _xifexpression_4 = null;
        if ((it instanceof Prog)) {
          _xifexpression_4 = this.gameAttributes;
        }
        _xifexpression_2 = _xifexpression_4;
      }
      _xifexpression = _xifexpression_2;
    }
    return _xifexpression;
  }
  
  public String objectType(final EObject it) {
    String _xifexpression = null;
    if ((it instanceof ObjDecl)) {
      String _type = ((ObjDecl)it).getType();
      _xifexpression = Common.capitalize(_type);
    } else {
      String _xifexpression_1 = null;
      if ((it instanceof ParamDecl)) {
        String _type_1 = ((ParamDecl)it).getType();
        _xifexpression_1 = Common.capitalize(_type_1);
      } else {
        String _xifexpression_2 = null;
        if ((it instanceof Prog)) {
          _xifexpression_2 = "Game";
        }
        _xifexpression_1 = _xifexpression_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  /**
   * ##### Vordefinierte @Check Funktion als Orientierungshilfe.
   */
  @Check
  public void checkExpressionOperands(final Expr it) {
    boolean _or = false;
    if ((it instanceof NumberLiteral)) {
      _or = true;
    } else {
      _or = (it instanceof Var);
    }
    if (_or) {
      return;
    }
    if ((it instanceof Touches)) {
      Var _left = ((Touches)it).getLeft();
      boolean _isNoGraphicalObject = this.isNoGraphicalObject(_left);
      if (_isNoGraphicalObject) {
        this.error("This Operand must evaluate to a Circle, Rectangle, or Triangle", 
          MGPLPackage.Literals.TOUCHES__LEFT);
      }
      Var _right = ((Touches)it).getRight();
      boolean _isNoGraphicalObject_1 = this.isNoGraphicalObject(_right);
      if (_isNoGraphicalObject_1) {
        this.error("This Operand must evaluate to a Circle, Rectangle, or Triangle", 
          MGPLPackage.Literals.TOUCHES__RIGHT);
      }
    } else {
      boolean _or_1 = false;
      if ((it instanceof Negation)) {
        _or_1 = true;
      } else {
        _or_1 = (it instanceof Complement);
      }
      if (_or_1) {
        EClass _eClass = it.eClass();
        String _name = MGPLPackage.Literals.NEGATION__EXPR.getName();
        final EStructuralFeature feature = _eClass.getEStructuralFeature(_name);
        final Object expr = it.eGet(feature);
        if ((expr instanceof Var)) {
          boolean _isNoInt = this.isNoInt(((Var)expr));
          if (_isNoInt) {
            this.error("This Operand must evaluate to an int", feature);
          }
        }
      } else {
        EClass _eClass_1 = it.eClass();
        String _name_1 = MGPLPackage.Literals.EQUALS__LEFT.getName();
        final EStructuralFeature leftFeature = _eClass_1.getEStructuralFeature(_name_1);
        EClass _eClass_2 = it.eClass();
        String _name_2 = MGPLPackage.Literals.EQUALS__RIGHT.getName();
        final EStructuralFeature rightFeature = _eClass_2.getEStructuralFeature(_name_2);
        final Object left = it.eGet(leftFeature);
        final Object right = it.eGet(rightFeature);
        if ((left instanceof Var)) {
          boolean _isNoInt_1 = this.isNoInt(((Var)left));
          if (_isNoInt_1) {
            this.error("This Operand must evaluate to an int", leftFeature);
          }
        }
        if ((right instanceof Var)) {
          boolean _isNoInt_2 = this.isNoInt(((Var)right));
          if (_isNoInt_2) {
            this.error("This Operand must evaluate to an int", rightFeature);
          }
        }
      }
    }
  }
  
  /**
   * ##### Ihre Implementierung der @Check Funktion für Aufgabe 2.
   */
  @Check
  public Object checkVar(final Var it) {
    return null;
  }
  
  @Check
  public Object checkAttributeAssignment(final AttrAss it) {
    return null;
  }
  
  @Check
  public Object checkMemberName(final MemberSelect it) {
    return null;
  }
  
  @Check
  public Object checkAnimation_blockAssignment(final AssStmt it) {
    return null;
  }
}
