'''//Copyright (C) 2010 Simon Kiertscher
//
//This program is free software; you can redistribute it and/or modify it 
//under the terms of the GNU General Public License as published by the 
//Free Software Foundation; either version 3 of the License, or (at your 
//option) any later version.
//
//This program is distributed in the hope that it will be useful, but WITHOUT 
//ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS 
//FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License along with 
//this program; if not, see <http://www.gnu.org/licenses/>.'''

import subprocess
import cherub_config

def cherub_boot(node_address):
    '''this script has to give the command to boot the given node
    for IPMI: prameter: ipmi address --for-example--> node015.ipmi.cluster or 10.3.9.115
    insert the right password for the root behind -P
    (also possible with a magic package technology)
    '''
    #first, check if power is already set on
    status = subprocess.Popen(["ipmitool", "-I", "lanplus", "-H", node_address, \
    "-U", "root", "-P", cherub_config.IPMIPassword, "power", "status"], \
    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stdout, stderr = status.communicate()
    error = status.returncode
    if (stderr != ''):
        print 'ERROR in cherub_boot (while status request):', stderr
	return 3
    # if the power is already set on, dont set it again, just exit function
    if (stdout.count('on') >= 1):
	return 2

    # otherwise proceed and boot it
    proc = subprocess.Popen(["ipmitool", "-I", "lanplus", "-H", node_address, \
    "-U", "root", "-P", cherub_config.IPMIPassword, "power", "on"], \
    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stderr = proc.communicate()[1]
    if (stderr != ''):
        print 'ERROR in cherub_boot:', stderr
    #return proc.returncode
    return 0

def cherub_shutdown(node_address):
    '''this script has to give the command to shutdown the given node
    for IPMI:prameter: ipmi address --for-example--> node015.ipmi.cluster or 10.3.9.115
    insert the right password for the root behind -P
    '''
    proc = subprocess.Popen(["ipmitool", "-I", "lanplus", "-H", node_address, \
    "-U", "root", "-P", cherub_config.IPMIPassword, "power", "soft"], \
    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stderr = proc.communicate()[1]
    if (stderr != ''):
        print 'ERROR in cherub_shutdown:', stderr
    return proc.returncode
	
def cherub_sign_off(node_name):
    '''this script has to sign off the given node from the RMS
    for PBS:mark the node named in the parameter as offline
    parameter: node name
    '''
    proc = subprocess.Popen(["pbsnodes", "-o", node_name], \
    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stderr = proc.communicate()[1]
    if (stderr != ''):
        print 'ERROR in cherub_sign_off:', stderr
    return proc.returncode
	
def cherub_register(node_name):
    '''this script has to register the given node to the RMS
    '''
    proc = subprocess.Popen(["pbsnodes", "-c", node_name], \
    stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stderr = proc.communicate()[1]
    if (stderr != ''):
       print 'ERROR in cherub_register:', stderr
    return proc.returncode

def cherub_status(node_name):
	'''must return the following states
	CHERUB_UNKNOWN = -1 = if the state of the node is unknown or an error occures
	CHERUB_BUSY    =  0 = if the node is booted and BUSY/WORKING and REGISTERT to the RMS
	CHERUB_ONLINE  =  1 = if the node is booted but IDLE and REGISTERT to the RMS
	CHERUB_OFFLINE =  2 = if the node is booted but NOT REGISTERT to the RMS
	CHERUB_DOWN    =  3 = if the node is shutdown and NOT REGISTERT to the RMS
	'''
	
	# ping it first
	pingproc = subprocess.Popen(["ping", "-c", "1", node_name], \
	stdout=subprocess.PIPE, stderr=subprocess.PIPE)
	stdout, stderr = pingproc.communicate()
	pingtext = stdout
	if (stderr != ''):
		print 'ERROR in cherub_status (while pinging):', stderr
	# if the ping fails, it is in status DOWN
	if pingtext.count('0 received') == 1:
		return 3
	
	# then check if the node appears in the job list
	pre_proc1 = subprocess.Popen(["qstat", "-nt"], stdout=subprocess.PIPE)
	pre_proc2 = subprocess.Popen(["grep", "-c", node_name], \
	 stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=pre_proc1.stdout)
	pre_proc1.stdout.close()
	stdout, stderr = pre_proc2.communicate()
	error = pre_proc2.returncode
	stdout = stdout[0]
	# error case
	if (stderr != ''):
		print 'ERROR in cherub_status (while qstat+grep):', stderr
		return -1
	# if yes, its busy
	if (int(stdout) >= 1):
		return 0
	
	# if not, look up what pbsnodes say
	proc = subprocess.Popen(["pbsnodes", node_name], \
	 stdout=subprocess.PIPE, stderr=subprocess.PIPE)
	stdout, stderr = proc.communicate()
	error = proc.returncode
	if (error < 0) or (stderr != ''):
		print 'ERROR in cherub_status (while pbsnodes):', stderr
		return -1
	subtext = str(stdout).split('\n')
	if subtext[1].count('free') == 1:
		return 1
	if subtext[1].count('down') == 1:
		print 'weird, the node is pingable, but pbs think its down... lol'
		return 3
	if subtext[1].count('offline') == 1:
		return 2
	if (subtext[1].count('reserve') == 1) or \
	 (subtext[1].count('job-exclusive') == 1) or \
	 (subtext[1].count('job-sharing') == 1) or \
	 (subtext[1].count('busy') == 1) or \
	 (subtext[1].count('time-shared') == 1):
		return 0
	if subtext[1].count('state-unknown') == 1:
		return -1
	print 'weird, no case was activated...'
	return -1
	
def cherub_node_load(node_name):
	'''this script has to return the following values
	-1 = if an error occured
	 0 = the given node has no load
	 1 = the given node has load (to indicate that he must be started)
	'''
	
	# first of all, look for reservation
	proc1 = subprocess.Popen(["showres", "-n"], stdout=subprocess.PIPE)
	proc2 = subprocess.Popen(["grep", "-c", node_name], \
	 stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=proc1.stdout)
	proc1.stdout.close()
	stdout, stderr = proc2.communicate()
	error = proc2.returncode
	stdout = stdout[0]
		
	if (error < 0) or (stderr != ''):
		print 'ERROR in cherub_node_load', stderr
		return -1
	if int(stdout) > 0:
		return 1
	
	# then look at qstat -ft (-t is for array jobs)
	proc = subprocess.Popen(["qstat", "-ft"], \
	 stdout=subprocess.PIPE, stderr=subprocess.PIPE)
	stdout2, stderr2 = proc.communicate()
	error = proc.returncode
	text = stdout2
	if (stderr2 != ''):
		print 'ERROR in cherub_node_load', stderr2
	subtext = str(text).split('Job Id: ')
	for job in subtext[1::]:
		zeilen = str(job).splitlines()
		for zeile1 in zeilen[1::]:
			if zeile1.count('Resource_List.select') == 1:
				if zeile1.count(node_name) == 1:
					return 1
			if zeile1.count('Resource_List.nodes') == 1:
				if zeile1.count(node_name) == 1:
					return 1
	# print node_name,'has no load'
	return error
	
def cherub_global_load():
	'''this script has to return the following values
	BEHAVIOR MUST BE CHANGED DUE TO VERSION CHANGE FROM 1.2 to 1.3
	-1 = if an error occured
	 0-n = for the number of nodes needet to run all QUEUED jobs exept the nodes who are selected directly like select:nodexxx+nodexxx... 
		   (so only nodes with select:2 for example)
	'''
	
	#get the whole list of jobs
	qstat = subprocess.Popen(["qstat", "-ft"], stdout=subprocess.PIPE)
	#filter only he content of queued jobs
	grep1 = subprocess.Popen(["grep", "-A 30", "job_state = Q"], \
	 stdout=subprocess.PIPE, stdin=qstat.stdout)
	qstat.stdout.close()
	#get only a list with the resource stuff
	grep2 = subprocess.Popen(["grep", "-e Resource_List.select", \
	 "-e Resource_List.nodes"], \
         stdout=subprocess.PIPE, stdin=grep1.stdout)
	grep1.stdout.close()
	#and filter just the numbers
	awk = subprocess.Popen(["awk", "{print $3}"], \
	 stdout=subprocess.PIPE, stdin=grep2.stdout)
	grep2.stdout.close()
	#and delete everything what is not a node, including ppn stuff, node names...
	sed = subprocess.Popen(["sed", "-e s/\:ppn=[0-9]*//g", \
	 "-e s/+*[a-zA-Z][a-zA-Z0-9]*\(+*\)/\\1/g"], \
	 stdout=subprocess.PIPE, stderr=subprocess.PIPE, stdin=awk.stdout)
	awk.stdout.close()
	
	stdout, stderr = sed.communicate()
	if (stderr != ''):
		print 'ERROR in cherub_global_load', stderr
	counter = 0
	text = str(stdout).splitlines()
	for needs in text:
		if str(needs).isdigit():
			counter += int(needs)
		else:
			subneeds = str(needs).split('+')
			for subneed in subneeds:
				if str(subneed).isdigit():
					counter += int(subneed)
	return counter

def cherub_giveme_all_load():
	'''this function is just for testpurpose, it outputs the load of every 
	node in the config file and is NOT used in the CHERUB API'''
	for node in cherub_config.cluster:
		print node[0], '[', cherub_node_load(node[0]), ']'
	print 'global load [', cherub_global_load(), ']'
	return 0
