#include <Python.h>
#include <unistd.h>

#include "cherub_api.h"
#include "cherub.h"

int select_node(char *commandstring, struct cherub_cluster *cluster)
{
	int node_selected = 0,n;
	printf("## Please select a node\n");
	for(n=0;n < cluster->number_of_nodes; n++)
	{
		printf("## %d = %s\n",n,cluster->nodes[n].name);
	}
	printf("#################################\n");
	printf("-1 = EXIT\n");
	printf("#################################\n");
	printf("## Select Node for %s\n## choice:",commandstring);
	scanf("%d", &node_selected); 
	if(node_selected < -1 || node_selected >= n)
	{
		printf("##\n## WRONG INPUT\n##\n");
		sleep(1);
		node_selected=-1;
	}
	return node_selected;
}

int test_shutdown(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0,error;
	n=select_node("shutdown",cluster);
	while(n!=-1)
	{
		error = cherub_shutdown(cluster->nodes[n].ip_address, content);
		printf("[TEST] shutdown %s\n",cluster->nodes[n].name);
		printf("[TEST] cherub_shutdown returned with %i\n",error);
		n=select_node("shutdown",cluster);
	}
	return 0;
}

int test_boot(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0, error;
	n=select_node("boot",cluster);
	while(n!=-1)
	{
		error = cherub_boot(cluster->nodes[n].ip_address, content); 		
		printf("[TEST] boot %s\n",cluster->nodes[n].name);
		printf("[TEST] cherub_boot returned with %i\n",error);
		n=select_node("boot",cluster);
	}
	return 0;
}

int test_offline(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0, error;
	n=select_node("offline setting",cluster);
	while(n!=-1)
	{
		error = cherub_sign_off(cluster->nodes[n].name, content); 		
		printf("[TEST] sign_off %s\n",cluster->nodes[n].name);
		printf("[TEST] cherub_sign_off returned with %i\n",error);
		n=select_node("offline setting",cluster);
	}
	return 0;
}

int test_register(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0, error;
	n=select_node("registration",cluster);
	while(n!=-1)
	{
		error = cherub_register(cluster->nodes[n].name, content); 		
		printf("[TEST] register %s\n",cluster->nodes[n].name);
		printf("[TEST] cherub_register returned with %i\n",error);
		n=select_node("registration",cluster);
	}
	return 0;
}

int test_status(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0,error;
	n=select_node("status reqeuest",cluster);
        while(n!=-1)
        {
		error = cherub_status(cluster->nodes[n].name, content);
		switch(error)
		{
			case  0:	printf("[TEST] status of %s is BUSY (%d)\n",cluster->nodes[n].name, error); break;
			case  1:	printf("[TEST] status of %s is ONLINE (%d)\n",cluster->nodes[n].name, error); break;
			case  2:	printf("[TEST] status of %s is OFFLINE (%d)\n",cluster->nodes[n].name, error); break;
			case  3:	printf("[TEST] status of %s is DOWN (%d)\n",cluster->nodes[n].name, error); break;
			case -1:	printf("[TEST] status of %s is UNKOWN (%d)\n",cluster->nodes[n].name, error); break;
			default:	printf("[TEST] WRONG STATUS RETURN-VALUE!!!"); break;
		}
		n=select_node("status reqeuest",cluster);
        }
	return error;
}

int test_load(struct cherub_cluster *cluster, struct cherub_content *content)
{
	int n=0,error;
	n=select_node("load request",cluster);
	while(n!=-1)
	{
		error = cherub_node_load(cluster->nodes[n].name, content); 		
		printf("[TEST] load of %s is %d\n",cluster->nodes[n].name, error);
		n=select_node("load request",cluster);
	}
	return 0;
}

int test_global_load(struct cherub_content *content)
{
	int error;
	error = cherub_global_load(content); 		
	printf("[TEST] global load is %d\n", error);
	return 0;
}

int test_nodes_load(struct cherub_content *content, struct cherub_cluster *cluster)
{
	int nodes_load_size, i;

	if(content->parallel_load==0)
	{
		printf("cherub_load_list is not implementet within %s.py",content->scriptname);
		return 1;
	}
	else
	{
		int* nodes_load_list = NULL;
		nodes_load_list = cherub_load_list(&nodes_load_size, content);
		printf("nodes_load_size = %d",nodes_load_size);
		for(i=0;i<nodes_load_size;i++)
		{
			printf("%s has %d load", cluster->nodes[i].name,nodes_load_list[i]);
		}
		return 0;
	}
}

int test_parallel_status(struct cherub_content *content, struct cherub_cluster *cluster)
{
	int nodes_status_size, i;
	int* nodes_status_list = NULL;
	if(content->parallel_status==0)
	{
		printf("cherub_status_parallel is not implementet within %s.py",content->scriptname);
		return 1;
	}
	else
	{
		nodes_status_list = cherub_status_parallel(&nodes_status_size, content);
		for(i=0;i<nodes_status_size;i++)
		{
			switch(nodes_status_list[i])
			{
				case  0:	printf("[TEST] status of %s is BUSY (%d)\n",cluster->nodes[i].name, nodes_status_list[i]); break;
				case  1:	printf("[TEST] status of %s is ONLINE (%d)\n",cluster->nodes[i].name, nodes_status_list[i]); break;
				case  2:	printf("[TEST] status of %s is OFFLINE (%d)\n",cluster->nodes[i].name, nodes_status_list[i]); break;
				case  3:	printf("[TEST] status of %s is DOWN (%d)\n",cluster->nodes[i].name, nodes_status_list[i]); break;
				case -1:	printf("[TEST] status of %s is UNKOWN (%d)\n",cluster->nodes[i].name, nodes_status_list[i]); break;
				default:	printf("[TEST] WRONG STATUS RETURN-VALUE!!!"); break;
			}	
		}
		free(nodes_status_list);
		return 0;
	}
}

int test_send_problem_mails(struct cherub_content *content, struct cherub_cluster *cluster)
{
	int n;
	printf("Setting problems for all nodes\n");
	for(n=0;n<cluster->number_of_nodes;n++)
	{
		cluster->nodes[n].boot_problem = 1;
		cluster->nodes[n].shutdown_problem = 1;
		cluster->nodes[n].register_problem = 1;
		cluster->nodes[n].signoff_problem = 1;
	}
	printf("invoking mail function\n");
	send_problem_mails(content, cluster);
	printf("mail function finished\n");
	return 0;
}

/*----------------------- TEST_MAIN ------------------------------------------------------*/

void test(struct cherub_cluster *cluster ,struct cherub_content *content)
{	
	printf("WAIT_FOR_SIGN_OFF  : %i\n" \
	       "UPDATE_CYCLE       : %i\n" \
	       "MINUTES_NORMALYSER : %i\n" \
	       "SIGN_OFF_THRESHOLD : %i\n" \
	       "ERROR_THRESHOLD    : %i\n" \
		   ,content->WAIT_FOR_SIGN_OFF,content->UPDATE_CYCLE,content->MINUTES_NORMALYSER,content->SIGN_OFF_THRESHOLD,content->ERROR_THRESHOLD
	);
	int exit=1;
	while(exit)
	{
		int eingabe = 0;
			printf( "\n\ntest the cherub_api functions\n" \
				"###############################\n"
				"## 1  = shutdown             ##\n"\
				"## 2  = boote                ##\n"\
				"## 3  = set offline          ##\n"\
				"## 4  = set online           ##\n"\
				"## 5  = show status          ##\n"\
				"## 6  = show parallel status ##\n"\
				"## 7  = show load            ##\n"\
				"## 8  = show global load     ##\n"\
				"## 9  = show parallel load   ##\n"\
				"## 10 = send problem mails   ##\n"\
				"## 11 = exit                 ##\n"\
				"###############################\n"\
					);
	
		printf("## Please enter choice     ##\n");
		printf("## choice:");
		scanf("%d", &eingabe); 
		printf("\n\n");
		switch (eingabe)
		{
			case 1: test_shutdown(cluster,content);			break;
			case 2: test_boot(cluster,content);			break;
			case 3: test_offline(cluster,content);			break;
			case 4: test_register(cluster,content);			break;
			case 5: test_status(cluster,content);			break;
			case 6: test_parallel_status(content,cluster);		break;
			case 7: test_load(cluster,content);			break;
			case 8: test_global_load(content);			break;
			case 9: test_nodes_load(content,cluster);		break;
			case 10: test_send_problem_mails(content,cluster);	break;
			case 11: exit = 0;					break;
			default: printf("## WRONG CHOICE, PLEASE TRY AGAIN\n"); break;
		}
	}
}

	/*	{
			error = cherub_init(&cluster, &content);	
			while(1)
			{ 
				update_cherub_cluster(&cluster, content); 	
				if(content.options & COMMANDLINE_INFO)
				{
					int n=0;
					for(n=0;n < cluster.number_of_nodes; n++){
						printf("\n##### INFORMATION ABOUT NODE %s ######\n"\
							"# NODE IP:     %15s            #\n"\
							"# RUNNING CYCLES: %12.0f            #\n"\
							"# LOAD:        %15i            #\n",cluster.nodes[n].name, cluster.nodes[n].ip_address, cluster.nodes[n].cycles_running, cluster.nodes[n].load);
						switch(cluster.nodes[n].state )
						{
						 case -1: printf("# STATUS:              UNKNOWN            #\n"); break;
						 case  0: printf("# STATUS:                 BUSY            #\n"); break;
						 case  1: printf("# STATUS:               ONLINE            #\n"); break;
						 case  2: printf("# STATUS:              OFFLINE            #\n"); break;
						 case  3: printf("# STATUS:                 DOWN            #\n"); break;
						}						
						printf("###########################################\n\n");
					}
				}
				sleep(content.UPDATE_CYCLE);
			}
			break;
		}
		
		default : printf("INVALID INPUT\n");
	}
	}*/
