#!/bin/sh
# $Id: Makefile 1827 2011-11-15 17:05:02Z umaxx $ */

# Copyright (c) 2011-2012 Joerg Zinke <info@salbnet.org>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

MAX_JOBS=${1:-1}

test_assert() {
    while read line; do
        fgrep -q "$line" $2 || {
            /bin/echo "$3...failed to match:"
            /bin/echo "[Expected] $line"
            /bin/echo -n "[Found]    "
            fgrep "$(echo $line | cut -d:  -f1)" $2 || fgrep "$(echo $line | cut -d\  -f1)" $2 || /bin/echo ""
            return 1
        }
    done < $1
    /bin/echo "$3...ok"
}

test_servload() {
    RESULT="test/result_$RANDOM.tmp"
    ./servload $2 > $RESULT 2> /dev/null
    test_assert $3 $RESULT "$1"
    rm $RESULT
}

test_run() {
    local PIDS=$(jobs -p)
    if [ $(echo "$PIDS" | wc -l) -ge $MAX_JOBS ]; then
      wait $(echo "$PIDS" | head -n1)
    fi
    test_servload "$@" &
}

echo "running tests..."
test_run "test case 1: http/1.0 combined log single request" "http://www.salbnet.org:80/ test/test1.log" test/result1.txt
test_run "test case 2: http/1.1 common log" "http://www.salbnet.org/ test/test2.log" test/result2.txt
test_run "test case 3: http/1.1 common log fast" "http://www.salbnet.org/ test/test2.log fast" test/result3.txt
test_run "test case 4: http/1.1 common log multiply" "http://www.salbnet.org/ test/test2.log multiply 3" test/result4.txt
test_run "test case 5: http/1.1 common log peak" "http://www.salbnet.org/ test/test2.log peak 3" test/result5.txt
test_run "test case 6: http/1.1 common log score" "http://www.salbnet.org/ test/test2.log score 3" test/result6.txt
test_run "test case 7: http/1.1 common log chunked" "http://www.golem.de/ test/test3.log" test/result7.txt
test_run "test case 8: https" "https://www.umaxx.net/ test/test3.log" test/result8.txt
test_run "test case 9: dns" "dns://8.8.8.8/ test/test4.log" test/result9.txt
test_run "test case 10: dns" "dns://google-public-dns-b.google.com/ test/test5.log" test/result10.txt
#test_run "test case 11: dnssec" "dnssec://149.20.64.20/ test/test4.log" test/result11.txt
#test_run "test case 12: dnssec" "dnssec://bind.odvr.dns-oarc.net/ test/test6.log" test/result12.txt

wait
