/**************************************************************************/
/*!
@file     MQ135.h
@author   G.Krocker (Mad Frog Labs)
@license  GNU GPLv3

First version of an Arduino Library for the MQ135 gas sensor
TODO: Review the correction factor calculation. This currently relies on
the datasheet but the information there seems to be wrong.

@section  HISTORY

v1.0 - First release

extended by Mareen Przybylla with corrections provided by the community, esp.
Vilius Kraujutis (https://github.com/ViliusKraujutis) and Andreas Grillenberger

*/
/**************************************************************************/
#ifndef MQ135_H
#define MQ135_H
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif

/// The load resistance on the board
#define RLOAD 10.0

/// Parameters for calculating ppm of CO2 from sensor resistance (calculated
//  from datasheet: http://davidegironi.blogspot.com/2014/01/cheap-co2-meter-
//  using-mq135-sensor-with.html#.X3MjrS8RrmE)
#define PARA 116.6020682
#define PARB 2.769034857

/// Parameters to model temperature and humidity dependence
#define CORA 0.00035
#define CORB 0.02718
#define CORC 1.39538
#define CORD 0.0018
#define CORE -0.003333333
#define CORF -0.001923077
#define CORG 1.130128205

/// Atmospheric CO2 level for calibration purposes (as of Sep 2020,
//  https://www.co2.earth)
#define ATMOCO2 412.55

class MQ135 {
 private:
  uint8_t _pin;
  float _rZero;

 public:
  MQ135(uint8_t pin, float rZero);
  float getCorrectionFactor(float t, float h);
  float getResistance();
  float getCorrectedResistance(float t, float h);
  float getPPM();
  float getCorrectedPPM(float t, float h);
  float getRZero();
  float getCorrectedRZero(float t, float h);
  float getPPMCustom(float rZero);
  bool isCalibrated();
  void setRZero(float rZero);
  float getRZeroWithTargetPPM(float ppm);

};
#endif
