/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.logging;

import android.os.Trace;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.annotation.Beta;
import android.support.test.rule.logging.LoggingBaseRule;
import android.support.test.rule.logging.RuleLoggingUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;

@Beta
public class LogGraphicsStatsRule
extends LoggingBaseRule {
    private static final String TAG = "LogGraphicsStatsRule";
    private static final String DEFAULT_LOG_FILE_NAME = "gfxinfo.dumpsys.log";

    public LogGraphicsStatsRule() {
    }

    public LogGraphicsStatsRule(@NonNull File logFileOutputDirectory, @Nullable String fileName) {
        super(logFileOutputDirectory, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTest() {
        String[] commandParts = this.getAndroidRuntimeVersion() >= 23 ? new String[]{"dumpsys", "gfxinfo", this.getPackageNameUnderTest(), "framestats"} : new String[]{"dumpsys", "gfxinfo", this.getPackageNameUnderTest()};
        try {
            Trace.beginSection((String)"Gfxinfo dumpsys");
            RuleLoggingUtils.startProcessAndLogToFile(commandParts, this.getLogFile(), this.getAndroidRuntimeVersion());
        }
        finally {
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeTest() {
        Process process = null;
        try {
            process = RuleLoggingUtils.startProcess(new String[]{"dumpsys", "gfxinfo", "--reset", this.getPackageNameUnderTest()});
            process.waitFor();
        }
        catch (IOException | InterruptedException exception) {
            Log.e((String)TAG, (String)"Unable to reset reset gfxinfo", (Throwable)exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    @Override
    String getDefaultLogFileName() {
        return DEFAULT_LOG_FILE_NAME;
    }
}

