#!/usr/bin/perl

package FDLinstall;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw (doinstallfdl lispnamemap fdlcmu fdlacl fdlbin fdlelisp);

my $zcat = "zcat";

# longname used for directory names
# shortnames used for mnemonics.
sub lispnamemap { 
    my $lispvendor = $_[0];
    my $longname;

    if ($lispvendor eq "cmu") {
	$longname = "cmucl";
    }
    if ($lispvendor eq "cmu18d") {
	$longname = "cmucl18d";
    }
    if ($lispvendor eq "cmu18e") {
	$longname = "cmucl18e";
    }
    elsif ($lispvendor eq "acl43") {
	$longname = "allegro43";
    }
    elsif ($lispvendor eq "acl501") {
	$longname = "allegro501";
    }
    elsif ($lispvendor eq "acl62") {
	$longname = "allegro62";
    }
    elsif ($lispvendor eq "acl61") {
	$longname = "allegro61";
    }
    elsif ($lispvendor eq "acl6") {
	$longname = "allegro6";
    }
    else {
	die "\nUnrecognized lispvendor $lispvendor\n";
    }
    
    return $longname;
}

sub fdltar {
    my $fdlhome = $_[0];
    my $fdldist = $_[1];
    my $platform = $_[2];
    my $compiler = $_[3];
    my $fdldbi = $_[4]; #  relative to .../fdl/sys or absolute pathname.

    print "FDL Install info : Untar : \n";
    chdir "$fdlhome/..";
    print "   $fdldist/fdltop.tgz\n";
    `$zcat $fdldist/fdltop.tgz | tar xf -`;
    print "   $fdldist/$platform-$compiler-run.tgz\n";
    `$zcat $fdldist/$platform-$compiler-run.tgz | tar xf -`;
    if (-e "$fdldist/fdl-source.tgz") {
	print "   $fdldist/fdl-source.tgz\n";
	`$zcat $fdldist/fdl-source.tgz | tar xf -`;
    }
    chdir "$fdlhome/sys";

    my $fdldb = ".";

    if (!($fdldbi eq "")) {
	$fdldb = $fdldbi;
    }

    if (!(-e "$fdldb/FDLdb")) {

	chdir $fdldb;

	my $pwd = `pwd`;
	my $dbtar = 0; 

	if (-e "$fdldist/standard-db.tgz") {
	    $dbtar = "$fdldist/standard-db.tgz";
	}
	elsif (-e "$fdldist/release-db.tgz") {
	    $dbtar = "$fdldist/release-db.tgz";
	}
	elsif (-e "$fdldist/fdldb.tgz") {
	    $dbtar = "$fdldist/fdldb.tgz";
	}
	elsif (-e "$fdldist/FDLdb.tgz") {
	    $dbtar = "$fdldist/FDLdb.tgz";
	}
		
	if ($dbtar) {
	    print "   Installing FDLdb $dbtar at $pwd\n";
	    sleep 5;

	    print "   $dbtar (This one may take a while)\n";
	    
	    `$zcat $dbtar | tar xf -`;

	    chdir "$fdlhome/sys";
	    if (!($fdldbi eq "")) {
		symlink "$fdldb/FDLdb", "FDLdb";}
	}
	else { 	print "   Not installing DB\n      since $fdldist does not contain db tar file. \n"; }
    }
    else {
	print "   Not installing DB\n      since $fdldb already exists \n";
    }

    chdir "$fdlhome";
    print "FDL Install info : Untar : done.\n";
}


sub fdlelisp {

    my $fdlhome = $_[0];
    my $inflisp = $_[1];	#cmulisp or allegro.
    my $fdlversion = $_[2];	# what if multiple versions?
    my $specializer = $_[3];

    print "FDL Install info : FDL elisp\n";

    `echo "#sh\nemacs -xrm \\\"Emacs.iconName: \\\$5\\\" -l $fdlhome/bin/elisp/require-fdl -fg \\\$1 -bg \\\$2 -ms \\\$3 -cr \\\$4 -T \\\$5 &\n" > $fdlhome/bin/run-emacs`;
    `chmod +x $fdlhome/bin/run-emacs`;

    my @fdlcmds;

    @fdlcmds = ("fdledd$specializer", "fdllib$specializer", "nuref$specializer", "fdlwww$specializer");

    if (-e "$fdlhome/bin/elisp/fdl.el") {
	`rm $fdlhome/bin/elisp/fdl.el`;
	}

    open FILE, ">$fdlhome/bin/elisp/fdl.el" or die "$fdlhome/bin/elisp/fdl.el failed to open";

    print FILE "(setq fdlhome \"$fdlhome/\")\n";
    print FILE "(when (file-exists-p \"$fdlhome/bin/elisp/fdl-misc.el\")\n  (load \"$fdlhome/bin/elisp/fdl-misc\"))\n";
    print FILE "(load \"$fdlhome/bin/elisp/ilisp5.12\")\n";

    my $cmd;
    map {
	$cmd = $_;
	print FILE "(defun $cmd ()\n";
	print FILE "   (interactive)\n";
	print FILE "   (cd \"$fdlhome/sys\")";
	print FILE "   (setq $inflisp-program \"$cmd\")\n";
	print FILE "   ($inflisp))\n\n";
    } @fdlcmds;
    print FILE "\n(provide 'fdl)\n";

    close FILE;

    print "FDL Install info : fdl elisp - created fdl.el\n";

    if (-e "$fdllhome/bin/elisp/require-fdl.el") {
	`rm $fdlhome/bin/elisp/require-fdl.el`;
    }

    open REQFILE, ">$fdlhome/bin/elisp/require-fdl.el" or die "$fdlhome/bin/elisp/require-fdl.el failed to open";
    print REQFILE "\n(require 'fdl \"$fdlhome/bin/elisp/fdl\")\n";
    close REQFILE;

    print "FDL Install info : FDL elisp done.\n";
}

# build usr/local scripts
sub fdlbin {
    my $fdlhome = $_[0];
    my $compiler = $_[1];
    my $specializer = $_[2];

    print "FDL Install info : fdl bin\n";

    my $majorversion = 0;
    my $minorversion = 0;

    my $path ="$fdlhome/bin/usrlink/disksaves/$compiler";
    my $prefix ="$path/fdl$majorversion";

    my $suffix ="";
    if ($compiler eq "allegro62") { $suffix = ".dxl"; }
    if ($compiler eq "allegro61") { $suffix = ".dxl"; }

    my $nv = "fdl$majorversion";

    my $lispex = "$fdlhome/bin/${compiler}x ";

    chdir "$fdlhome/bin";

    my $msg;

    print "pwd : ";
    print `pwd`;

    if ($compiler eq "allegro43") {
	if (-e "$prefix-ref") {
	    `ln -s $path/$nv-nu5 nuref$specializer`;
	}
	if (-e "$prefix-lib") {
	    `ln -s $path/$nv-lib nulib$specializer`;
	}
	if (-e "$prefix-edd") {
	    `ln -s $path/$nv-edd nuedd$specializer`;
	}
    }
    else {
	if (-e "$prefix-nu5$suffix") {
	    print "FDL Install info : fdl bin - creating $fdlhome/bin/nuref$specializer\n";
	    `echo "#sh\n$lispex $path/$nv-nu5$suffix\n" > ./nuref$specializer`;
	    `chmod +x ./nuref$specializer`;
	}
	if (-e "$prefix-lib$suffix") {
	    print "FDL Install info : fdl bin - creating $fdlhome/bin/fdllib$specializer\n";
	    `echo "#sh\n$lispex $path/$nv-lib$suffix\n" > ./fdllib$specializer`;
	    `chmod +x ./fdllib$specializer`;
	};
	if (-e "$prefix-edd$suffix") {
	    print "FDL Install info : fdl bin - creating $fdlhome/bin/fdledd$specializer\n";
	    `echo "#sh\n$lispex $path/$nv-edd$suffix\n" > ./fdledd$specializer`;
	    `chmod +x ./fdledd$specializer`;
	}
    }
    print "FDL Install info : fdl bin - created $fdlhome/bin scripts\n";



    `rm $fdlhome/utils/profile/cshrc`;
    `echo "\nset path = ( $fdlhome/bin \\\$path)\nsetenv LD_ASSUME_KERNEL 2.4.1\n" > $fdlhome/utils/profile/cshrc`;
    
    `rm $fdlhome/utils/profile/xinitrc`;
    `echo "\nxset fp+ $fdlhome/sys/fonts/bdf\nxset fp rehash\n" > $fdlhome/utils/profile/xinitrc`;

    print "FDL Install info : fdl bin done.\n";
}


sub fdlcmu {

    my $fdlhome = $_[0];
    my $compiler = $_[1];
    my $platform = $_[2];
    my $locallisp = $_[3];

    print "FDL Install info : CMUCL $compiler\n";

    if ($locallisp) {
	if (-e "$fdlhome/bin/usrlocal/$platform/$compiler") {
	    `rm -rf $fdlhome/bin/usrlocal/$platform/$compiler`; }
	`ln -s $locallisp $fdlhome/bin/usrlocal/$platform/$compiler`;
	print "FDL Install info : CMUCL linked to local $locallisp \n";
    }

    `echo "#sh\n$fdlhome/bin/usrlink/$compiler/cmucl -core \\\$1\n" > $fdlhome/bin/${compiler}x`;
    `chmod +x $fdlhome/bin/${compiler}x`;
    print "FDL Install info : CMUCL created ${compiler}x script\n";

    print "FDL Install info : CMUCL done.\n";
}


sub fdlacl {

    my $fdlhome = $_[0];
    my $compiler = $_[1];
    my $locallisp = $_[2];

    if (!($locallisp)) {
	$locallisp = "$fdlhome/bin/usrlink/$compiler";
    }


    #if (-e "~/.clinit.cl") { `mv ~/.clinit.cl ~/.clinit.cl.orig`; }
    #`ln -s ~/init.lisp ~/.clinit.cl`;

    print "FDL Install info : $compiler\n";

    `rm $fdlhome/bin/${compiler}x`;
    if ($compiler eq "allegro43") {
    }
    else {
	if ($compiler eq "allegro501") {
	    `echo "#sh\n$locallisp/lisp -I \\\$1\n" > $fdlhome/bin/${compiler}x`;
	}
	else {
	    `echo "#sh\n$locallisp/alisp8 -I \\\$1\n" > $fdlhome/bin/${compiler}x`;
	}

	`chmod +x $fdlhome/bin/${compiler}x`;
    }

}

sub doinstallfdl{

    my $fdlhome = shift;
    my $lispvendor = shift;
    my $platform = shift;
    my $dist = shift;
    my $dbpath = shift;

    my $usrlocal = shift;
    my $locallisp = shift;
    my $specializer = shift;
    $zcat = shift;
    my $ghostp = shift;


    my $gfdlhome = glob $fdlhome;
    my $fdldist = "$gfdlhome/dist";

    if ($dist) {
	$fdldist = glob $dist;
    }

    print "FDL Install info : Begin. Installing at $gfdlhome\n    from tar files at $fdldist \n";

    sleep 5;

    chdir "$gfdlhome/..";
    
    #if (-e "./init.lisp") { `mv ./init.lisp ./init.lisp.orig`; }
    #`echo "(progn\n  (defvar *init-root* \\\"$gfdlhome\\\")\n  (load \\\"$gfdlhome/fdl/bin/fdl-init.l\\\"))" > ./init.lisp`;


   # Untar

    fdltar $gfdlhome, $fdldist, $platform, $lispvendor, $dbpath;


   # usrlocal
    if ($usrlocal) {
        # `ln -s $gfdlhome/bin/usrlocal/$platform $usrlocal/fdl`;
	print "FDL Install info : linking through $usrlocal/fdl\n";
	`ln -s $usrlocal/fdl $gfdlhome/bin/usrlink`;
    }
    else { 
	if (-e "$gfdlhome/bin/usrlink") { 
	    `rm -f  $gfdlhome/bin/usrlink`;}
	`ln -s $gfdlhome/bin/usrlocal/$platform $gfdlhome/bin/usrlink`; 
    }

    my $longlispname = lispnamemap $lispvendor;

    if ($lispvendor eq "cmu"
	|| $lispvendor eq "cmu18d"
	|| $lispvendor eq "cmu18e") {

	fdlcmu $gfdlhome,  $longlispname, $platform, $locallisp;

	fdlbin $gfdlhome,  $longlispname, $specializer;

	if (!($ghostp)) {
	    fdlelisp $gfdlhome, "cmulisp", "0";
	}
    }
    elsif ($lispvendor eq "acl6"
	   || $lispvendor eq "acl501"
	   || $lispvendor eq "acl43"
	   || $lispvendor eq "acl62"
	   || $lispvendor eq "acl61"
	   ) {

	fdlacl $gfdlhome, $longlispname, $locallisp;

	fdlbin $gfdlhome, $longlispname, $specializer;
	
	fdlelisp $gfdlhome, "allegro", "0";
    }
    else {die "Unrecoginized lisp $lispvendor\n";}

    print "FDL Install info : DONE.\n";
}





