
(setq load-path
      (cons (expand-file-name (concat fdlhome "bin/elisp/ilisp-5.12.0/"))
	    load-path))

(autoload 'run-ilisp "ilisp" "Select a new inferior LISP." t)

(autoload 'allegro   "ilisp" "Inferior Allegro Common LISP." t)
(autoload 'cmulisp   "ilisp" "Inferior CMU Common LISP." t)

(setq ilisp-load-hook
      '(lambda ()
     	 ;; Change default key prefix to C-c
	 (setq ilisp-*prefix* "\C-c")

 	 ;; Sample initialization hook.  Set the inferior LISP directory to
     	 ;; the directory of the buffer that spawned it on the first prompt.
     	 (setq ilisp-init-hook
     	       '(lambda ()
     		  (default-directory-lisp ilisp-last-buffer)))
	 ))


(set-default 'auto-mode-alist
	     (append '(("\\.lisp$" . lisp-mode)
		       ("\\.lsp$" . lisp-mode)
		       ("\\.cl$" . lisp-mode))
		     auto-mode-alist))
(setq lisp-mode-hook '(lambda () (require 'ilisp)))


;; this is better.
(load "cl-indent") 

;; for some reason, the following causes problems on some linux versions??
;; seems ok now
(setq lisp-indent-function 'common-lisp-indent-function)
