
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************

#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;	
;;;;	Migrate: 
;;;;	 migrate template opid to !template?? Must also do so in abstractions. How about ml funcs
;;;;	which build template terms??
;;;;	

;;;; -docs- (mod edd dform)
;;;;
;;;;	Dform: Display Form.
;;;;
;;;;	Display forms may be defined to assist in display and instantiation of
;;;;	data in proofs as well as the bodies of library objects.  Display forms
;;;;	are defined within disp objects of the library.  Display-forms control
;;;;	whitespace and parenthesization.
;;;;	
;;;;	Each disp object may define multiple display forms, however all display
;;;;	forms within a single object must be of the same type.
;;;;	
;;;;	Each dform contains a list of attributes, a list of formats, and a model
;;;;	term. The attributes include choice and parenthesization parameters.
;;;;	The formats specify how the term is to be displayed.  The model term is
;;;;	used to match the term instance to be displayed.
;;;;	
;;;;  -page-
;;;;
;;;;	Dform address : 
;;;;	
;;;;	<dform-addr>	: !dform_address{s}(<oid>)
;;;;			| !dform_address{s}
;;;;
;;;;	There are theree flavors of dform addresses:
;;;;	  - index : If the string is a string of decimal digits then the number
;;;;	            represents an index into the list of dforms within the
;;;;	            object (beginning at 1).
;;;;	  - blank : If the string is the empty string, then it is interpreted
;;;;		    as addressing the first dform defined in the object.
;;;;	  - named : Otherwise, the string represents the name of the dform and 
;;;;		    it is expected that the specified object has a dform with
;;;;		    that name. If more than one dform within an object has the
;;;;		    same name than it is unpredicatable which will be returned
;;;;		    when accessed by address.  Suppressing a dform by name
;;;;		    suppresses all dforms with that name.
;;;;	
;;;;	Dform addresses sometimes occur in contexts where the object
;;;;	id of the dform is implicit. In such cases the object
;;;;	id need not be included.
;;;;	
;;;;  -page-
;;;;	
;;;;	Precedence tree:
;;;;	
;;;;	The precedence tree is used in determining whether or not to parenthesize
;;;;	subterms. Parameter data is not parenthesized.
;;;;	
;;;;	The precedence tree is built from precedence objects.  Precedence
;;;;	objects are trees whose leaves are pointers to other precedence objects,
;;;;	or precedence labels.
;;;;	
;;;; -doct- (mod edd dform data)
;;;;	
;;;;	Term Syntax : syntax for prec object contents.
;;;;
;;;;	<prec-expr>	: !precedence_object{<oid>}
;;;;	 		| !precedence_ordered(<prec-expr> <prec-expr>)
;;;;			| !precedence_unrelated(<prec-expr> <prec-expr>)
;;;;			| <prec-eq-expr>
;;;;
;;;;	<prec-eq-expr>	: !precedence_equal(<prec-eq-expr> <prec-eq-expr>)
;;;;			| <inj-label>
;;;;
;;;;	<inj-address>	: <dform-addr>
;;;;			| <prec-label>
;;;;	
;;;;	<prec-label>	: !precedence_label{t}()
;;;;			
;;;; -doct- (mod edd dform)
;;;;
;;;;	Dforms may contain a !dform_precedence_injection attribute. The
;;;;	precedence injection may point to other dforms to comprise an injection
;;;;	tree. A dform address in an injection pointer need not be valid. The
;;;;	injection tree may culminate at a precedence label. Such a precedence
;;;;	label need not occur in the precedence tree. All members of an injection
;;;;	tree have equal precedence. An injection tree which does not culminate
;;;;	at a valid precedence label is called a hanging injection tree.
;;;;
;;;;	<injection>	: <dform-addr>
;;;;			| <prec-label>
;;;;
;;;;	<attribute>	: !dform_precedence_injection{}(<injection>)
;;;;
;;;;	A global prec tree corresponding to the top-level unrelated list is
;;;;	explicitely maintained. (De)Activating a prec object rebuilds explicit
;;;;	tree. The dform injection trees are maintained as links within the
;;;;	dforms.  (De)Activating a dform rebuilds its injection tree.
;;;;
;;;;	A precedence sensitivity flag may occur in the dform attributes.  The
;;;;	presence of such a flag indicates that the dform may be parenthesized.
;;;;	Absence of the flag indicates the dform should never be parenthesized.
;;;;	
;;;;  -page-
;;;;	
;;;;	Precedence Notes:
;;;;
;;;;	  - All precedence objects which are not pointed to by other precedence 
;;;;	    objects are considered to comprise an implicit top-level list of
;;;;	    unrelated trees. The top unrelated list contains the precdence tree
;;;;	    fragments built by the precedence objects and the hanging injection
;;;;	    trees.
;;;;	  
;;;;	  - All dforms not included in precedence tree or an injection tree
;;;;	    are considered to be individual members of the top-level list of
;;;;	    unrelated trees. In conjunction with the default insensitivity
;;;;	    dforms remain unparenthesized by default.
;;;;
;;;;	  - A precedence object may be pointed to by at most one
;;;;	    !precedence_object pointer. Forward (wrt time of activation)
;;;;	    references to prec objects will cause warnings.
;;;;
;;;;	  - The subterms of a !precedence_equal operator may only be
;;;;	    !precedence_equal operators or !precedence_label's.
;;;;	    This restriction is encoded in the syntax.
;;;;
;;;;	  - cycles among precedence objects are not allowed.
;;;;	     * if activation of a prec object would create a cycle then
;;;;	       activate fails and the explicit precedence tree is left
;;;;	       unchanged.
;;;;	
;;;;	  - cycles in an injection tree are allowed.
;;;;	    An injection tree containing a cycle will not culminate in a
;;;;	    precedence label and thus will not be a part of the explicit
;;;;	    precedence tree.
;;;;	
;;;;	
;;;;	Lib checks object tree structure but does not do cycle detection.
;;;;	EDD will detect cycles at precedence definition insert.
;;;;
;;;;	More doc in ~eaton/Mail/nuprl5/doc Subject: iparms. ~sfa/prl/edit/timt/display
;;;;
;;;;  -page-
;;;;
;;;;	An internal representation for a precedence tree may be as follows:
;;;;
;;;;	<prec-tree>		: <prec-unordered-list>
;;;;				| <prec-ordered-list>
;;;;				| <prec-equivalence-list>
;;;;
;;;;	<prec-leaf>		: [<tok> | <dform-address>
;;;;			 	   <prec-expr>
;;;;				  ]
;;;;
;;;;	<prec-ordered-list>	: ( <prec-unordered-list> | <prec-equivalence-list> ) list
;;;;
;;;;	<prec-unordered-list>	: ( <prec-ordered-list> | <prec-equivalence-list> ) list
;;;;
;;;;	<prec-equivalence-list>	: <prec-leaf> list
;;;;				  
;;;;	
;;;;	<prec-expr>		: <int-prec-expr>
;;;;				| <tok-prec-expr>
;;;;
;;;;	<tok-prec-expr>	: <utok> | ( <utok> . <int-prec-expr> )
;;;;
;;;;	<int-prec-expr>	: <INT> | ( <INT> . <tok-prec-expr> )
;;;;
;;;;	<utok>			:  uninterned symbol.
;;;;
;;;;	
;;;;	Notes: 
;;;;	
;;;;	Named and blank dform addresses will be coerced to index dform addresses
;;;;	when possible.
;;;;	
;;;;  -page-
;;;;
;;;;	Assigning Precedence expressions :
;;;;
;;;;	The following algorithm can be used to assign precedence expressions:
;;;;	
;;;;	Assign_Precedence_Expression (plist expr)
;;;;	 IF unordered? plist
;;;;	    THEN let nexpr = (gen_utok . expr)
;;;;		  map \l. (Assign_Precedence_Expression l nexpr)
;;;;		      members_of plist
;;;;	 ELSEIF ordered? plist
;;;;	    THEN Assign_Precedence_Order members_of list expr 0
;;;;	 ELSE * must be equivalence *
;;;;	    map \leaf. SET leaf.prec-expr <- expr
;;;;		members_of plist
;;;;	 ENDIF
;;;;
;;;;	Assign_Precedence_Order (plist expr i)
;;;;	 Assign_Precedence_Expression (hd plist) (i . expr)
;;;;	 Assign_Precedence_Order (tl plist) expr 1+i
;;;;
;;;;
;;;;	Hanging injection trees which culminate (including a cycle) at a valid
;;;;	dform will have the dform assigned as prec address.
;;;;
;;;;	Hanging injection trees which culminate at an invalid dform will have   
;;;;	a tok assigned as prec address. Tok will be derived from address so
;;;;	that injection pointers with similar addresses will be eq.
;;;;
;;;;	Hanging injection trees which culminate at a label will have the
;;;;	label assigned as prec address.
;;;;
;;;;  -page-
;;;;	
;;;;	Comparing Precedence expressions :
;;;;	 Precedence expressions can be Equal, Unrelated, Less or Greater.
;;;;
;;;;	Precedence (A, B)
;;;;	 IF A = B		   * = -> eq *
;;;;	    THEN return Equal
;;;;	 ELSEIF not (consp A) or not (consp B)
;;;;	    THEN return Unrelated
;;;;	 ELSE Precedence_ (rest A, rest B)
;;;;	 ENDIF
;;;;	
;;;;	
;;;;	Precedence_ (A, B)
;;;;	  IF (A is NIL) and (B is NIL)
;;;;	     THEN return Equal
;;;;	  ELSEIF (A is NIL) or (B is NIL)
;;;;	     THEN return Unrelated
;;;;	  ELSE Let a,b = first A, first B
;;;;	     IF a in tok and b in tok
;;;;	        THEN IF a = b
;;;;	                THEN Precedence_ (rest A, rest B))
;;;;	             ELSE return Unrelated
;;;;		     ENDIF
;;;;	     ELSEIF a in Natural and b in Natural
;;;;	        THEN IF a > b
;;;;	                THEN return Less
;;;;	             ELSEIF a = b
;;;;	                THEN Precedence_ (rest A, rest B)
;;;;	             ELSEIF a < b
;;;;	                THEN return Greater
;;;;	             ENDIF
;;;;	     ELSE return Unrelated
;;;;	     ENDIF
;;;;	   ENDIF
;;;;	
;;;;	Precedence_ contains redundant equality check for completeness.
;;;;	If the quick equality check is used, Precedence_ should never
;;;;	return Equal. In fact, it might be a useful to flag it as an error
;;;;	in order to detect bugs.
;;;;	
;;;;	
;;;; -doct- (mod edd dform ml)
;;;;
;;;;	The precedence tree can be accessed from ML :
;;;;	
;;;;	precedence_tree		 	: unit -> term
;;;;	precedence_sub_tree		: object_address -> term
;;;;	 * does not include dforms.
;;;;
;;;;	precedence_label_of_dform	: dform -> tok | dform
;;;;	  * If arg dform has no injection pointer then result dform will be arg.
;;;;	  * If injection cycle then result dform will be some member of cycle.
;;;;
;;;;	precedence_object_of_label	: tok -> object_address
;;;;
;;;;	precedence_equivalence_class	: dform -> dform list
;;;;
;;;; -doct- (mod edd dform)
;;;;
;;;;	Rehashing precedence tree :
;;;;	
;;;;	It is unacceptably costly to rebuild injection tree at each dform update
;;;;	during a load. When inserting dforms the entire dform table needs to be
;;;;	scanned to find injection pointers to new dforms.
;;;;	
;;;;	Two possible approaches :
;;;;	  - complicated global state to allow for efficient incremental updates.
;;;;	     - complicated.
;;;;	     - may still be costly.
;;;;	     + never stale.
;;;;	  - simple periodic rehash.
;;;;	     + simple
;;;;	     + stale tree has limited consequences.
;;;;	     - may still be costly.
;;;;	     - what is a period?
;;;;		* Add to transaction protocol.
;;;;		* Fixed time.
;;;;		* At user request.
;;;;
;;;;	Possibilities for incremental update:
;;;;	  - maintain list of hanging dform addresses?? Then only need to search that list.
;;;;	    * or list of hanging injection trees. (equivalent to preceding)
;;;;	    ? but harder problem is deleting dform may create hanging trees by interrupting a chain.
;;;;	  - maintain list of dforms referencing prec label directly or indirectly, then only
;;;;	    need to rehash that list on delete of any member.
;;;;	  - maintain list of hanging prec labels? Prec update infrequent enought that scan
;;;;	    of table for hanging labels is acceptable.
;;;;
;;;;	Possibility for periodic rehash :
;;;;	  - Rely on library to transmit some indication of appropriate time to rehash.
;;;;	      * -ie delay/finish or insert-commit/grouping mechanism
;;;;	
;;;;	 FTTB : wait, ie do periodic rehashs frequently.
;;;;
;;;;  -page-
;;;;	
;;;;	Display Form Syntax :
;;;;	
;;;;
;;;;	Attributes:
;;;;	
;;;;	Dform name : the dform name is used to refer to a dform in the
;;;;	  precedence tree. See the preceding section on dform addresses for 
;;;;	  for more details.
;;;;	
;;;;	<attribute>	: !dform_name{s}
;;;;
;;;;
;;;;  -page-
;;;;	
;;;;
;;;;	Dform macro name :
;;;;
;;;;	When a dform is activated an editor macro is generated which causes the
;;;;	a version of model term of the dform to be pasted into the selected
;;;;	point.  The pasted term is the model term with the meta-variables
;;;;	replaced with placeholders.  If !dform_macro_name is present then the
;;;;	macro will use the specified name. If the name is already in use then
;;;;	a warning will be issued and the newer (wrt order of activation) definition
;;;;	will shadow the former. 
;;;;	
;;;;	<attribute>	: !dform_macro_name{s} 
;;;;
;;;;	   * dform name string should not be composed entirely of decimal digits.
;;;;	
;;;;  -page-
;;;;	
;;;;
;;;;	Conditions : each dform has a set of associated conditions.
;;;;	  Conditions are case insensitive, ie all characters in condition string
;;;;	  are upcased.
;;;;
;;;;	<attribute>	: !condition{s}()
;;;;			| !text{s|t}()
;;;;
;;;;	  ** Any combination and multiple occurences of previous operators are 
;;;;	     allowed. Resulting condition list is union of all occurences.
;;;;
;;;;	** v4.2 migration note:
;;;;	   In version 4.2 conditions had to be specified in a
;;;;	   !dform_conditions{}(<conditions>) term. During the v4.2->v5
;;;;	   conversion such terms are migrated to <conditions>.
;;;;
;;;;  -page-
;;;;	
;;;;	Choice attributes :
;;;;
;;;;	The conditon expression facility can be used to control choice of
;;;;	dforms. The condition expressions are evaluated while choosing a dform,
;;;;	ie while instantiating display tree. It is possible that a condition
;;;;	expressions may require access to portions of dtree not yet
;;;;	instantiated.  In such a case the evaluation will fail, ie the
;;;;	evaluation will return false and the dform will not be used.  Thus
;;;;	conditions expressions attached to dforms must be carefully written.
;;;;
;;;;	<attribute>	: !dform_cond_expr(<cond_expr>)
;;;;	  * all dform cond_expr attributes must evaluate true for dform
;;;;	    to be used.
;;;;
;;;;	 ** v4.2 migration note:
;;;;	   - v4.2 migration will migrate !dform_not_point_condition{}() to
;;;;	     !dform_cond_expr(!text{"(!~point-suppress !~point)"}).
;;;;	     ie suppresses dform when term would be point,
;;;;	     ie dform is ok if not at point.
;;;;	   - v4.2 migration will migrate !dform_parents to check for a condition.
;;;;	     It must also add the condition to the parents. Cross theory references will
;;;;	     have to be handled manually. (unless every dform has some deterministic condition
;;;;	     added based on its address).
;;;;		    
;;;;
;;;;	Hiding :
;;;;	
;;;;	If a meta variable occurs in the model, but is not also present in the
;;;;	format list of a dform, then the structure bound to that meta variable
;;;;	by match is considered hidden.
;;;;	
;;;;	It has been deemed undesirable to have a dform chosen which hides
;;;;	certain types of structure in some conditions. For example, when instantiating
;;;;	a term, it would be annoying if empty slots were hidden. However, there are
;;;;	other circumstances where it is ok to hide a slot. The hidden cond expr
;;;;	can be used to control such behaviour.
;;;;
;;;;	<attribute>	: !dform_hidden_cond_expr(<cond_expr>)
;;;;	  * if all hidden cond_expr's evaluate to true on all subterms and
;;;;	    parameter values of the hidden structure then the dform will be
;;;;	    chosen.
;;;;	      - default : !(|(slot |(~point ~mark)))
;;;;		if any specified, then default not included.
;;;;
;;;;	 ** v4.2 migration note:
;;;;	   v4.2 migration will migrate !dform_hidden_ok{}() to
;;;;	   !dform_hidden_cond_expr(!text{"true"}).
;;;;
;;;;  -page-
;;;;	
;;;;	Parenthesization attributes : besides the injection attribute, several
;;;;	  dform attributes influence parenthesization.
;;;;	
;;;;	<attribute>	: !dform_precedence_passthru()
;;;;	
;;;;	  * when comparing a parent and child precedence, if the parent has the
;;;;	    passthru attribute than the precedence of its first ancestor
;;;;	    without the attribute is used. This allows one to prevent invisible
;;;;	    dforms from affecting precedence.
;;;;	
;;;;	<attribute>	: !dform_precedence_sensitivity()
;;;;			| !dform_precedence_exception{}()
;;;;
;;;;	  * This flags the display form as being non-irritating as though it
;;;;	    occurred in the bottom level, even though it may occur in the
;;;;	    precedence tree.  This allows one to define a non-irritating display
;;;;	    form which may itself be irritated.
;;;;	  * exception is inverse of !dform_precedence_sensitivity{}().
;;;;	  * if neither is specified precedence exception is default.
;;;;
;;;;	Attributes may be specified locally in a child format. Parenthesization 
;;;;	parameters for each child is included in the child parentheses attribute.
;;;;
;;;;	The parentheses attribute may contain an injection pointer. This pointer
;;;;	specifies an alternate precedence tree address be used for the parent
;;;;	when comparing precedences. If the alternate address points to a dform
;;;;	which indicates passthru, the passthru is ignored.  Specifying an
;;;;	alternate in a child slot allows different children in the same dtree to
;;;;	behave differently wrt parenthesization.
;;;;
;;;;	The parentheses attribute also specifies a parens relation for each
;;;;	child in a term position. As parameter data is not parenthesized,
;;;;	parentheses attributes should not be specified for a child used to
;;;;	display a parameter position.
;;;;
;;;;	<relation>	: LESS | EQUAL | ALL
;;;;
;;;;	  * LESS : The child will be parenthesized unless
;;;;		   the child has less precedence than the display form.
;;;;	  * EQUAL : The child will be parenethesized unless the child has less
;;;	            or equal precedence than the display form.
;;;;	  * ALL : The child will not be parenthesized.
;;;;
;;;;	Note that if a child is not related to a containing display form instance,
;;;;	then the child will be enclosed in parentheses unless the paren relation
;;;;	for the child is all.
;;;;	
;;;;	<child-attr>	: !dform_child_parentheses{<relation>:t}(<attr-injection>;
;;;;								 <v>.<formats>)
;;;;	
;;;;	<attr-injection>	: <injection>
;;;;				| !void{}
;;;;
;;;;	  * <formats> is a list of dform formats. When parenthesized, the 
;;;;	    formats are displayed with the child substituted into the format
;;;;	    list for the variable v.  If v does not occur in format list then a
;;;;	    warning will be issued and all formats will precede the child.  If
;;;;	    not parenthesized the child is used directly.
;;;;	      - child formats except for constants are not allowed in the
;;;;		parentheses format list.
;;;;	      - variables are not otherwised allowed in format lists.
;;;;	      - relation will be real valued and will be on of the listed values.
;;;;	      - <v> will be a real value.
;;;;	
;;;;	
;;;;  -page-
;;;;
;;;;	Parenthesize? : the following algorithm is used to decide if a child
;;;;			needs to be parenthesized.
;;;;
;;;;	The following snippets of data structures are used:
;;;;
;;;;	<dtree>		: dtree[...
;;;;				<term>
;;;;				<dtree{parent}>
;;;;				<dform>
;;;;				...
;;;;				]
;;;;	  ** Null parent indicates root.
;;;;	
;;;;	<dform>		: dform[...
;;;;				<prec_addr>
;;;;		 		<bool{passthru}>
;;;;				<bool{exception}
;;;;				]
;;;;
;;;;	<parens>	: parens[
;;;;				<token{relation}>
;;;;				<prec_addr{injection}> | VOID
;;;;				]
;;;;	  ** parens is derived from the !dform_child_parentheses attribute.
;;;;	  ** prec_addr will be nil if injection was !void{}.
;;;;
;;;;  -page-
;;;;
;;;;	The following utility procedures are used by the parenthesize-p
;;;;	procedure.
;;;;
;;;;	** attribute is relation of parens attribute of child format.
;;;;	** attribute is one of ALL, LESS, or EQUAL.
;;;;	** relation is relation of child prec-addr to parent prec-addr
;;;;	** relation is one of GREATER, LESS, UNRELATED, or EQUAL.
;;;;
;;;;	test_precedence_relation relation attribute
;;;;	  IF	 attribute = ALL 	THEN false
;;;;	  ELSEIF relation  = GREATER	THEN false
;;;;	  ELSEIF relation  = LESS	THEN true
;;;;	  ELSEIF relation  = UNRELATED 	THEN true
;;;;	  ELSEIF attribute = LESS	THEN true
;;;;	  ELSE false
;;;;
;;;;
;;;;	passthru(dtree)
;;;;	 IF (null dtree) THEN nil
;;;;	 ELSE IF passthru-of-dform (dform-of-dtree dtree)
;;;;		 THEN passthru (parent-of-dtree dtree)
;;;;		 ELSE (dform-of-dtree dtree)
;;;;
;;;;  -page-
;;;;
;;;;	** if parenthesize-p returns true then dtree should be wrapped in parentheses.
;;;;
;;;;	parenthesize-p (dtree parens)
;;;;
;;;;	  ** parens is parens attribute of child format corresponding to child
;;;;	  ** being displayed by dtree.
;;;;	
;;;;	   LET dform = dform-of-dtree dtree IN
;;;;	     IF exception-of-dform dform
;;;;		THEN false
;;;;	 	ELSE LET addr = IF null (prec-addr-of-parens parens)
;;;;				   THEN LET parent-dform = passthru (parent-of-dtree dtree)
;;;;					  IN IF parent-dform
;;;;					        THEN prec-addr-of-dform parent-dform
;;;;					        ELSE Nil
;;;;				   ELSE (prec-addr-of-parens parens)
;;;;		       IN IF null addr
;;;;			     THEN false
;;;;			     ELSE test_precedence_relation
;;;;					(Precedence (prec-addr-of-dform dform)
;;;;						    addr)
;;;;					(relation-of-parens parens)
;;;;	
;;;;	** Note that the Precedence procedure is defined above in the section describing
;;;;	** the Precedence tree.
;;;;	
;;;;  -page-
;;;;
;;;;	Iteration attributes :
;;;;
;;;;	The !dform_family{s}() operator specifies a string to name a family.  If
;;;;	!dform_family occurs directly as an attribute, then it sets the iterate
;;;;	cursor when used. !dform_family terms in a !dform_families attribute
;;;;	specify that the dform is a member of the family and as such satisfy the
;;;;	iterate cursor test. The prescence of a !dform_families attribute causes
;;;;	the iterate cursor test to be generated for the dform.
;;;;	
;;;;	<attribute>	: !dform_family{s}()
;;;;	  * head of family.
;;;;	
;;;;	<attribute>	: !dform_families{}(<families>)
;;;;
;;;;	<families>	: !dform_family{s}()
;;;;			| !dform_family_cons()
;;;;			| !dform_family_cons(<families>; <families>)
;;;;
;;;;	
;;;;  -page-
;;;;	
;;;;	Formats :
;;;;
;;;;	Layout and presentation is affected by labels attached to state, dtree,
;;;;	or dform.  The !dform_label_wrap operator will attach the specified label
;;;;	to a list of formats. Eg, one may want a constant term in a format list to
;;;;	be displayed with a smaller font than the subterms. The !dform_constant_child
;;;;	format could be wrapped with !dform_label_wrap{reduce:t}(<constant>) to
;;;;	attach the reduce label to the constant format where layout may interpret its
;;;;	prescence and use a smaller font.
;;;;
;;;;	There is no preordained set of labels.  A user interface coder may
;;;;	configure the edit and presentation components to interpret labels by
;;;;	modifying the character label mapping and the character glyph mappings.
;;;;	These mappings are described in more detail in the presentation
;;;;	documentation.
;;;;	
;;;;	<format>	| !dform_label_wrap{t}(<formats>)
;;;;	
;;;;	The token parameter specifies a label which will be present in any text
;;;;	or child format in the formats subterm. The token will be a real value.
;;;;	
;;;;	
;;;;	Text:
;;;;
;;;;	<format>	: !text{s|t}
;;;;
;;;;	The string or token will be a real value.
;;;;	
;;;;	Indentation :
;;;;
;;;;	A push form pushes margin some number of characters characters past
;;;;	current position. As characters may have variable width the actual
;;;;	indent amount can not be determined until the characters are identified.
;;;;	If a line break occurs before the required number of characters have
;;;;	been seen then the missing characters will be treated as zero width
;;;;	characters.
;;;;
;;;;	For details on the interpretation of push and pop formats, see
;;;;	the layout description in tbe editor documentation.
;;;;	
;;;;	<format>	: !dform_push{n}
;;;;			| !dform_pop{}
;;;;
;;;;	The amount will be a real value.
;;;;
;;;;  -page-
;;;;
;;;;	Elision : elision can be forced relative to a depth within the display
;;;;	  tree. 
;;;;	
;;;;	During layout a depth register will be maintained. The depth format may
;;;;	modify the depth register by adding or subtracting to it, by setting it
;;;;	to the min or max of its current value and a constant, by setting it to
;;;;	be a constant, or by indicating that depth elision should not occur.
;;;;	
;;;;
;;;; 	<format>	: !dform_depth{NODEPTH:t}
;;;; 			| !dform_depth{<type>:t,n}
;;;;
;;;;	<type>		: NEW | MIN | MAX | + | -
;;;;
;;;;	The type and the number will be real values. The type will be one of the listed values.
;;;;
;;;;  -page-
;;;;	
;;;;	Whitespace :
;;;;
;;;;	<format>	: !space{}
;;;;	  * if the previous character is not a space or a line-break then causes
;;;;	    a space to be displayed.
;;;;	
;;;;		
;;;;	Breaking is controlled by specifying a break control context.
;;;;	See ~eaton/Mail/nuprl5/doc/7 for some discussion.
;;;;
;;;;	<format>	: !dform_break_control{<break-zone>:t}
;;;;	  
;;;;	<break-zone>	: LINEAR | BREAK | SOFT | MULTILINEAR
;;;;			| the null token
;;;;	
;;;;	The break zone will be a real value and will be one of the values listed.
;;;;	Null token means pop.
;;;;
;;;;	<format>	: !dform_break{s}
;;;;			| !dform_break{s,s}
;;;;			| !dform_break{s,s,s}
;;;;	  * First string used when not broken
;;;;	  * Second (when available) used preceding break.
;;;;	  * Third (when available) used following break.
;;;;	
;;;;	Any break string present will be a real value.
;;;;	
;;;;	
;;;;  -page-
;;;;	
;;;;	Child Formats : A child format is used to display a subterm or parameter of
;;;;	  a term.  There are three flavors:
;;;;	    - variable : displays subterm or parameter matched to id in model.
;;;;	    - constant : displays term encoded directly in dform format.
;;;;	    - library : displays term from library at object address derived
;;;;			from subterm or parameter matched to pointer id in model.
;;;;
;;;;	<format>	: !dform_variable_child{<id>:s, <descriptor>:s}
;;;;					       (<child-attrs>)
;;;;			| !dform_constant_child(<term> <child-attrs>)
;;;;			| !dform_library_child{<pointer>:s}(<child-attrs>)
;;;;
;;;;	  * it might be desirable to have constant parameters as well as constant
;;;;	    terms. It seems sufficient to just use exploded parameters or some
;;;;	    other parameter carrier.
;;;;	
;;;;	  * the pointer is the name of a model variable which whose associated structure
;;;;	    will be coerced to an object_address at dtree instantiation.
;;;;	    The pointer may refer to either a parameter or a term.
;;;;	      - the !dform_library_child format will not occur in format list of
;;;;		!dform_child_parentheses term.
;;;;	      - the pointer will be a real value.
;;;;
;;;;	  * !dform_variable_child restrictions : (guaranteed by LIB)
;;;;	      - will not occur in format list of !dform_child_parentheses term.
;;;;	      - id will be a real value, ie not as meta or slot value.
;;;;	      - id will not be empty string.
;;;;	      - id will not be "FLOATDOWN"
;;;;	      - descriptor will be a real value.
;;;;	
;;;;	Child Attributes: 
;;;;
;;;;	<child-attrs>	: <child-attr>
;;;;			| !dform_child_attr_cons(<child-attrs>; <child-attrs>)
;;;;			| !dform_child_attr_cons()
;;;;
;;;;	<child-attr>	: <conditions>
;;;;	   * a dtree representing the child inherits the specified conditions.
;;;;
;;;;	The child parentheses attribute was discussed previously.
;;;;
;;;;	Other attributes may be added incrementally
;;;;	
;;;;	 ** v4.2 migration notes:
;;;;	  - !dform_child_noelide_p filtered out :
;;;;	      * Fail rather than have child elided.
;;;;	      * not used in v4.2.
;;;;	  - !dform_child_mode{t} filtered out : potentially useful, uncertain if good to filter.
;;;;	      * not used on v4.2.
;;;;	  - !dform_child split into !dform_variable_child and !idform_library_child
;;;;	  - !dform_break_control{s} -> !dform_break_control{t}
;;;;
;;;;  -page-
;;;;
;;;;	Model: model specifies target to match to produce instances to 
;;;;	  instantiate children. If match fails then dform is not used. Match
;;;;	  will only be attempted if model and instance have same term-sig. Meta
;;;;	  variables for the match are !template{<v>:v} terms for term positions
;;;;	  and display meta variables for parameter positions. Some template
;;;;	  variable have special significance wrt float or iteration facilities.
;;;;
;;;;  -page-
;;;;
;;;;	Iteration: implementation differs slightly from some doc.
;;;;
;;;;	Iteration is possible when the model of the dform matches the iterated
;;;;	subterm.  A display meta variable in a term position with id ITERATE or
;;;;	#, identifies the iterated subterm.
;;;;
;;;;	Iterate-match-p (model subterm) 
;;;;	  - same opids
;;;;	  - same number and type of parameters.
;;;;	  - ForEach parameter :
;;;;		the model parameter is display meta
;;;;		Or the parameter values are equal.
;;;;	  - same arities
;;;;
;;;;	Iterate-match-p is checked when lazily instantiating iterated child.
;;;;	
;;;;  -page-
;;;;	
;;;;	Iterate-cursor:
;;;;	
;;;;	Error if family attribute but not iterated dform.
;;;;	
;;;;	Passing through a dform with a family attribute sets cursor.  To choose
;;;;	a dform with families the cursor must be a member of the families.
;;;;
;;;;	Why not fail if cursor is set but families is not?
;;;;	  - Because if there were not a suitable dform in the family then no
;;;;	    dform could be chosen.
;;;;	
;;;;  -page-
;;;;	
;;;;	Floatdown :
;;;;	  - lib detects FLOATDOWN as id of variable child format as error.
;;;;	  - the index, i, of floatdown subterm in model is cached at dform
;;;;	    import. At dtree instantiation, the i'th subterm of the iterated
;;;;	    term must be alpha-equal to the term matched to the floatdown
;;;;	    variable.
;;;;
;;;;  -page-
;;;;	
;;;;	Floatup : floatup is controlled by the interaction of the following
;;;;		  parameters:
;;;;	 - floatup model variable, a display meta variable for a term in the
;;;;	   model with id FLOATUP.
;;;;	 - floatup child format : a child format with id FLOATUP.
;;;;	 - iterated dform : model contains an iterated subterm.
;;;;	 - floatup dfparm : term being floated.
;;;;	 - floatup model variable match instance : term matched to variable.
;;;;	
;;;;	A Floatup variable and floatup format in a dform source with no iterated
;;;;	subterm will cause an error and no dform will be produced.
;;;;
;;;;	Using a floatup format with no floatup variable results in the usual
;;;;	undeclared format id error.
;;;;
;;;;	Failure in the following means dform is not chosen.
;;;;	
;;;;	variable, format and iterated :
;;;;	  - sets dfparm to instance.
;;;;	variable, format and not iterated : 
;;;;	  - as mentioned above, rejected by dform checker.
;;;;	variable, no format, null dfparm :
;;;;	  - fails
;;;;	variable, no format, dfparm:
;;;;	  - fails if dfparm not alpha-equal to instance.
;;;;	  - if not iterated then nullifies dfparm.
;;;;
;;;;  -page-
;;;;	
;;;;	Implementation hints:
;;;;
;;;;	At term-to-dform:
;;;;	  - variable, format and iterated : cache index of dtree child of
;;;;	    to be used to set dfparm (ie child assoc'ed with floatup
;;;;	    variable).
;;;;
;;;;	  - variable, no format :
;;;;	     * flag dform as floatup-continued.
;;;;	     * cache index of subterm which is floatup display meta variable.
;;;;
;;;;	At dtree instantiation :
;;;;	  - if cached index, set dfparm.
;;;;	  - if floatup-continued then compare dfparm to instance.
;;;;	  
;;;;  -page-
;;;;   
;;;;	In summary normal use of floatup : 
;;;;
;;;;	Begin	: Dform chosen which has floatup child format, floatup model
;;;;		  variable, and is iterated. Term matched to floatup model
;;;;		  variable becomes float term.
;;;;	Middle	: Dform chosen which has floatup model variable, no floatup
;;;;		  child format, is iterated, and float term is alpha-equivalent
;;;;		  to instance matched to floatup model variable.
;;;;	End	: Dform chosen which is not iterated.
;;;;
;;;;  -page-
;;;;	
;;;;	Iparms:
;;;;
;;;;	Implicit binding : a real variable binding of a subterm of the dform model.
;;;;	 Dfparms contain a list of implicit bindings, this list can be initialized
;;;;	 from the object being displayed.
;;;;
;;;;	Iparm : a real variable subterm of the model term.
;;;;
;;;;	A dform choice will fail if an Iparm is not bound by an implicit binding.
;;;;
;;;;	Should we reject dforms which bind real variable subterms?  The library
;;;;	dform syntax checker will report error when a real variable subterm of
;;;;	the model is bound with a display meta binding.  Real variable bindings
;;;;	which fail to actually bind (ie, ids not the same) the subterm are
;;;;	ignored.  If a real variable binding binds the subterm then it will not
;;;;	be considered an iparm.  Ie, foo(x.x) will generate no iparm test and
;;;;	not affect the implicit binding list, but dform checker will not object;
;;;;	foo(<x>.x) will be rejected as a dform; foo(y.x) will cause iparm check.
;;;;
;;;;	From sfa note: mail nuprl5/doc Subject: iparms. ~sfa/prl/edit/timt/display
;;;;
;;;;	  - for IParms,
;;;;	     * add to Implicit Bindings all variables binding this slot that
;;;;	       are explicit in the model for D (rather than filling slots for binding vars),
;;;;	     * remove from Implicit Bindings all vars binding this slot that are filling
;;;;	       binding slots in the model for D (rather than occurring explicitly);
;;;;
;;;;	What if both happens, ie in model d,<d>.<t> in instance d,d.t
;;;;	 Then d should be added as it is explicit in the model, but it
;;;;	 should also be removed as it is it is bound to <d>.
;;;;	Answer, depends on order in this case add d then remove it so effectively removed.
;;;;	 but if model <d>,d.<t> in instance d,d.t then remove and add so effectively added.
;;;;	
;;;;  -page-
;;;;	
;;;;	Dummy Test: 
;;;;
;;;;	A dummy display meta varible in a binding position, will only match
;;;;	instances where the matched variable does not occur free in the bound term.
;;;;
;;;;	The dummy display meta variable is the display meta variable null identifier,
;;;;	ie <>.
;;;;
;;;; -doct- (mod edd dform data)
;;;;
;;;;	Summary Term syntax: A correct disp object must contain a term which 
;;;;	  conforms to the following syntax when expanded. The library checks this
;;;;	  syntax and will produce a translation error at translate or activate time
;;;;	  if the object is non-conforming.
;;;;
;;;;	<dform-sexpr>	: !dform_cons(<dform-sexpr>; <dform-sexpr>)
;;;;			| !dform_cons()
;;;;			| <dform>
;;;;	
;;;;	<dform>		: !dform(<attributes>; <formats>; <model>)
;;;;	
;;;;	<attributes>	: !dform_attr_cons(<attributes>; <attributes>)
;;;;			| !dform_attr_cons()
;;;;			| <attribute>
;;;;
;;;;	<formats>	: !dform_attr_cons(<formats>; <formats>)
;;;;			| !dform_attr_cons()
;;;;			| <format>
;;;;
;;;;  -page-
;;;;
;;;;	<attribute>	: !dform_cond_expr(<text>)
;;;;			| !dform_hidden_cond_expr(<text>)
;;;;			| !dform_precedence_passthru{}
;;;;			| !dform_precedence_sensitivity{}
;;;;			| !dform_precedence_exception{}
;;;;			| !dform_precedence_injection{}(<injection>)
;;;;			| !dform_family{s}()
;;;;			| !dform_families{}(0)
;;;;			| !dform_name{s}
;;;;			| !dform_macro_name{s} 
;;;;			| <conditions>
;;;;			| <term>
;;;;
;;;;	<conditions>	: !condition_cons(<conditions>; <conditions>)
;;;;			| !condition_cons()
;;;;			| <condition>
;;;;
;;;;	<condition>	: !condition{s}
;;;;			| !text{s|t}
;;;;
;;;;	<injection>	: <inj-address>
;;;;	
;;;;	<prec_label>	: !precedence_label{t}()
;;;;	
;;;;	<dform-addr>	: !dform_address{s}(<oa>)
;;;;			| !dform_address{s}
;;;;
;;;;	<text>		: !text{<s|t}
;;;;			: !text_cons()
;;;;			: !text_cons(<text>; <text>)
;;;;	
;;;;  -page-
;;;;
;;;;	<format>	: !dform_variable_child{<id>:s, <descriptor>:s}
;;;;					       (<child-attrs>)
;;;;			| !dform_constant_child(<term> <child-attrs>)
;;;;			| !dform_library_child{<pointer>:s}(<child-attrs>)
;;;;			| !dform_break_control{<break-zone>:t}
;;;;			| !space{}
;;;;			| !dform_break{s}
;;;;			| !dform_break{s,s}
;;;;			| !dform_break{s,s,s}
;;;;			| !dform_depth{NODEPTH:t}
;;;;			| !dform_depth{<depth-type>:t,n}
;;;;			| !text{s|t}
;;;;			| !dform_label_wrap{t}(<formats>)
;;;;			| <term>
;;;;
;;;;	<depth-type>	: NEW | MIN | MAX | + | -
;;;;
;;;;	  
;;;;	<break-zone>	: LINEAR | BREAK | SOFT | MULTILINEAR
;;;;			| the null token
;;;;
;;;;
;;;;	<child-attrs>	: <child-attr>
;;;;			| !dform_child_attr_cons(<child-attrs>; <child-attrs>)
;;;;			| !dform_child_attr_cons()
;;;;
;;;;	<child-attr>	: !dform_child_parentheses{<relation>:t}(<injection>;
;;;;								 <v>.<formats>)
;;;;			| <conditions>
;;;;
;;;;	<relation>	: LESS | EQUAL | ALL
;;;;
;;;;  -page-
;;;;	
;;;;	<model>		: <id>{<parameters>}(<bound-terms>)
;;;;			| <id>{}(<bound-terms>)
;;;;			| <id>{<parameters>}()
;;;;			| <id>{}(<bound-terms>)
;;;;	
;;;;	<parameters>	: <parameter>
;;;;			| <parameter>, <parameters>
;;;;	
;;;;	<bound-terms>	: <bound-term>
;;;;			| <bound-term>; <bound-terms>
;;;;	
;;;;	<bound-term>	: <bindings>.<subterm>
;;;;			| <subterm>
;;;;
;;;;	<subterm>	: !template{<meta-id>:s}()
;;;;			| variable{<display-meta-variable>:v}()
;;;;			| <constant-term>
;;;;
;;;;	<bindings>	: <value>, <bindings>
;;;;
;;;;	<parameter>	: <value>:<type-id>
;;;;
;;;;	<value>		: <display-meta-variable>
;;;;			| <constant-value>
;;;;	
;;;;	<constant-value>	: <slot>
;;;;				| <abstraction-meta-variable>
;;;;				| <string>
;;;;
;;;;
;;;;	Notes :
;;;;
;;;;	Conditions, cond_expr and hidden cond_expr can occur multiple times.
;;;;	All others should only occur once. If there is more than one occurence,
;;;;	then an error will be generated, and/or one will be chosen arbitrarily.
;;;;
;;;;	In addition to having to conform to the preceding syntax, the following errors
;;;;	are also detected. The library will check the syntax and error conditions at
;;;;	translation time.
;;;;
;;;;	In a !template{<meta-id>:s} subterm, the meta-id must be a real string, ie
;;;;	it cannot be a meta value, or a slot.
;;;;	
;;;;	If subterm is variable{<a>:v}() then <a> must not occur in the binding list
;;;;	which binds the subterm, ie foo(<a>.variable{<a>:v} is an error.
;;;;	  - (dform model subterm variable template bound)
;;;;
;;;;	If subterm is variable{<a>:v} then <a> must occur in some binding list which
;;;;	does not bind the subterm, ie foo(variable{<a>:v}) is an error, but
;;;;	foo(<a>.!template{b:s}; variable{<a>:v}) is ok.
;;;;	  - (dform model subterm variable template)
;;;;	
;;;;	It is an error for a display-meta variable to occur in a parameter or
;;;;	binding of a <constant-term> subterm.
;;;;	  - (dform model subterm meta)
;;;;	
;;;;	If the subterm is a constant term and the term is a first order
;;;;	variable, then it is an error for the binding list which binds the
;;;;	subterm to contain a display meta variable.
;;;;	  - (dform model subterm constant variable bound meta)
;;;;	
;;;;	If the subterm is a constant term and the term is not a first order variable, 
;;;;	then it is an error for the term to contain free variables.
;;;;	Eg, foo(x.(any(x))) is an error as x is free in any(x), however foo(x.x) is ok.
;;;;	  - (dform model subterm constant free)
;;;;	
;;;;	It is an error for the same id to occur in more than one
;;;;	!template{<id>:s} or variable{<id>:v} subterm.
;;;;	 - (dform model subterm multiple)
;;;;	
;;;;	It is an error for the same id to occur in both a !template:<id>:s}
;;;;	subterm and a <display-meta-variable> value.
;;;;	  - (dform model overloaded)
;;;;	
;;;;	It is an error for a !template{FLOATDOWN:s} subterm to occur if there is not
;;;;	also an !template{ITERATE:s} or !template{#:s} subterm.
;;;;	  - (dform model floatdown no-iterate)
;;;;
;;;;	It is an error for there to be more than one !template{ITERATE:s} or !template{#:s} subterm, either
;;;;	individually or together.
;;;;	  - (dform model iterate multiple)
;;;;	
;;;;  -page-
;;;;	
;;;;	Although the library detects many syntactic errors it does not catch
;;;;	them all. The syntax checker in the library might be said to be a
;;;;	peephole checker, ie it does not catch errors in which distant data must
;;;;	be examined. Notably errors in interaction between child formats and the
;;;;	model term are not detected by the library.
;;;;	
;;;;	Errors the editor is expected to detect :
;;;;	
;;;;	The parameter display-meta-variable values and the !template{<id>:s}
;;;;	values can be considered to define a model variable namespace.  For each
;;;;	<id> of !dform_variable_child formats there must exist a model variable
;;;;	with the same name.
;;;;	  - (format variable model not)
;;;;	 
;;;;	The pointer of a !dform_library_child must correspond to a model variable.
;;;;	
;;;;	If some model variable is FLOATUP and there is a !dform_variable_child format
;;;;	with FLOATUP id, then it is an error if there is not also an ITERATE or # model
;;;;	variable.
;;;;	
;;;;  -page-
;;;;	
;;;;	Dform suitability : The following tests must all succeed for dform to used:
;;;;
;;;;	The order of the test is based on how costly the test is estimated to be,
;;;;	and on dependencies of later tests on earlier tests. EG, IParm test is
;;;;	cheap and independent so it is first and Floatdown is
;;;;	from least to most expensive, and on the dependency of some tests on some
;;;;	previous.
;;;;
;;;;	  - Suppression : An editor may allow for some dforms to be disallowed under
;;;;	    certain circumstances by the user.
;;;;	  - Iparm : all iparms of the model term must be bound by the implicit bindings.
;;;;	  - Model Match : the instance must match the model. 
;;;;	  - Floatup : perform floatup tests as outlined above.
;;;;	  - Dummies : perform dummy tests as outlined above.
;;;;	  - Hidden Cond-Expr : evaluate hidden condition expression.
;;;;	  - Iterate : perform iterate test as outlined above.
;;;;	  - Floatdown : perform floatdown test  as outlined above.
;;;;	  - Cond-Expr : evaluate condition expression.
;;;;	
;;;;  -page-
;;;;	
;;;;	Dform-model-match : test to see if model of dform matches a term instance.
;;;;	
;;;;	model term matches an instance term when :
;;;;	  - model and instance have identical term sigs
;;;;	  - all parameters match
;;;;	  - all bound-terms match
;;;;
;;;;	A bound-term matches when :
;;;;	  - all bindings match
;;;;	  - the subterms match.
;;;;	
;;;;	A subterm matches when :
;;;;	  - if model subterm is !template{s} then matches.
;;;;      - if model subterm is variable{<meta>:v} then matches if instance is variable{v} and
;;;;	    parameter values match.
;;;;	  - if model subterm is constant then model must be alpha equal to instance.
;;;;	  
;;;;	A model parameter matches an instance parameter when
;;;;	IF model is not display meta variable
;;;;	   THEN parameters must be equal. 
;;;;	   ELSE parameter value must match.
;;;;
;;;;	A parameter value matches if all parameter values bound to meta variable
;;;;	are equal.
;;;;	
;;;;	A parameter equals another parameter if:
;;;;	  - parameter types are the same
;;;;	  - parameter values are equal.
;;;;	
;;;;	A parameter value equals another parameter value if:
;;;;	  - both are slot with same meta attributes.
;;;;      - both are meta variables of the same type and the ids are the same.
;;;;	  - both are real values and their string representations are equal.
;;;;	
;;;; -doce-


;;;;	
;;;;	RLE TODO : current match implementation may not be correct.
;;;;	RLE TODO : doubt that it handles meta slots.
;;;;	RLE TODO : !template models seem funky too.

;;;;	RLE TODO : Should default parens be created for children not specifying them. ???
;;;;	

;;;;	
;;;;
;;;;	Should we reject dforms which bind constant subterms? If subterm closed,
;;;;	which is guaraunteed by dform checker,	no matter if there are bindings. 


;;;
;;; group stamp set as side-effect of clash-f.
;;;


;;; RLE TODO may be worthwhile to examine the distribution of data wrt
;;; RLE TODO some uses to be sure related data is near.


;; dforms-list has dforms in last to first order.
;; access function defined for reverse to allow for cache of revese list.
(defun permuted-list-of-dforms (dforms) (reverse (dforms-list dforms)))


;; need a method of marking slots modifiable or not wrt the editor.


    
;;;;	Dform Staleness: choice of dform may be cached. Modification to dform pool
;;;;	  requires refreshing dform choice.
;;;;	   
;;;;	  - Term : caches asynch dform pool. destructive mods to pool avoid pool lookup.
;;;;	  - Dtree : caches dform pool. When pool stale, refreshes choice and constructivley    
;;;;	      modifies pool cache to appear updated. (Ie does not lookup but copies stamp).
;;;;	
;;;;	 Term may be shared among environments or multiple generations of same environment.
;;;;	 Thus do need to check if pool is relevant. So term cache so include stamp of dform
;;;;	 table.
;;;;
;;;;	  FTTB assumes no sharing, not relevant here anyway.
;;;;	  - dform can be shared by multiple dform tables. Unusual but possible.
;;;;	      * but there are fields modified within environment so sharing should be avoided.
;;;;	          - copy at insertion.
;;;;		  - rely on bcast to give up a copy (ie def -> term -> def)
;;;;		    fttb assume true, but if lib and edd in same process then may be trouble.
;;;;		    Of course, to be trouble a lot of optimizations would have to work.
;;;;		    Sympton would be suppression in one evironment affecting another.
;;;;	  - dform may be shared by multiple objects in same table. Unusual, maybe not even possible.
;;;;	  FTTB assumes no sharing.
;;;;

;;;; Old
;;;;	  - not-in-table : removed from table.
;;;;	      * sets not-in-table bit in dform flags.
;;;;	        note that not-in-table does not mean there is no copy in table not not in the eq sense.
;;;;	  - stale : dforms inserted in group before dforms of dform.
;;;;	      * only relevant if reference made to dform prior to time of insertion.
;;;;
;;;;	If deactivate/activate without modification then may insert eq definition.
;;;;
;;;;	When dforms are inserted in dforms table
;;;;	  Foreach dforms in group 
;;;;	   Replace dform with copy.
;;;;	   Set stale field of orginal.
;;;;	   
;;;;	The original and the copy will share the flags field.
;;;;
;;;;	When a dforms are deleted from dforms table
;;;;	  Set not-in-table flag of dform flags.
;;;;	  Set stale field of dform.
;;;;
;;;;	Then
;;;;	  - not-in-table valid for all copies of a dform.
;;;;	  - Can detect copies of a dform by eqness of flags field.
;;;;	  - References made to dforms after an insertion can not appear stale.
;;;;
;;;;	** This presumes that flags are handled such that bit twiddling is done
;;;;	** destructively.
;;;;
;;;;	Dform equivalence: three possible flavors
;;;;
;;;;	Eq
;;;;	Copy
;;;;	Models are equivalent up to renaming of display meta variables.
;;;;

;;;; Old
;;;;	Abstract dform syntax :
;;;;	
;;;;	<dform-list>	: dform_list[<term-sig>
;;;;				     <dform> list
;;;;				    ]
;;;;
;;;;	<dform>		: dform[<attributes>
;;;;				<formats>
;;;;				<term{model}>
;;;;				]
;;;;
;;;;	<formats>	: formats[<format> array
;;;;				  <format-child> array
;;;;				 ]
;;;;
;;;;	<attributes>	: [<tok{condition}> list
;;;;			   <string{name}>
;;;;			   <string{macro-name}>
;;;;			   <cond_expr>
;;;;			   <cond_expr{hidden}>
;;;;			   <closure> list {predicates}
;;;;			   <string{family}>
;;;;			   <string> list {families}
;;;;			   <bool{floatup-continued}
;;;;			   INTEGER{floatup-index}
;;;;			   <bool{parens-passthru}>
;;;;			   <bool{precedence exception}>
;;;;			   <precedence-injection>
;;;;			   <precedence-tree-address>
;;;;			   ]
;;;;	

;;;;	precedence-tree ()	
;;;;	  * build explicit precedence tree from current precedence table.
;;;;	
;;;;	Could view the injection as a dependency and use the ddag ops to
;;;;	incrementally refresh injection trees. 
;;;; 
;;;;	Not certain if we want injection dependencies recorded in lib. 
;;;;	Would need a protocol to report such dependencies.
;;;;
;;;;	RLE TODO : doc funcs like compare-prec, rehash-prec-labels, rehash-injection-tree
;;;;
;;;;	RLE NAP 'twould be nice to have collections of precedence objects define
;;;;	RLE NAP global prec trees. Different trees could be used for diff purposes
;;;;	RLE NAP or in diff circumstances. Then prec obj could be pointed to once in
;;;;	RLE NAP each collection.
;;;;	
;;;;	RLE ???  If dforms pooled by injection tree and
;;;;	 precedence index allows pool lookup then possible, but sounds easier to include
;;;;	 chain in dform itself. Consider simpler rehash versus more complex local updates. 
;;;;	 Global Rehash on every change
;;;;	 unless there is some easy local rehashing. Provide ability to delay rehashing
;;;;	 when receiving frequent updates (eg start up ). Adding/deleting dforms can
;;;;	 hopefully be handled locally.
;;;;
;;;;	
;;;;	RLE TODO: Need some method of recognizing last commit of a sequence to trigger
;;;;	RLE TODO: delayed ops. Or some method of bunching up commits.
;;;;	RLE TODO: Rehashing global prec tree would be a good thing to delay.
;;;;	RLE TODO: Rehashing injection chains too.
;;;;	

;;;;	  RLE ??? (previous is same as current 4.2) : following sounds better? NO.
;;;;	  - an injection tree which does not culminate in a label in  
;;;;	    the precedence tree defines an equivalence class within
;;;;	    the default unrelated list.
;;;;
;;;;
;;;;	  RLE ??? (previous is same as current 4.2) : following sounds better? No.
;;;;	  - All dforms not included in precedence tree or an injection tree are
;;;;	    comprise a list of unrelated dforms. This list is considered to be
;;;;	    lower than the top-level unrelated list. Ie, there is a
;;;;	    topmost-level ordered list containing the top-level unrelated list
;;;;	    and the default unrelated list.
;;;;
;;;;	  - An injection tree which does not culminate in a label in  
;;;;	    the precedence tree defines an equivalence class within
;;;;	    the top-level unrelated list.
;;;;	


;;;
;;;	Implementation rep of precedence label will be a symbol.
;;;

(defun term-to-precedence-label (term)
  (token-of-iprecedence-label-term term))



;;;;	
;;;;	Dform Table:
;;;;	
;;;;	<group>		: <dforms> list
;;;;
;;;;	<dforms>	: [<term-sig>
;;;;			   <dform> list
;;;;			  ]
;;;;	
;;;;	





;;;;	order of dform defs within term group?
;;;;	  - maintain library list and use position?
;;;;	      * move library to com abstract wrt element then maintain lib
;;;;		list via broadcasts to compute position.
;;;;	  - use order of sequence of import.
;;;;	    For now as easy. Latest imported is first in term group.
;;;;	

;;;;	RLE TODO: should get table updates as whole ordered term groups??
;;;;	 leaves issue of order in lib.
;;;;	

(defun import-dforms (term)
  (let* ((substance (term-to-data term))
	 (dsubstance (provide-data substance 'display-substance))
	 )

  (let ((dforms (map-isexpr-to-list (term-of-substance dsubstance)
				    (idform-cons-op)
				    #'term-to-dform)))

    ;; RLE TODO : we should generate a warning when two dforms defined
    ;; RLE TODO : within same object with same name.

    (when (forall-p #'null dforms)
      (message-emit (warn-message '(dforms none) term)))

    (new-edd-dforms dsubstance dforms))))



;;;; -docs- (mod edd dform)
;;;;
;;;;	DForm Prcedence Address:
;;;;
;;;;	Blank dform addresses coerced to index dform addresses at term-to-dform-address.
;;;;	Named dform addresses are coerced to index dform addresses when possible (ie named dform exists).
;;;;
;;;;	dform address precedence clash : if named and index dform addresses both occur
;;;;	 in precedence tree at distinct addresses.
;;;;	  - a warning is issued when such a clash is detected.
;;;;	    can only be detected if named dform exists.
;;;;	  - classes are kept distinct, if ambiguous the dform will belong to the index
;;;;	    class.
;;;;	      * possible for a named dform to have a class and dform not be a member of it.
;;;;	
;;;;	A warning may be issued when a dform referenced by an address in the precedence
;;;;	tree points to a different precedence class through its injection address.
;;;;
;;;;	dform injection address :
;;;;	  - Null : treat as pointer to self.
;;;;	  - dform address : may or may not occur in precedence tree.
;;;;	      * dform address pointing to self.
;;;;	      * dform address pointing to another actual dform.
;;;;	      * dform address pointing to non-existent dform.
;;;;	  - label : may or may not occur in precedence tree.
;;;;
;;;;	A dform injection address is reflexive if injection address is dform address
;;;;	of the dform or if there is no injection address.
;;;;	
;;;;	precedence tree : ephemeral data structure produced by combining all precedence
;;;;	objects.
;;;;
;;;;	precedences-address table : hash table mapping injection addresses to precedence addresses.
;;;;	
;;;;	The set of dforms can be partitioned into a set of equivalence classes based upon
;;;;	the precedence address to which they refer. Dforms which refer to themselves,
;;;;	whose addresses do not appear in the precedence tree, and which are not referenced
;;;;	by other dforms comprise singleton classes.
;;;;
;;;;	precedence-addresses for singleton classes will not occur in the precedence-address
;;;;	table.
;;;;
;;;;  -page-
;;;;
;;;;	The precedence address table and the precedence address fields of dforms can be
;;;;	maintained lazily.
;;;;
;;;;	events which effect precedence address state :
;;;;	  - precedence object insert/delete :
;;;;	      * rehash precedences table:
;;;;		  - mark precedence addresses in precedence address table stale.
;;;;		  - delete precedence address table.
;;;;	      * precedence address table reference, ie dform precedence address lookup.
;;;;		  - build precedence tree.
;;;;		      * emit warning if precedence clash.
;;;;		      * mark the precedence addresses of any singleton dform referenced by
;;;;			precedence tree stale. Otherwise, such dforms would continue to act
;;;;			as though they were not in precedence tree.
;;;;		  - assign precedence expressions to referenced injection addresses.
;;;;	  - dform insert :
;;;;	    Observations :
;;;;	      * dform can not currently be member of a class.
;;;;	      * both the index dform address and the named dform address
;;;;		may currently be assigned precedence addresses.
;;;;	    When precedence address table active:	 
;;;;	      * mark precedence address stale at either named or index dform injection address.
;;;;	      * emit warning if dform causes precedence clash.
;;;;	  - dform delete 
;;;;	    When precedence address table active:	 
;;;;	      * mark dform's precedence address stale.
;;;;
;;;;  -page-
;;;;
;;;;	Updating stale precedence addresses:
;;;;	
;;;;	When a stale or uninitialized precedence address is requested from a dform
;;;;	the laziness must be resolved. The following algorithm describes how to
;;;;	update state at reference time:
;;;;
;;;;	<dform> 	[...
;;;;			<inj-address>
;;;;			<prec-address>
;;;;			]
;;;;
;;;;	
;;;;	<prec-addr>	: prececence-address[	<bool{stale}>
;;;;						<bool{singleton}>
;;;;						<class key>
;;;;						<prec-expr> | <inj-address> | <dform> 
;;;;						]
;;;;
;;;;	<field>-of-<type>	: access function.
;;;;	<type>-<field>		: set access function.   
;;;;
;;;;
;;;;	precedence address expression: 
;;;;	  - real precedence expression : dform address or label occuring in
;;;;	    precedence tree.
;;;;	  - symbol : precedence label not occuring in precedence tree.
;;;;	  - dform address : dform address not occuring in precedence tree.
;;;;
;;;;	NewPrecendenceAddress (<inj-addr> <pe>)		: <prec-addr>
;;;;	 <pe> : <prec-expr> | <inj-addr> | <dform> 
;;;;	 Singleton is TRUE by default.
;;;;
;;;;	LookupPrecendenceAddress (<inj-addr>)		: <prec-addr> | NULL
;;;;	AddPrecendenceAddress (<inj-addr> <prec-addr>)	: <prec-addr>
;;;;	 * sets singleton to FALSE.
;;;;	 ** Call of either will refreshes stale precedence address table.
;;;;
;;;;	DformAddress_of_DForm (<dform>)			: <dform-addr{index}>
;;;;
;;;;	NamedDformAddress_of_DForm (<dform>)		: <dform-addr{named}>
;;;;
;;;;  -page-
;;;;
;;;;	UpdateDFormPrecedenceAddress (dform) :
;;;;
;;;;	UpdateDFormPrecedenceAddress is called when precedence address of dform
;;;;	is required but current address is uninitialized or stale.
;;;;	UpdateDFormPrecedenceAddress will follow the injection path to the root
;;;;	and update all dforms on the path with the root's precedence address.
;;;;	To dectect cycles as each dform is passed through it is assigned a
;;;;	tentative precedence address which will be found if dform is returned
;;;;	to. In such a case the tentative address becomes the real address. As
;;;;	the recursion returns, tentative address are replaced by real addresses.
;;;;
;;;;	LET inj-addr = injection-address-of-dform dform IN
;;;;	  case kind-of(inj-addr)
;;;;
;;;;	   null :
;;;;	     dform-precedence-address (dform)
;;;;		<- OR LookupPrecedenceAddress (DformAddress_of_DForm dform)
;;;;		      LookupPrecedenceAddress (NamedDformAddress_of_DForm dform)
;;;;		      NewPrecedenceAddress (DformAddress_of_DForm dform)
;;;;					   (DformAddress_of_DForm dform)
;;;;
;;;;	   precedence-label :
;;;;	     dform-precedence-address (dform)
;;;;		<- AddPrecedenceAddress inj-addr (NewPrecedenceAddress inj-addr inj-addr)
;;;;
;;;;	   dform-address :
;;;;	     IF LookupPrecendenceAddress inj-addr
;;;;	        THEN (dform-precedence-address dform) <- LookupPrecendenceAddress inj-addr
;;;;	     ELSEIF Null LookupDform inj-addr
;;;;		THEN dform-precedence-address dform)
;;;;			<- AddPrecedenceAddress inj-addr (NewPrecedenceAddress inj-addr inj-addr)
;;;;	     ELSE
;;;;	      LET inj-dform = LookupDform inj-addr IN
;;;;		IF inj-dform = dform
;;;;		   THEN dform-precedence-address dform
;;;;			 <- NewPrecedenceAddress inj-addr inj-addr
;;;;		ELSE LET prec-addr = precedence-address-of-dform inj-dform
;;;;		      IF prec-addr
;;;;			 THEN IF precedence-address-singleton-p prec-addr
;;;;				 THEN AddPrecedenceAddress inj-addr prec-addr
;;;;			      dform-precedence-address dform <- prec-addr
;;;;			 ELSE /* Assign prec-addr to dform in order to prevent loop if cycle */
;;;;				dform-precedence-address dform
;;;;				  <- NewPrecedenceAddress inj-addr inj-addr
;;;;				UpdateDFormPrecedenceAddress inj-dform
;;;;				LET prec-addr = precedence-address-of-dform inj-dform
;;;;				  IF precedence-address-singleton-p prec-addr
;;;;				     THEN AddPrecedenceAddress inj-addr prec-addr
;;;;			          dform-precedence-address dform <- prec-addr
;;;;		
;;;;
;;;;
;;;; -doce-

;;;;
;;;;	*precedence-classes* : hash table mapping injection addresses to equivalence classes.
;;;;	  - Eager : Not present in lazy version.
;;;;	  - an equivalence class is a list of dforms.
;;;;	  - dforms which point to themselves and are not pointed to by others or the precedence
;;;;	    tree are not included in table.
;;;;	  - prec object change has no effect except to change address and possibly add/remove singleton classes.
;;;;	  - prec label need not occur in prec tree
;;;;	  - blank dform addresses are mapped to index dform addresses.
;;;;	
;;;;	
;;;;	If we choose to export precedence addresses we can do so by exporting
;;;;	*precedences* and *precedence-classes*. *precedences* will be exported
;;;;	as a unit. *precedence-classes* can be exported by add/remove of classes
;;;;	and add/remove of members of classes. In this case members of classes will
;;;;	be id'd by their index dform addresses.
;;;;	
;;;;	Exporting requires eager rehashing.
;;;;	
;;;;	Batch : do lazy for some period and then rehash.
;;;;	  - Send new precedences, and compare old/new precedence classes to
;;;;	    determine exports, below some threshold of size just dump new precedence
;;;;	    classes in entirety.
;;;;	  - Good for startup and large incremental changes but too costly for 
;;;;	    small incremental changes.
;;;;	
;;;;	what if during lazy mode precedences table needs to be rehashed or precedence
;;;;	class patch is updated. Should have no effect as precedences dumped in entirety
;;;;	and batch rehash of precedence classes only depends on current precedences.
;;;;	
;;;;	
;;;;	
;;;;	Mode switch :
;;;;	 lazy -> eager : batch
;;;;	 eager -> lazy : hide precedence-classes.
;;;;
;;;;	events :
;;;;	  - precedence insert/delete :
;;;;	      * rehash precedences table:
;;;;		  - Eager :
;;;;		      * build precedence table and assign addresses.
;;;;			adds singleton classes to precedence classes referenced by 
;;;;			precedence tree.
;;;;		      * map precedence classes and update with new prec-address.
;;;;			removes singleton classes no longer referenced by precedence tree.
;;;;			??? could leave as they do not disturb anything.
;;;;		  - Lazy :
;;;;		      * mark precedence address in precedences table stale.
;;;;		      * build new precedence table when referenced.
;;;;		        updates dforms referenced by precedence tree.
;;;;	  - dform insert :
;;;;	      * Observations :
;;;;		  - dform can not currently be member of a class.
;;;;		  - both the index dform address and the named dform address
;;;;		    may currently head precedence classes.
;;;;		  - adding a dform to a precedence class updates precedence
;;;;		    address of dform.
;;;;	      * Eager :
;;;;		  - Reflexive injection address without precedence clash :
;;;;		      * find and delete named precedence class.
;;;;			EXPORT : delete 
;;;;		      * add dform and named precedence class to index precedence
;;;;			class.
;;;;			EXPORT : partial or total add to index precedence class.
;;;;		  - Reflexive injection address with precedence clash :
;;;;		      * add dform to precedence class of injection address.
;;;;			EXPORT : partial add to injection address precedence
;;;				 class.
;;;;		  - Non-Reflexive injection address without precedence clash :
;;;;		      * find and delete named and index precedence classes.
;;;;			EXPORT : deletes
;;;;		      * add dform and named and index precedence classes to
;;;;			precedence class of injection address, updating
;;;;			precedence addresses of new members.
;;;;			EXPORT : partial or total add to injection address
;;;;				 precedence class.
;;;;		  - Non-Reflexive injection address with precedence clash :
;;;;		      * find and delete index precedence class.
;;;;			EXPORT : delete.
;;;;		      * add dform and index precedence class to precedence class
;;;;			of injection address, updating precedence addresses of
;;;;			new members.
;;;;			EXPORT : partial or total add to injection address
;;;;				 precedence class.
;;;;	      * Lazy :
;;;;		  - mark as stale all members of both the named and index precedence
;;;;		    classes headed by dform and delete precedence classes.
;;;;		  - Emit warning if dform causes precedence clash.
;;;;		    Precedence clash if name dform address and index dform address
;;;;		    present in precedence table.
;;;;	  - dform delete : partition eq-class
;;;;	      * Eager :   
;;;;		  - find precedence class containing dform
;;;;		    IF any member contains injection address of dform being deleted
;;;;		       THEN
;;;;			* delete entire class.
;;;;			  EXPORT : delete
;;;;			* rebuild new classes from remaining members by simulating inserts.
;;;;			  EXPORT : total add of each new class.
;;;;		       ELSE remove dform from class.
;;;;			  EXPORT : delete member.
;;;;	      * Lazy :
;;;;		 - mark as stale all members of precedence class containing dform and
;;;;		   delete precedence class.
;;;;
;;;;	
;;;;	
;;;;
;;;;	prec exports :
;;;;	  - *precedences* : map of injection addresses to precedence addresses.
;;;;	  - *precedence-classes* : map of injection addresses to dform address
;;;;				   lists.
;;;;	      * add class <injection-address> <dform-address> list.
;;;;	      * delete class <injection-address>
;;;;	      * add members <injection-address> <dform-address> list.
;;;;	      * remove members <injection-address> <dform-address> list.
;;;;	      * union classes <injection-address> <injection-address>
;;;;	      * partition class <injection-address>
;;;;				(<injection-address> <dform-address> list) list.
;;;;		Implemented with delete class followed by sequence of add classes.
;;;;	
;;;;	Add following broadcast operators:
;;;;
;;;;	!precedences_addresses{n, DMS-PRECEDENCE-ADDRESSES}
;;;;			      (<stamp>; !cons(<injection-address>; <prec-address>))
;;;;
;;;;	!list_table_add{n, DMS-PRECEDENCE-CLASS:t}
;;;;		       (<stamp>; <injection-address>, <dform-address> list)
;;;;	!list_table_remove{n, DMS-PRECEDENCE-CLASS:t}
;;;;			  (<stamp>; <injection-address>)
;;;;	!list_table_add_members{n, DMS-PRECEDENCE-CLASS:t}
;;;;			       (<stamp>; <injection-address>, <dform-address> list)
;;;;	!list_table_remove_members{n, DMS-PRECEDENCE-CLASS:t}
;;;;				  (<stamp>; <injection-address>, <dform-address> list)
;;;;	!list_table_union{n, DMS-PRECEDENCE-CLASS:t}
;;;;			 (<stamp>; <injection-address>; <injection-address>)
;;;;	
;;;;	
;;;;	Plan :
;;;;	  - do lazy
;;;;	  - add batch
;;;;	  - add queries later if required.
;;;;	  - add eager and exports later if required.
;;;;	
;;;;	
;;;;	

;;;;
;;;;	worst case dform scenarios: 
;;;;
;;;;	add dform which joins a large eq-class to a small one
;;;;	 fix by sending inj-addr to union rather than sending class itself.
;;;;	
;;;;	remove dform which partitions an eq-class into individual members.
;;;;	remove dform which partitions an eq-class into x class of y members.
;;;;	 consider a sequence of deletes which eventually removes all members in class.
;;;;	 but each delete divedes the remaining members in two.
;;;;	
;;;;	step n costs n and reduces n by one but produces two n/2 probems
;;;;	 n + 2*(f(-1)
;;;;	 and n transmissions 1 n transmission 2(n/2) + 4(n/4) ... + logn (n/logn) = n (logn) data transmitted.
;;;;	if n is 1k then n(logn) is 12k and if each address is 100 bytes then 1200k to be transmitted
;;;;	but can be compressed to 200k. so 1k deletes results in 200k tranmission or 200/delete which
;;;;	is reasonable.
;;;;
;;;;	if n is 16k then n(logn) is 16k*16= 256k and if each address is 128 bytes then 32M to be transmitted
;;;;	but can be compressed to 8M. so 16k deletes results in 8M tranmission 8*1024K/16k = 512/delete which
;;;;	is still reasonable.
;;;;
;;;;	VS dform and precedence updates
;;;;	 + less data transmitted
;;;;	 + simpler protocol.
;;;;	 + allows lazy implementation
;;;;	 + less work for DMS.
;;;;	 + much less codeing for DMS.
;;;;	 | DMS does not rely on dform syntax.
;;;;	 + worst case add for non-lazy could be quite expensive.
;;;;	 - more compute work for DMC.
;;;;	 - slightly more coding work for DMC.
;;;;	 - harder for Nuprl to change algorithms or input.
;;;;	 | DMC exposed to more of dform syntax
;;;;	   DMC knows too much. too closely coupled to dform prec objects.

;;;;	Summary :
;;;;	  More complex state we attempt to transmit the more complicated the protocol,
;;;;	  more duplicated data, less opportunity for laziness. Only slightly simpler
;;;;	  Client, however client is insulated from some extensions. Server can be 
;;;;	  arbitrarily complex in how changes are collected and broadcast.
;;;;	
;;;;	  Less complex state -> easier server implementation, harder client implementation.
;;;;				More opportunity for laziness (laziness may ameliorate client complexity).
;;;;	  More complex state -> easier client implementation, harder server implementation.
;;;;				Less opportunity for laziness.
;;;;	  More complex protocol -> more rigid algorithms. 
;;;;	  Simpler protocol -> more duplication, less efficiency as state complexity rises.
;;;;
;;;;	metrics :
;;;;	  - network cost (number and size)
;;;;	  - computation cost : not worth mentioning unless exorbitant.
;;;;	  - memory,
;;;;	  - implementation cost 
;;;;
;;;;	  Win is broadcast simple state with simple protocol.
;;;;
;;;;	require robust protocol :
;;;;
;;;;	RISP - few instructions to simplify programming.
;;;;	 - may blow up number of messages sent as some update do not conform nicely to instruction set.

;;;;	export laziness by exporting notice of change but not change, then client
;;;;	prompts rehash when referenced. 
;;;;	 - adds significant delay to client.
;;;;	
;;;;	

;;;
;;; RLE TODO : support for multiple libraries.
;;; RLE TODO :   ?? Order of groups in clan
;;; RLE TODO :   ?? suppress clash??
;;;

;;; RLE TODO : rehash dform injection trees after delete or insert.
;;;;	
;;;;	If precedence injection is dform address  then reset precedence address
;;;;	to dform at address.
;;;;
;;;;	when the prec address is looked up the prec-address fields can be updated
;;;;	to root of tree, root may be a label, a dform, or a dform address.
;;;;	


;;;;	Injection chains are refreshed in a lazy manner.
;;;;	Recall that the injection pointer is either a dform address
;;;;	or a precedence tree label. A precedence tree label is converted to a
;;;;	precedence tree address or a symbol (if label not in precedence tree). The dform
;;;;	address will either be converted to a dform or a an sexpr (if address does not
;;;;	resolve to a dform).
;;;;	

;;;;	All members of equivalence class point to same(eq) precedence address structure.
;;;;	
;;;;	
;;;;	
;;;;	


;;;;	dform precedence address  : prec-addr, constant, stale, or lazy.
;;;;	  - precedence address : dform address or label occuring in precedence tree.
;;;;	  - label : label not occuring in precedence tree.
;;;;	  - dform address : dform address not occuring in precedence tree and not existent.
;;;;	  - dform : dform address not occuring in precedence tree but existent.



;; returns precedence-address.
(defun compute-dform-precedence-address (inj &optional dform)

  ;; dform addr or nil or label.
  (cond
    ((and (null inj) dform)
     (let* ((da (dform-address-of-dform dform))
	    (index-prec-key (cons (stamp-of-dform-address da) (id-of-dform-address da)))
	    (index-prec-addr (lookup-precedence-label index-prec-key)))

       ;; put in index-prec class if there is one.
       (or index-prec-addr

	   (let* ((name (name-of-dform dform))
		  (name-prec-addr (when name
				    (lookup-precedence-label (cons (stamp-of-dform-address da)
								   name)))))
	     ;; Or put in name class.
	     (or name-prec-addr

		 ;; Or make singleton class with dform as prec addr.
		 (new-precedence-address index-prec-key dform))))))

    ((symbolp inj)
     (or (lookup-precedence-label inj)
	 (precedence-address-table-add inj
				       (new-precedence-address inj inj))))
	       
    ((dform-address-p inj)

     ;; check for use as prec label, use prec-addr found.
     (let ((prec-addr (lookup-precedence-dform-address inj)))

       (or prec-addr

	   ;; find dform.
	   (let ((inj-dform (dform-address-to-dform inj)))
	     (if inj-dform
		 (let ((pa (new-precedence-address (cons (stamp-of-dform-address inj)
							 (id-of-dform-address inj))
						   inj-dform)))
	
		   ;; to prevent cycle loop. Can't get back here if there is a valid addr.
		   (when dform (setf (dform-precedence-address dform) pa))

		   ;; if dform points to self then dform prec addr ok as singleton.
		   (or (unless (eql inj-dform dform)

			 ;; precedence-address-of-dform is indirect recursion.
			 ;; either a prec addr will be found or the preceding cycle detecting addr will be found.
			 ;; either way update dform with prec-addr found (no-op in case of cycle starting here.)
			 (let ((prec-addr (precedence-address-of-dform inj-dform)))
			   ;; put in table if not there.
			   (unless (precedence-address-flag-in-table-p prec-addr)
			     (precedence-address-table-add (key-of-precedence-address prec-addr) prec-addr))
			   prec-addr))

		       pa))

		 ;; if inj not valid dform use inj as prec addr.
		 (let ((prec-addr (new-precedence-address (cons (stamp-of-dform-address inj)
								(id-of-dform-address inj))
							  inj)))
		   (precedence-address-table-add (key-of-precedence-address prec-addr)
						 prec-addr)) )))))
      
    (t (system-error (error-message '(injection-tree update injection unknown))))))



;;;;	RLE TODO
;;	A warning will be issued when a dform referenced by an address in the precedence
;;	tree points to a different precedence class through its injection address.
;;(when nil
;;  (message-emit
;;   (warn-message '(precedence-tree injection-dform-address not-precedence-tree-class)))

(defun update-dform-precedence-address (dform)
  (setf (dform-precedence-address dform)
	(compute-dform-precedence-address (precedence-injection-of-dform dform)
					  dform)))

(defun precedence-address-of-dform (dform)
  (let ((addr (dform-precedence-address dform)))
    (when (or (null addr)
	      (precedence-address-flag-stale-p addr))
      (update-dform-precedence-address dform))
    
    (expression-of-precedence-address (dform-precedence-address dform))))
		      

;; initially addr is either a dform addr or a precedence label or nil
;; dform rehash will promote to real precedence address or it can happen lazily here.
(defun precedence-address-of-dform-parentheses (parens)
  (let ((addr (dform-parentheses-precedence-address parens)))
    (when (or (null addr)
	      (precedence-address-flag-stale-p addr))
      (setf (dform-parentheses-precedence-address parens)
	    (compute-dform-precedence-address (dform-parentheses-injection-address parens))))

    (expression-of-precedence-address
     (dform-parentheses-precedence-address parens))))


;;; apparently done lazily when prec address requested.
;;; updates prec address in each child parens
;;; updates prec-address in dform.

;; RLE TODO ??? : remove stale dforms from suppression lists (global and views).
#|
(defun rehash-dforms ()
  (labels
      (

       (precedence-address (injection)
	 (cond
	   ((null injection)
	    ;;;;	RLE TODO :  if each dform has unique id distinct from labels then use self label
	    ;;;;	RLE TODO :  rather than gensym. At prec tree change dform labels rehashed.
	    ;;;;	RLE TODO :  at dform insert, prec labels looked up.
	    ;;;;	RLE TODO :  Or why not just point at self?
	    (gensym))
	   ((symbolp injection)
	    (lookup-precedence-label injection))
	   ((dform-address-p injection)
	    (let ((inj-dform (dform-address-to-dform injection)))
	      (or inj-dform
		  (generate-name-suppress-label injection (id-of-dform-address injection)))))
	   (t (system-error (error-message '(rehash-dform-precedence-addresses)))))) 

       (update-child-format-parentheses (format)
	 (when (dform-term-child-p format)
	   (let ((parens (parens-of-dform-term-child format)))
	     (when parens
	       (let ((addr (injection-address-of-dform-parentheses parens)))
		 (when addr
		   (setf (dform-parentheses-precedence-address parens)
			 (precedence-address addr))))))))
       )			  

    ;; rehash injection trees.
    (definition-table-map (environment-resource 'dforms)
	(current-transaction-stamp)
      #'(lambda (oid dforms)
	  (declare (ignore oid))
	  (format t "D")
	  ;;(setf -dforms dforms)
	  (dolist (dform (list-of-dforms dforms))
	    (when dform
	      ;;(setf -dform dform) (break "rd")
	      (update-dform-precedence-address dform)
	      ;;(setf (dform-precedence-address dform) (precedence-address (precedence-injection-of-dform dform)))
	      (let ((children (child-formats-of-dform dform)))
		(dotimes (i (length children))
		  (let ((format (aref children i)))
		    (update-child-format-parentheses format))))
	      (let ((children (library-formats-of-dform dform)))
		(dotimes (i (length children))
		  (let ((format (aref children i)))
		    (update-child-format-parentheses format)))))))))

  )
|#			

;;;;	      * Lazy :
;;;;		 - mark as stale precedence addresses associated with  both the named and indexed
;;;;		   injection addresses.

(defun insert-dforms (dforms)

  (let ((oid (oid-of-definition dforms)))

    ;; allow for address suppression.
    (dolist (dform (list-of-dforms dforms))
      (when dform
	(let ((oid (oid-of-definition dforms)))
	  (setf (dform-oid dform) oid
		(dform-suppress-tag dform) (generate-suppress-tag))
	  (let ((name (name-of-dform dform)))
	    (when name
	      (setf (dform-suppress-label dform) (generate-name-suppress-label oid name))
	      (when (globally-suppressed-address-p oid name)
		(dform-flag-set-globally-suppressed-address dform t)))))))

    ;; name prop is not avail, name should be part of definition.
    (add-edit-macros-of-object-aux oid
				   (name-of-dforms dforms)
				   'disp)


    ;; mark subsequent dforms in pool as stale.
    #|
  (let* ((dforms-table (environment-resource 'dforms))
	 (group (cdr (definition-lookup-pool dforms-table (key-of-definition dforms dforms-table))))
	 (stale-p nil))
    (dolist (gdforms group)
      (if stale-p
	  (setf (dforms-list gdforms)
		(mapcar #'(lambda (dform)
			    (when dform
			      (prog1 (copy-dform dform)
				(setf (dform-stale dform) t))))
			(list-of-dforms gdforms)))
	  (when (eq dforms gdforms)
	    (setf stale-p t)))))
    |#

    ;; mark precedence classes stale.
    (unless (lazy-precedence-table-labels-p (environment-resource 'precedences))
      (dotimeslist (i dform (list-of-dforms dforms))
		   (when dform
		     (let* ((name (name-of-dform dform))
			    (oid (oid-of-dform dform))
			    (name-prec-addr (when name
					      (lookup-precedence-label
					       (cons (stamp-of-oid oid) name))))
			    (index-prec-addr (lookup-precedence-label
					      (cons (stamp-of-oid oid) i))))

		       (when name-prec-addr
			 (when index-prec-addr
			   (message-emit
			    (oid-warn-message '(precedence-tree build dform-address duplicate)
					      (oid-of-definition dforms))))
			 (when (precedence-address-p name-prec-addr)
			   (precedence-address-flag-set-stale name-prec-addr t)))
		     
		       (when index-prec-addr
			 (when (precedence-address-p index-prec-addr)
			   (precedence-address-flag-set-stale index-prec-addr t)))))))))


(defun delete-dforms (dforms)

  ;; is name-prop still available?? should be since ostate bcast comes after transaction.
  (delete-edit-macros-of-object-aux (oid-of-definition dforms)
				    (name-of-dforms dforms)
				    'disp)


  ;; mark precedence class stale.
  (unless (lazy-precedence-table-labels-p (environment-resource 'precedences))
    (dolist (dform (list-of-dforms dforms))
      (when dform
	(let ((addr (dform-precedence-address dform)))
	  (unless (or (null addr)
		      (precedence-address-flag-stale-p addr))
	    (precedence-address-flag-set-stale addr t)))
	;;(let ((prec-addr (precedence-address-of-dform dform)))
	;;(when prec-addr
	;;(precedence-address-flag-set-stale prec-addr t)))
	))))




;;;;	
;;;;	Dform table. 
;;;;	
;;;;	

;;;;	precedence tree??
;;;;	  - explicit, dforms have indirect pointers to tree.
;;;;
;;;;	  -  not encoded in dforms as causes difficulity when tree is modified.
;;;;	
;;;;	Modification of precedence tree should cause all dtree dform selections to become
;;;;	stale. Unless of course one can find a subset of affected dforms which
;;;;	become stale.
;;;;	
;;;;	


(defstruct (dform-table (:include definition-table))
  (pools (new-pool-tixt-table #'display-meta-parameter-p
			      #'dform-meta-term-match-p 
			      #'(lambda (a b) (equal-oids-p (oid-of-definition a) (oid-of-definition b)))
			      ;; sort
			      #'(lambda (a b)
				  ;; need to recognize defaults and insure last in list.
				  (let ((adform (find-first #'(lambda (d) d) (list-of-dforms a)))
					(bdform (find-first #'(lambda (d) d) (list-of-dforms b))))


				    ;; t means a comes later??
				    (cond
				      ((and (when (and adform bdform
						       (member 'default (conditions-of-dform adform))
						       (member 'default (conditions-of-dform bdform)))
					      ;;(break "dform-table two defaults")
					      )
					    nil))
				      ((and adform (member 'default (conditions-of-dform adform)))
				       t)
				      ((and bdform (member 'default (conditions-of-dform bdform)))
				       nil)

				      ;;	one simple metric : that which hides the most is first. ie least occurences
				      ;;	of child formats in format list.
				      (t (let ((ladform (car (last (list-of-dforms a))))
					       (lbdform (car (last (list-of-dforms b)))))
					   (cond
					     ((null ladform) t)
					     ((null lbdform) nil)
					     (t (< (length (child-formats-of-dform lbdform))
						   (length (child-formats-of-dform ladform)))))))))))
	 ))


(defun pools-of-dform-table (dtable) (dform-table-pools dtable))


(defun dform-pool-table-backdoor-insert (table def)
  ;;(insert-dforms def) ;; don't do it. left as reminder not to do it.
  (pool-tixt-add (pools-of-dform-table table)
		 (current-transaction-stamp)
		 (model-of-dforms def)
		 def
		 t
		 ))


(defun dform-pool-table-insert (table def s)
  (insert-dforms def)
  (pool-tixt-add table s
		 (model-of-dforms def)
		 def
		 ))

(defun dform-pool-table-delete (table def s)
  (delete-dforms def)
  (pool-tixt-remove table s
		    (model-of-dforms def)
		    def))

(defun dform-table-backdoor-commit (table def)
  (let ((pt (pools-of-dform-table table)))
    (dform-pool-table-backdoor-insert pt def)))


(defun dform-table-commit (table def insertp s i)
  (declare (ignore i))

  (let ((pt (pools-of-dform-table table)))
    ;;(setf -pt pt -table table -def def -insertp insertp) (break "dtc")
    (if insertp
	(dform-pool-table-insert pt def s)
	(dform-pool-table-delete pt def s))))


;; todo : add hook
(defun dform-transaction-end-hook (th)

  (let ((dforms  (resource 'dforms)))
    (when dforms
      (when (exists-p #'(lambda (tr)
			  (equal (tags-of-definition-table dforms)
				 (tags-of-touch-record tr)))
		      th)
	(with-local-transaction
	    (pool-tixt-sort (pools-of-dform-table dforms) (current-transaction-stamp))))
      
      (with-io-echo-stats (t 'dform-rehash)
	(rehash-dforms)))))

(defun new-dform-table (stamp tag)
  (define-definition-table
      stamp
    (list 'dform tag)
    nil
    :import-f #'import-dforms
    :make-f make-dform-table
    :commit-f #'dform-table-commit
    ))

(defun dforms-lookup-pool (dforms term)
  (pool-tixt-lookup (pools-of-dform-table dforms) term))

  
#|
(defun dform-table (stamp
		    tag
		    )
  (define-definition-table
      stamp
      (list 'dform tag)
    t group nil
    :import-f #'import-dforms
    :order-f #'(lambda (a b)
		 (not (list-table-position-< (address-of-definition a)
					     (address-of-definition b)
					     (if (environment-resource-p 'edit-library)
						 (environment-resource 'edit-library)
						 (environment-resource 'library)))))
    :key-match-f nil			; not #'dform-term-match
    :commit-f #'(lambda (cur-def old-def type)
		  ;;(setf a type) (break "dtc")
		  ;; oid changes : commit-f (<def> <bool{insert?})
		  (case type
		    (|!table_insert| (insert-dforms cur-def))
		    (|!table_delete| (delete-dforms old-def)))
		  ;;(rehash-dforms)
		  )
    ))
|#



;;;;	
;;;;	Utilities
;;;;	
;;;;	

;; should return dform address or precedence label.
(defun term-to-precedence-pointer (term &optional (void-ok-p nil))
  (cond
    ((idform-address-term-p term)
     (term-to-dform-address term))

    ((iprecedence-label-term-p term)
     (term-to-precedence-label term))

    ((and (ivoid-term-p term) void-ok-p)
     nil)
    
    (t (raise-error (error-message '(precedence-pointer term))))))


(defun dforms-lookup (oid)
  (without-dependencies
   (definition-lookup-by-oid (environment-resource 'dforms) oid)))
     

(defunml (|dforms_lookup| (oid))
    (object_id -> (dform list))

  (list-of-dforms (dforms-lookup oid)))

(defun dform-address-to-dform (daddr)
  (let ((dforms (dforms-lookup (oid-of-dform-address daddr))))
    (lookup-dform-in-list (list-of-dforms dforms) daddr nil)))


(defun named-dform-map (daddr f)
  (let ((dforms  (dforms-lookup (oid-of-dform-address daddr)))
	(id (id-of-dform-address daddr)))
    (when dforms
      (dolist (dform (list-of-dforms dforms))
	(when (and dform
		   (let ((name (name-of-dform dform)))
		     (and name
			  (eql name id))))
	  (funcall f dform))))))

(defunml (|dform_lookup| (oid i))
    (object_id -> (int -> dform))
  
  (nth-dform (list-of-dforms
	      (definition-lookup-by-oid (environment-resource 'dforms) oid))
	     i))



(defvar *top-child-format*
  (new-dform-variable-child (get-dummy-display-meta-variable-id)
			    "term"))

(defvar *top-child-format-array*
  (let ((format (new-dform-variable-child (get-dummy-display-meta-variable-id)
					  "term")))
    (setf (dform-child-dtree-index format) 0)
    (make-array 1 :initial-element format)))



;;;;	
;;;;	Can assume
;;;;	 - isexpr of !dform(0;0;0)'s with !dform-cons
;;;;	 - all model terms have same term sig.
;;;;	

;;;
;;;	RLE document as import function is milled.
;;;
(define-primitive |!pform_name| ((string . name)) ())

(defun term-to-dform-attribute (term dform)

  (cond

    ;;
    ;; Conditions
    ;;
    
    ((icondition-sexpr-p term)
     (setf (dform-conditions dform)
	   (nconc (conditions-of-dform dform)
		  (term-to-condition-list term))))
    ;;
    ;; Choice
    ;;

    ;; !dform_hidden_cond_expr
    ((idform-hidden-cond-expr-term-p term)
     (setf (dform-hidden-cond-expr dform)
	   (cons (term-to-cond-expr (expression-of-idform-hidden-cond-expr-term term))
		 (hidden-cond-expr-of-dform dform))))
    
    ;; !dform_cond_expr
    ((idform-cond-expr-term-p term)
     (setf (dform-cond-expr dform)
	   (cons (term-to-cond-expr (expression-of-idform-cond-expr-term term))
		 (cond-expr-of-dform dform))))
    
    ;;
    ;; Parens
    ;;

    ;; !dform_parens_passthru
    ((idform-precedence-passthru-term-p term)
     (dform-flag-set-parens-passthru dform t))

    ;; !dform_precedence_sensitivity{}()
    ;; !dform_precedence_exception{}()
    ((idform-precedence-exception-term-p term)
     (dform-flag-set-precedence-exception dform t))
    ((idform-precedence-sensitivity-term-p term)
     (dform-flag-set-precedence-exception dform nil))

    ;; !dform_precedence_injection{}(0)
    ((idform-precedence-injection-term-p term)
     (setf (dform-precedence-injection dform)
	   (term-to-precedence-pointer
	    (pointer-of-idform-precedence-injection-term term))))
    

    ;;
    ;; Iteration.
    ;;

    ;; !dform_families{}(0)
    ((idform-families-term-p term)
     (setf (dform-families dform)
	   (map-isexpr-to-list
	    (list-of-idform-families-term term)
	    (idform-family-cons-op)
	    ;; lib verified for family list.
	    #'(lambda (dft) (intern-system (name-of-idform-family-term dft))))))
    
    ;; !dform_family{s}()
    ((idform-family-term-p term)
     (setf (dform-family dform)
	   (intern-system (name-of-idform-family-term term))))

    ;;
    ;; Misc.
    ;;
    
    ;; !dform_edit_macro{s}()
    ((idform-macro-name-term-p term)
     (setf (dform-macro-name dform)
	   (string-of-idform-macro-name-term term)))
    
    ;; !dform_name{s}()
    ((idform-name-term-p term)
     (let ((name (name-of-idform-name-term term)))
       (setf (dform-name dform) name)))

     
    ;;
    ;; Other Misc.
    ;;
    ;; !dform_name{s}()
    ((ipform-name-term-p term)
     (push term (dform-others dform)))

    
    ;;;
    ;;;  Unrecognized.
    ;;;

    ;; warn if unrecognized attributes.
    (t
     ;;(setf a term) (break)
     (message-emit (warn-message (list 'dform 'attribute 'unrecognized (id-of-term term)) term))))

  (values))




;;;;	
;;;;	Formats:
;;;;	

;; why not parameter children?
(defun term-to-dform-child-attribute (term child)
  (cond
    ;; conditions
    ((icondition-sexpr-p term)
     (setf (dform-child-conditions child)
	   (nconc (conditions-of-dform-child child)
		  (term-to-condition-list term))))

    ;; parentheses
    ((idform-child-parentheses-term-p term)
     (if (dform-term-child-p child)
	 (setf (dform-term-child-parens child)
	       (new-dform-parentheses (relation-of-idform-child-parentheses-term term)
				      (term-to-precedence-pointer (pointer-of-idform-child-parentheses-term term)
								  t)
				      (binding-of-formats-of-idform-child-parentheses-term term)
				      (let ((formats nil))
					(map-isexpr (formats-of-idform-child-parentheses-term term)
						    (idform-format-cons-op)
						    #'(lambda (ft)
							(let ((format (term-to-dform-format ft)))
							  (when format (push format formats)))))
					(nreverse formats))))
	 (message-emit (warn-message '(dform format child attribute parens term not) (kind-of-format child)))))

    (t (message-emit (warn-message '(dform format child attribute unknown) term)))
    ))


;; Dform nil implies a restricted set of formats is applicable.
;; Mainly child formats are not allowed.
(defun term-to-dform-format (term &optional dform)

  (labels
      ((term-to-dform-child-attributes (term child)
	 (map-isexpr term
		     (idform-child-attr-cons-op)
		     #'(lambda (term)
			 (term-to-dform-child-attribute term child)))
	 child))
    
    (cond
      ;; for parentheses formats.
      ((variable-p term)
       (when dform (system-error (error-message '(dform format variable not-null dform))))
       (id-of-variable-term term))
      
      ;; RLE TODO need to resolve line-breaks embedded in text.
      ;; RLE TODO "foo\ngoo" -> "foo" {hard} {break} {end} "goo".
      ((itext-term-p term)
       (new-text-format (text-of-itext-term term)))

      ((idform-text-term-p term)
       (new-text-format (text-of-idform-text-term term) nil (length-of-idform-text-term term)))

      ((idform-label-wrap-term-p term)
       (let* ((label-acc nil)
	      (formats (do ((term term (formats-of-idform-label-wrap-term term)))
			   ((not (idform-label-wrap-term-p term)) term)
			 (push (label-of-idform-label-wrap-term term) label-acc)))
	      (labels (nreverse label-acc)))
	 
	 (let ((format-list nil))
	   (map-isexpr formats
		       (idform-format-cons-op)
		       #'(lambda (iformat)
			   (let ((format-expr (term-to-dform-format iformat dform)))
			     (cond
			       ((null format-expr))
			       ((consp format-expr)
				(dolist (format format-expr)
				  (push (set-format-labels format labels) format-list)))
			       (t (push (set-format-labels format-expr labels) format-list))))))
	   (nreverse format-list))))


      ((idform-space-term-p term)
       (new-space-format))

      ((idform-push-term-p term)
       (new-push-format (amt-of-idform-push-term term)))

      ((idform-pop-term-p term)
       (new-pop-format))
    
      ((idform-break-control-term-p term)
       (new-break-control-format (tok-upcase (type-of-idform-break-control-term term))))

      ((idform-cut-break-term-p term)
       (make-cut-break-format))

      ((idform-break-term-p term)
       (new-break-format (string-of-idform-break-term term)
			 (prefix-of-idform-break-term term)
			 (suffix-of-idform-break-term term)))


      ((idform-variable-child-term-p term)
       (unless dform (system-error (error-message '(dform format child null dform))))

       (let* ((id (meta-id-of-idform-variable-child-term term))
	      (mv (model-variable-of-dform id dform)))

	 (when (null mv)
	   ;;(setf a id b dform c term) (break)
	   (raise-error (error-message '(format variable model not) id)))
	 
	 ;; caught by lib:
	 ;;(when (dummy-display-meta-variable-id-p id)
	 ;; dummy display-meta used to indicate dummy test. Should
	 ;; not be used to display values.
	 ;;(raise-error (error-message '(dform format child dummy variable))))
	 
	 (term-to-dform-child-attributes
	  (attributes-of-idform-child-term term)
	  (if (dform-model-variable-flag-term-p mv)
	      (new-dform-variable-child
	       (meta-id-of-idform-variable-child-term term)
	       (descriptor-of-idform-variable-child-term term))
	      (new-dform-parameter-child (meta-id-of-idform-variable-child-term term)
					 (descriptor-of-idform-variable-child-term term))))))

      ((idform-library-child-term-p term)
       (unless dform (system-error (error-message '(dform format child null dform))))

       (let ((pointer (get-display-meta-variable-id
		       (pointer-of-idform-library-child-term term))))

	 (unless (model-variable-of-dform pointer dform)
	   (raise-error (error-message '(dform format library) term)))
       
	 (term-to-dform-child-attributes (attributes-of-idform-child-term term)
					 (new-dform-library-child pointer))))
    
      ((idform-constant-child-term-p term)
       (term-to-dform-child-attributes (attributes-of-idform-child-term term)
				       (new-dform-constant-child
					(term-of-idform-constant-child-term term))))

      (t ;;(setf a term) (break "term-to-dform-format")
	 (message-emit (warn-message '(dform format term unknown) term))
	 nil)
    
      )))
    

;;;;	RLE NAP: Heres a useless feature we don't need:
;;;;	RLE NAP: Currently there is no way to have an !template subterm in the model term
;;;;	RLE NAP: be a constant, it is always expected to be a meta variable.
;;;;	RLE NAP: Could do something with quotes to make it viable??



;; assumes shallow model.
(defun set-model-part-indices (dform-model)
  (let ((model-variables (variables-of-dform-model dform-model))
	(model (term-of-dform-model dform-model)))

    ;; start indices at 1. 
    (let ((i 1))

      (labels 
	  ((find-mv (id)
	     (some #'(lambda (mv)
		       (when (eql id (id-of-dform-model-variable mv))
			 mv))
		   model-variables)))

	(mapc #'(lambda (p)
		  (when (display-meta-parameter-p p)
		    (push-model-variable-part-index (find-mv (value-of-parameter p)) i))
		  (incf i))
	      (parameters-of-term model))
	     
	(dolist (bt (bound-terms-of-term model))
	  (dolist (b (bindings-of-bound-term bt))
	    (when (display-meta-variable-id-p b)
	      (push-model-variable-part-index (find-mv b) i))
	    (incf i))
	  (let ((subterm (term-of-bound-term bt)))
	    (when (itemplate-term-p subterm)
	      (push-model-variable-part-index (find-mv (meta-id-of-itemplate-term subterm)) i))
	    (incf i))) ))))



(defun term-to-dform-model (term)

  (let ((vars nil)
	(preorder-vars nil)
	(parameter-vars nil)
	(iparms nil)
	(floatdown-index nil)
	(dummy-tests nil)
	(meta-parameter-p nil)
	(meta-bound-term-p nil))

    (labels ((maybe-new-dform-model-variable (id)
	       (push id preorder-vars)
	       (unless (member id vars :key #'id-of-dform-model-variable)
		 (push (new-dform-model-variable id) vars))))

    (dolist (p (parameters-of-term term))
      (when (display-meta-parameter-p p)
	(setf meta-parameter-p t)
	(push (value-of-parameter p) parameter-vars)
	(maybe-new-dform-model-variable (value-of-parameter p))))
	
    (dotimeslist (i bt (bound-terms-of-term term))
		 (let* ((implicit nil)
			(implicit-p nil)
			(subterm (term-of-bound-term bt))
			(iparm (when (variable-p subterm)
				 (let ((id (id-of-variable-term subterm)))
				   (unless (member id (bindings-of-bound-term bt))
				     ;; ie only an iparm if not bound. 
				     ;; note lib insures no meta bindings.
				     id)))))

		   (dotimeslist (j b (bindings-of-bound-term bt))
				(when (dummy-display-meta-variable-id-p b)
				  (push (cons i j) dummy-tests)))

		   (cond
		     (iparm (push iparm iparms))
		     ((itemplate-term-p subterm)
		      ;; note: lib checks prevent duplicate term model vars.
		      (setf meta-bound-term-p t)
		      (push (meta-id-of-itemplate-term subterm) preorder-vars)
		      (push (new-dform-model-variable (meta-id-of-itemplate-term subterm)
						      t
						      (when implicit-p (nreverse implicit)))
			    vars)
		      (when (floatdown-p (meta-id-of-itemplate-term subterm))
			(setf floatdown-index i)))
		     ((display-meta-variable-term-p subterm)
		      (setf meta-bound-term-p t)
		      (maybe-new-dform-model-variable (id-of-variable-term subterm))))

		   (unless iparm
		     (dolist (b (bindings-of-bound-term bt))
		       (cond
			 ((display-meta-variable-id-p b)
			  (setf meta-bound-term-p t)
			  (maybe-new-dform-model-variable b)
			  (push nil implicit))
			 ((variable-id-p b)
			  (setf implicit-p t)
			  (push b implicit))
			 (t;; slots ?
			  (push nil implicit)))))))

    (new-dform-model term
		     (nreverse vars)
		     (nreverse preorder-vars)
		     (nreverse parameter-vars)
		     iparms floatdown-index dummy-tests
		     meta-parameter-p meta-bound-term-p))))

  
;; should emit message and  return nil if failure.
(defun term-to-dform (term)

  (with-handle-error (('(dform term))
		      ())

    ;; need to add cond_expr.
    (let ((dform (new-dform)))

      ;;
      ;; Attributes.
      ;;

      ;; process specified attributes.
      (map-isexpr (attributes-of-idform-term term)
		  (idform-attr-cons-op)
		  #'(lambda (term)
		      (term-to-dform-attribute term dform)))

      ;; set default hidden-cond-expr if none specified
      (when (null (hidden-cond-expr-of-dform dform))
	(setf (dform-hidden-cond-expr dform)
	      (list (string-to-cond-expr "!(<(|(slot |(~point ~mark))))"))))


      ;;
      ;; Model
      ;;

      (setf (dform-model dform)
	    (term-to-dform-model (model-of-idform-term term)))

      (set-model-part-indices (dform-model dform))

      (when (some #'dform-model-variable-flag-iterate-p
		    (model-variables-of-dform dform))
	(dform-flag-set-iterate dform t))
      
      ;;
      ;; Formats
      ;;
      ;; Model must be done first as some term to format code uses model info.

      (setf (dform-formats dform)
	    (new-dform-formats
	     (let* ((format-list nil))
	       (map-isexpr (formats-of-idform-term term)
			   (idform-format-cons-op)
			   #'(lambda (iformat)
			       (let ((format-expr (term-to-dform-format iformat dform)))
				 (cond
				   ((null format-expr))
				   ((consp format-expr)
				    (dolist (format format-expr)
				      (push format format-list)))
				   (t (push format-expr format-list))))))
	       (nreverse format-list))))

      

  (let ((formats (array-of-dform-formats (formats-of-dform dform)))
	(child-formats (children-of-dform-formats (formats-of-dform dform)))
	(model-variables (model-variables-of-dform dform))
	(messages nil)
	(error-p nil))
    
    (declare (vector formats child-formats model-variables))

    ;; No need to check for format variables not defined in model.
    ;; as term-to-format fails if no model varaible.
    
    ;; floatup
    (when (some #'(lambda (mv)
		    (floatup-p (id-of-dform-model-variable mv)))
		model-variables)
      
      (setf (dform-floatup-index dform)
	    (do ((i (length model-variables) (1+ i)))
		((floatup-p (id-of-dform-model-variable (aref model-variables i)))
		 i)))
      
      (if (some #'(lambda (child)
		    (floatup-p (variable-of-dform-child child)))
		(child-formats-of-dform dform))

	  ;; variable and format
	  (when (not (dform-flag-iterate-p dform))

	    ;; Error if floatup model variable, floatup child, but not iterated.
	    (push (error-message '(float format model iterate not))
		  messages)
	    (setf error-p t))
	  
	  ;; variable and no format
	  (dform-flag-set-floatup-continued dform t)
	  ))

    ;; RLE TODO : add check to syntax for floatup and floatdown used as display meta parameter variables.
    ;; RLE TODO : add check to syntax for multiple floatup or floatdown model occurences.
    ;; RLE TODO : or this is implicit in not allowing dup term model vars.
    
    ;; Warn if model variable not used in formats. 
    (map nil
	 #'(lambda (mv)
	     (let ((v (id-of-dform-model-variable mv)))
	       (unless (some #'(lambda (cf)
				 (eql v (variable-of-dform-child cf)))
			     child-formats)
		 (dform-model-variable-flag-set-hidden mv t)
		 (unless (or (floatdown-p v)
			     (floatup-p v)
			     (some #'(lambda (f)
				       (and (dform-library-child-p f)
					    (eql v (pointer-of-dform-library-child f))))
				   formats))
		 
		   (push (warn-message '(model variable format not) v)
			 messages)))))
	  model-variables)
				   
    (dform-formats-update dform)

    (when messages
      (message-emit (basic-message '() messages)))

    (when error-p
      (raise-error (error-message '())))

    dform))))





;;;;
;;;;	lookup attributes or characteristics of variable child.
;;;;


(defun descriptor-of-variable (v dform)
  (let ((children (children-of-dform-formats (formats-of-dform dform))))
    (declare (vector children))

    (some #'(lambda (child)
	      (cond
		((dform-variable-child-p child)
		 (when (eql v (variable-of-dform-variable-child child))
		   (descriptor-of-dform-variable-child child)))
		((dform-parameter-child-p child)
		 (when (eql v (variable-of-dform-parameter-child child))
		   (descriptor-of-dform-parameter-child child)))
		(t nil)))
	  children)))


(defun dform-variable-term-usage-p (v dform)
  (let ((children (children-of-dform-formats (formats-of-dform dform))))
    (declare (vector children))

    (some #'(lambda (child)
	      (and (dform-variable-child-p child)
		   (eql v (variable-of-dform-variable-child child))))
	  children)))


(defun conditions-of-variable (v dform)
  (let ((children (children-of-dform-formats (formats-of-dform dform))))
    (declare (vector children))

    (some #'(lambda (child)
	      (when (and (dform-variable-child-p child)
			 (eql v (variable-of-dform-variable-child child)))
		(conditions-of-dform-child child)))
	  children)))





;;;;
;;;;	Dform match :
;;;;	
;;;;	 Types of parameters not considered. String rep of parameters used for
;;;;	comparison of real valued parameters.
;;;;	
;;;;	from sfa mail in nuprl5/features:
;;;;	It is sensible to allow op-param edit-slots in the model of a display
;;;;	form spec. This is mainly useful when editing by means of terms that
;;;;	normally have empty slots. This goes for term-slots (placeholders) to.
;;;;	
;;;;	Parameter slots are ok as they are considered equal parameters.  Note
;;;;	that as iplaceholder-term has no boundterms or parameters, all
;;;;	placeholders alpha-equal.
;;;;	
;;;;
;;;;	Matching dform to terms, dtrees.
;;;;	
;;;;	Testing predicates (dfparms?).
;;;;	 might make sense to test predicates on dtrees always to avoid label complications.





;; returns vector (possibly 0 elements) of actuals or nil no match.

;; no es verdad, returns alist not vector?
;;(eval-when (compile)
;;  (proclaim '(function dform-term-match (term term) vector)))


;;;;	
;;;;	dform-meta-term-match : compares models.	
;;;;	
;;;;	values of different parameter types can match, so any two meta
;;;;	parameters in the same position match.
;;;;	
;;;;	
;;;;

(defun equal-real-parameter-value-strings-p (p q)
  (let ((pv (value-of-parameter p))
	(qv (value-of-parameter q))
	(ptype (type-of-parameter p))
	(qtype (type-of-parameter q)))
    (and (real-parameter-value-p pv ptype)
	 (real-parameter-value-p qv qtype)
	 (string= (real-parameter-value-to-string pv ptype)
		  (real-parameter-value-to-string qv qtype)))))

(defun dform-meta-term-match-p (model-a model-b)
  (or (itemplate-term-p model-a)
      (itemplate-term-p model-b)
      (and (equal-opids-p (id-of-term model-a) (id-of-term model-b))
	   (apply-predicate-to-list-pair (parameters-of-term model-a) 
					 (parameters-of-term model-b)
					 #'(lambda (p q)
					     (cond
					       ((abstraction-meta-parameter-p p)
						(and (abstraction-meta-parameter-p q)
						     (eql (value-of-parameter p)
							  (value-of-parameter q))))
					       ((abstraction-meta-parameter-p q) nil)
					       ((or (display-meta-parameter-p p)
						    (display-meta-parameter-p q))
						t)
					       (t ;; not meta.
						(equal-real-parameter-value-strings-p p q)))))

	   (apply-predicate-to-list-pair
	    (bound-terms-of-term model-a)
	    (bound-terms-of-term model-b)
	    #'(lambda (bt-a bt-b)
		(and (dform-meta-term-match-p (term-of-bound-term bt-a)
					      (term-of-bound-term bt-b))
		     (apply-predicate-to-list-pair
		      (bindings-of-bound-term bt-a)
		      (bindings-of-bound-term bt-b)
		      #'(lambda (binding-a binding-b)
			  (cond
			    ((abstraction-meta-variable-id-p binding-a)
			     (and (abstraction-meta-variable-id-p binding-b)
				  (eql binding-a binding-b)))
			    ((abstraction-meta-variable-id-p binding-a) nil)
			    ((or (display-meta-variable-id-p binding-a)
				 (display-meta-parameter-p binding-b))
			     t)
			    (t;; not meta.
			     (eql binding-a binding-b))))
			  )))))))


;; return match assoc list!.
;; matches model with instance.
(defvar *edit-verbose-choice* nil)

(defun dform-term-match (model term)

  ;;(when (eql *imessage* (id-of-term term)) (setf -model model -term term) (break "dtm"))
  ;;(when (eql '|mymultiply| (id-of-term term)) (setf -model model -term term) (break "dtm"))  

  (let ((match-list nil))
    (labels
 	((match (v value)
	   (let ((prev-match (cdr (assoc v match-list))))
	     ;;(setf a v b value c prev-match d match-list)
	     (if prev-match
		 (let ((p (when (parameter-p value) value))
		       (q (when (parameter-p prev-match) prev-match)))
		   ;;(setf a p b q) (when t (and p q) (break))
		   (cond
		     ;; want parameter which are similar but different types to match.
		     ((and p q
			   (if (or (and (display-meta-parameter-p p)
					(display-meta-parameter-p q))
				   (and (abstraction-meta-parameter-p p)
					(abstraction-meta-parameter-p q)))
			       (eql (value-of-parameter p)
				    (value-of-parameter q))
			       (equal-real-parameter-value-strings-p p q)))
		      (setf match-list (acons v p match-list))
		      t)
		     ((and (bound-term-p value) (bound-term-p prev-match)
			   (null (bindings-of-bound-term prev-match))
			   (null (bindings-of-bound-term value))
			   (compare-terms-p (term-of-bound-term value)
					    (term-of-bound-term prev-match)))
		      (setf match-list (acons v value match-list))
		      t)
		     (t;;(setf a p b q) (when t (and p q) (break "dtm"))
		      		      nil)))
 		 (progn (setf match-list (acons v value match-list))
 			t))))
	 
	 (match-parameter (x y)
	   (if (display-meta-parameter-p x)
	       (match (value-of-parameter x) y)
	       ;; todo : should we coerce match if string reps are same
	       ;;   even it types differ.
	       ;;  I'd say not since then may change type in term -> dtree -> term.
	       ;; using equal-parameters-p for level-expressions changes [1 | i 0] to i
	       ;; in term->dtree->term when dform matches a constant i as le.
	       (or (equal-real-parameter-value-strings-p x y)
		   (when *edit-verbose-choice*
		     (message-emit (inform-message '(edit dform choice match parameter)
						   (iparameter-term x)
						   (iparameter-term y)))
		     nil))))

	 (match-binding (x y)
	   (if (display-meta-variable-id-p x)
	       (if (dummy-display-meta-variable-id-p x)
		   t
		   (match x (instantiate-parameter y *variable-type*)))
	       (equal-parameter-values-p x y *variable-type*)))
	 
	 (match-bound-term (x y)
	   (and (forall-p #'match-binding
			  (bindings-of-bound-term x)
			  (bindings-of-bound-term y))
		(match-subterm (term-of-bound-term x)
			       (term-of-bound-term y) y)))

	 (match-subterm (x y y-bound-term)
	   (if (itemplate-term-p x)
	       (match (meta-id-of-itemplate-term x) y-bound-term)
	       (if (and (null (bound-terms-of-term x))
			(null (bound-terms-of-term y)))
		   (match-term x y)
		   (edit-equal-terms-p x y)))) ; model subterms shown closed dform import.

	 (match-term (x y)
	   ;;(setf -x x -y y) (break "mt")
	   (if (itemplate-term-p x)	; degenerate case of dform for a template term.
	       ;; ??? should we require template-term to have display meta value
	       ;; ??? ie why is this not a call to parameter match???
	       (match (meta-id-of-itemplate-term x)
		      (car (parameters-of-operator (operator-of-term y))))
	       (and (eql (id-of-operator (operator-of-term x))
			 (id-of-operator (operator-of-term y)))
		    (apply-predicate-to-list-pair (parameters-of-operator (operator-of-term x))
						  (parameters-of-operator (operator-of-term y))
						  #'match-parameter)
		    (apply-predicate-to-list-pair (bound-terms-of-term x)
						  (bound-terms-of-term y)
						  #'match-bound-term)))))

      (if (match-term model term)
	  match-list
	  '(fail)))))



;;;	Explicit precedence tree is not maintained. When a prec object is
;;;	inserted or deleted, a hash table of precedence labels with addresses is
;;;	updated.  The hash table can be used to do incremental updates to
;;;	injection trees when dforms are updated.


(defstruct precedence-set
  (id nil)
  (members nil)
  )

(defun members-of-precedence-set (p) (precedence-set-members p))
(defun id-of-precedence-set (p) (precedence-set-id p))


(defstruct (precedences (:include definition))
  set
  )

(defun new-precedences (set) (make-precedences :set set))

(defun set-of-precedences (p) (precedences-set p))


(defun new-precedence-set (opid members)
  (case opid
    ((|!precedence_equal| |!precedence_unrelated| |!precedence_ordered|)
     (make-precedence-set :id opid
			  :members members))

    (otherwise (system-error (error-message '(new-precedence-set))))
    ))

(defun new-unrelated-precedence-set (l)
  (new-precedence-set '|!precedence_unrelated| l))

(defun precedence-ordered-set-p (pset) (eql '|!precedence_ordered| (id-of-precedence-set pset)))
(defun precedence-unrelated-set-p (pset) (eql '|!precedence_unrelated| (id-of-precedence-set pset)))
(defun precedence-equal-set-p (pset) (eql '|!precedence_equal| (id-of-precedence-set pset)))

(defun precedence-tree-to-term (tree)
  (cond
    ((precedence-set-p tree)
     (map-list-to-isexpr (members-of-precedence-set tree)
			 (instantiate-term (instantiate-operator (id-of-precedence-set tree) nil) nil)
			 #'precedence-tree-to-term))

    ((symbolp tree)
     (iprecedence-label-term tree))

    ((oid-p tree)
     (iprecedence-object-term tree))

    ((dform-address-p tree)
     (dform-address-to-term tree))

    (t (setf -tree tree) (break "pttt"))))


(defunml (|precedence_tree| (unit)  :declare ((declare (ignore unit))))
    (unit -> term)

  (precedence-tree-to-term (precedence-tree-build (resource 'precedences))))
      


(defun import-precedence (term)
  (labels
      ((visit (term)
	 (cond
	   ((or (iprecedence-ordered-term-p term)
		(iprecedence-unrelated-term-p term)
		(iprecedence-equal-term-p term))
	    (new-precedence-set (id-of-term term)
				(map-isexpr-to-list term
						    (operator-of-term term)
						    #'visit)))
	   ((iprecedence-label-term-p term)
	    (token-of-iprecedence-label-term term))

	   ((iprecedence-object-term-p term)
	    (oid-of-iprecedence-object-term term))

	   ((idform-address-term-p term)
	    (term-to-dform-address term nil))

	   (t (system-error (error-message '(precedence) term)))))
       )

    (let* ((substance (term-to-data term))
	   (psubstance (provide-data substance 'substance))
	   )

      (new-precedences (visit (term-of-substance psubstance))))))




;;;;	expression may be
;;;;	precedence expression
;;;;	dform addr
;;;;	dform
;;;;	symbol

(defstruct precedence-address
  (flags nil)
  (key nil)
  (expression nil)
  )

(define-flags (precedence-address)
    ((stale nil t)
     (in-table nil t)
     ))

(defun new-precedence-address (key expr &optional (in-table nil))
  (init-precedence-address-flags 
   (make-precedence-address :key key :expression expr)
   (when in-table
     '((in-table . t)))))

(defun key-of-precedence-address (a) (precedence-address-key a))
(defun expression-of-precedence-address (a) (precedence-address-expression a))

(defun precedence-address-expression-p (pa)
  (consp (expression-of-precedence-address pa)))


;; RLE TODO : unit testing
;;;;	RLE TODO :  need to make more robust wrt failure.
;;;;	RLE TODO :  As somewhat removed from obj twould be nice to have some precedence
;;;;	RLE TODO :  even when part of the tree is in error.

(defun precedence-tree-build (prec-table)
  (let ((precedences-list nil)
	(cur-root)	
	(tree nil)			; assoc list of roots.
	(referenced nil)		; list of objects referenced.
	(labels nil)
	(dform-addrs nil)
	)

    (definition-table-map prec-table
	(current-transaction-stamp)
	#'(lambda (oid precedences)
	    (declare (ignore oid))
	    (push precedences precedences-list)))
      
    (labels
	((visit (set)
	   (cond
	     ((precedence-set-p set)
	      (new-precedence-set (id-of-precedence-set set)
				  (mapcar #'visit
					  (members-of-precedence-set set))))

	     ((symbolp set)
	      (when (member set labels)
		(raise-error (error-message '(precedence-tree build label duplicate) set)))
	      (push set labels)
	      set)

	     ((dform-address-p set)
	      ;; map named dform address to index address if possible.
	      (let ((dform-addr (or (when (dform-address-named-p set)
				      (let ((dform (dform-address-to-dform set)))
					(when dform
					  (dform-address-of-dform dform))))
				    set)))

		(let ((dform (dform-address-to-dform dform-addr)))
		  (when dform
		    ;; mark possible singleton prec-addr stale.
		    (let ((pa (dform-precedence-address dform)))
		      (when pa (precedence-address-flag-set-stale pa t)))))

		;; precedence-tree dform address clash
		(when (member dform-addr dform-addrs :test #'equal-dform-addresses-p)
		  (message-emit (warn-message '(precedence-tree build dform-address duplicate) set)))
		(push dform-addr dform-addrs)
		dform-addr))

	     ((oid-p set)
	      (let ((precedences (definition-lookup-by-oid prec-table set)))
		(cond
		  ((member precedences referenced)
		   ;; will hit on cycle as well as duplicate references.
		   (raise-error (oid-error-message set '(precedence-tree build object duplicate))))

		  ((eql precedences cur-root)
		   (raise-error (oid-error-message set '(precedence-tree build object cycle))))

		  (t (push precedences referenced)
		     (let ((root (assoc precedences tree)))
		       (if root
			   (cdr root)
			   (visit (set-of-precedences precedences))))))))

	     (t (system-error (error-message '(precedence-tree build))))))
	 )

    (dolist (precedences precedences-list)
      (unless (member precedences referenced)
	(setf cur-root precedences)
	(push (cons precedences
		    (visit (set-of-precedences precedences)))
	      tree)))

    (if (null (cdr tree))
	(cdar tree)
	(new-unrelated-precedence-set (mapcan #'(lambda (root)
						  (unless (member (car root) referenced)
						    (list (cdr root))))
					      tree))))))


(defun rehash-precedence-labels (prec-table)
  (let ((counter 0)
	(labels (make-hash-table)))

    (labels
	((utok ()
	   (make-symbol (concatenate 'string
				     "precedence-"
				     (princ-to-string (incf counter)))))

	 (assign-precedence-address-to-dform-address (dform-addr prec-addr)
	   (let ((key (cons (stamp-of-dform-address dform-addr)
			    (id-of-dform-address dform-addr))))
	     (setf (gethash key labels)
		   (new-precedence-address key prec-addr t))))
					
	 (visit (tree addr)
	   (typecase tree
	     
	     (symbol
	      (setf (gethash tree labels)
		    (new-precedence-address tree 
					    (reverse (cons tree addr))
					    t)))

	     
	     (dform-address
	      (assign-precedence-address-to-dform-address tree
							  (reverse (cons (utok) addr))))

	     (precedence-set
	      (cond
		((precedence-equal-set-p tree)
		 (let ((prec-addr (reverse (cons (utok) ;; utok to insure cons in degenerate case.
						 addr))))
		   (dolist (member (members-of-precedence-set tree))
		     (cond
		       ((symbolp member)
			(setf (gethash member labels)
			      (new-precedence-address member prec-addr t)))
		       ((dform-address-p member)
			(assign-precedence-address-to-dform-address member prec-addr))
		       (t (system-error (error-message '(rehash-precedence-labels precedence-equal-set))))))))
		
		((precedence-unrelated-set-p tree)
		 (dolist (member (members-of-precedence-set tree))
		   (visit member (cons (utok) addr))))

		((precedence-ordered-set-p tree)
		 (dotimeslist (i member (members-of-precedence-set tree))
			      (visit member (cons i addr))))

		(t (system-error
		    (error-message '(rehash-precedence-labels precedence-set))))))

	      (otherwise (system-error
			  (error-message '(rehash-precedence-labels typecase)))))))
      

      (let ((tree (precedence-tree-build prec-table)))

	(visit tree nil))
      
      labels

      ;; map over dforms and reset addresses.
      ;;(definition-table-map *dforms*
      ;;#'(lambda (dforms)
      ;;(dolist (dform (list-of-dforms dforms))
      ;;;; RLE TODO : what about addresses in parens????
      ;;(let ((injection (precedence-injection-of-dform dform)))
		;;	  (when (symbolp injection)
		  ;;  (setf (dform-precedence-address dform)
			;;  (or (gethash injection labels)
			  ;;    injection)))))))
      )))


(defstruct (precedence-table (:include definition-table))
  (labels (make-hash-table)))

(defun lazy-rehash-precedence-labels (prec-table)
  ;; make prec addrs stale.
  (let ((l (precedence-table-labels prec-table)))
    (when l
      (maphash #'(lambda (k v)
		   (declare (ignore k))
		   (precedence-address-flag-set-stale v t))
	       l))

    (setf (precedence-table-labels prec-table) nil)))

(defun lazy-precedence-table-labels-p (p)
  (null (precedence-table-labels p)))

(defun labels-of-precedence-table (p)
  (or (precedence-table-labels p)
      (setf (precedence-table-labels p)
	    (rehash-precedence-labels p))))

(defun set-precedence-table-labels (p l) (setf (precedence-table-labels p) l))



;;;;	RLE TODO :
;;;;	RLE TODO :   should delay rehash to commit and not due at delete, insert, or undo.
;;;;	RLE TODO :

(defun precedence-table (stamp tag)
  (define-definition-table
      stamp
      (list 'precedence tag)
    nil
    :make-f make-precedence-table
    :import-f #'import-precedence
    ))


;; need to add to hooks
(defun precedence-transaction-end-hook (th)

  (let ((precs (resource 'dforms)))
    (when precs
      (when (exists-p #'(lambda (tr)
			  (equal (tags-of-definition-table precs)
				 (tags-of-touch-record tr)))
		      th)
	(lazy-rehash-precedence-labels precs)))))

(defun precedence-address-table-add (key addr)
  (precedence-address-flag-set-in-table addr t)
  (setf (gethash key (labels-of-precedence-table (environment-resource 'precedences)))
	addr))

(defun lookup-precedence-label (label)
  (let* ((precedences (environment-resource 'precedences))
	 (pa (gethash label (labels-of-precedence-table precedences))))
    (when pa
      ;; refresh stale precedence addresses.
      (if (precedence-address-flag-stale-p pa)
	  (setf (gethash label (labels-of-precedence-table precedences))
		(if (precedence-address-expression-p pa)
		    (new-precedence-address label (expression-of-precedence-address pa) t)
		    nil))
	  pa))))

(defun lookup-precedence-dform-address (addr)
  (let* ((precedences (environment-resource 'precedences))
	 (key (cons (stamp-of-dform-address addr) (id-of-dform-address addr)))
	 (pa (gethash key (labels-of-precedence-table precedences))))
    (when pa
      ;; refresh stale precedence addresses.
      (if (precedence-address-flag-stale-p pa)
	  (setf (gethash key (labels-of-precedence-table precedences))
		(when (precedence-address-expression-p pa)
		  (new-precedence-address key (expression-of-precedence-address pa) t)))
	  pa))))
		
	



;;;;	
;;;;	precedence address will be either
;;;;	 - token : label in precedence tree.
;;;;	 - address : address of dform
;;;;	

;; returns one of less unrelated equal greater.
;; if a is less than b then returnes less.
(defun compare-precedence-addresses (a b)
  (labels
      ((visit (a b)
	 (cond
	   ((and (null a) (null b))
	    'equal)
	   ((or (null a) (null b))
	    'unrelated)
	   (t (let ((aa (car a))
		    (bb (car b)))
		(cond
		  ((and (symbolp aa) (symbolp bb))
		   (if (eql a b)
		       (visit (cdr a) (cdr b))
		       'unrelated))
		  ((and (integerp aa) (integerp bb))
		   (cond
		     ((< aa bb) 'less)
		     ((= aa bb) (visit (cdr a) (cdr b)))
		     ((> aa bb) 'greater)))
		  (t 'unrelated)))))))
		 
  (cond
    ((eql a b) 'equal)
    ((not (and (consp a) (consp b))) 'unrelated)
    (t (visit a b)))))


;;;;		- L : The child will be tolerated (ie not enclosed in parentheses)
;;;;		      only if the child is less irritating than the display form.
;;;;		- E : The child will be tolerated only if the child is less or
;;;;	               equally irritating than the display form.
;;;;	        - * : The child will be tolerated.

;;;;	a child is less irritating than the parent if the precedence of
;;;;	the child is less than the precedence of the parent.

;; assume parens pointer already followed, and passthrus done too.
;; returns t if parens needed.

(defun compare-dform-precedences-p (relation parent-addr addr)
  (setf -r
  (unless (eql 'all relation)	; *
    (let ((rel (compare-precedence-addresses parent-addr addr)))
      (cond
	((eql rel 'greater)
	 nil)
	   
	((or (eql rel 'less)
	     (eql rel 'unrelated))
	 t)

	(t ;; rel must be 'equal
	 (eql 'less relation))))))
  ;;(format t "cdfpp ~a ~a ~a ~a~%" -r relation parent-addr addr)
  -r
  )



    
;;;;	
;;;;	Default dforms
;;;;	
;;;;	
;;;;	

(defun term-to-idform-term (term)
  (labels
      ((parameter (parm)
	 (list (idform-variable-child-term (string (value-of-parameter parm))
					   (string (type-id-of-parameter parm))
					   (idform-child-attr-nil-term))
	       (itext-term (concatenate 'string
					":"
					(string (parameter-type-shortest-alias
						 (type-of-parameter parm)))))))

       (bindings (bindings)
	 (when bindings
	   (nconc
	    (nlists-to-list 
	     (mapcar #'(lambda (binding)
			 (list (idform-variable-child-term (string binding)
							   "binding"
							   (idform-child-attr-nil-term))))
		     bindings)
	     (list (itext-term ",")))
	    (list (itext-term ".")))))

       (bound-term (bound-term)
	 (nconc
	  (bindings (bindings-of-bound-term bound-term))
	  (list (idform-variable-child-term (id-of-itemplate-term (term-of-bound-term bound-term))
					    "term"
					    (idform-child-attr-nil-term))))))

    (let* ((template (term-sig-to-model-term (term-sig-of-term term)))
	   (parameters (parameters-of-term template))
	   (bound-terms (bound-terms-of-term template)))

      
      (idform-term (icondition-term "DEFAULT")
			      
		   (map-sexpr-to-isexpr 
		    `(,(idform-push-term 2) ; assume 20 is pixels and not chars.
		      ,(itext-term (string (id-of-term template)))
		      ,@(when parameters
			      `(,(itext-term "{")
				,(idform-push-term 0)
				,(idform-break-control-term 'soft)
				,@(nlists-to-list
				   (mapcar #'parameter parameters)
				   (list (itext-term ",") (idform-break-term " ")))
				,(idform-break-control-term '||)
				,@(when (cdr parameters)
					(list (idform-break-control-term 'soft)
					      (idform-break-term "")
					      (idform-break-control-term '||)))
				,(itext-term "}")
				,(idform-pop-term)))
		      ,@(when bound-terms
			      `(,@(when (or t	;; changed to unconditional
					    parameters)
					(list (idform-break-control-term 'soft)
					      (idform-break-term "")
					      (idform-break-control-term '||)))
				,(itext-term "(")
				,(idform-push-term 0)
				,(idform-break-control-term 'soft)
				,@(nlists-to-list
				   (mapcar #'bound-term bound-terms)
				   (list
				    (itext-term ";")
				    (idform-break-term " ")))
				,(idform-break-control-term '||)
				,(idform-break-control-term 'soft)
				,(idform-break-term "")
				,(idform-break-control-term '||)
				,(itext-term ")")
				,(idform-pop-term)))
		      ,(idform-pop-term))
		    (idform-format-nil-term))

		   template))))


(defun new-default-dform (term)

  ;;(setf -a term) (break "ndd")
  (format t "new default dform~%")

  (let ((idform  (term-to-idform-term term)))
    (let ((dform (term-to-dform idform)))

      (let ((dforms (new-edd-dforms (display-substance idform nil (model-term-of-dform dform))
				    (list dform))))
	(setf (definition-dependency dforms) (dependency *null-oid* nil nil))

	(setf (dform-precedence-address dform) (let ((sym (gensym))) (new-precedence-address sym sym)))
	(setf (dform-oid dform) (oid-of-definition dforms))

	;; makes nothing stale and
	;; ??? does not define handle for suppression.
	(dform-pool-table-backdoor-insert (environment-resource 'dforms) dforms)

	dform))))


(defun dform-map (p)
  (let ((acc nil))
    (definition-table-map (environment-resource 'dforms)
	(current-transaction-stamp)
      #'(lambda (oid dforms)
	  (when (exists-p #'(lambda (dform)
			     (funcall p oid dform))
			  (list-of-dforms dforms))
	    (push oid acc))))
  acc))

;;;;	
;;;;	
;;;;	
;;;;	TODO this of course must be updated whenever 
;;;;	dforms table is modified. Like in transaction-cleanup
;;;;	also must be part of env.
;;;;	
;;;;	
;;;;	
;;;;	pform-index-assoc	: (<int> . <token>) list
;;;;	pform-name-assoc	: (<token> . <dform>) list
;;;;	pindex-dform-assoc	: (<int> . <dform>) list
;;;;	
(defun make-pform-name-assoc ()
  (let ((acc nil))
    (definition-table-map (environment-resource 'dforms)
	(current-transaction-stamp)
      #'(lambda (oid dforms)
	  (declare (ignore oid))
	  (dolist (dform (list-of-dforms dforms))
	    (let ((pname (find-first #'(lambda (a)
					 (when (ipform-name-term-p a)
					   ;;(format t "~% ~a~%" a)
					   a))
				     (other-attributes-of-dform dform))))
	      (when pname
		(push (cons (intern-system (string-upcase (name-of-ipform-name-term pname))) dform) acc)
		)))))
    acc))

(defun make-pform-dform-assoc (pform-index-assoc &optional pform-name-assoc)
  (let ((pna (or pform-name-assoc (make-pform-name-assoc)))
	(acc nil))
    (dolist (pindex pform-index-assoc)
      (let ((dform (cdr (assoc (cdr pindex) pna))))
	(when dform
	  (push (cons (car pindex) dform) acc))))
    acc))

(defvar *pform-dform-assoc* nil)

(defun init-pda (pform-index-assoc &optional force-p)
  (when (or force-p (null *pform-dform-assoc*))
    (setf *pform-dform-assoc* 
	  (make-pform-dform-assoc pform-index-assoc
				  (make-pform-name-assoc)))))


(defmacro with-pda ((pda) &body body)
  `(let ((*pform-dform-assoc* (make-pform-dform-assoc ,pda
						      (make-pform-name-assoc))))
    ,@body))

  

(defun pda-lookup (index)
  (cdr (assoc index *pform-dform-assoc*)))

(defun pda-rev-lookup (dform)
  (when (exists-p #'(lambda (a) (ipform-name-term-p a))
		  (other-attributes-of-dform dform))
    (car (revassoc dform *pform-dform-assoc*))))

