%()
*****************************************************************************
*****************************************************************************
UTILITIES-2.ML
*****************************************************************************
*****************************************************************************
Formatting and printing library objects and theories.
]%


%[
*****************************************************************************
Formatting Library Objects 
*****************************************************************************
]%


let status_symbol_alist = 
  [`COMPLETE`,"*"
  ;`BAD`,"-"
  ;`PARTIAL`,"#"
  ;`RAW`,"?"
  ]
;;

% dfs_to_suppress should be list of !dform_address terms %

  
%[ 
Formatting term with header.

All terms printed at indent_1 or indent_2, with preference given to 
indent_2 when term display fits on one line. 

More precisely:

a) If length header < indent_2. 
      format term in (width - indent_2) 
      If term display fits on 1 line, add it at indent_2. o/w go on to b)

b) Format term in (width - indent_1)
      If length header < indent_1, 
        start term display on same line as header
      else
        start term display on next line. 
]%

letref format_term_with_header_indent_1 = 15 ;;
letref format_term_with_header_indent_2 = 30 ;;
letref format_term_with_header_indent_3 =  5 ;;

letref ppce = edit_ce_string_to_expression "TRUE" : cond_expr;;

let format_term_with_header header tm width dfs_to_suppress = 
  let indent_1 = format_term_with_header_indent_1 in
  let indent_2 = format_term_with_header_indent_2 in

  let header_width = str_length header in
  let tm_strs2 = term_to_print_strings_with_suppression ppce
                   dfs_to_suppress tm (width - indent_2) 
  in 
  if header_width < indent_2 & length tm_strs2 = 1 then
    [pad_right_str header indent_2 J hd tm_strs2]
  else
  let tm_strs1 = term_to_print_strings_with_suppression ppce
                   dfs_to_suppress tm (width - indent_1) 
  in
    add_header_to_strs header indent_1 tm_strs1
;;


let term_to_print_strings_ref t =
 term_to_print_strings_with_suppression ppce [] t 100
;;

let mk_dform_addr_term name index = 
  mk_term (`!dform_address`,
                  [mk_token_parm name;mk_natural_parm index]) [] ;;


% Returns list of dform_address terms %

let find_dfs_to_suppress_in_df_def_term name df_def_term = 
  let get_num_df_defs t = 
    length (find_subterms_with_addrs (\vs,t.is_term `!dform` t) t )
  in let mk_addr_terms n = 
    map (mk_dform_addr_term name) (upto 1 n)
  in
  let n1 = get_num_df_defs df_def_term
  in 
  if n1 > 0 then
    mk_addr_terms n1
  if not (is_ab_term df_def_term) then
    []
  else
    mk_addr_terms (get_num_df_defs (unfold_ab df_def_term))
;;

let object_kind_alist = 
 [`STM`,"S"
 ;`PRF`,"P"
 ;`DISP`,"D"
 ;`LAT`,"P"
 ;`COM`,"C"
 ;`ABS`,"A"
 ;`ML`,"M"
 ;`CODE`,"M"
 ;`RULE`,"R"
 ;`DIR`,"I"
 ;`stm`,"S"
 ;`prf`,"P"
 ;`disp`,"D"
 ;`lat`,"P"
 ;`com`,"C"
 ;`abs`,"A"
 ;`ml`,"M"
 ;`rule`,"R"
 ;`dir`,"I"
 ;`INV`,""
 ;`inv`,""
 ;`TERM`,""
 ;`term`,""
 ;`GRP`,""
 ;`grp`,""
 ;`cmt`,""
 ;`CMT`,""
 ]
;;

let lookup_object_kind_abbr kind = 
  apply_alist object_kind_alist kind ? (term_break `kind`; tok_to_string kind)
;;

let format_thm_object long_p width name status term = 
  
 %let status = `no status yet`% %lal status_of_object obtok% 
 let header1 = 
       (apply_alist status_symbol_alist status ? "?")
       J "T " 
       J (tok_to_string name)
 in
 let goal = statement_lookup (lemma_lookup name) in
  
 if not long_p then
   let header2 = "n0 header 2" %header1 J spacing J size_str J time_str %
   in
     format_term_with_header header2 goal width []

 else  % long_p true %

   let header2 = "n0 header 2" %header1 J time_str% in
   let proof_strs = 
     %if non nil poid list is_thm_object_expanded obtok then%
       proof_to_print_strings term width
   in
     header2 . "" . proof_strs @ [""]
;;


% 
M> pp_unwanted_dfs ;; 
[Dn: equal.2; 
 D: irule_definition_df.MoreWhiteSpace; 
 D: irule_definition_df.ConstrainedMoreWhiteSpace] 
: term list

M> short_print_theory "rules_1" ;; 
() : unit 

irule_definition_df.ConstrainedLessWhiteSpace
irule_definition_df.LessWhiteSpace

%

letref pp_unwanted_dfs = nil:term list;;

let format_non_thm_object width name kind status term = 
 
 let header =
    %LAL do we want status to represent active, for stm, if stm has complete prf%
    %(apply_alist status_symbol_alist status ? "?")
    J% lookup_object_kind_abbr kind 
    J " " 
    J (tok_to_string name)
  in let unwanted_dfs = 
        kind = `DISP` 
        => find_dfs_to_suppress_in_df_def_term name term 
        | pp_unwanted_dfs
  in 
    format_term_with_header header term width unwanted_dfs
;;


let format_object long_p width name kind status term = 
   if kind = `PRF` & (not long_p) then []
  else
    format_non_thm_object width name kind status term
;;

let format_dir name = 
   ["DIR " J (tok_to_string name)]
;;

let format_dir_end name = 
   ["END " J (tok_to_string name)]
;;

let maybe_format_dir kind name = 
    %if kind = `GRP` THEN [(tok_to_string name)] else %
    if kind = `DIR` then format_dir name
    else []
;;

let maybe_format_dir_end kind name = 
   if kind = `DIR` then format_dir_end name
   else []
;;


%maybe want kind as part of oidtree. and status 2, in other words, get
all info from lib that you need at once.%
letrec format_oidtree long_p width oidtree = 
  let (name, kind, status) = oidtree_to_toks oidtree in
  (let term = oidtree_to_source oidtree in
   format_object long_p width name kind status term)
  ?
   (let l = oidtree_to_tree oidtree in
   append (maybe_format_dir kind name) (append (flatten (map (format_oidtree long_p width) l)) (maybe_format_dir_end kind name)))
;;

%letrec format_oidtreeterm long_p width oidtree = 
  (let (name, oid) = oidtreeterm_to_stuff oidtree
   in let (term, props) = get_term_and_properties oid ``KIND`` in
   format_object long_p width name (token_of_itoken_term (hd props)) term)
  ?
   (let l = oidtree_to_tree oidtree
   in let ot = hd l and ch = tl l in
   if ch = nil then format_oidtree long_p width ot
   else  (format_oidtree long_p width ot) @
         (flatten (map (format_oidtree long_p width) ch)))
;;
%
%[
***************************************************************************
Formatting Theories
***************************************************************************
]%

let format_theory long_p width ot = 
  let (name, kind, status) = oidtree_to_toks ot
  in let title_string = upcase_string (tok_to_string name)
  in let title_underline = 
      toks_to_string (map (\x.`_`) (string_to_toks title_string))
  in  
    [title_string;title_underline;""]
    @
    flatten (map (format_oidtree long_p width) (oidtree_to_tree ot))
    @
    (long_p => [] | 
     ["";"Thm stats: <log2 (# pscript lines)> <log2 (expansion time in sec)>"]
    )
;;

%[
***************************************************************************
Writing Theory Listings to Files
***************************************************************************
]%


let dump_strs_to_file strs filename = 
  set_snapshot_file filename 
  ; open_snapshot_file true
  ; pp_output_lines strs
  ; close_snapshot_file ()
  ; ()
;;

let append_strs_to_file strs filename = 
  set_snapshot_file filename 
  ; open_snapshot_file false
  ; pp_output_lines strs
  ; close_snapshot_file ()
  ; ()
;;

%[
print_theory_aux <printer> <suffix> <thy> 
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Applies 
 
  <printer> : string -> string list

function to <thy> and dumps value to <thy><suffix>.prl and 
<thy><suffix>.tex files. 
]%

letref theory_prefix = "~/nuprlprint/";;

let print_theory_aux printer suffix ot = 
  let (name, kind, status) = oidtree_to_toks ot
  in let lib_fname = theory_prefix J (tok_to_string name)
  in
  let prl_file = lib_fname J suffix J ".prl" in
  let tex_file = lib_fname J suffix J ".tex" in
    dump_strs_to_file
      (printer ot)
      prl_file

    ; latexize_file prl_file tex_file
;;

let iobject_tree_cons_op = (`!object_tree_cons`,[])
;;

let dest_object_tree_term term =
  let ((id, parms),
       [([],name);
        ([],kind);
        ([],status);
        ([],substance); 
        ([],children)
       ]) = destruct_term term in
  ((token_of_itoken_term name),(token_of_itoken_term kind), (token_of_itoken_term status), substance, children)
;;
  
letrec term_to_oidtree term =
  let (name, kind, status, substance, children) = dest_object_tree_term term in
  mk_oidtree name kind status substance (map_isexpr_to_list iobject_tree_cons_op term_to_oidtree children)
  
;;  


let short_print_theory thyoid = 
  
  let ot = term_to_oidtree (get_oidtree_short thyoid) in
  print_theory_aux (format_theory false pp_width) "" ot   
;;
 
let long_print_theory thyoid = 
  let ot = term_to_oidtree (get_oidtree thyoid) in 
  print_theory_aux (format_theory true pp_width) "_long" ot  
;;

%LAL todo: make long and short versions of print_object%
let print_object oid = 
  let ot = term_to_oidtree (get_oidtree oid) in 
  print_theory_aux
   (format_oidtree true pp_width)
   "_obj"
   ot  
;;
%
let short_print_object oid = 
  let ot = term_to_oidtree (get_object_tree oid) in 
  print_theory_aux
   (format_oidtree true pp_width)
   "_obj"
   ot
;;
%
let print_collection oid = 
  let ot = term_to_oidtree (get_collection_tree oid) in 
  print_theory_aux
   (format_oidtree true pp_width)
   "_obj"
   ot
  
;;


%[
*****************************************************************************
Formatting of Nuprl Data-Structures in LaTeX
*****************************************************************************
Useful when creating papers based on Nuprl theories; LaTeX can be cut 
directly from Lisp window and pasted into LaTeX document.
]%



%
Display latexized text of object suitable for direct inclusion
in latex document

For convenience, also first displays object in normal format.
%

let latexize_string str = 
  concatenate_strings (map latexize_char (string_to_toks str))
;;

let display_latex_line str = 
  display_line ("\\>" J latexize_string str J "\\\\")  ;;

let display_latex_for_term1 header prefix width t = 
  let strs = term_to_print_strings ppce t width in
  let strs' = header @ map ($J prefix) strs 
  in
  display_line "" ;
  map display_line strs' ;
  display_line "" ;
  map display_latex_line strs' ;
  display_line "" 
;;

let display_latex_for_term width t = 
  display_latex_for_term1 [] "" width t 
;; 

let display_latex_for_obj width ob = fail
 % display_latex_for_term1 [ob J ":"] "  " width (term_of_object ob)% ;;

%
let display_latex_for_def_n n width id = 
  display_latex_for_term1 [id J ":"] "  " width 
    (mk_typed_def_n n (string_to_tok id))
%
%
    (mk_tm `typed_def` [mk_typed_def_n n (string_to_tok id)])
%

%
let display_latex_for_lib_objs width nam1 nam2 = 
  let nams = list_lib_seg nam1 nam2 in
  let block = flatten (map (format_object false width) nams) in
  display_line "" ;
  map display_line block ;
  display_line "" ;
  map display_latex_line block ;
  display_line "" 
;;

let display_latex_for_def = 
   display_latex_for_def_n 1
;;



let DispTex p = 
  let strs = pp_format_proof p 
  in
  display_line "" ;
  map display_line (pp_format_proof p) ;
  display_line "" ;
  map display_latex_line (pp_format_proof p) ; 
  display_line "" ;
  Id p
;;
%
%[
Some abbreviations
]%

%
letref latex_display_width = 60 ;;

let dlt t = display_latex_for_term latex_display_width t ;;
let dlo nam = display_latex_for_obj latex_display_width nam ;;
let dld nam = display_latex_for_def latex_display_width nam ;;
let dldn n nam = display_latex_for_def_n n latex_display_width nam ;;


let dllib nam1 nam2 = 
  display_latex_for_lib_objs latex_display_width nam1 nam2;;

%
%[
***************************************************************************
LaTeX File formatting 
***************************************************************************
Not used at present.

*latex-preamble* should be updated to include ttdisp stuff 
if latexize_block below is going to be used
]%

%
let latex_preamble = 
  pp_divide_into_lines (lisp "*latex-preamble*") 80;;
let latex_postamble = ["\\end{document}"];;
%
%[
Create a ttdisp block from a string block.
]%
%
let latexize_block strs = 
  let first_strs,[last_str] = split_lastn 1 (map latexize_string strs) in
  ["\\begin{ttdisp}"] 
  @ map (\x."\\>" J x J "\\\\") first_strs 
  @ ["\\>" J last_str] 
  @ ["\\end{ttdisp}"] 
;;
%


let dump_term_print fname w t =
 dump_strs_to_file (term_to_print_strings ppce t w)
  fname
;;
