%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let object_begin_delimiter = itext_term "------ begin ";;
let object_end_delimiter = itext_term "------ end ";;
let object_delimiter_trailer = itext_term " ------";;

let make_object_delimiters name =
  let start_name = name J "_start" in
  let finish_name = name J "_finish" in
  let name_term = itext_term name in
  
    (string_to_tok start_name,
	(create_objc_with_term `COM`
		(map_to_ilist (\x.x) (itext_cons_op)
			[ object_begin_delimiter; name_term; object_delimiter_trailer])
		nil))
    
    , (string_to_tok finish_name,
       (create_objc_with_term `COM`
		(map_to_ilist (\x.x) (itext_cons_op)
			[ object_end_delimiter; name_term; object_delimiter_trailer])
		nil))
;;
    
let make_object_start_delimiter name =
  let start_name = name J "_start" in
  let name_term = itext_term name in
  
    (string_to_tok start_name,
	(create_objc_with_term `COM`
		(map_to_ilist (\x.x) (itext_cons_op)
			[ object_begin_delimiter; name_term; object_delimiter_trailer])
		[`NAME`, itoken_term (string_to_tok start_name)]))
;;
    
let make_object_finish_delimiter name =
  let finish_name = name J "_finish" in
  let name_term = itext_term name in
  
    (string_to_tok finish_name,
       (create_objc_with_term `COM`
		(map_to_ilist (\x.x) (itext_cons_op)
			[ object_end_delimiter; name_term; object_delimiter_trailer])
		[`NAME`, itoken_term (string_to_tok finish_name)]))
;;
    

let exists_object_delimiters_p name = 				     
  ((lib_find_oid_by_name (concat name `_start`); true) ? false)
  or ((lib_find_oid_by_name (concat name `_object_directory`); true) ? false)
;;
	
let exists_object_p name =
 false
 % this is a throwback to v4 that reference environments make useless.
  TODO remove callers.
 %
 %  (lib_find_oid_by_name name; true)
  ? false
%;;


let apply_tttt envoid goal tttt = 
  apply_ttt nuprl5_refiner_description_term 
     (tttt_to_ttt tttt)
     (inf_objc (goal, []))
     envoid
     nil
;;

 
     
letrec inf_tree_to_tactic_tree itree =
  make_icons_term tactic_tree_cons_op
	     (get_term (inf_tree_object_id itree))
	     (map_to_ilist id tactic_tree_cons_op
  	       (map inf_tree_to_tactic_tree (inf_tree_children itree)))
;;

letrec partial_inf_tree_to_tactic_tree itree =
  make_icons_term tactic_tree_cons_op
	     ((get_term (inf_tree_object_id itree)) ? (itext_term ""))
	     (map_to_ilist id tactic_tree_cons_op
  	       (map partial_inf_tree_to_tactic_tree (inf_tree_children itree)))
;;


% TODO : we need better criteria. 
   need other flavors of Obvious not
   to create primitive proof at top level
   so they can be added here.
%

let inf_tree_to_tactic_tree_wfill itree r =
 letrec aux r itree = 
   (let tac = get_term (inf_tree_object_id itree) in
    let children,nr =  auxlist r (inf_tree_children itree) in
     make_icons_term tactic_tree_cons_op
       tac
       (map_to_ilist id tactic_tree_cons_op children)
   , nr)
   ? ((hd r ? failwith `inf_tree_to_tactic_tree_wfill less`), tl r)
 and auxlist r itrees =
   if null itrees then r,nil else
   let (ttree, nr) = aux r (hd itrees) in
   let (rttree, rr) = auxlist nr (tl itrees) in
    (ttree.rttree), rr
 in
  let ttree,lr = aux r itree in
   if not (null lr) then failwith `inf_tree_to_tactic_tree_wfill more`
   else ttree
;;

let inf_tree_to_tactic_tree_with_interior use_interior_p itree =
 letrec aux itree =
   let inoid = inf_tree_object_id itree in
   let children = map aux (inf_tree_children itree) in
   let step = inf_objc_src_step (oc inoid) in
    if (use_interior_p (inf_step_tactic step))
    then
     (tty_print "proof_search true";
      let sitree = inf_step_inf_tree step in 
       (inf_tree_to_tactic_tree_wfill sitree children))
    else make_icons_term tactic_tree_cons_op (get_term inoid)
	  (map_to_ilist id tactic_tree_cons_op children) in
 aux itree
;;

let refine_tree_tactic_p t =
 is_string_prefix "!refine_tree" (tok_to_string (id_of_term t))
 or
 (let opid = opid_of_term (source_reduce t ``EDITEPHEMRAL UNCONDITIONAL``) in
  is_string_prefix "!refine_tree" (tok_to_string opid))
;;
 
let inf_tree_to_tactic_tree_wout_refine_tree =  
  inf_tree_to_tactic_tree_with_interior refine_tree_tactic_p
;;

let expose_interior_trees use_interior_p poid =
 % walk tree and replace RefineTree nodes with interior trees.
   need to turn on direct bit of interior tops as turned off
   when building refine tree interior.
 %
 letrec auxfill r itree = 
  let infoid = inf_tree_object_id itree in
  let iobjc = oc infoid in
    
    if ((not (inf_step_refined_p (inf_objc_src_step iobjc))) ? true)
       then hd r, tl r
       else let children,nr =  auxfilllist r (inf_tree_children itree) in
            let noid = create_object_id () in
             save noid (expose_inf_from_refine_tree iobjc);
             make_inf_tree noid children,nr

 and auxfilllist r itrees =
   if null itrees then r,nil else
   let (ttree, nr) = auxfill r (hd itrees) in
   let (rttree, rr) = auxfilllist nr (tl itrees) in
    (ttree.rttree), rr

 and aux itree = 
   let step = inf_objc_src_step (inf_tree_object_contents itree) in
   let children = map aux (inf_tree_children itree) in
    if (use_interior_p (inf_step_tactic step))
       then let nitree,lr = auxfill children (inf_step_inf_tree step) in 
             if null lr
                then nitree
                else failwith `expose_refine_trees more`
       else make_inf_tree (inf_tree_object_id itree) children

 in
   let pobjc = oc poid in
     save poid (prf_objc_src_modify_inf_tree pobjc
                  (aux (prf_objc_src_inf_tree pobjc)))
;;

let expose_refine_trees = expose_interior_trees refine_tree_tactic_p;;

let ObviousFrom_string_match = string_match_f true "^ObviousFrom ";;
let ObviousConcl_string_match = string_match_f true "^ObviousConcl ";;
let ObviousContradiction_string_match = string_match_f true "^ObviousContradiction ";;

let proof_search_tactic_term_p ttac =
 itext_term_p ttac
 & let s = string_of_itext_term ttac in
    s = "Obvious"
    or (ObviousFrom_string_match s)
    or (ObviousContradiction_string_match s)
    or (ObviousConcl_string_match s)
    or s = "JProver" 
    or s = "ObviousListInduction"
;;

let inf_tree_to_tactic_tree_wout_search =
  inf_tree_to_tactic_tree_with_interior
    (\t. proof_search_tactic_term_p t or refine_tree_tactic_p t)
;;

letrec migrate_proof_to_tactic_tree_term mp =
  let (s, (tac, (a, c))) = destruct_itree mp in
    make_icons_term tactic_tree_cons_op
       tac
       (map_to_ilist id tactic_tree_cons_op
         (map migrate_proof_to_tactic_tree_term c))
;;
%
letrec jprover_list_to_tactic_tree_term l =
  let (string, term1, term2) = hd l in
    make_icons_term tactic_tree_cons_op
       jprover_to_nuprl_tactic string term1 term2
       (map_to_ilist id tactic_tree_cons_op
         (map jprover_list_to_tactic_tree_term (tl l)))
;;
%

let destruct_thm_data t = 
  let (id, parms), (([],goal) . ([], tttt) . rest) = destruct_term t in
    (goal, tttt)
;;

% returns oid of stm %
let create_thm envoid data props =
  let (goal, tttt) = destruct_thm_data data in
  if (ivoid_term_p tttt) then

    (let soid = create_object_id () in

	    save soid
	        (objc_set_properties
		  (if (ivoid_term_p goal)
		      then (objc_contents `STM`)
		      else (objc_modify_source (objc_contents `STM`) goal))
	          props)
       ; soid)

  
  else if isl envoid then
    % differs from then clause in that tttt is added to props %
    (let soid = create_object_id () in

	    save soid
	        (objc_set_properties
		  (if (ivoid_term_p goal)
		      then (objc_contents `STM`)
		      else (objc_modify_source (objc_contents `STM`) goal))
	           ( ( `tttt`
                     , if (itext_term_p tttt) then (simple_tactic_tree_term tttt) else tttt)
                   . props))
       ; soid)
  
  
  else

  % and here we actually do the proof,
    generally this won't happen here, but instead is done later.
  %  
  let poid = create_object_id ()
  and soid = create_object_id () in
    save poid (objc_set_properties
	        (mk_prf_objc (apply_tttt (outr envoid) goal tttt))
		props);

    save soid
      (stm_objc_src_modify_proofs
        (objc_set_properties
          (objc_modify_source (objc_contents `STM`) goal)
          props)
        [poid]);

   soid
;;


% place is name of an object. Create in same dir as place
  maybe someday allow for adjacency.
%

letref default_ref_environment_index = dummy_object_id ();;


let create_lib_object_data auxdata = 
 letrec aux t =
  (if (`!not_include_properties` = (id_of_term t)) then (false, [], (subtermn 1 t)) % incase want !include_properties to be data %
   else if (`!include_properties` = (id_of_term t))
           then let repb, l, tt = aux (subtermn 2 t) in 
                 (repb, (term_to_property_list (subtermn 1 t) @ l), tt)
   else false,[],t
   ) ? false,[], t
  in aux auxdata
;;

% if !insert_object_id_in_operator term has parms then they are a token and a nat
  where the token is the name of some preceding object and the nat indicates position of
  obid in parameter list
%
let create_lib_data_munge noids oid t =
 letref yes = false in
 letrec aux t =
  let ((opid, parms), bts) = destruct_term t in
   if (opid = `!insert_object_id_in_operator`)
      then ( yes := true
	   ; let mt = snd (hd bts) in
	     let munget = if (is_term `!insert_object_id_in_operator` mt)
		             then aux mt
			     else mt in
	     let (oopid, oparms), obts = destruct_term munget in
	      aux (if (null parms)
		      then make_term (oopid, ((make_object_id_parameter oid) . oparms)) obts
		      else ( let n = destruct_token_parameter (hd parms) in
			     let i = destruct_natural_parameter (hd (tl parms)) in
			     let b,a = split i oparms in
			       make_term (oopid, b @ ((make_object_id_parameter (apply_alist noids n)) . a))
			                 obts
		           ? t)))
      else make_term (opid, parms) (map (\b,s. b, aux s) bts)

  in let nt = aux t in
   if yes then ( tty_print "cldm put "; put_term oid nt)
;;    

let create_lib_object_aux default_desc noids odata =
 tty_print "new create_lib_object_aux";
    (let ((op, (kindparm . nameparm . rest)), ((nil, auxdata) . restbt))  = destruct_term odata in
     let kind = destruct_token_parameter kindparm in
     let name = destruct_token_parameter nameparm in
     let repoidp, props, data = create_lib_object_data auxdata in
      (name,
       let oid =
       if (kind = `COM`) then					
	(create_with_term kind data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		( (`NAME`, itoken_term name)
		. props)))
       else if (kind = `DISP`) then
	(create_with_term kind data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		( (`DESCRIPTION`, nuprl5_edit_description_term)
		. (`NAME`, itoken_term name)
		. props)))
       else if (kind = `ABS`) then
	(create_with_term kind data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		( (`DESCRIPTION`, default_desc)
		. (`NAME`, itoken_term name)
		. props)))
       else if (kind = `ML`) then
	(create_with_term `CODE` data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		( (`DESCRIPTION`, default_desc)
		. (`LANGUAGE`, itoken_term `ML`)
		. (`NAME`, itoken_term name)
		. props)))
       else if (kind = `STM`) then
	(create_with_term kind data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		( (`DESCRIPTION`, nuprl5_refiner_description_term)
		. (`NAME`, itoken_term name)
		. props)))
       else if (kind = `THM`) then
        (create_thm (inl ()) data
           (remove_prior_duplicates_p (\p q. (fst p) = (fst q))
		    ( (`DESCRIPTION`, nuprl5_refiner_description_term)
		    . (`NAME`, itoken_term name)
		    . props)))
       else
	(raise_error [] ``create_lib_object ref kind not`` [(itoken_term kind)]; fail)
  in ( if repoidp then
       (let ((opid, parms), bts) = destruct_term data in
         put_term oid (make_term (opid, ((make_object_id_parameter oid) . parms)) bts))
       else create_lib_data_munge noids oid data 

     ; oid)))
;;

letref make_complete_prf_f = (\re oid. fail) : (object_id -> object_id -> object_id);;


let create_activate_aux dir oids = 

  map (\oid.
        % if thm then attempt proof? %
	let objc = oc oid in
	    if (`STM` = objc_kind objc) then
	    ( (tty_print "create_lib_objects proof stm";
	        let re = ( oid_of_ioid_term (get_property oid `reference_environment`)
                         ? get_dyn_ref_environment_at dir oid) in 
	        tty_print "create_lib_objects proof re";
                let poid = make_complete_prf_f re oid in
	          tty_print "create_lib_objects proof complete";
		  activate_prf poid;
  		  tty_print "create_lib_objects proof activated";
		  save oid (stm_objc_src_modify_proofs objc [poid]))
            ? tty_print "create_lib_objects proof bombed"; ());
	      	      
        activate oid ? ();
	oid)
  oids
;;


let create_activate_aux_rechain reinit oids =
 letrec aux oids re =
  if null oids then re,[]
  else let oid = hd oids in
       let notdp = not (dummy_object_id_p re) in
       tty_print (if notdp then "caar not" else "caar notnot");
       (% if thm then attempt proof? %
	let objc = oc oid in
        let k = objc_kind objc in
        let nre =
	    if (`STM` = k) then
	      ((tty_print "create_lib_objects proof stm";
                let poid = make_complete_prf_f re oid in
	          tty_print "create_lib_objects proof complete";
		  activate_prf poid;
	          if notdp then put_property poid `reference_environment` (ioid_term re);

  		  tty_print "create_lib_objects proof activated";
		  save oid
                       (objc_add_property 
		          (stm_objc_src_modify_proofs objc [poid])
                          `reference_environment` (ioid_term re))
                 ; oid)
	       ? (tty_print "create_lib_objects proof bombed";
		 save oid
                       (objc_add_property 
		          objc
                          `reference_environment` (ioid_term re))
		 ; oid))
            else if (`ABS` = k) then (if notdp then put_property oid `reference_environment` (ioid_term re); oid)
            else if (`CODE` = k) then (if notdp then put_property oid `reference_environment` (ioid_term re); oid)
            else re in
	      	      
        activate oid ? ();
	let rre, noids = aux (tl oids) nre in
	 rre, (oid . noids)) in
  aux oids reinit
;;
  
let create_lib_objects_aux default_desc odts dir place =

 letrec aux noids odatas =
  if null odatas then (rev noids)
  else let nameoid = create_lib_object_aux default_desc noids (hd odatas) in
         aux (nameoid . noids) (tl odatas) in

  let nameoids = aux nil odts in
      map (\name,oid. dag_insert_after dir 
				       (if (isr place) 
					   then (outr place) 
					   else null_token) name oid)
          (rev nameoids);

     create_activate_aux dir (map snd nameoids)
;;



let create_lib_objects_aux_rechain default_desc odts reinit dir place =

 letrec aux noids odatas =
  if null odatas then (rev noids)
  else let nameoid = create_lib_object_aux default_desc noids (hd odatas) in
         aux (nameoid . noids) (tl odatas) in

  let nameoids = aux nil odts in

  if null nameoids then [] else
  
  let rno = rev nameoids in
  let rnoname = fst (hd rno) in
   dag_insert_after dir (if (isr place) then (outr place) else null_token) rnoname (snd (hd rno));
   
   map (\name,oid. dag_insert_before dir rnoname name oid)
       (rev (tl rno));

     snd (create_activate_aux_rechain reinit (map snd nameoids))
;;

let obacc_create_lib_objects_aux default_desc odts dir place =
  letrec aux noids odata = 
   if null odata then (rev noids)
   else let nameoid = create_lib_object_aux default_desc noids (hd odata) in
          aux (nameoid . noids) (tl odata) in

  create_activate_aux dir
    (map (\name, oid. dag_insert_before dir place name oid; oid)
         (aux nil odts))
;;


let obacc_create_lib_objects_aux_wrechain default_desc re odts dir place =
 letrec aux noids odata = 
   if null odata then (rev noids)
   else let nameoid = create_lib_object_aux default_desc noids (hd odata) in
          aux (nameoid . noids) (tl odata) in

   create_activate_aux_rechain re
     (map (\name, oid. dag_insert_before dir place name oid; oid)
	  (aux nil odts))
;;

let find_dir_of_place place =
  let paths = flatten (map oid_find_paths (filter lib_active_p (lib_find_oids_by_name place))) in
     if nil = paths then ((raise_error [] ``find_dir_of_place place path not`` [(itoken_term place)]); fail)
     else (descendent_s (firstn (length (snd (hd paths))) (snd (hd paths))))
;;

let lib_create_ref_objects_with_delims_at id dir place data = 
   let delims = make_object_delimiters id in

     (let eoid = (create_object_id ()) in
       let (etok, eoc) = snd delims in 
         save eoid eoc;
         dag_insert_after dir place etok eoid;

      let boid = (create_object_id ()) in
       let (btok, boc) = fst delims in 
       save boid boc;
       dag_insert_after dir place btok boid;
   
       create_lib_objects_aux nuprl5_refiner_description_term data dir (inr btok))
;;

let lib_create_ref_objects_with_delims id place =
 lib_create_ref_objects_with_delims_at id (find_dir_of_place place) place 
;;

		  
let lib_create_ref_objects data place = 
 let dir = (find_dir_of_place place) in
   create_lib_objects_aux nuprl5_refiner_description_term data dir (inr place)
;;

let lib_create_ref_objects_at data dir place = 
   create_lib_objects_aux nuprl5_refiner_description_term data dir (inr place)
;;

let lib_create_ref_objects_at_wrechain_aux data reinit dir place = 
   create_lib_objects_aux_rechain nuprl5_refiner_description_term data reinit dir (inr place)
;;


let object_accumulator_start name place =
 let dir = (find_dir_of_place place) in
 let dname = (concat name `_object_directory`) in
   let oid = dag_make_named_directory_after dir place dname in
     let (stok, soc) = make_object_start_delimiter (tok_to_string name) in
     (let soid = (create_object_id ()) in
       save soid soc;
       dag_insert oid stok soid)
   
   ; oid
;;

let make_obacc_recall_term pdir pname dir name oids =
  make_term (`obacc_recall`,
				[ make_object_id_parameter dir
				; make_token_parameter name
				; make_object_id_parameter pdir
				; make_token_parameter pname
				])
			     [[], map_to_ilist ioid_term ioid_cons_op oids]
;;

let make_obacc_recall_term_wextras extras pdir pname dir name oids =
  make_term (`obacc_recall`,
				[ make_object_id_parameter dir
				; make_token_parameter name
				; make_object_id_parameter pdir
				; make_token_parameter pname
				])
			     [ [], map_to_ilist ioid_term ioid_cons_op oids
			     ; [], extras]
;;

let made_dir_of_recall_term t =
 if null_token = second_tok t then inl ()
 else ((inr (first_oid t)) ? inl())
;;
			       
% apparently not used 5/02
let make_obacc_recall_term_wre re pdir pname dir name oids =
  make_term (`obacc_recall`,
				[ make_object_id_parameter dir
				; make_token_parameter name
				; make_object_id_parameter pdir
				; make_token_parameter pname
				])
			     [[], map_to_ilist ioid_term ioid_cons_op oids; [], ioid_term re]
;;
%
let obacc_recall_term_append term oids = 
 let op, (([], toids) . r) = destruct_term term in
   make_term op ( ([], map_to_ilist ioid_term ioid_cons_op
                         (append (map_isexpr_to_list ioid_cons_op oid_of_ioid_term toids) oids)) 
                . r)
;;

% apparently not used 5/02
let obacc_recall_term_append_wre re term oids = 
 let op, (([], toids) . oldre . r) = destruct_term term in
   make_term op (([],  map_to_ilist ioid_term ioid_cons_op
                        (append (map_isexpr_to_list ioid_cons_op oid_of_ioid_term toids) oids)) 
                . ([], (ioid_term re))
                . r)
;;
%

let obacc_start dirp delimp mnemonic extras dir place =
 let dname = concat mnemonic `_object_directory` in
 let (adir, aplace) =  
       if dirp then (if (child_p dir dname) then (child dir dname, null_token)  
		     else (dag_make_named_directory_after dir place dname, null_token))
               else (dir, place) in

 % up pointer to help find find/make ref env index. %
 if not (equal_oids_p adir dir)
    then  put_property adir `theory` ((get_property dir `theory`) ? (ioid_term dir));

 let rname = `.recall ` ^ mnemonic in
 if (child_p adir rname) then raise_error [dir; adir] ``obacc_start exists`` []; 

 let roid = dag_make_named_leaf_at false adir aplace rname `TERM` in

 if delimp 
    then (let (stok, soc) = make_object_start_delimiter (tok_to_string mnemonic) in
          let soid = (create_object_id ()) in
          let (ftok, foc) = make_object_finish_delimiter (tok_to_string mnemonic) in
          let foid = (create_object_id ()) in
            save soid soc;
            save foid foc;
            dag_insert_at true adir rname stok soid;
            dag_insert_at false adir rname ftok foid;
            put_term roid (make_obacc_recall_term_wextras extras
                             dir (if dirp then dname else null_token)
                             adir rname
			     [soid; roid; foid])
	  )
    else put_term roid (make_obacc_recall_term
                            dir (if dirp then dname else null_token)
			    adir rname
			    [roid])
   
   ; roid
;;

let obacc_add odata roid =
  let rterm = get_term roid in
  let noids =  obacc_create_lib_objects_aux 
	         nuprl5_refiner_description_term odata
	         (first_oid_of_term rterm)
	         (first_tok_of_term rterm) in
   put_term roid (obacc_recall_term_append rterm noids)
   ; ()
;;

   
   
let obacc_add_wrechain odata re roid =
  let rterm = get_term roid in
  let rre,noids =  obacc_create_lib_objects_aux_wrechain 
	         nuprl5_refiner_description_term re odata
	         (first_oid_of_term rterm)
	         (first_tok_of_term rterm) in
   put_term roid (obacc_recall_term_append rterm noids)
   ; (rre . noids)
;;
   
let object_accumulator_finish name oid = 
  let (ftok, foc) = make_object_finish_delimiter (tok_to_string name) in
    (let foid = (create_object_id ()) in
       save foid foc;
       dag_insert oid ftok foid)
;;

let object_accumulator_wo_delim_at name dir place =
 let dname = (concat name `_object_directory`) in
   dag_make_named_directory_after dir place dname 
;;

let object_accumulator_wo_delim name place =
  object_accumulator_wo_delim_at name (find_dir_of_place place) place
;;


let object_accumulator_add odata dir =
     create_lib_objects_aux nuprl5_refiner_description_term odata dir (inl ())
;;


let add_def_disp_ap = (begin_ap "add_def_disp ");;

let add_def_disp parent place abs = 
 let term = objc_substance_term (oc abs) in
 let model = subterm_of_term term 2 in
 let dfdata = ref_eval_to_term (term_ap add_def_disp_ap model) in
 let ((op, (kindparm . nameparm . rest)), ((nil, data) . restbt))  = destruct_term dfdata in
   let name = destruct_token_parameter nameparm in
     let oid = ( child parent name 
	       ? (let noid = (create_with_properties `DISP`
	       			[ `DESCRIPTION`, nuprl5_edit_description_term
				; `NAME`, itoken_term name
				]) in
			dag_insert_after parent place name noid;
			noid
			)) 
    in
     let objc = oc oid in
      if (objc_kind objc) = `DISP` 
         then (put_term oid data; activate oid)
         else raise_error [parent; oid] ``add_def_disp exists dform not`` []
;;     

   
let get_static_oids kind oids =
 flatten (map (\oid. filter (\oid. kind = kind_of_oid oid)
                            (oid . (static_oids_of_term (get_substance_term oid))))
	       oids)
;;

let lib_get_static_oids_for_re abss stms upds =
 (get_static_oids `ABS` abss),
 (get_static_oids `STM` stms),
 (get_static_oids `CODE` upds)
;;
   
letref find_ephemeral_refenv_location_term_f = \(place:tok) (dir:object_id). ivoid_term;;

let ephemeral_refenv_location_term place dir =
 find_ephemeral_refenv_location_term_f place dir
;;
