%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

% useful lib functions for building nuprl5 proofs%

let lib_migrate_itree oid =
	(objc_property (lib_object_contents oid) `migrate_proof`) ;;

let lib_abstractions oids =
	 letrec f l =
	 if null l then [] 
	 else let h1.t1 = l in
	(if (objc_kind (lib_object_contents h1)) = `ABS`
		  then h1. f t1 
		   else f t1)
	 in f oids ;;

let lib_codes oids =
	 letrec f l =
	 if null l then [] 
	 else let h1.t1 = l in
	(if (objc_kind (lib_object_contents h1)) = `CODE`
		  then h1. f t1 
		   else f t1)
	 in f oids ;;
		   
let lib_proofs oids =
	 letrec f l =
	 if null l then [] 
	 else let h1.t1 = l in
	(if (objc_kind (lib_object_contents h1)) = `PRF`
		  then h1. f t1 
		   else f t1)
	 in f oids ;;

%
let lib_step_subgoals oid =
 let ((id, parms),
      [([],goal);
       ([],node); 
       ([],children);
       ([],annotations)]) = (destruct_term (objc_property (lib_object_contents oid) `migrate_proof`)) in
	let (b, sequent)= let (a, c) = (destruct_term goal)  in
	 nth 1 c in
	let (b2, tactic)=let (a, f) = (destruct_term node) in nth 3 f in
	 let istep  = (inf_step (sequent, [])) in
	 let step = (inf_step_refine (nuprl5_refiner_description_term ) istep tactic oid [oid]) in
	let objc = (objc_inf_modify_step
   	            (objc_modify_source (objc_contents `INF`) tactic)
		    step)
           in  (inf_step_subgoals step) ;;


letrec build_all2 oalist =

   if oalist = nil then true
    else  let oa1 = hd oalist in
     let tags = tags_of_object_address oa1 in
      (if (((length tags) = 2) & ((second tags) = `STATEMENT`))
          then  ( activate oa1;
			   build_all2 (tl oalist))
	   else
	    (if (((length tags) = 2) & ((second tags) = `PROOF`))
          then 
	  (build_proof (lib_migrate_itree oa1) oa1;
	  activate oa1;
	 build_all2 (tl oalist))
	   else  build_all2 (tl oalist))) ;;

let build_all oalist =
  map (\oa1. (let tags = tags_of_object_address oa1 in
	       (if (((length tags) = 2) & ((second tags) = `STATEMENT`))
          then activate oa1
	  else
	    (if (((length tags) = 2) & ((second tags) = `PROOF`))
          then 
	    (let it = (build_proof (lib_migrate_itree oa1) oa1)  in
	  activate oa1))))) oalist ;;
%
%
let build_all oids =
  map (\oid. (let objc = lib_object_contents oid in
	       (if (`STM` = objc_kind objc)
		   then activate oid
		   else	if  (`PRF` = objc_kind objc) 
		   then ( build_proof (lib_migrate_itree oid) oid)
			; activate oid)))
       oids ;;

%
% successful proof refinements%
%
false_wf ->  decidable__implies work (first 25 )
stable_wf -> sq_stable__from_stable work
xmiddle_wf, squash_elim work
grand total:39
%

%
;;;;	
;;;;	assume result from nl is !cons list of subgoals. Dummy up to make palatable
;;;;	to lib-inf.
;;;;	
;;;;	!inf_tree(!inf_goal(G; !nil()); 
;;;;		  !inf_top{true:b}(!void(); !inf_tree(!inf_goal(G, !nil)); 
;;;;						      !inf_primitive(!void(); !inf_extract());
;;;;						      !inf_tree_cons());
;;;;		  !inf_tree_cons Subgoals.
;;;;	
;;;;	
;;;;	
%

let ref_eval cl = orb_eval_args `ANY` nuprl5_refiner_description_term cl;;
let ref_all_eval cl = orb_eval_args `ALL` nuprl5_refiner_description_term cl;;
let ref_eval_to_term cl = orb_eval_args_to_term `ANY` nuprl5_refiner_description_term cl;;

let ref_eval_string s = ref_eval (null_ap (itext_term s));;
let ref_eval_to_bool = make_bool_return ref_eval_to_term;;
let ref_eval_to_object_id = make_oid_return ref_eval_to_term;;
let ref_eval_to_object_ids = make_oids_return ref_eval_to_term;;
let ref_eval_to_object_ids_marshalled = make_oids_return_marshalled ref_eval_to_term;;
let ref_eval_to_some_term = make_some_term_return ref_eval_to_term;;
let ref_eval_to_terms = make_terms_return ref_eval_to_term;;

let nuprllight_refine_cmd goal tac oids =
 make_term (`!refine`, nil)
   [[], goal; [], tac; [], ioids_term oids]
;;


let lib_nuprllight_refine desc goal tac oids =
  dummy_up_mp goal tac
     (orb_eval_command_to_term `ANY` desc
			       (nuprllight_refine_cmd goal tac oids))
;;


%  Major kludge time:
     - using object_id as refenv indicator was in retrospect too limiting.
       instead it should be a term.
     - the motivating case is the minimal refenvs.
     - rather than trying to fix up all dependent code in lib and edd, instead
       only the refiner will be modified and then calls to the refiner will be modified here.
     - if envoid is stm or prf then we look for min terms otherwise pass through as obid.

%
let lib_refine_prim goal tac envoid oids =
  ref_eval_to_term
     (oids_ap (oid_ap (term_ap (term_ap (begin_ap "ref_refine_prim") goal) tac) envoid) oids)
;;
let lib_refine_primt goal tac envterm =
  ref_eval_to_term
     (term_ap (term_ap (term_ap (begin_ap "ref_refine_primt") goal) tac) envterm)
;;

let lib_refine_ap = null_ap (itext_term "ref_refine ");;
let lib_nuprl_refine desc goal tac envoid oids =
  orb_eval_args_to_term `ANY` desc
    (oids_ap (oid_ap (term_ap (term_ap lib_refine_ap goal) tac) envoid) oids)
;; 

let lib_refinet_ap = (token_ap (null_ap (itext_term "ref_refinet ")) `refine`);;
let lib_nuprl_refinet desc goal tac envterm =
  orb_eval_args_to_term `ANY` desc
    (term_ap (term_ap (term_ap lib_refinet_ap goal) tac) envterm) 
;; 
    
let ref_recompile oids =
 ref_all_eval (oids_ap (begin_ap "recompile_code_silent ") oids)
;; 

let lib_nuprl_prim_refine goal tac envoid oids =
  ref_eval_to_term 
    (oids_ap (oid_ap (term_ap (term_ap (begin_ap "ref_refine_prim") goal) tac) envoid) oids)
;; 

letref do_faux_ref = false;;

let placeholder_term s = 
  make_term (`placeholder`, [(make_string_parameter s)]) []
;;

let monitor_inf_ap =
  null_ap (itext_term "monitor_ref_refine ")
;;  


let monitor_inf ioid poid soid =
 (let iobjc = lib_object_contents ioid in
   let step = inf_objc_src_step iobjc in
      ref_eval
	 (oids_ap
	  (term_ap
	    (term_ap monitor_inf_ap
			     (igoal_term (inf_step_goal step)))
	    (inf_step_tactic step))
          [poid; soid]))
 ; ()
;;

 
let monitor_prf poid soid =
 letrec aux itree =
          (let ioid = inf_tree_object_id itree in
	    monitor_inf ioid poid soid;
	    map aux (inf_tree_children itree);
	    ())
  in (aux (prf_objc_src_inf_tree (lib_object_contents poid)) ? ());
  ()
;;


let start_refine_monitoring ()  = 
  ref_eval (begin_ap " init_refine_monitoring true true ")
;;

let stop_refine_monitoring () = 
  ref_eval (begin_ap " init_refine_monitoring false false ")
;;

let report_refine_monitoring () =
  ref_eval (begin_ap " report_refine_monitor() ");
;;


let report_all () =
  report_proof_stats "~/fu.report" ((`all` , (lib_statements (lib_list()))) . nil) `all`
;;


let monitor_all () =

   start_refine_monitoring ();

  (map  (\soid. ((map (\poid. monitor_prf poid soid)
			(stm_objc_src_proofs (lib_object_contents soid)); ()) ? ()))
	(lib_statements (lib_list ())));

  report_refine_monitoring ();
  stop_refine_monitoring ();

  ()
;;


let accumulate_infs () =
 letref acc = nil in
   letrec aux itree =
     acc := ((inf_tree_object_id itree) . acc);
     map aux (inf_tree_children itree);
     () in
   (map (\soid. ((map (\poid. aux (prf_objc_src_inf_tree (lib_object_contents poid)))
			(stm_objc_src_proofs (lib_object_contents soid)); ()) ? ()))
	(lib_statements (lib_list ())));
   acc
;;


let monitor_stm soid =
 let poids = stm_objc_src_proofs (lib_object_contents soid) in
   if poids = [] 
      then fail `monitor_stm: none.`
      else ( start_refine_monitoring ();
	     monitor_prf (hd poids) soid; 
	     report_refine_monitoring ();
	     stop_refine_monitoring ();
	    ())
;;


let nuprllight_ascii_cmd persist data =
 make_term (`!faux_ascii`, nil)
   [[], persist; [], data]
;;

let nuprllight_ascii_cmd_q persist =
 make_term (`!faux_ascii`, nil)
   [[], persist]
;;


let nuprllight_mbs_cmd term =
 make_term (`!faux_mbs`, nil)
   [[], term]
;;


%
;;;;	
;;;;	
;;;;	Stm+Prf
;;;;	  SymbolicAddress : !token{<t>:t} !tok_cons list
;;;;	
;;;;	
;;;;	nl functions library calls.
;;;;	
;;;;	mp_list_root_module	: unit -> tok list
;;;;	mp_list_module_thm	: tok list -> (tok # term {inf_sequent}) list
;;;;	mp_list_module		: tok list -> (tok list) list {dependencies} # (tok # term) list {thms}
;;;;
;;;;	mp_list_display		: (tok list) list -> (prec? # (tok # term) list) list
;;;;	
;;;;	mp_thm_create_and_set	: object_id {stm} -> term -> unit
;;;;	mp_thm_create		: object_id {stm} -> unit
;;;;	mp_thm_set_goal		: object_id {stm} -> term -> unit
;;;;
;;;;	mp_lookup_proof		: object_id {stm} -> term {inf_tree}
;;;;
;;;;	mp_undo			: term{symaddr} -> term{address} -> term {inf_tree}
;;;;	mp_refine		: term{symaddr} -> term{address} -> term{tactic} -> term {inf_tree}
;;;;
;;;;	
;;;;	
%    

let nuprllight_create_set_cmd t1 t2 =
 make_term (`!mp_create_set`, nil)
   [([], t1); ([], t2)]
;;

let mp_command name tl = mk_simple_term name tl;;
   
%let mp_eval_command = orb_eval_command  `ANY` metaprl_refiner_description_term;;%

let mp_eval_command_to_term = orb_eval_command_to_term  `ANY` metaprl_refiner_description_term;;

% let mp_eval_asynch_command_to_term command =
  orb_eval_asynch_with_completion metaprl_refiner_description_term
                                  (command, nil) %%posure%%
				  jprover_ref_notify
;;
%

let destruct_mp_ref_term term =
     let ((id, parms),
	  [([],goal);
	    ([],subgoals);
	    ([],extras)]) = destruct_term term in
     
     (goal, subgoals, extras)
;;

let destruct_mp_prf_term term =
     let ((id, parms),
	  [([],goal);
	    ([],tac); 
	    ([],children);
	    ([],extras)]) = destruct_term term in
     
     (goal, tac, children, extras)
;;

let mp_list_root_module	(():unit) =
  let term = mp_eval_command_to_term (mp_command `!mp_list_root` [])
  in term_to_tokens term
;;
    
  
let dest_mp_edit = destruct_mp_prf_term ;;
    
%returns list of deependencies of the module and lists of pairs of object names 
and sequents for each kind of object%
let mp_list_module_aux command tokens =
  let result = mp_eval_command_to_term (mp_command command [(tokens_to_term tokens)]) in
    let dependencies = 
      map (\x.[x]) (map_isexpr_to_list icons_op token_of_itoken_term (ihead result)) in
    let (w, c, a, r) = dest_mp_edit (itail result) in

    let f t =
     map (\x. ((token_of_itoken_term (ileft x)), (iright x))) 
	(map_isexpr_to_list icons_op (\x. x) t) in
    (dependencies, (f w, f c, f a, f r))
;;

let mp_list_module = mp_list_module_aux `!mp_list_module`;;
let mp_list_module_prfs = mp_list_module_aux `!mp_list_module_prfs`;;

let mp_list_module_thm tokens =
  map_isexpr_to_list icons_op (\x. ((token_of_itoken_term (ihead x)), (itail x))) 
    (mp_eval_command_to_term (mp_command `!mp_list_module_thm` [(tokens_to_term tokens)]))
;;
  
let mp_list_display ltokens =
  let term =
  mp_eval_command_to_term (mp_command `!mp_list_display`
				      [(map_to_ilist (\x.x) ilist_op (map tokens_to_term ltokens))])
  in let f t = (ileft t,
      map_isexpr_to_list icons_op (\x. ((token_of_itoken_term (ileft x)), (iright x))) (iright t)) in
      map_isexpr_to_list icons_op f term
;;
  
let mp_thm_create_and_set oid goal =
   mp_eval_command_to_term (mp_command `!mp_create_set` [(objc_property (oc oid) `SYMBOLICADDRESS`);
						goal]); ()
;;
let term_break v = (mk_simple_term v []) = (mk_simple_term v []) ;;
let mp_thm_set tokens goal =
  %term_break `set`;%
  let rsp = mp_eval_command_to_term (mp_command `!mp_set_thm` [(tokens_to_term tokens);
					   goal]) in
    if alpha_equal_terms ivoid_term rsp then () else fail
;;
let mp_rw_set tokens goal =
  %term_break `setrw`;%
  let rsp = mp_eval_command_to_term (mp_command `!mp_set_rw` [(tokens_to_term tokens);
					   goal]) in
    if alpha_equal_terms ivoid_term rsp then () else fail
;;
let mp_thm_create oid =
  mp_eval_command_to_term (mp_command `!mp_thm_create` [(objc_property (oc oid) `SYMBOLICADDRESS`)]); ()
;;  
let mp_lookup_proof tokens =
  let term = mp_eval_command_to_term (mp_command `!mp_lookup_proof` [(tokens_to_term tokens)])
  in let (goal, tac, s, e) = destruct_mp_prf_term term
  in dummy_mp_to_proof goal tac s e
;;			       

let mp_refine symaddr addr tac =
  let term = mp_eval_command_to_term (mp_command `!mp_refine` [symaddr;
				       addr %(map_to_ilist (\x. inatural_term x) icons_op il)%;
					   tac])
  in let (goal, c, e) = destruct_mp_ref_term term
  in dummy_mp_to_inf_tree goal tac c e
;;
  
let mp_save oid =
  mp_eval_command_to_term (mp_command `!mp_save` [(objc_property (oc oid) `SYMBOLICADDRESS`)])
;;			       

%name is cons term of tokens%					    
let mp_save_thy name =
  mp_eval_command_to_term (mp_command `!mp_save_thy` [name])
;;			       

  
let lib_refine desc goal tac envoid oids =
 let sys = system_of_description_term desc in

   if sys = `NUPRL` then lib_nuprl_refine desc goal tac envoid oids
   else
   if sys = `metaprl` then
   % if do_faux_ref then lib_nuprllight_refine desc (address_of_goal goal) tac oids else%
   % above was used for testing %
        (let addr = address_of_goal goal and saddr = symaddr_of_goal goal and
	    sequent = unnumber_sequent_term  (sequent_of_goal goal) and soid = hd (tl oids) in %lal was hd oids%
            %descendent (root `Modules`) (tl (term_to_tokens saddr))% %LAL opt: first in oids is soid of proof%
                       
	    if top_address_p addr then %user can only modify top goal%
	       (if (not (alpha_equal_terms sequent (objc_source (lib_object_contents soid)))) ? false then    
                (%term_break `not=`; %
		put_term soid sequent) %this also modifies in mp %
	        else () % raise_error [soid] [`lib`; `refine`; `subgoal`; `modified`] [sequent; addr]%);

	     mp_refine saddr addr tac)
	
   else (raise_error oids [`lib`; `refine`; sys] [desc; goal; tac]; 
	  % following is meaningless: only present for compiler to type else correctly%
	  lib_nuprl_refine desc goal tac envoid oids)
;;

let lib_refinet desc goal tac envterm =
 let sys = system_of_description_term desc in
   if sys = `NUPRL` then lib_nuprl_refinet desc goal tac envterm
   else (raise_error nil [`lib`; `refine`; sys] [desc; goal; tac]; 
	% following is meaningless: only present for compiler to type else correctly%
	 fail)
;;
   
let mp_undo symaddr =
   let term = mp_eval_command_to_term (mp_command `!mp_undo` [symaddr])
   in
   let (goal, tac, s, e) = destruct_mp_prf_term term
   in %test if goal diff%
   let soid = descendent (root `Modules`) (tl (term_to_tokens symaddr)) in 
     if not (alpha_equal_terms goal (objc_source (lib_object_contents soid))) then    
             (%term_break `not=`; %put_term soid goal);
     dummy_mp_to_proof goal tac s e

   
;;
%
let refine_undo poid =
  let pobjc = oc poid in
  let desc = objc_property pobjc `DESCRIPTION` in
  let sys = system_of_description_term desc in

  if	   sys = `NUPRL`	then (failwith `nv5 undo not expected`; ivoid_term)
  else if sys = `metaprl`	then
  (let itree = (mp_undo (objc_property pobjc `SYMBOLICADDRESS`))
		  
  in let new_pobjc = prf_objc_src_import_inf_tree pobjc itree
  in save poid new_pobjc;
  let tree = prf_objc_src_inf_tree new_pobjc in
  let status = 
    if inf_tree_complete_p tree then iproof_status_term `complete`
    else iproof_status_term `incomplete`
  in inf_tree_to_iproof_editor_term tree status inat_nil_term `d`)
  else (failwith `undo refiner unknown`; ivoid_term)
;;   
%

	    
%
let mp_testascii () =
   let term = get_persist () in
   orb_eval_command_to_term `ANY` (metaprl_refiner_description_term)
    (nuprllight_ascii_cmd_q term)
 
;;

let lib_nuprllight_ascii () =
  let c = lib_get_pd () in
  orb_eval_command_to_term `ANY` (metaprl_refiner_description_term)
    (nuprllight_ascii_cmd (ihead c) (itail c))
 
;;

let lib_nuprllight_ascii_q () =
  let c = lib_get_pd () in
  orb_eval_command_to_term `ANY` (metaprl_refiner_description_term)
    (nuprllight_ascii_cmd (ihead c))
 
;;
%

let add_code_order_properties namelist =
 let nl = map_isexpr_to_list icons_op (\x. x) namelist in
  letrec addpr oid l =
    if null l then ()
    else let hoid = (hd l) and tl = tl l in
    (put_property hoid `code-order` (ioid_term oid);
    addpr hoid tl) in
  if null nl then ()
  else addpr (name_to_oid (hd nl)) (names_to_oids (tl nl))
;;


let add_code_order_properties_to_oids oids =
  letrec addpr oid l =
    (if null l then ()
     else let hoid = (hd l) and tl = tl l in
           ( put_property hoid `code-order` (ioid_term oid)
	   ; addpr hoid tl
	   ; ()))
    in
  if null oids then ()
  else addpr (hd oids) (tl oids)
;;

let remove_code_order_properties namelist =
 let nl = map_isexpr_to_list icons_op (\x. x) namelist in
  letrec addpr oid l =
    if null l then ()
    else let hoid = (hd l) and tl = tl l in
    (remove_property hoid `code-order`;
    addpr hoid tl) in
  if null nl then ()
  else addpr (name_to_oid (hd nl)) (names_to_oids (tl nl))
;;

let deactivate_duplicate_lemmas () =
  map deactivate (ref_eval_to_object_ids (null_ap (itext_term "find_duplicate_lemmas() ")));;

let deactivate_duplicate_abs () =
  map deactivate (ref_eval_to_object_ids (null_ap (itext_term "find_duplicate_abs() ")));;

let lib_unfold term = ref_eval_to_term (term_ap (begin_ap "unfold_ab ") term)
;;

let pop_a_prf soid =
 let pobjc = oc soid in
 let prfs = stm_objc_src_proofs pobjc in
 if (length prfs) > 1 then save soid (stm_objc_src_modify_proofs pobjc (tl prfs))
 ; ()
;;

let lib_refine_tree eoid tgoal tttt = 
 ref_eval_to_term (term_ap (term_ap (oid_ap (begin_ap "ref_refine_tree ") eoid) tgoal) tttt)
;;

let reduce_tactic t = source_reduce t ``ML INF``;;

letref ggbug = ivoid_term;;
let build_inf desc iinf_tree g tac  =
 %let gg, n, a, children = destruct_iinf_tree_term iinf_tree in%
 tty_print "build_inf";
 ggbug := g;
 let iobjc = inf_objc_refined 
                 (objc_add_property (objc_modify_source (inf_objc (destruct_igoal g))
							tac)
                     `DESCRIPTION`
                     desc)
                 iinf_tree in
 tty_print "build_inf2";
  add_object iobjc
;;
 

let tttt_to_proof desc eoid goal tttt =
 % probably should reduce goal too. %
 let rtttt = tttt_map reduce_tactic tttt in
 let igoal = (igoal_term (goal, nil)) in
 let r = lib_refine_tree eoid igoal rtttt in

  if (ivoid_term_p r) then failwith `tttt_to_proof` else

  % build an inf_tree %
  letrec build itree tttt igoal =
   let n = (ihead itree)
   and t = (ihead tttt) in
   let nchildren = map_ilist_to_list (icons_op) id (itail itree)
   and tchildren = children_of_tttt tttt  in
   let subgoals = subgoals_of_iinf_tree n in
    inf_tree (build_inf desc n igoal t) 
             (map3 build nchildren tchildren subgoals)

     in let poid = inf_tree_to_prf desc (build r tttt igoal) in
         activate_prf poid;
	 poid
;;

let tttt_to_proof_finish desc igoal tttt r = 

  if (ivoid_term_p r) then failwith `tttt_to_proof` else

  % build an inf_tree %
  letrec build itree tttt igoal =
   let n = (ihead itree)
   and t = (ihead tttt) in
   let nchildren = map_ilist_to_list (icons_op) id (itail itree)
   and tchildren = children_of_tttt tttt  in
   let subgoals = subgoals_of_iinf_tree n in
    inf_tree (build_inf desc n igoal t) 
             (map3 build nchildren tchildren subgoals)

     in let poid = inf_tree_to_prf desc (build r tttt igoal) in
         activate_prf poid;
	 poid
;;


let tttt_complete_p tttt r = 

  if (ivoid_term_p r) then false else

  % build an inf_tree %
  letrec build itree tttt =
   let n = (ihead itree)
   and t = (ihead tttt) in
   let nchildren = map_ilist_to_list (icons_op) id (itail itree)
   and tchildren = children_of_tttt tttt  in
   let subgoals = subgoals_of_iinf_tree n in
      ( all id (map2 build nchildren tchildren)
      ? false
      )

    in ( (build r tttt)
       ? false )
;;

let tttt_to_partial_inf_tree desc igoal tttt r = 
  %view_showd `RICH` r;%
  if (ivoid_term_p r) then failwith `tttt_to_proof` else

  let build_unrefined g =
    inf_tree (add_object (objc_add_property (inf_objc (destruct_igoal g))
                         `DESCRIPTION`
                          desc))
      nil in
   
  % build an inf_tree %
  letrec build itree tttt igoal =
   (let n = (ihead itree)
   and t = (ihead tttt) in
   let nchildren = map_ilist_to_list (icons_op) id (itail itree)
   and tchildren = children_of_tttt tttt  in
   let subgoals = subgoals_of_iinf_tree n in
    
    inf_tree (build_inf desc n igoal t) 
               ( (map3 build nchildren tchildren subgoals)
	       ? (map build_unrefined subgoals)
	       )
     ) ? (build_unrefined igoal)

    in ( (build r tttt igoal)
       ? (build_unrefined igoal))
;;

let tttt_to_partial_proof_finish desc igoal tttt r = 
 
 if (ivoid_term_p r) then failwith `tttt_to_proof`
 else
  inf_tree_to_prf desc
   (tttt_to_partial_inf_tree desc igoal tttt r)
;;


let complete_thy_reference_environment dir = 
 descendent dir [`reference environment`; (name_property dir) ^ `_complete`]
;;


let obid_of_abstraction_term_ap = (begin_ap "obid_of_abstraction_term");;

let find_obid_of_abstraction t =
   (obid_of_abstraction_term t)
 ? (ref_eval_to_object_id (term_ap obid_of_abstraction_term_ap t))
;; 


% finds refenv oids not listed in dirs and thus presumably garbage.

(view_showd_oids `RICH`
 (filter (\oid. not (string_match_f false "@$" (tok_to_string (name_property oid))) ? false)
  (diffoids
   (map_lib ``CODE`` true
      (\oid oc. (lex_equal_terms nuprl5_refiner_description_term (description_of_objc oc))   
              & (can (term_find (is_term_id `!make_reference_environment`)) (objc_source oc)))) 
   (unionoids (subtree_oids false (root `theories`))
	      (subtree_oids false (root `system`))))))

%
