%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%

let ienvironment_address_term addr = 
  make_term (`!environment_address`, map (\a. make_token_parameter a) addr) nil;;

let tags_of_ienvironment_address_term t =
  let (op, bts) = destruct_term t in
   let (opid, tags) = op in
    map destruct_token_parameter tags
;;

% following is kludge should not be advertised. %
letref remote_orb_address = []:tok list;;			    

%  connects to port for output and opens socket at edd_port for input%
let orb_connect_to_port remote_port host local_port =  
 let oa = orb_address() in
  orb_connect remote_port host local_port;

  % exchange orb addresses %
  orb_send_address remote_port;
  remote_orb_address := orb_request_address remote_port;

  % make remote be transaction manager %
  subscribe_transaction false remote_orb_address;

  % it %
  orb_send_bus_link_properties remote_port [`IT`, ibool_term true];

  orb_compressed_stream remote_port
;;

% port should be the port of the out-stream to ensure uniqueness%
let orb_disconnect_from_port port =  

 %let oa = orb_address() in
 let ba = orb_bus_orb port in %

  orb_uncompressed_stream port;

  % stop it requesets %
  orb_send_bus_link_properties port [`IT`, ibool_term false];

  % revoke orb addresses %
  orb_unrequest_address port;
  orb_unsend_address port;

  orb_disconnect port 
;;


let find_local = orb_match_local_environment;;

let connect rp rh lp = orb_connect_to_port rp rh lp;;
let disconnect lp = orb_disconnect_from_port lp;;		% Local port or remote port %



%

	remote eval : unmarshall and apply

%


let TtoS = string_of_istring_term;;
let TtoN = number_of_inatural_term;;
let TtoB = bool_of_ibool_term;;
let TtoO = oid_of_ioid_term;;
let TtoSomeO = some_of_isome_oid;;
let TtoSomeT = some_of_isome_term;;
let TtoOs = oids_of_ioid_term;;
let TtoT = token_of_itoken_term;;
let TtoTs = tokens_of_itokens_term;;
let TtoSs = strings_of_istring_term;;
let TtoCl t = let l = map_ilist_to_list icons_op (\x.x) t in (hd l, tl l);;
let TtoTerms = map_ilist_to_list icons_op (\x.x);;

let Unmarshall_ap um f = \l. (f (tl l)) (um (hd l));;

let Null_ap f = \l. if l = [] then f else failwith (`Null_ap` ^ (int_to_tok (length l)));;
let Terms_ap f = \l. f l;;
let String_ap f = Unmarshall_ap TtoS f;;
let Nat_ap f = Unmarshall_ap TtoN f;;
let Bool_ap f = Unmarshall_ap TtoB f;;
let Token_ap f = Unmarshall_ap TtoT f;;
let Oid_ap f = Unmarshall_ap TtoO f;;
let SomeOid_ap f = Unmarshall_ap TtoSomeO f;;
let SomeTerm_ap f = Unmarshall_ap TtoSomeT f;;
let Oids_ap f = Unmarshall_ap TtoOs f;;
let Tokens_ap f = Unmarshall_ap TtoTs f;;
let Strings_ap f = Unmarshall_ap TtoSs f;;
let Term_ap f = Unmarshall_ap (\t:term.t) f;;
let TermList_ap f = Unmarshall_ap TtoTerms f;;
let Unit_ap f = Unmarshall_ap (\t:term.()) f;;
let DDG_ap f = Unmarshall_ap term_to_ddg f;;

let Posure_ap f = Unmarshall_ap (\t:term. TtoCl t) f;;



let uosa port =
 tty_print "should NOT be used in LIBRARY, use losa instead";
 orb_start_application_server_accept port
;;


letref lib_ports_connected = (config_sockets() ? (0, 0));;
letref lib_host = (config_libhost() ? "");;
letref lib_env = (config_libenv() ? "");;

let set_lib_host host =
 lib_host := host
;;

let set_lib_env env =
 lib_env := env
;;

let set_local_port port =
 let (i, j) = lib_ports_connected in
 lib_ports_connected := (i, port)
 
;;

let setup_connect i j =
 lib_ports_connected := (i, j);
 (\host. lib_host := host)
;; 

% for single socket %
let set_con i =
 lib_ports_connected := (i, 0);
 (\host. lib_host := host)
;; 

let setup_config_connect () =
 let (i,j) = config_sockets() in
   ((setup_connect i j) (config_libhost()))
;;   

	 
let do_connect () =
  connect (fst lib_ports_connected) lib_host (snd lib_ports_connected)
;;
  
let do_disconnect () =
  disconnect (fst lib_ports_connected);;

let dc = do_connect;;
let dd = do_disconnect;;

let cleanup_connection tok = cleanup_bus_link (orb_match_bus_environment [tok]);;
let cc = cleanup_connection;;
  
let connected_p () = (can orb_bus_orb (fst lib_ports_connected)) ;;



let orb_eval_args_by_address addr posure =  orb_eval_args `ONE` (itokens_term addr) posure;;


letref client_broadcasts =
 [ `edd`, ``EDIT-LIBRARY ABSTRACTIONS TERMS OSTATES DDG CODE DFORMS PRECEDENCES``
 ; `ref`, ``STATEMENTS ABSTRACTIONS CODE RULES``
 ; `as`,  ``CODE``
 ] 	  
;;

% primarily used by refiner to set properties of refiner in connected lib environment.
%

let modify_environment_properties_t addrt = 
 modify_environment_properties (tags_of_ienvironment_address_term addrt) 
;;

let modify_environment_property_aux addr name term =
  modify_environment_properties_t addr (\props. update_insert_alist props name term)
;;
   
let remove_environment_property_aux addr name =
  modify_environment_properties_t addr (\props. remove_alist_entry props name)
;;

let set_environment_bool_property name b addr =
  modify_environment_properties addr (\props. update_insert_alist props name (ibool_term b))
;;

let set_environment_idle_property = set_environment_bool_property `IDLE`;;

let set_environment_priority_property_aux addr i =
  modify_environment_properties_t addr
    (\props. update_insert_alist props `PRIORITY` (inatural_term i))
;;

let show_environment_properties_aux addrt =
 property_list_to_term
   (show_environment_properties (tags_of_ienvironment_address_term addrt))
;;

   
% eval in edit to get asynch pop-ups to one editor. kind of a kludge.
lib_set_environment_bool_property `MAIN` true;;

;; indicate to server that reqs can be sent (by default imported envs are IDLE):
lib_set_environment_bool_property `IDLE` false;;
%

let connect_to_lib_env tag locala =
 let roa = remote_orb_address  % at some point may want better method of choosing orb %
 in 
  orb_send_environment_address roa locala;
  let liba = orb_request_environment_address roa [`lib`; tag] in

    orb_send_environment_description roa locala;
    orb_request_environment_description roa liba;

    % locally, set lib not IDLE
      needs to com before orb_connect environments since once connected anonymous mods not allowed
    %
    set_environment_idle_property false liba;

    orb_connect_environments locala liba;
						
    liba
;;
							       
let set_idle b remotea locala =
 orb_send_environment_properties remotea locala [`IDLE`,(ibool_term b)]
;; 

letref restart_name = null_token;;
letref restart_kind = null_token;;
letref restart_event_synchronization_stamp = ivoid_term;;
letref client_broadcasts_recall = nil : (tok list # tok list) list;;

let add_client_broadcasts_recall clientaddr broadcasts =
  client_broadcasts_recall := (clientaddr, broadcasts) . client_broadcasts_recall
;;

let recall_client_broadcasts clientaddr = apply_alist client_broadcasts_recall clientaddr ;;  

let finish_start_aux f kind synchro locala liba = 
 restart_kind := kind;
 subscribe synchro liba ((recall_client_broadcasts locala)
			 ? (let bs = apply_alist client_broadcasts kind in
			     add_client_broadcasts_recall locala bs
			     ; bs));
 ((set_idle false liba locala) ? ());
 ((f liba locala) ? ())
;;

let finish_start_aux_null = finish_start_aux (\a b. ());;

let start_aux finish_ap synchro name locala =
 let liba = connect_to_lib_env name locala in

  orb_queue_asynch_local_by_address true locala
    (tokens_ap (tokens_ap (some_term_ap finish_ap synchro) locala) liba)
 ; ()
;;
 
let open_aux openf =
 if not (connected_p ()) then dc();
 openf (string_to_tok lib_env)
;;

let close_aux closef =
  closef (string_to_tok lib_env)
;;


let local_close tag = 
  close_environment (orb_match_local_environment [tag]) true false
;;  

let disconnect_from_lib_env locala liba   =  
 let roa = remote_orb_address  % at some point may want better method of choosing orb %
 in
    (orb_unconnect_environments locala liba ? ());  % may fail if was not connected in first place %
    orb_unrequest_environment_address roa liba;
    orb_unsend_environment_address roa locala
;;

% unsubscribe should be done in global transaction in client environment
  then disconnect could be done in local transaction (could be in global?)

  orb_queue_asynch_local_by_address true locala
    ... unsubscribe [which queues up disconnect at end?]...

  finish_ap : some Posure
  synchro : some term

%


let stop_finish finish_posure exitp name liba locala synchro = 

 inject_trace_message `stop_finish` (itoken_term `disconnect`);
 disconnect_from_lib_env locala liba;

 if (isr finish_posure) 
    then (restart_event_synchronization_stamp := outr synchro;
          restart_name := name;
	  let p = token_ap (term_to_posure (outr finish_posure)) name in
	    local_eval_apply (fst p) (snd p)
	  ; ())
%          (orb_queue_asynch_local false (token_ap (term_to_posure finish_ap) name)))
%
 else (local_close name; ())

 % probably should be some recursion to check for other connections to close
   but FTTB there will be only one.
 %
 ; if exitp then (dd (); exit ())		   
;;

let stop_unsubscribe finish_posure exitp name liba locala =
 inject_trace_message `stop_unsubscribe` (itoken_term `before`);
 let synchro = (unsubscribe (isr finish_posure) liba (recall_client_broadcasts locala) ? (inl ())) in

  inject_trace_message `stop_unsubscribe` (itoken_term `after`);
  orb_queue_asynch_local_by_address false locala
  (some_term_ap (tokens_ap (tokens_ap (token_ap (bool_ap (some_term_ap (begin_ap "stop_finish")
							               finish_posure)
							 exitp)
						name)
				      liba) locala) synchro)
 ; ()
;;
  

let stop_aux finish_ap exitp name =
 let locala = orb_match_local_environment [name] in
 let liba = orb_match_bus_environment  [`lib`; name] in

 set_idle true liba locala;
 orb_queue_asynch_local_by_address true locala
  (tokens_ap (tokens_ap (token_ap (bool_ap (some_term_ap (begin_ap "stop_unsubscribe")
						         (if (isl finish_ap) then inl()
						          else inr (posure_to_term (outr finish_ap))))
					   exitp)
				  name)
			liba) locala)
 ; ()
;;  
					
let old_stop_aux syncp finish_ap name =
 let locala = orb_match_local_environment [name] in
 let liba = orb_match_bus_environment  [`lib`; name] in

 set_idle true liba locala;
					
 let synchro = (unsubscribe syncp liba (recall_client_broadcasts locala) ? (inl ())) in
   disconnect_from_lib_env locala liba;

 if (isr synchro) 
    then (restart_event_synchronization_stamp := outr synchro;
          restart_name := name;
          (orb_queue_asynch_local false (token_ap (outr finish_ap) name)))

 else (local_close name; ())
;;

let stop_aux_nosync = stop_aux (inl ());;

  
let envs (():unit) = (orb_local_environments(), orb_bus_environments());;


%let eval_with_props props  =
  local_eval_apply_wprops (term_to_property_list props)
;;
%

let with_transaction_properties posure = posure
% now mostly done implicitly by asynch evals
 let props = get_transaction_properties () in
  if null props then posure
  else
   (posure_ap
     (term_ap (begin_ap "eval_with_props")
	      (property_list_to_term props))
     posure)
%;;

letref iam = inl () : unit + tok;;

let current_description () =
 let purps = purposes_of_description_term (current_description_aux ()) in
  if (member `LIBRARY` purps) then nuprl5_library_description_term
  if (member `REFINER` purps) then nuprl5_refiner_description_term
  if (member `EDIT` purps) then nuprl5_edit_description_term
  else fail
;;  

   

%%%
	generic client environment creation and connection.
%%%

let new_environment_aux purposes resources reductions kind tag = 
  client_broadcasts := (kind, resources) . (filter (\e. not (kind = fst e)) client_broadcasts);
  let clientaddr = [sys_version(); orb_name(); kind; tag] in
   new_environment clientaddr purposes nil %resources% nil reductions;

   start_aux (token_ap (begin_ap "finish_start_aux_null") kind)
     (inl()) tag clientaddr
;;

let close_environment_aux tag =
 stop_aux_nosync false tag 
;; 

let new_simple_environment kind = 
  new_environment_aux nil nil [kind] kind
;;

% became no-op since expect ORB to do Transaction processing. %
let new_transaction_client_environment purposes resources reductions = 
  new_environment_aux 
   purposes
   resources
   reductions
;;

let new_code_client_environment purposes resources =
 new_transaction_client_environment purposes 
   (`CODE` . resources) 
;;

let client_eval_to_term_aux addr posure =
  orb_eval_args_to_term `ONE` (itokens_term addr) posure;;  

let client_eval toks = client_eval_to_term_aux (orb_match_bus_environment toks);;

let client_eval_to_unit toks posure =
  orb_eval_args `ONE` (itokens_term (orb_match_bus_environment toks)) posure
;;

let client_eval_to_term toks posure =
 orb_eval_args_to_term `ONE` (itokens_term (orb_match_bus_environment toks)) posure
;;
 
let client_eval_to_terms toks posure =
 (make_terms_return
  (orb_eval_args_to_term `ONE` (itokens_term (orb_match_bus_environment toks))) posure)
;;

let new_demand_environment kind tag =
 new_environment_aux nil nil nil kind tag
;; 


%
;; new_code_client_environment nil nil nil `sun` `markb`;;
;; new_code_client_environment nil nil nil `linux` `markb`;;
;;	new_code_client_environment nil nil nil `PVS` `markb`;;
;;	close_environment_aux `markb`;;
%



letref notify_idle_hooks = nil : (tok # (tok list) # (tok list -> unit)) list;;
let add_notify_idle_hook name hook =
 notify_idle_hooks := (name, (current_environment_address()), hook) . (remove_if (\n,h. n = name) notify_idle_hooks)
;;

let call_notify_idle_hooks () =
 map (\n,a,h. h a) notify_idle_hooks
 ; ()
;;
					      

let queue_quit name = 
  orb_queue_asynch_local_by_address true (orb_match_local_environment name)
    (unit_ap (begin_ap "quit"))
;; 



let finish_client_disksave diskf name =

    tty_print "quit_toploop"
    ; quit_toploop ()
    ; tty_print "do_disconnect"
    ; do_disconnect ()
    ; tty_print "close local orb"
    ; close_environment (orb_address()) true false
    ; tty_print "dodisk"
    ; diskf name
    ; tty_print "local_close"
    ; local_close name
    ; exit ()
;;

    
