/*
 * Nuprl5
 * Unix file system functionality
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <fcntl.h>
#include <unistd.h>


int libc_mkdir (name)
char *name;
{
	int u, r;
	u = umask(0);
	r = mkdir (name, S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IWGRP | S_IXGRP | S_IROTH | S_IXOTH);
	umask (u);
	return(r);
  
}

int libc_chmod (name)
char *name;
{
	int u, r;
	u = umask(0);
	r = chmod (name, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH);
	umask (u);
	return(r);
  
}

int libc_rmdir (name)
char *name;
{
	rmdir(name);
}

int libc_umask (mode)
int mode;
{
	 umask(mode);
}

int libc_create (filename)
char *filename;
{	
	int u, r, fd;
	u = umask(0);
	fd = creat(filename, S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH);
	umask(u);
	close (fd);
	return(fd);
}


int lock_reg(fd, cmd, type, offset, whence, length)
 int fd, cmd, type, whence;
 off_t offset, length;
{
	struct flock lock;
	 lock.l_type = type;
	 lock.l_start = offset;
	 lock.l_whence = whence;
	 lock.l_len = length;
	
	 return(fcntl(fd, cmd, &lock));
}

int lock_test(fd, type, offset, whence, length)
 int fd, type, whence;
 off_t offset, length;
{
	struct flock lock;
	 lock.l_type = type;
	 lock.l_start = offset;
	 lock.l_whence = whence;
	 lock.l_len = length;
	
	 if (fcntl(fd, F_GETLK, &lock) < 0)
	 return(-1);
	 if (lock.l_type == F_UNLCK)
	 return(0);
	 return (lock.l_pid);
	 
}

int read_lock_test(fd)
{
	 return(lock_reg(fd, F_SETLK, F_RDLCK, 0, SEEK_SET, 1));

}

int write_lock_test(fd)
{
	 return(lock_reg(fd, F_SETLK, F_WRLCK, 1, SEEK_SET, 1));
}

int read_lock(fd)
{
	 return(lock_reg(fd, F_SETLK, F_RDLCK, 1, SEEK_SET, 1));

}

int write_lock(fd)
{
	 return(lock_reg(fd, F_SETLK, F_WRLCK, 0, SEEK_SET, 1));
}

int isread_lock(fd)
{
	 return(lock_test(fd, F_WRLCK, 1, SEEK_SET, 1));

}

int iswrite_lock(fd)
{
	 return(lock_test(fd, F_RDLCK, 0, SEEK_SET, 1));
}

int iswrite_lock_file(name)
char *name;
{
	FILE *ffd;
	int lock_p, fd;
	fd = open(name, O_RDONLY, 0);
	lock_p = iswrite_lock(fd);
	close(fd);
	return(lock_p);
}

int un_lock(fd)
{
	 return(lock_reg(fd, F_SETLK, F_UNLCK, 0, SEEK_SET, 1));

}

int un_lock_read(fd)
{
	 return(lock_reg(fd, F_SETLK, F_UNLCK, 1, SEEK_SET, 1));

}

int read_modes(filename)
 char *filename;
{
	 if (chmod (filename, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH) < 0)
	 return(-1);
	 return(0);

}

int owner_uid(name)
 char *name;
{
	struct stat buf;
	int uid;
	stat(name, &buf);
	uid =  buf.st_uid;
	/*printerr ("%d:", uid);*/
	return(uid);
	  
}
int libc_atime(name)
 char *name;
{
	struct stat buf;
	struct tm *tm;
	 struct tm tt;
	time_t *clock;
	 int s, m, h, d, mo, y;
	stat(name, &buf);
	/*time(clock);*/
	 clock = &buf.st_atime;
	tm = localtime(clock);
	tt = *tm;
	d = tt.tm_mday;
	mo = 1 + tt.tm_mon;
	y = tt.tm_year;
	h = tt.tm_hour;
	m = tt.tm_min;
	s = tt.tm_sec;
	/* printf ("%d:%d:%d:%d:%d:%d\n",s, m, h, y, d, mo);*/
	return(60*(24*(mo*31 + y*12*31 +d)+ h) + m);
	  
}

char *libc_asctime(name)
 char *name;
{char *s;
	struct stat buf;
	struct tm *tm;
	 struct tm tt;
	time_t *clock;
	time(clock);
	/*stat(name, &buf);
	 clock = &buf.st_atime;
	tm = gmtime(clock);
	tt = *tm;*/
	 s = ctime(clock);
	 printf ("%s:", s);
	return(s);
	  
}
/*
main ()

{ char *s;
int i;
 printf ("%d\n", 5);
  l = (libc_mkdir("/usr/u/nuprl/nuprl5L/NuPrlDB/tempd"));
 i = libc_atime("/usr/u/nuprl/nuprl4i/nuprl5L/sys/src/io-db.lsp");
  printf ("%d\n", i);
}

*/
