%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2003                                *
;;;                                                                       *
;;;                                                                       *
;;;                Formal Digital Library System                          *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the FDL group, Department of Computer Science,         *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify FDL provided this notice    *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;                                                                       *
;;;************************************************************************
%


let new_library tag =
  let ea = [sys_version(); `lib`; tag; (string_to_tok "0")] in

   % I believe we know desire the ObjectIdDag table to be available locally. Twould seem
     we would need ObjectIdDag in the purpose list as well as the TERMS resource tag?
   %
   new_environment ea
   		   ``ObjectIdDAG LIBRARY`` 
		   ``LIBRARY ABSTRACTIONS CODE TERMS``
		   ``LIBRARY ABSTRACTIONS DFORMS TERMS CODE
		     PRECEDENCES STATEMENTS PROOFS RULES OSTATES DDG``
		   ``LIB LIBRARY``;

   % todo ??? shouldn't broadcast to self be implicit???  is there a diff between resouces and types broadcast?
     journal restarts by starting broadcasts for resource types!
   %
   subscribe (inl ()) ea ``LIBRARY ABSTRACTIONS CODE TERMS``;
   %orb_start_broadcasts ea ea%
   environment_start_journal ea ``TRANSACTION LIBRARY``;
   ea

;;

% TODO mill callers and remove %   
let with_remote_properties p = p;;
   
	       
