
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************


#+cltl2(in-system-package)
#-cltl2(in-package *system-package-name*)

;;;;
;;;; -docs- (mod ref top ml)
;;;;	 
;;;;	rcomp &optional lisp-p ml-p tactics-p
;;;;	 * args default to t. To avoid compilation supply nil.
;;;;	   Eg, (rcomp t t nil) avoids tactic compilation.
;;;;	 
;;;;	rcomp 	: bool -> bool -> bool -> unit
;;;;	
;;;;	withref &body body
;;;;	  * evals in ref  environment.
;;;;
;;;;	
;;;;	connect	: int{remote-port} -> string{remote-hostname} -> int{local-port} -> unit
;;;;	open	: tok -> unit
;;;;	close	: tok -> string{journal stamp}  list
;;;;	
;;;;	EG.
;;;;	connect 6289 "DENEB" 2896;;
;;;;	connect 4289 "DENEB" 2894;;
;;;;	connect 6289 "ALFHEIM" 2896;;
;;;;	
;;;;	open `rtheories`;; 
;;;;	open `rtest`;;
;;;;	open `ltest`;;
;;;;	
;;;; -doce-


(defun do-ml-ref-compile (tactics-p &optional printp forcep)

  (com-ml-comp)
  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"library\"; \"orb\"],"
          "   [\"orbm-bsc\"])"
    
	  "; ([\"library\"; \"top\"],"
          "   [\"comm-dag\"; \"comm-nlb\"; \"comm-graph\"; \"comm-lib\"; \"comm-ref\";"
	  "   \"comm-mp\"; \"utilities\""
	  "   ])" 

	  "; ([\"refiners\"; \"nuprl5\"; \"src\"],"
	  "   [\"refm-bsc\"; \"refm-sc-com\"; \"refm-re\"; \"refm-jpr\"; \"refm-lib\"])"

	  "; ([\"library\"; \"top\"],"
          "   [\"comm-ned\""
	  "   ])" 

	  "]"
	  
	  "; load_system true false false []"
	  "[ ([\"library\"; \"top\"], [\"comm-ref\"; ])"
	  "; ([\"refiners\"; \"nuprl5\"; \"tactics\"; \"standard\"],"
	  "   [\"tactics\"; \"load-tac\"]) "
	  "]")))

  ;;(format t "~%~% dmrct ~%")
  (when tactics-p
    (if forcep
	(inml (ml-text" compile_standard_tactics()"))
	(inml (ml-text" load_standard_tactics()"))
    )))




(defun rcomp (&optional (p t) (q t) (r t) (printp nil) (forcep nil))
  (when p (funcall (intern "COMPILE-SYSTEM" (find-package "MAKE")) 'nuprl5))
  (when q (do-ml-ref-compile r printp forcep)))


;;;;
;;;;	rcomp : bool {lisp} -> bool {system ml} -> bool {tactics}
;;;;	
(defunml (|rcomp| (lisp-p ml-p tac-p))
    (bool -> (bool -> (bool -> unit)))
  (rcomp lisp-p ml-p tac-p)
  nil)

(defun rmlcomp () (rcomp nil t nil t))
(defun rmlcomptac () (rcomp nil t t nil))

(defun rmlcomp-helm (&optional tactics-p printp forcep)
  ;;(format t "~%~% dmrc ~%")
  (load "/home/nuprl/nuprll/nuprl5/sys/src/t-proof-aux.lsp")
  (com-ml-comp)
  (inml (ml-text
	 (list
	  (format-string "load_system true false ~a []"
			 (if printp "true" "false"))

	  "[ ([\"library\"; \"orb\"],"
          "   [\"orbm-bsc\"])"
    
	  "; ([\"library\"; \"top\"],"
          "   [\"comm-dag\"; \"comm-nlb\"; \"comm-graph\"; \"comm-lib\"; \"comm-ref\";"
	  "    \"comm-ned\"; \"comm-mp\""
	  "   ])" 

	  "; ([\"refiners\"; \"nuprl5\"; \"src\"],"
	  "   [\"refm-bsc\"; \"refm-sc-com\"; \"refm-re\"; \"refm-jpr\"; \"refm-lib\"])"
	  "]"
	  
	  "; load_system true false false []"
	  "[ ([\"library\"; \"top\"], [\"comm-ref\"; ])"
	  "; ([\"refiners\"; \"nuprl5\"; \"tactics\"; \"standard\"],"
	  "   [\"tactics\"; \"load-tac\"]) "
	  "; ([\"refiners\"; \"nuprl5\"; \"src\"], [\"t-proof-v5\"; ])"
	  "]")))


  ;;(format t "~%~% dmrct ~%")
  (when tactics-p
    (if forcep
	(inml (ml-text" compile_standard_tactics()"))
	(inml (ml-text" load_standard_tactics()"))
    )))



(defun init-ref-base (&optional (expand-p nil))

  (init-com-base)

  (setf *component-kind* '|ref|)

  (pushnew :nuprl-ref *features*)

  (when expand-p (expand))
  )


(defun init-ref-restart ()

  (init-com-restart)

  #|
  (when nil
    (add-transaction-end-hook 'refiner
			      #'(lambda (thl)
				  (let ((th (refiner-touch-history)))
				    (dolist (record thl)
				      (touch-history-push record th)))

				  (with-ignore (ml-text "touch_history_touched ()"))
				  )))|#

  (rehash-direct-computation-table)
  ;;(add-command-map 'ref0 #'map-command-ref0)


  (db-init (db-root-path t (find-db-path)))
  ;;(db-init (db-root-path t (car (get-config-data 'dbpath))))

  (ref-expand (car (get-config-data 'memory-profile)))
  )

(defun do-init-ref ()

  
  (init-ref-base)
  (rmlcomptac)

  (set-reload-global-alist)
  (init-ref-restart)

  ;; but if following happens then recompile tacs.
  ;; Loading bin /usr/u/nuprl/nuprl4i/nuprl5/lib/ml/standard/mlbin/lucid-sparc/load-tac.sbin.
  ;; >>Error: The symbol NUPRL5-ML-RUNTIME::|loadf_system%2959%139| has no global value

  ;;(do-ml-ref-compile t nil comptacp)

  (print-client-banner "Refiner")
  ;;(in-package 'NUPRL5)
  ;;(top)
)

(defun do-disk-init-ref ()
  (init-ref-base t)
  (rmlcomptac)

  (format t "~%;;;~%;;;	")
  (format t "~%;;;	Nuprl Refiner.~%;;;	")
  (format t "~%;;;~%;;;	(in-package \"FDL0\")(dodisk-ref)")
  (format t "~%;;;	(in-package \"FDL0\")(dodisk-ref t) ; overwrites current~%")
  (format t "~%;;;~%;;;	")

  )

(defun do-ref-restart ()
  (init-ref-restart)
  (print-client-banner "Refiner")
  (eval `(in-package ,*system-package-name*))

  #+cmu
  (read-eval-print-loop)
)

(defun do-ref-hot-start ()
  (init-ref-restart)
  (print-client-banner "Refiner")
  (eval `(in-package ,*system-package-name*))

  (format t ";;; HotStart dc() ~%")
  (ml-text "if not (connected_p ()) then (dc();())")
  
  (let ((libenv (ml-text "lib_env")))
    (unless (match-bus-environment-p (list libenv))
      (format t ";;; HotStart restart ~%")
      (with-environment ((address-of-environment (match-environment-in-list (list '|ref|) *component*)))
	(with-appropriate-transaction (nil nil)
	  (ml-text (format-string "restart_ref `~a`" libenv))))))

  (top)
)

(defun dodisk-ref (&optional overwrite)
  (dodisk #'do-ref-restart overwrite))

(defunml (|dodisk_ref| (hotp name))
    (bool -> (tok -> unit))
  (if hotp
      (dodisk-kind name #'do-ref-hot-start)
      (dodisk-kind name #'do-ref-restart)
      ))

#|(defmacro withref (&body body)
  `(insys
    (with-environment ((address-of-environment (match-environment-in-list '(|ref|) *component*)))
      (with-local-transaction 
	  ,@body))))
|#
