%
;;;************************************************************************
;;;                                                                       *
;;;    Copyrighted Cornell University 2000                                *
;;;                                                                       *
;;;                                                                       *
;;;                Nuprl Proof Development System                         *
;;;                ------------------------------                         *
;;;                                                                       *
;;;   Developed by the Nuprl group, Department of Computer Science,       *
;;;   Cornell University, Ithaca NY.  See the release notes for a list    *
;;;   of the members of the group.                                        *
;;;                                                                       *
;;;   Permission is granted to use and modify Nuprl provided this notice  *
;;;   is retained in derived works.                                       *
;;;                                                                       *
;;;************************************************************************
%

let jprover_refiner_description_term =
  make_term (`!description`, [(make_token_parameter `metaprl`)])
            [(nil, (inatural_term 0));
             (nil, (icons_term (itoken_term `JPROVER`)
		    inil_term))
	    ]
;;

let jprover_eval_command_to_term =
  mp_eval_command_to_term_aux jprover_refiner_description_term;;



let dest_apply_jp term =
 let (f,v) = dest_apply term in
 if is_pair_term v then
    (let (x,y) = dest_pair v in
     let f' = nuprl_to_mp_apply_term (mk_apply_term f x) in (f',y))
 else
 (f,v)
;;
% 
  var terms and apply terms have different syntax in nuprl and jprover so
  we convert them here
%

let jprover_map_var term =
  map_term_bottom_up is_variable_term nuprl_to_mp_var_term term
;;
let jprover_map_apply term =
  map_term_bottom_up is_apply_term nuprl_to_mp_apply_term term
;;


let is_mp_jprover_string_term term =
  (let [p1; p2], [] = dest_term_with_opid `!metaprl_implementation` term in
  let s = destruct_string_parameter p2 in
  let [p3; p4] = destruct_parameter_list_parameter p1 in
  let s1 = destruct_string_parameter p3 and s2 = destruct_string_parameter p4 in
  (s1 = "Jprover") & (s2 = "string"))
  ? false
;;

let nuprl_map_jprover_string term =
  map_term_bottom_up is_mp_jprover_string_term mp_string_to_nuprl_var_term term
;;

letref term1 = ivoid_term;;
letref hyps1 = ivoid_term;;

let jprover multiplicity hyps term =
  term1:= term;
  hyps1:= hyps;
  let l = map_isexpr_to_list icons_op (\t. t) hyps in  
  let jhyps = map_to_ilist (\t. (jprover_map_var (jprover_map_apply t))) 
		            icons_op l in
  nuprl_map_apply
  (nuprl_map_jprover_string
     (nuprl_map_var (jprover_eval_command_to_term
		      (icons_term
			(inatural_term multiplicity)
			(icons_term jhyps (jprover_map_var (jprover_map_apply term)))))))
;;
