
let name_property oid = first_tok_of_term (get_property oid `NAME`);;
let name_of_oid = name_property;;


let definition_dir = "nuprl:/definitions/";;
let current_theory = "nuprl:/num_thy_1/";;

letrec concatenate str_list =
  if (null str_list) then
    ""
  else
    ((hd str_list) J (concatenate (tl str_list)))
;;


letrec add_index lst index =
  if (null lst) then
    []
  else
    [(index, (hd lst))] @ (add_index (tl lst) (index + 1))
;;


letrec form lst =
  if (not (null lst)) then
    if (length lst) = 1 then
      lst
    else
      [((hd lst) J ",")] @ (form (tl lst))
  else
    []
;;


let level_exp_to_string le =
  let exp = dest_level_exp le in
    (concatenate (form (map (\t,i. ((tok_to_string t) J "," J (int_to_string i))) exp)))
;;


let bool_to_string b =
  if b then "T" else "NIL"
;;


let is_parameter_substitution_list_parm p =
  type_of_parameter p = `parameter-substitution-list`
;;


let is_variable_parameter p = is_variable_parm p & not (is_mparm p);;
let is_variable_meta_parameter p = is_variable_parm p & is_mparm p;;
let is_level_exp_parameter p = is_level_exp_parm p & not (is_mparm p);;
let is_level_exp_meta_parameter p = is_level_exp_parm p & is_mparm p;;
let is_natural_parameter p = is_natural_parm p & not (is_mparm p);;
let is_natural_meta_parameter p = is_natural_parm p & is_mparm p;;
let is_string_parameter p = is_string_parm p & not (is_mparm p);;
let is_string_meta_parameter p = is_string_parm p & is_mparm p;;
let is_token_parameter p = is_token_parm p & not (is_mparm p);;
let is_token_meta_parameter p = is_token_parm p & is_mparm p;;
let is_bool_parameter p = is_bool_parm p & not (is_mparm p);;
let is_bool_meta_parameter p = is_bool_parm p & is_mparm p;;
let is_parameter_substitution_list_parameter p = 
      is_parameter_substitution_list_parm p;;


let parameter_to_xml p =
  let meta_var_of_parameter = (tok_to_string o var_to_tok o destruct_meta_parameter) in
    let pstr =
      ("<parameter " J
      (if is_variable_parameter p then
        ("val=\"" J (variable_to_string (dest_variable_parm p)) J
         "\" type=\"var-parameter\"")
      else if is_variable_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"var-meta-parameter\"")
      else if is_level_exp_parameter p then
        ("val=\"" J (level_exp_to_string (dest_level_exp_parm p)) J
         "\" type=\"level-exp-parameter\"")
      else if is_level_exp_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"level-exp-meta-parameter\"")
      else if is_natural_parameter p then
        ("val=\"" J (int_to_string (dest_natural_parm p)) J
         "\" type=\"natural-parameter\"")
      else if is_natural_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"natural-meta-parameter\"")
      else if is_string_parameter p then
        ("val=\"" J (dest_string_parm p) J
         "\" type=\"string-parameter\"")
      else if is_string_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"string-meta-parameter\"")
      else if is_token_parameter p then
        ("val=\"" J (tok_to_string (dest_token_parm p)) J
         "\" type=\"token-parameter\"")
      else if is_token_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"token-meta-parameter\"")
      else if is_bool_parameter p then
        ("val=\"" J (bool_to_string (dest_bool_parm p)) J
         "\" type=\"bool-parameter\"")
      else if is_bool_meta_parameter p then
        ("val=\"" J (meta_var_of_parameter p) J
         "\" type=\"bool-meta-parameter\"")
      else if is_parameter_substitution_list_parameter p then
        ("val=\"" J (parameter_to_string p) J
         "\" type=\"unknown-parameter\"")
      else
        "val=\"unknown\" type=\"unknown-parameter\"") J
      "></parameter>\n")
    in
      pstr
;;


let extract_parameter_value p =
  let meta_var_of_parameter = (tok_to_string o var_to_tok o destruct_meta_parameter) in
    let pstr =
      (if is_variable_parameter p then
        (variable_to_string (dest_variable_parm p))
      else if is_variable_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_level_exp_parameter p then
        (level_exp_to_string (dest_level_exp_parm p))
      else if is_level_exp_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_natural_parameter p then
        (int_to_string (dest_natural_parm p))
      else if is_natural_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_string_parameter p then
        (dest_string_parm p)
      else if is_string_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_token_parameter p then
        (tok_to_string (dest_token_parm p))
      else if is_token_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_bool_parameter p then
        (bool_to_string (dest_bool_parm p))
      else if is_bool_meta_parameter p then
        (meta_var_of_parameter p)
      else if is_parameter_substitution_list_parameter p then
        (parameter_to_string p)
      else
        "unknown value")
    in
      pstr
;;


letrec term_to_xml t =
  let (opid, parms), bterms = dest_term t in
    let s_opid = tok_to_string opid in
      if (s_opid = "variable") then
        ("<var val=\"" J (extract_parameter_value (hd parms)) J "\"></var>\n")
      else if (s_opid = "function") then
        ("<function>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</function>\n")
      else if (s_opid = "lambda") then
        ("<lambda binder=\"" J (hd (map (\bvars,t'. (variable_to_string (hd bvars)) J
         "\">\n" J (term_to_xml t')) bterms)) J "</lambda>\n")
      else if (s_opid = "apply") then
        ("<apply>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</apply>\n")
      else if (s_opid = "product") then
        ("<product>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</product>\n")
      else if (s_opid = "pair") then
        ("<pair>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</pair>\n")
      else if (s_opid = "spread") then
        ("<spread>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl bvars))) J "\"></binder>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</spread>\n")
      else if (s_opid = "union") then
        ("<union>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</union>\n")
      else if (s_opid = "inl") then
        ("<inl>\n" J (hd (map (\bvars,t'. (term_to_xml t')) bterms)) J "</inl>\n")
      else if (s_opid = "inr") then
        ("<inr>\n" J (hd (map (\bvars,t'. (term_to_xml t')) bterms)) J "</inr>\n")
      else if (s_opid = "decide") then
        ("<decide>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J
             "\"></binder>\n" J (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</decide>\n")
      else if (s_opid = "universe") then
        ("<universe level=\"" J (extract_parameter_value (hd parms)) J "\"></universe>\n")
      else if (s_opid = "prop") then
        ("<prop level=\"" J (extract_parameter_value (hd parms)) J "\"></prop>\n")
      else if (s_opid = "equal") then
        ("<equal>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</equal>\n")
      else if (s_opid = "axiom") then
        ("<axiom></axiom>\n")
      else if (s_opid = "void") then
        ("<void></void>\n")
      else if (s_opid = "any") then
        ("<any>\n" J (hd (map (\bvars,t'. (term_to_xml t')) bterms)) J "</any>\n")
      else if (s_opid = "atom") then
        ("<atom></atom>\n")
      else if (s_opid = "token") then
        ("<token val=\"" J (extract_parameter_value (hd parms)) J "\"></token>\n")
      else if (s_opid = "atom_eq") then
        ("<atom_eq>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</atom_eq>\n")
      else if (s_opid = "int") then
        ("<int></int>\n")
      else if (s_opid = "natural_number") then
        ("<natural_number val=\"" J (extract_parameter_value (hd parms)) J "\"></natural_number>\n")
      else if (s_opid = "minus") then
        ("<minus>\n" J (hd (map (\bvars,t'. (term_to_xml t')) bterms)) J "</minus>\n")
      else if (s_opid = "add") then
        ("<add>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</add>\n")
      else if (s_opid = "subtract") then
        ("<sub>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</sub>\n")
      else if (s_opid = "multiply") then
        ("<multiply>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</multiply>\n")
      else if (s_opid = "divide") then
        ("<divide>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</divide>\n")
      else if (s_opid = "remainder") then
        ("<remainder>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</remainder>\n")
      else if (s_opid = "int_eq") then
        ("<int_eq>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</int_eq>\n")
      else if (s_opid = "less") then
        ("<less>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</less>\n")
      else if (s_opid = "ind") then
        ("<ind>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl bvars))) J "\"></binder>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</ind>\n")
      else if (s_opid = "less_than") then
        ("<less_than>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J
         "</less_than>\n")
      else if (s_opid = "list") then
        ("<list></list>\n")
      else if (s_opid = "nil") then
        ("<nil></nil>\n")
      else if (s_opid = "cons") then
        ("<cons>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</cons>\n")
      else if (s_opid = "list_ind") then
        ("<list_ind>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl bvars))) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl (tl bvars)))) J "\"></binder>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</list_ind>\n")
      else if (s_opid = "rec") then
        ("<rec>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<var val=\"" J (variable_to_string (hd bvars)) J "\"></var>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</rec>\n")
      else if (s_opid = "rec_ind") then
        ("<rec_ind>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl bvars))) J "\"></binder>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</rec_ind>\n")
      else if (s_opid = "set") then
        ("<set>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</set>\n")
      else if (s_opid = "isect") then
        ("<isect>\n" J (concatenate (map (\bvars,t'. (term_to_xml t')) bterms)) J "</isect>\n")
      else if (s_opid = "quotient") then
        ("<quotient>\n" J (concatenate (map (\bvars,t'.
          (if not (null bvars) then
            ("<binder var=\"" J (variable_to_string (hd bvars)) J "\"></binder>\n" J
             "<binder var=\"" J (variable_to_string (hd (tl bvars))) J "\"></binder>\n" J
             (term_to_xml t'))
          else
            (term_to_xml t'))) bterms))
        J "</quotient>\n")
      else if (s_opid = "level-expression") then
        ("<level-expression val=\"" J (extract_parameter_value (hd parms)) J "\">\n" J
         "</level-expression>\n")
      else if (s_opid = "parameter-substitution-list") then
        ("<parameter-substitution-list val=\"" J
         (extract_parameter_value (hd parms)) J "\">\n" J
         "</parameter-substitution-list>\n")
      else if (s_opid = "tag") then
        ("<tag step=\"" J (extract_parameter_value (hd parms)) J "\">\n" J
         (hd (map (\bvars,t'. (term_to_xml t')) bterms)) J
         "</tag>\n")
      else
        ("<term opid=\"" J (tok_to_string opid) J "\" uri=\"" J
         definition_dir J (tok_to_string opid) J "\">\n" J
         (if not (null parms) then
            (concatenate (map (\p. (parameter_to_xml p)) parms))
          else
            "") J
         (if not (null bterms) then
            (concatenate (map (\bvars,t'.
             ((if not (null bvars) then
                 (concatenate (map (\bv. ("<binder var=\"" J (variable_to_string bv) J
                                          "\"></binder>\n")) bvars))
               else
                 "") J
              (term_to_xml t'))) bterms))
          else
            "") J
        "</term>\n")
;;

let is_hidden h =
  (hd (explode (string_to_tok h))) = `%`
;;


let sequent_to_xml hps cncl =
  (if not (null hps) then
    (concatenate (map (\h.
      (let v,t,h = dest_declaration h in
        (if (is_hidden (variable_to_string v)) then
           ("<hypothesis ")
         else
           ("<hypothesis var=\"" J (variable_to_string v) J "\"")
        ) J
        (if h then " hidden=\"true\"" else "") J
         ">\n" J
        (term_to_xml t) J
        "</hypothesis>\n")) hps))
  else
    "") J
  ("<conclusion>\n" J (term_to_xml cncl) J "</conclusion>\n")
;;


let extract_assumption_index t =
  let (opid, parms), bterms = dest_term t in
    (extract_parameter_value (hd parms))
;;


let extract_lemma_name t =
  let (opid, parms), bterms = dest_term t in
    (extract_parameter_value (hd parms))
;;


let extract_level_exp t =
  let (opid, parms), bterms = dest_term t in
    ("<level-expression val=\"" J (extract_parameter_value (hd parms)) J
     "\">\n" J
     "</level-expression>\n")
;;


let prim_rule_to_xml rnmt_rule =
  let name, args = destruct_primitive_rule rnmt_rule in
    let sname = tok_to_string name in (
      if (sname = "dependent_functionFormation") then
        ("<dependent_functionFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_functionFormation>\n")
      else if (sname = "independent_functionFormation") then
        ("<independent_functionFormation>\n" J "</independent_functionFormation>\n")
      else if (sname = "functionEquality") then
        ("<functionEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</functionEquality>\n")
      else if (sname = "independent_functionEquality") then
        ("<independent_functionEquality>\n" J "</independent_functionEquality>\n")
      else if (sname = "lambdaEquality") then
        ("<lambdaEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</lambdaEquality>\n")
      else if (sname = "lambdaFormation") then
        ("<lambdaFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</lambdaFormation>\n")
      else if (sname = "applyEquality") then
        ("<applyEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</applyEquality>\n")
      else if (sname = "independent_functionElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<independent_functionElimination number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</independent_functionElimination>\n")
      else if (sname = "dependent_functionElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<dependent_functionElimination number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</dependent_functionElimination>\n")
      else if (sname = "applyReduce") then
        ("<applyReduce>\n" J "</applyReduce>\n")
      else if (sname = "functionExtensionality") then
        ("<functionExtensionality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</functionExtensionality>\n")
      else if (sname = "dependent_productFormation") then
        ("<dependent_productFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_productFormation>\n")
      else if (sname = "independent_productFormation") then
        ("<independent_productFormation>\n" J "</independent_productFormation>\n")
      else if (sname = "productEquality") then
        ("<productEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</productEquality>\n")
      else if (sname = "independent_productEquality") then
        ("<independent_productEquality>\n" J "</independent_productEquality>\n")
      else if (sname = "dependent_pairEquality") then
        ("<dependent_pairEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_pairEquality>\n")
      else if (sname = "dependent_pairFormation") then
        ("<dependent_pairFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_pairFormation>\n")
      else if (sname = "independent_pairEquality") then
        ("<independent_pairEquality>\n" J "</independent_pairEquality>\n")
      else if (sname = "independent_pairFormation") then
        ("<independent_pairFormation>\n" J "</independent_pairFormation>\n")
      else if (sname = "spreadEquality") then
        ("<spreadEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</spreadEquality>\n")
      else if (sname = "productElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<productElimination number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</productElimination>\n")
      else if (sname = "spreadReduce") then
        ("<spreadReduce>\n" J "</spreadReduce>\n")
      else if (sname = "unionFormation") then
        ("<unionFormation>\n" J "</unionFormation>\n")
      else if (sname = "unionEquality") then
        ("<unionEquality>\n" J "</unionEquality>\n")
      else if (sname = "inlEquality") then
        ("<inlEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</inlEquality>\n")
      else if (sname = "inlFormation") then
        ("<inlFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</inlFormation>\n")
      else if (sname = "inrEquality") then
        ("<inrEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</inrEquality>\n")
      else if (sname = "inrFormation") then
        ("<inrFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</inrFormation>\n")
      else if (sname = "decideEquality") then
        ("<decideEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</decideEquality>\n")
      else if (sname = "unionElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<unionElimination number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</unionElimination>\n")
      else if (sname = "decideReduceLeft") then
        ("<decideReduceLeft>\n" J "</decideReduceLeft>\n")
      else if (sname = "decideReduceRight") then
        ("<decideReduceRight>\n" J "</decideReduceRight>\n")
      else if (sname = "universeFormation") then
        ("<universeFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</universeFormation>\n")
      else if (sname = "universeEquality") then
        ("<universeEquality>\n" J "</universeEquality>\n")
      else if (sname = "cumulativity") then
        ("<cumulativity>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</cumulativity>\n")
      else if (sname = "equalityFormation") then
        ("<equalityFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</equalityFormation>\n")
      else if (sname = "equalityEquality") then
        ("<equalityEquality>\n" J "</equalityEquality>\n")
      else if (sname = "axiomEquality") then
        ("<axiomEquality>\n" J "</axiomEquality>\n")
      else if (sname = "equalityElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<equalityElimination number_hyp=\"" J assumption_index J "\">\n" J
           "</equalityElimination>\n")
      else if (sname = "hypothesisEquality") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<hypothesisEquality number_hyp=\"" J assumption_index J "\">\n" J
           "</hypothesisEquality>\n")
      else if (sname = "substitution") then
        ("<substitution>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</substitution>\n")
      else if (sname = "equality") then
        ("<equality>\n" J "</equality>\n")
      else if (sname = "voidFormation") then
        ("<voidFormation>\n" J "</voidFormation>\n")
      else if (sname = "voidEquality") then
        ("<voidEquality>\n" J "</voidEquality>\n")
      else if (sname = "anyEquality") then
        ("<anyEquality>\n" J "</anyEquality>\n")
      else if (sname = "voidElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<voidElimination number_hyp=\"" J assumption_index J "\">\n" J
           "</voidElimination>\n")
      else if (sname = "atomFormation") then
        ("<atomFormation>\n" J "</atomFormation>\n")
      else if (sname = "atomEquality") then
        ("<atomEquality>\n" J "</atomEquality>\n")
      else if (sname = "tokenEquality") then
        ("<tokenEquality>\n" J "</tokenEquality>\n")
      else if (sname = "tokenFormation") then
        ("<tokenFormation>\n" J "</tokenFormation>\n")
      else if (sname = "atom_eqEquality") then
        ("<atom_eqEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</atom_eqEquality>\n")
      else if (sname = "atom_eqReduceTrue") then
        ("<atom_eqReduceTrue>\n" J "</atom_eqReduceTrue>\n")
      else if (sname = "atom_eqReduceFalse") then
        ("<atom_eqReduceFalse>\n" J "</atom_eqReduceFalse>\n")
      else if (sname = "intFormation") then
        ("<intFormation>\n" J "</intFormation>\n")
      else if (sname = "intEquality") then
        ("<intEquality>\n" J "</intEquality>\n")
      else if (sname = "natural_numberEquality") then
        ("<natural_numberEquality>\n" J "</natural_numberEquality>\n")
      else if (sname = "minusEquality") then
        ("<minusEquality>\n" J "</minusEquality>\n")
      else if (sname = "addFormation") then
        ("<addFormation>\n" J "</addFormation>\n")
      else if (sname = "subtractFormation") then
        ("<subtractFormation>\n" J "</subtractFormation>\n")
      else if (sname = "multiplyFormation") then
        ("<multiplyFormation>\n" J "</multiplyFormation>\n")
      else if (sname = "divideFormation") then
        ("<divideFormation>\n" J "</divideFormation>\n")
      else if (sname = "addEquality") then
        ("<addEquality>\n" J "</addEquality>\n")
      else if (sname = "subtractEquality") then
        ("<subtractEquality>\n" J "</subtractEquality>\n")
      else if (sname = "multiplyEquality") then
        ("<multiplyEquality>\n" J "</multiplyEquality>\n")
      else if (sname = "divideEquality") then
        ("<divideEquality>\n" J "</divideEquality>\n")
      else if (sname = "remainderBounds1") then
        ("<remainderBounds1>\n" J "</remainderBounds1>\n")
      else if (sname = "remainderBounds2") then
        ("<remainderBounds2>\n" J "</remainderBounds2>\n")
      else if (sname = "remainderBounds3") then
        ("<remainderBounds3>\n" J "</remainderBounds3>\n")
      else if (sname = "remainderBounds4") then
        ("<remainderBounds4>\n" J "</remainderBounds4>\n")
      else if (sname = "divideRemainderSum") then
        ("<divideRemainderSum>\n" J "</divideRemainderSum>\n")
      else if (sname = "arith") then
        let level_exp = extract_level_exp (hd args) in
          ("<arith>\n" J level_exp J "</arith>\n")
      else if (sname = "indEquality") then
        ("<indEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</indEquality>\n")
      else if (sname = "intElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<intElimination number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</intElimination>\n")
      else if (sname = "indReduceDown") then
        ("<indReduceDown>\n" J "</indReduceDown>\n")
      else if (sname = "indReduceUp") then
        ("<indReduceUp>\n" J "</indReduceUp>\n")
      else if (sname = "indReduceBase") then
        ("<indReduceBase>\n" J "</indReduceBase>\n")
      else if (sname = "int_eqEquality") then
        ("<int_eqEquality>\n" J "</int_eqEquality>\n")
      else if (sname = "int_eqReduceTrue") then
        ("<int_eqReduceTrue>\n" J "</int_eqReduceTrue>\n")
      else if (sname = "int_eqReduceFalse") then
        ("<int_eqReduceFalse>\n" J "</int_eqReduceFalse>\n")
      else if (sname = "lessEquality") then
        ("<lessEquality>\n" J "</lessEquality>\n")
      else if (sname = "lessReduceTrue") then
        ("<lessReduceTrue>\n" J "</lessReduceTrue>\n")
      else if (sname = "lessReduceFalse") then
        ("<lessReduceFalse>\n" J "</lessReduceFalse>\n")
      else if (sname = "less_thanEquality") then
        ("<less_thanEquality>\n" J "</less_thanEquality>\n")
      else if (sname = "less_thanFormation") then
        ("<less_thanFormation>\n" J "</less_thanFormation>\n")
      else if (sname = "less_thanMember") then
        ("<less_thanMember>\n" J "</less_thanMember>\n")
      else if (sname = "listFormation") then
        ("<listFormation>\n" J "</listFormation>\n")
      else if (sname = "listEquality") then
        ("<listEquality>\n" J "</listEquality>\n")
      else if (sname = "nilEquality") then
        ("<nilEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</nilEquality>\n")
      else if (sname = "nilFormation") then
        ("<nilFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</nilFormation>\n")
      else if (sname = "consFormation") then
        ("<consFormation>\n" J "</consFormation>\n")
      else if (sname = "consEquality") then
        ("<consEquality>\n" J "</consEquality>\n")
      else if (sname = "list_indEquality") then
        ("<list_indEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</list_indEquality>\n")
      else if (sname = "listElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<listElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</listElimination>\n")
      else if (sname = "list_indReduceUp") then
        ("<list_indReduceUp>\n" J "</list_indReduceUp>\n")
      else if (sname = "list_indReduceBase") then
        ("<list_indReduceBase>\n" J "</list_indReduceBase>\n")
      else if (sname = "recEquality") then
        ("<recEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</recEquality>\n")
      else if (sname = "rec_memberEquality") then
        ("<rec_memberEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</rec_memberEquality>\n")
      else if (sname = "rec_memberFormation") then
        ("<rec_memberFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</rec_memberFormation>\n")
      else if (sname = "rec_indEquality") then
        ("<rec_indEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</rec_indEquality>\n")
      else if (sname = "recElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<recElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</recElimination>\n")
      else if (sname = "recUnrollElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<recUnrollElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</recUnrollElimination>\n")
      else if (sname = "dependent_setFormation") then
        ("<dependent_setFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_setFormation>\n")
      else if (sname = "independent_setFormation") then
        ("<independent_setFormation>\n" J "</independent_setFormation>\n")
      else if (sname = "setEquality") then
        ("<setEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</setEquality>\n")
      else if (sname = "dependent_set_memberEquality") then
        ("<dependent_set_memberEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_set_memberEquality>\n")
      else if (sname = "dependent_set_memberFormation") then
        ("<dependent_set_memberFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</dependent_set_memberFormation>\n")
      else if (sname = "independent_set_memberEquality") then
        ("<independent_set_memberEquality>\n" J "</independent_set_memberEquality>\n")
      else if (sname = "independent_set_memberFormation") then
        ("<independent_set_memberFormation>\n" J "</independent_set_memberFormation>\n")
      else if (sname = "setElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<setElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</setElimination>\n")
      else if (sname = "isectFormation") then
        ("<isectFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</isectFormation>\n")
      else if (sname = "isectEquality") then
        ("<isectEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</isectEquality>\n")
      else if (sname = "isect_memberEquality") then
        ("<isect_memberEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</isect_memberEquality>\n")
      else if (sname = "isect_memberFormation") then
        ("<isect_memberFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</isect_memberFormation>\n")
      else if (sname = "isect_member_caseEquality") then
        ("<isect_member_caseEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</isect_member_caseEquality>\n")
      else if (sname = "isectElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<isectElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</isectElimination>\n")
      else if (sname = "quotientFormation") then
        ("<quotientFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</quotientFormation>\n")
      else if (sname = "quotientWeakEquality") then
        ("<quotientWeakEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</quotientWeakEquality>\n")
      else if (sname = "quotientEquality") then
        ("<quotientEquality>\n" J "</quotientEquality>\n")
      else if (sname = "quotient_memberWeakEquality") then
        ("<quotient_memberWeakEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</quotient_memberWeakEquality>\n")
      else if (sname = "quotient_memberFormation") then
        ("<quotient_memberFormation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</quotient_memberFormation>\n")
      else if (sname = "quotient_memberEquality") then
        ("<quotient_memberEquality>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</quotient_memberEquality>\n")
      else if (sname = "quotient_equalityElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<quotient_equalityElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</quotient_equalityElimination>\n")
      else if (sname = "quotientElimination") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<quotientElimination number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</quotientElimination>\n")
      else if (sname = "quotientElimination_2") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<quotientElimination_2 number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</quotientElimination_2>\n")
      else if (sname = "direct_computation") then
        ("<direct_computation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</direct_computation>\n")
      else if (sname = "reverse_direct_computation") then
        ("<reverse_direct_computation>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</reverse_direct_computation>\n")
      else if (sname = "direct_computation_hypothesis") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<direct_computation_hypothesis number_hyp=\"" J assumption_index J
           "\">\n" J (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</direct_computation_hypothesis>\n")
      else if (sname = "reverse_direct_computation_hypothesis") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<reverse_direct_computation_hypothesis number_hyp=\"" J assumption_index J
           "\">\n" J (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</reverse_direct_computation_hypothesis>\n")
      else if (sname = "thin") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<thin number_hyp=\"" J assumption_index J "\">\n" J
           "</thin>\n")
      else if (sname = "cut") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<cut number_hyp=\"" J assumption_index J "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</cut>\n")
      else if (sname = "hyp_replacement") then
        let assumption_index = (extract_assumption_index (hd args)) in
          ("<hyp_replacement number_hyp=\"" J assumption_index J
           "\">\n" J
           (concatenate (map (\a. (term_to_xml a)) (tl args))) J
           "</hyp_replacement>\n")
      else if (sname = "lemma") then
        let lemma_name = extract_lemma_name (hd args) in
          ("<lemma name=\"" J lemma_name J "\">\n" J
           "</lemma>\n")
      else if (sname = "extract") then
        let lemma_name = extract_lemma_name (hd args) in
          ("<extract name=\"" J lemma_name J "\">\n" J
           "</extract>\n")
      else if (sname = "instantiate") then
        ("<instantiate>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</instantiate>\n")
      else if (sname = "because") then
        ("<because>\n" J "</because>\n")
      else if (sname = "rename") then
        ("<rename>\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</rename>\n")
      else
        ("<rule name=\"" J sname J "\">\n" J
         (concatenate (map (\a. (term_to_xml a)) args)) J
         "</rule>\n")
    )
;;

letrec change_sym lst =
  if (null lst) then
    []
  else
    if (hd lst) = (string_to_tok "\"") then
      ([`&`; `q`; `u`; `o`; `t`; `;`] @ (change_sym (tl lst)))
    else if (hd lst) = (string_to_tok "'") then
      ([`&`; `a`; `p`; `o`; `s`; `;`] @ (change_sym (tl lst)))
    else if (hd lst) = (string_to_tok "<") then
      ([`&`; `l`; `t`; `;`] @ (change_sym (tl lst)))
    else if (hd lst) = (string_to_tok ">") then
      ([`&`; `g`; `t`; `;`] @ (change_sym (tl lst)))
    else if (hd lst) = (string_to_tok "&") then
      ([`&`; `a`; `m`; `p`; `;`] @ (change_sym (tl lst)))
    else
      ([(hd lst)] @ (change_sym (tl lst)))
;;


let check_and_correct t =
  let t1 = (tok_to_string (implode (change_sym (explode (string_to_tok t))))) in
    t1
;;


let destruct_iproof_node_term term =
  (let ((id, parms), [([], stat); ([], addr); ([], goal); ([], tac); ([], subgoals); ([], annos)]) = destruct_term term in
   let (op, [([], tac'); ([], ref)]) = destruct_term tac in
	    
  (stat, addr, goal, tac', subgoals)) ? failwith `iproof node not`
;;


let complete_p status = 
 let ([p1]),[] = dest_term_with_opid `!proof_status` status in
 ((destruct_token_parameter p1) = `status`)
;;
let strings_return_itext = itext_term "map_to_ilist (\\x.istring_term x) icons_op ";;

let make_strings_return = 
 make_return_eval_aux strings_return_itext (map_isexpr_to_list icons_op string_of_istring_term)
;;


let lib_get_ref_env oid = 
 lib_eval_to_term (oid_ap (begin_ap "get_ref_environment_term ") oid)
;;

let edd_eval_to_term p = 
 lib_eval_to_term (posure_ap (begin_ap "edd_eval_to_term ") p)
;;


let edd_eval_to_string_list =
  make_strings_return edd_eval_to_term
;;

let edd_term_to_print_strings term =
  edd_eval_to_string_list (term_ap (begin_ap "term_to_print_strings_ref") term)
;;


letrec traverse_tree_prim_aux proof addr nlist thm_name =
  let (sequent, annos) = destruct_igoal (proof_to_goal proof) in
  tty_print " traverse prim aux";
  ("<node>\n" J

  (let hps, cncl = assumptions_of_sequent sequent, conclusion_of_sequent sequent in (
     "<sequent number=\"" J addr J "\">\n" J
     (sequent_to_xml hps cncl) J
     "</sequent>\n")) J

  (if (is_refined proof) then
     (tty_print " is refined";
     let rnmt_rule = (refinement proof) in 
         ("<ruleinstance>\n" J
          (prim_rule_to_xml rnmt_rule) J
          "</ruleinstance>\n"))
       
     else
     ( tty_print " not refined";"")) J

  (if (is_refined proof) then 
     (let subproofs = add_index (children proof) 1 in 
        (concatenate (map (\i,p. 
			   (traverse_tree_prim_aux p (addr J (int_to_string i)) nlist thm_name))
			subproofs)))
  else "") J

  "</node>\n")
;;

letrec traverse_tree_aux p addr nlist thm_name =
  ("<node>\n" J

  (let hps, cncl = hyps p, concl p in (
     "<sequent number=\"" J addr J "\">\n" J
     (sequent_to_xml hps cncl) J
     "</sequent>\n")) J

  (if (is_refined p) then (
     let rnmt_rule = refinement p in (
       if (is_prim_rule rnmt_rule) then
         ("<ruleinstance>\n" J
          (prim_rule_to_xml rnmt_rule) J
          "</ruleinstance>\n")
       else

          (
            close_snapshot_file ();

            set_snapshot_file ("~/xmldoc/index/index.txt");
            open_snapshot_file false;
            print_to_snapshot_file (current_theory J thm_name J "_" J addr);
            print_return_to_snapshot_file ();
            close_snapshot_file ();

            set_snapshot_file ("~/xmldoc/" J thm_name J "_" J addr J ".xml");
            open_snapshot_file true;
            print_to_snapshot_file "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
            print_to_snapshot_file "<NuPrlProof>\n";
            print_to_snapshot_file (traverse_tree_aux (proof_of_tactic_rule rnmt_rule) (addr J "0")
                                              ([(thm_name J "_" J addr)] @ nlist) thm_name);
            print_to_snapshot_file "</NuPrlProof>";
            close_snapshot_file ();
            set_snapshot_file ("~/xmldoc/" J (hd nlist) J ".xml");
            open_snapshot_file false;
            "<tacticinstance name=\"" J (check_and_correct (concatenate (map (\l. (l J " "))
                                 (edd_term_to_print_strings (tactic_rule_to_term rnmt_rule))))) J
            "\" uri=\"" J
            current_theory J thm_name J "_" J addr J
            "\">\n" J
            "</tacticinstance>\n"
          )))

    else
     "") J

  (if (is_refined p) then (
     let subproofs = add_index (children p) 1 in
       (concatenate (map (\i,p. (traverse_tree_aux p (addr J (int_to_string i)) nlist thm_name)) subproofs)))
   else
     "") J

  "</node>\n")
;;

letrec traverse_tree_prim poid node addr nlist thm_name =
  let (status, address, goal, tactic, subgoals) = destruct_iproof_node_term node in
  let (sequent, annos) = destruct_igoal goal in

  tty_print " goal ok";
  
  ("<node>\n" J

  (let hps, cncl = assumptions_of_sequent sequent, conclusion_of_sequent sequent in (
     "<sequent number=\"" J addr J "\">\n" J
     (sequent_to_xml hps cncl) J
     "</sequent>\n")) J

  (if (((not (complete_p status)) & (not (is_term `!proof_node_nil` subgoals)))
          or (complete_p status)) then

           (close_snapshot_file ();
            set_snapshot_file ("~/xmldoc/index/index.txt");
            open_snapshot_file false;
            print_to_snapshot_file (current_theory J thm_name J "_" J addr);
            print_return_to_snapshot_file ();
            close_snapshot_file ();

            set_snapshot_file ("~/xmldoc/" J thm_name J "_" J addr J ".xml");
            open_snapshot_file true;
            print_to_snapshot_file "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
            print_to_snapshot_file "<NuPrlProof>\n";
            tty_print " before prim";
	    let proof = ref_refine_primr goal tactic (lib_get_ref_env poid) in
	    print_to_snapshot_file (traverse_tree_aux proof (addr J "0")
				      ([(thm_name J "_" J addr)] @ nlist) thm_name);
	    tty_print "after prim ";
            print_to_snapshot_file "</NuPrlProof>";
            close_snapshot_file ();
            set_snapshot_file ("~/xmldoc/" J (hd nlist) J ".xml");
            open_snapshot_file false;
            "<tacticinstance name=\"" J 
	      (check_and_correct (concatenate (map (\l. (l J " ")) (edd_term_to_print_strings tactic)))) J
            
            "\" uri=\"" J
            current_theory J thm_name J "_" J addr J
            "\">\n" J
            "</tacticinstance>\n"
          )

    else
     "") J

  (if (((not (complete_p status)) & (not (is_term `!proof_node_nil` subgoals)))
          or (complete_p status)) then
     let subproofs = add_index (map_isexpr_to_list (`!proof_node_cons`,[]) (\x.x) subgoals) 1 in
       (concatenate 
	  (map (\i,p. (traverse_tree_prim poid p (addr J (int_to_string i)) nlist thm_name)) subproofs))
   else
     "") J

  "</node>\n")
;;


letrec traverse_tree node addr nlist thm_name =
  let (status, address, goal, tactic, subgoals) = destruct_iproof_node_term node in
  let (sequent, annos) = destruct_igoal goal in
  
  tty_print " goal ok";
  
  ("<node>\n" J

  (let hps, cncl = assumptions_of_sequent sequent, conclusion_of_sequent sequent in 
     ("<sequent number=\"" J addr J "\">\n" J
       (sequent_to_xml hps cncl) J
       "</sequent>\n")) J

  (if (((not (complete_p status)) & (not (is_term `!proof_node_nil` subgoals)))
          or (complete_p status)) then
  
    ( close_snapshot_file ();
            set_snapshot_file ("~/xmldoc/index/index.txt");
            open_snapshot_file false;
            print_to_snapshot_file (current_theory J thm_name J "_" J addr);
            print_return_to_snapshot_file ();
            close_snapshot_file ();

            set_snapshot_file ("~/xmldoc/" J thm_name J "_" J addr J ".xml");
            open_snapshot_file true;
            print_to_snapshot_file "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
            print_to_snapshot_file "<NuPrlProof>\n";
            %prim tree went here%
            print_to_snapshot_file "</NuPrlProof>";
            close_snapshot_file ();
            set_snapshot_file ("~/xmldoc/" J (hd nlist) J ".xml");
            open_snapshot_file false;
            "<tacticinstance name=\"" J 
            (check_and_correct (concatenate (map (\l. (l J " ")) (edd_term_to_print_strings tactic)))) J
            "\" uri=\"" J
            current_theory J thm_name J "_" J addr J
            "\">\n" J
            "</tacticinstance>\n"
          )
    else
     "") J

  (if (((not (complete_p status)) & (not (is_term `!proof_node_nil` subgoals)))
          or (complete_p status)) then
     let subproofs = add_index (map_isexpr_to_list (`!proof_node_cons`,[]) (\x.x) subgoals) 1 in
       (concatenate 
          (map (\i,p. (traverse_tree p (addr J (int_to_string i)) nlist thm_name)) subproofs))
   else
     "") J

  "</node>\n")
;;

letref myterm = ivoid_term ;;

let proof_to_xml name sequent =
 
    set_snapshot_file ("~/xmldoc/index/index.txt");
    open_snapshot_file false;
    print_to_snapshot_file name;
    print_return_to_snapshot_file ();
    close_snapshot_file ();

    set_snapshot_file ("~/xmldoc/" J name J ".xml");
    open_snapshot_file true;
    print_to_snapshot_file "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    print_return_to_snapshot_file ();
    print_to_snapshot_file "<NuPrlProof>";
    print_return_to_snapshot_file ();
    myterm := sequent;
    print_to_snapshot_file (traverse_tree sequent "" [name] name);
    print_to_snapshot_file "</NuPrlProof>";
    print_return_to_snapshot_file ();
    close_snapshot_file ()
;;

let proof_to_xml_prim name sequent poid =
 
    set_snapshot_file ("~/xmldoc/index/index.txt");
    open_snapshot_file false;
    print_to_snapshot_file name;
    print_return_to_snapshot_file ();
    close_snapshot_file ();

    set_snapshot_file ("~/xmldoc/" J name J ".xml");
    open_snapshot_file true;
    print_to_snapshot_file "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    print_return_to_snapshot_file ();
    print_to_snapshot_file "<NuPrlProof>";
    print_return_to_snapshot_file ();
    myterm := sequent;
    print_to_snapshot_file (traverse_tree_prim poid sequent "" [name] name);
    print_to_snapshot_file "</NuPrlProof>";
    print_return_to_snapshot_file ();
    close_snapshot_file ()
;;

%let run_conversion poid =
  let name = tok_to_string (name_of_oid poid) in 
  let pterm = lib_eval_to_term (oid_ap poid) (begin_ap "poid_to_iproof_editor_term")  in 
  proof_to_xml name pterm; 
  compress (tok_to_string thm);
  tok_to_string name
;;
%

let print_obj_helm pterm =
  let ([]),[([], name); ([], kind); ([], status); ([], sequent); ([], children)] = 
    dest_term_with_opid `!object_tree` pterm in
    proof_to_xml (tok_to_string (token_of_itoken_term name)) sequent  
;;

let print_obj_helm_prim pterm poid =
   tty_print " ref start";
   let ([]),[([], name); ([], kind); ([], status); ([], sequent); ([], children)] = 
    dest_term_with_opid `!object_tree` pterm in
    proof_to_xml_prim (tok_to_string (token_of_itoken_term name)) sequent poid 
;;

 
