%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
LIB-DEP-1.ML
****************************************************************************
****************************************************************************
Library Dependencies of tactics:

Here we introduce ML terms which only get properly defined once certain
theories are loaded. Each entry in this file should record:

1. which object in which theory properly defines the term.
2. The ml file(s) which first require the properly defined term.

]%


% 
Initialized in object ycomb_unroll in theory core-2 
Used in utilities.ml
%
let new_conv_ref_state = 
  new_singleton_ref_state IdC
;;

letref YUnrollC_bo = IdC;;

%
letref YUnrollC_ref_state = new_conv_ref_state `YUnrollC`;;

let set_YUnrollC index edges f =
 declare_ref_state_index index `YUnrollC` index;
 YUnrollC_ref_state := declare_ref_state_data_indirect `YUnrollC` YUnrollC_ref_state index f edges
;;

let YUnrollC e t =
  let f = ref_state_get YUnrollC_ref_state (current_ref_environment_index `YUnrollC`) in
   (f e t)
;;
%
% 
Initialized in objects pi1_eval/pi2_eval in theory core-2 
Used in module-tactics-2.ml
%

letref pi1_evalC_bo = IdC;;
letref pi2_evalC_bo = IdC;;

%letref pi1_evalC_ref_state = new_conv_ref_state `pi1_evalC`;;

let set_pi1_evalC index edges items =
 declare_ref_state_index index `pi1_evalC` index;
 pi1_evalC_ref_state
   := declare_ref_state_data_indirect `pi1_evalC` pi1_evalC_ref_state index items edges
;;

let pi1_evalC e t =
  let f = ref_state_get pi1_evalC_ref_state (current_ref_environment_index `pi1_evalC`) in
   (f e t)
;;
%

%
letref pi2_evalC_ref_state = new_conv_ref_state `pi2_evalC`;;

let set_pi2_evalC index edges items =
 declare_ref_state_index index `pi2_evalC` index;
 pi2_evalC_ref_state
   := declare_ref_state_data_indirect `pi2_evalC` pi2_evalC_ref_state index items edges
;;

let pi2_evalC e t =
  let f = ref_state_get pi2_evalC_ref_state (current_ref_environment_index `pi2_evalC`) in
   (f e t)
;;
%


