%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
MATCH-INC.ML
****************************************************************************
****************************************************************************
]%

%
Need here to avoid possible conflicts between bound and free vars with
the same name.
%

let merge_tsubs tsub1 tsub2 = 
  let bvsub1,tsub1' = divide_list is_bvar_binding tsub1 in
  let bvsub2,tsub2' = divide_list is_bvar_binding tsub2 in
    priority_merge_alists bvsub1 bvsub2 @ merge_alists_p tsub1' tsub2' alpha_equal_terms
  ? failwith `merge_tsubs: term substitutions incompatible`
;;

% 
Use:

  half_match_with_retry get_hard_and_supertype_alts

as default half_match_fun arg to match_in_context_with_ti_and_ms
%

%
Variants of half match:

  regular_half_match:

  Used by all the default forward and backward chaining tactics.
  1. if pattern and instance are both member or both equal terms then
     a) soft match equands
   & b) i)soft/type inc match type
        or ii) ignore type altogether.

  2. otherwise, do soft match.


  half_match_member_el

  Used by ReflEqCD and NonReflEqCD tactics
  pat and inst must both be member terms.
  Hard match on member. Ignore type.
  
  half_match_member_with_soft_type

  Used by ReflEqCD and NonReflEqCD tactics
  pat and inst must both be member terms.
  Hard match on member. Soft match on type.
  

  half_match_member_with_type_inc : 

  Experimental. Could be used by ReflEqCD and NonReflEqCD tactics
  pat and inst must both be member terms.
  1. hard match on member.
  2. On type
     a) try soft match
     b) try type inc match 
     c) give up. Rely only on member match.
%


let half_match_member_with_type_inc
  pol meta_parm_vars meta_term_vars pattern instance 
  =
  let P,p = dest_member pattern in
  let I,i = dest_member instance in
  let type_pdset,type_tsub =
   (half_match_with_retry
      get_hard_and_supertype_alts
      pol
      meta_parm_vars 
      meta_term_vars 
      P 
      I
   ) ? [],[]
  in
  let el_pdset,el_tsub =
    half_match_with_retry
      (\x.[])
      ((-1)*pol)
      meta_parm_vars 
      meta_term_vars 
      p 
      i
  in
    type_pdset @ el_pdset
    ,merge_tsubs el_tsub type_tsub
;;

let half_match_member_with_soft_type
  pol meta_parm_vars meta_term_vars pattern instance 
  =
  let P,p = dest_member pattern in
  let I,i = dest_member instance in
  let type_pdset,type_tsub =
    half_match_with_retry
      get_hardened_pr
      pol
      meta_parm_vars 
      meta_term_vars 
      P 
      I
  in
  let el_pdset,el_tsub =
    half_match_with_retry
      (\x.[])
      ((-1)*pol)
      meta_parm_vars 
      meta_term_vars 
      p 
      i
  in
    type_pdset @ el_pdset
    ,merge_tsubs el_tsub type_tsub
;;

let half_match_member_el
  pol meta_parm_vars meta_term_vars pattern instance 
  =
  let P,p = dest_member pattern in
  let I,i = dest_member instance in
    half_match_with_retry
      (\x.[])
      ((-1)*pol)
      meta_parm_vars 
      meta_term_vars 
      p 
      i
;;

let regular_half_match
  pol meta_parm_vars meta_term_vars pattern instance 
  =
  let dest_memeq t = 
    (dest_member t ?
     let T,a,b = dest_equal t 
     in 
       if alpha_equal_terms a b then T,a else T,mk_pair_term a b
    )
  in
  if is_terms ``member equal`` pattern then
  ( let P,p = dest_memeq pattern in
    let I,i = dest_memeq instance in
    let type_pdset,type_tsub =
    ( half_match_with_retry
        get_hard_and_supertype_alts
        pol
        meta_parm_vars 
        meta_term_vars 
        P 
        I
    ? [],[]
    )
    in
    let el_pdset,el_tsub =
      half_match_with_retry
        get_hardened_pr
        ((-1)*pol)
        meta_parm_vars 
        meta_term_vars 
        p 
        i
    in
    type_pdset @ el_pdset
    ,merge_tsubs el_tsub type_tsub
  )
  else
    half_match_with_retry
      get_hardened_pr
      pol
      meta_parm_vars 
      meta_term_vars 
      pattern 
      instance
;;

