%
*************************************************************************
*                                                                       *
*    Copyrighted Cornell University 2000                                *
*                                                                       *
*                                                                       *
*                Nuprl Proof Development System                         *
*                ------------------------------                         *
*                                                                       *
*   Developed by the Nuprl group, Department of Computer Science,       *
*   Cornell University, Ithaca NY.  See the release notes for a list    *
*   of the members of the group.                                        *
*                                                                       *
*   Permission is granted to use and modify Nuprl provided this notice  *
*   is retained in derived works.                                       *
*                                                                       *
*                                                                       *
*************************************************************************
%

%[
****************************************************************************
****************************************************************************
REWRITE-TACTICS.ML
****************************************************************************
****************************************************************************
General Purpose Rewrite Tactics

Tactics here are largely superceded by RewriteWithStr defined
in simp-tactics.ml.
]%


% Rewrite with hyps and lemmas till no further progress.
Assume all simple formulae %

let RewriteWith hyps lemmas i p = 
  let i' = get_pos_hyp_num i p
  in let hyps' = map (\k.get_pos_hyp_num k p) hyps 
  in
  if exists (\j.j LE i') hyps' then
    failwith `RewriteWith: hyps used should precede hyp being rewritten`
  else
   let HypsC e = FirstC (map (\j.OldHypC j e) hyps')
   in let LemmasC = FirstC (map LemmaC lemmas)
   in let Conv e t = 
     RepeatC (SweepUpC (Repeat1C (HypsC e ORELSEC LemmasC))) e t
   in
     Rewrite Conv i' p
;;



let CondRewriteWith_aux T hyps f lemmas =
 \i p.
  let i' = get_pos_hyp_num i p
  in let hyps' = map (\k.get_pos_hyp_num k p) hyps 
  in 
  if exists (\j.j LE i') hyps' then
    failwith `RewriteWith: hyps used should precede hyp being rewritten`
  else
   let HypsC e = FirstC (map (\j.OldHypThenLC [T] j e) hyps)
   in let LemmasC = FirstC (map (f [T]) lemmas)
   in let Conv e t = 
     RepeatC (SweepUpC (Repeat1C (HypsC e ORELSEC LemmasC))) e t
   in
     Rewrite Conv i' p
;;

let CondRewriteWith T hyps lemmas =
 CondRewriteWith_aux T hyps LemmaThenLC lemmas
;;
let CondRewriteWith_o T hyps lemmas =
 CondRewriteWith_aux T hyps (GenLemmaCondC_aux `tactics` dummy_conv_enabler `LR` (-1) []) lemmas
;;

let RewriteOnceWith hyps lemmas i p = 
  let i' = get_pos_hyp_num i p
  in let hyps' = map (\k.get_pos_hyp_num k p) hyps 
  in
  if exists (\j.j LE i') hyps' then
    failwith `RewriteOnceWith: hyps used should precede hyp being rewritten`
  else
   let HypsC e = FirstC (map (\j.OldHypC j e) hyps')
   in let LemmasC = FirstC (map LemmaC lemmas)
   in let Conv e t = 
     HigherC (HypsC e ORELSEC LemmasC) e t
   in
     Rewrite Conv i' p
;;





let RWHL name = Rewrite (HigherC (LemmaC name)) ;;
let RWHH i = Rewrite (HigherC (HypC i)) ;;

let RWHRevL name = Rewrite (HigherC (RevLemmaC name)) ;;
let RWHRevH i = Rewrite (HigherC (RevHypC i)) ;;

