%
| This is the second part of sqequal, which should be loaded
| after most of the other tactics.
%

%
| Make a version of GenHyp that uses sqequal, to avoid all the
| well-formedness goals normally generated.
|
| Usage:
|    H, i: T[a], J >> C
|        By SqGenHyp 'a ~ b' i
|    H, i: T[b], J[b/a] >> C[b/a]
|
|    May provide a type as an optional argument.
|
| The type of the equality may be supplied as an argument.
%
let SqGenHyp a_sim_b i p =
    let hyps = num_hyps p in
    let a, b = dest_sqequal a_sim_b in
    let T = get_term_arg `t1` p ? get_type p a in
    let v = maybe_new_proof_var `z' p in

    % Have an existential Ev. i = v in T.  Take care of this goal %
    let DExists p =
	(With a (D 0)
	 THENL [Trivial;
		Trivial;
		MemCD THENL [AddHiddenLabel `wf`;
			     Trivial;
			     Trivial] ]) p
    in

    % Perform the substitution into each of the clauses and the goal %
    let OnTheClauses p =
	let n = num_hyps p in
	letrec Loop j =
	    if j > n then
		SqSubst a_sim_b 0
		THENL [NthHyp (i + 1); Thin (i + 1)]
	    else
		SqSubst a_sim_b j
		THENL [NthHyp (i + 1); Loop (j + 1)]
        in
	    Loop (i + 2) p
    in

    % Given the existential as a hyp,
    | get the witness, prove the sqequal,
    | and perform the substitution.
    %
    let DWork p =
	(Thin (-1)
	 THEN D i
         THEN AssertAtHyp (i + 2) (mk_sqequal_term a b)
         THENL [With T SqEqual THEN Trivial;
		Thin (i + 1) THEN OnTheClauses]) p
    in
	(if is_var_term b then
	     % Generate the well-formedness goals first %
	     Assert (mk_member_term T a)
	     THENL [AddHiddenLabel `wf`;
		    AssertAtHyp i (mk_exists_term v T
				      (mk_equal_term T a (mk_var_term v)))
		    THENL [DExists;
			   DWork]]
	 else
	     FailWith `SqGenHyp: generalize to a variable`) p;;

%
| Add hooks for sqequal.
%
 
%
| Add to Trivial reasoning.
%
%update_Trivial_additions `SqEq` SqEq;;%

%
| EqCD additions.
%
update_EqCD_additions `SqEqCD` SqEqCD;;
update_EqCD_additions `SqEqual` SqEqual;;

%
| Auto additions (to be added after Paul provides the hook).
%
update_Auto_additions `SqEqual` SqEqual;;
update_Auto_additions `SqEqCD` SqEqCD;;
